/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui;

import com.sap.engine.library.monitor.gui.tree.MonitorTreeNode;
import com.sap.engine.library.monitor.mapping.MappedTree;
import com.sap.engine.library.monitor.mapping.MappingTreeNode;
import com.sap.engine.library.monitor.util.NodeFinder;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class IMonitorPanel
extends JPanel {
    public static final String DEFAULT_MAPPING = "default";

    public abstract MonitorTreeNode getRoot();

    public abstract DefaultTreeModel getTreeModel();

    public abstract MappedTree getMapping();

    public abstract JTree getMonitorTree();

    public abstract void restoreDefault();

    public abstract DefaultTreeModel getDefaultTreeModel();

    public TreePath constructPathFromString(String pathName) throws Exception {
        String[] pathArray = NodeFinder.parsePath((String)pathName);
        MappingTreeNode selectedNode = (MappingTreeNode)this.getRoot();
        MappingTreeNode tempNode = null;
        TreePath result = new TreePath(selectedNode);
        int childCount = 0;
        int i = 0;
        while (i < pathArray.length) {
            childCount = selectedNode.getChildCount();
            int j = 0;
            while (j < childCount) {
                tempNode = (MappingTreeNode)selectedNode.getChildAt(j);
                if (tempNode != null && tempNode.getName().equals(pathArray[i])) {
                    selectedNode = tempNode;
                    result = result.pathByAddingChild(selectedNode);
                    break;
                }
                if (i + 1 < pathArray.length && tempNode.getName().equals(pathArray[i] + "/" + pathArray[i + 1])) {
                    ++i;
                    --childCount;
                    selectedNode = tempNode;
                    result = result.pathByAddingChild(selectedNode);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public void expandTree() {
        TreePath treePath = null;
        int i = 0;
        while (i < this.getMonitorTree().getRowCount()) {
            treePath = this.getMonitorTree().getPathForRow(i);
            this.getMonitorTree().expandPath(treePath);
            ++i;
        }
    }

    public void collapseTree() {
        TreeModel model = this.getMonitorTree().getModel();
        Object root = model.getRoot();
        if (root != null) {
            IMonitorPanel.traverseTree(this.getMonitorTree(), model, root, new TreePath(root));
            this.getMonitorTree().expandRow(0);
        }
        this.getMonitorTree().grabFocus();
    }

    private static void traverseTree(JTree tree, TreeModel model, Object node, TreePath path) {
        int nChildren = model.getChildCount(node);
        Object child = null;
        if (nChildren > 0) {
            int i = 0;
            while (i < nChildren) {
                child = model.getChild(node, i);
                IMonitorPanel.traverseTree(tree, model, child, path.pathByAddingChild(child));
                ++i;
            }
        }
        tree.collapsePath(path);
    }
}

