/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui;

import com.sap.engine.services.monitor.MonitorRuntimeControlInterface;
import com.sap.engine.services.monitor.gui.GrmgJTextField;
import com.sap.engine.services.monitor.gui.GrmgTreeNode;
import com.sap.engine.services.monitor.gui.MonitorRuntimeView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class GrmgCustomizingPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
TreeSelectionListener,
MouseListener {
    private static int addDialogLength = 500;
    private Hashtable customizingsHash = new Hashtable();
    private JList applications = null;
    private DefaultListModel appModel = null;
    private JTree customizingTree = null;
    private DefaultTreeModel customizingModel = null;
    private JButton refresh = null;
    private JButton save = null;
    private JButton add = null;
    private JButton remove = null;
    private JButton edit = null;
    private JButton saveInCCMSAgent = null;
    private JScrollPane treeScrollPane = null;
    private JTextField monitorText = null;
    private JTextArea commentForTag;
    private Frame mainFrame;
    private MaxLengthActionListner maxLengthListerner = new MaxLengthActionListner();
    private MonitorRuntimeControlInterface managementInterface = null;

    public GrmgCustomizingPanel(MonitorRuntimeControlInterface managementInterface, Frame mainFrame) {
        this.managementInterface = managementInterface;
        this.mainFrame = mainFrame;
        String[][] test = null;
        boolean wrongAppGet = false;
        try {
            test = managementInterface.getApplicationsWithGrmgCustomizing();
        }
        catch (RemoteException e) {
            wrongAppGet = true;
        }
        this.appModel = new DefaultListModel();
        if (test != null) {
            int i = 0;
            while (i < test[0].length) {
                this.appModel.addElement(test[0][i]);
                ++i;
            }
        }
        this.applications = new JList(this.appModel);
        this.applications.setSelectionMode(0);
        this.applications.addListSelectionListener(this);
        JScrollPane appScrollPane = new JScrollPane();
        appScrollPane.getViewport().add(this.applications);
        this.customizingModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.customizingTree = new JTree(this.customizingModel);
        this.customizingTree.addTreeSelectionListener(this);
        this.customizingTree.getSelectionModel().setSelectionMode(1);
        this.customizingTree.addMouseListener(this);
        this.customizingTree.setShowsRootHandles(true);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setOpenIcon(MonitorRuntimeView.getIcon("tag.gif"));
        renderer.setClosedIcon(MonitorRuntimeView.getIcon("tag.gif"));
        renderer.setLeafIcon(MonitorRuntimeView.getIcon("text.gif"));
        this.customizingTree.setCellRenderer(renderer);
        this.monitorText = new JTextField("");
        this.monitorText.setBackground(Color.lightGray);
        this.monitorText.setEditable(false);
        this.treeScrollPane = new JScrollPane();
        this.treeScrollPane.getViewport().add(this.monitorText);
        Dimension dimButton = new Dimension(110, 25);
        this.refresh = new JButton("Refresh");
        this.refresh.setPreferredSize(dimButton);
        this.refresh.setToolTipText("Refresh applicaitons");
        this.refresh.setIcon(MonitorRuntimeView.getIcon("refresh.gif"));
        this.refresh.addActionListener(this);
        this.save = new JButton("Save");
        this.save.setPreferredSize(dimButton);
        this.save.setToolTipText("Save edited customization to database");
        this.save.setIcon(MonitorRuntimeView.getIcon("save.gif"));
        this.save.addActionListener(this);
        this.save.setEnabled(false);
        this.saveInCCMSAgent = new JButton("Upload");
        this.saveInCCMSAgent.setPreferredSize(dimButton);
        this.saveInCCMSAgent.setToolTipText("Upload customization to CCMS Agent");
        this.saveInCCMSAgent.setIcon(MonitorRuntimeView.getIcon("icon_upload.gif"));
        this.saveInCCMSAgent.addActionListener(this);
        this.saveInCCMSAgent.setEnabled(false);
        this.add = new JButton("Add");
        this.add.setPreferredSize(dimButton);
        this.add.setToolTipText("Add node");
        this.add.setIcon(MonitorRuntimeView.getIcon("icon_create.gif"));
        this.add.addActionListener(this);
        this.add.setEnabled(false);
        this.remove = new JButton("Remove");
        this.remove.setPreferredSize(dimButton);
        this.remove.setToolTipText("Remove node");
        this.remove.setIcon(MonitorRuntimeView.getIcon("icon_delete.gif"));
        this.remove.addActionListener(this);
        this.remove.setEnabled(false);
        this.edit = new JButton("Edit");
        this.edit.setPreferredSize(dimButton);
        this.edit.setToolTipText("Edit tag");
        this.edit.setIcon(MonitorRuntimeView.getIcon("icon_change.gif"));
        this.edit.addActionListener(this);
        this.edit.setEnabled(false);
        JPanel buttonAppPanel = new JPanel();
        FlowLayout flla = new FlowLayout();
        flla.setAlignment(1);
        buttonAppPanel.setLayout(flla);
        buttonAppPanel.add(this.refresh);
        buttonAppPanel.add(this.save);
        buttonAppPanel.add(this.saveInCCMSAgent);
        appScrollPane.setBorder(BorderFactory.createTitledBorder("Applications with GRMG customization"));
        JPanel panelAppOuter = new JPanel(new BorderLayout());
        panelAppOuter.add((Component)buttonAppPanel, "North");
        panelAppOuter.add((Component)appScrollPane, "Center");
        JScrollPane appScrollPaneOuter = new JScrollPane();
        appScrollPaneOuter.getViewport().add(panelAppOuter);
        appScrollPaneOuter.setPreferredSize(new Dimension(360, 360));
        JPanel buttonTreePanel = new JPanel();
        FlowLayout buttonTreeLayout = new FlowLayout();
        buttonTreeLayout.setAlignment(1);
        buttonTreePanel.setLayout(buttonTreeLayout);
        buttonTreePanel.add(this.add);
        buttonTreePanel.add(this.remove);
        buttonTreePanel.add(this.edit);
        this.treeScrollPane.setBorder(BorderFactory.createTitledBorder("Customizing tree for application"));
        this.commentForTag = new JTextArea("");
        this.commentForTag.setEditable(false);
        JPanel commentTreePanel = new JPanel(new BorderLayout());
        commentTreePanel.add((Component)this.commentForTag, "Center");
        JScrollPane commentScrollPane = new JScrollPane();
        commentScrollPane.getViewport().add(commentTreePanel);
        JPanel panelTreeOuter = new JPanel(new BorderLayout());
        panelTreeOuter.add((Component)buttonTreePanel, "North");
        panelTreeOuter.add((Component)this.treeScrollPane, "Center");
        panelTreeOuter.add((Component)commentScrollPane, "South");
        JScrollPane treeScrollPaneOuter = new JScrollPane();
        treeScrollPaneOuter.getViewport().add(panelTreeOuter);
        JSplitPane splitPane = new JSplitPane(1, appScrollPaneOuter, treeScrollPaneOuter);
        splitPane.setDividerSize(10);
        splitPane.setContinuousLayout(true);
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
        if (wrongAppGet) {
            JOptionPane.showMessageDialog(this, "Problem getting applications names from DB.", "GRMG Error", 0);
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.refresh)) {
            this.refreshApplications();
        } else if (event.getSource().equals(this.save)) {
            this.saveCustomizing();
        } else if (event.getSource().equals(this.add)) {
            GrmgTreeNode treeNode = (GrmgTreeNode)this.customizingTree.getLastSelectedPathComponent();
            if (treeNode.getNodeType() == 5) {
                this.addScenario(treeNode);
            } else if (treeNode.getNodeType() == 17) {
                this.addComponent(treeNode);
            } else if (treeNode.getNodeType() == 26) {
                this.addComponentProperty(treeNode);
            }
        } else if (event.getSource().equals(this.remove)) {
            this.removeNode();
        } else if (event.getSource().equals(this.edit)) {
            this.editTag();
        } else if (event.getSource().equals(this.saveInCCMSAgent)) {
            this.saveCustomizingInCCMSAgent();
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            String appName = (String)this.applications.getSelectedValue();
            if (appName == null) {
                return;
            }
            boolean wrongGetFile = false;
            boolean wrongParse = false;
            String wrongMsg = "";
            String customizingFile = "";
            GrmgTreeNode rootNode = new GrmgTreeNode(1, customizingFile);
            rootNode = (GrmgTreeNode)this.customizingsHash.get(appName);
            if (rootNode == null) {
                try {
                    customizingFile = this.managementInterface.getCustomizing(appName);
                }
                catch (RemoteException e) {
                    wrongGetFile = true;
                    wrongMsg = e.getMessage();
                }
            }
            if (wrongGetFile) {
                this.applications.repaint();
                this.treeScrollPane.getViewport().removeAll();
                this.treeScrollPane.getViewport().add(this.monitorText);
                this.treeScrollPane.repaint();
            } else {
                if (rootNode == null) {
                    try {
                        rootNode = GrmgTreeNode.buildGrmgTree(customizingFile);
                        this.customizingsHash.put(appName, rootNode);
                    }
                    catch (Exception e) {
                        wrongParse = true;
                        wrongMsg = e.getMessage();
                    }
                }
                if (wrongParse) {
                    this.applications.repaint();
                    this.treeScrollPane.getViewport().removeAll();
                    this.treeScrollPane.getViewport().add(this.monitorText);
                    this.treeScrollPane.repaint();
                } else {
                    this.customizingModel.setRoot(rootNode);
                    this.treeScrollPane.getViewport().removeAll();
                    this.treeScrollPane.getViewport().add(this.customizingTree);
                    this.customizingTree.repaint();
                }
            }
            this.add.setEnabled(false);
            this.remove.setEnabled(false);
            this.edit.setEnabled(false);
            this.save.setEnabled(true);
            this.saveInCCMSAgent.setEnabled(true);
            this.commentForTag.setText("");
            this.repaint();
            if (wrongGetFile) {
                JOptionPane.showMessageDialog(this, "Problem getting file form DB \n" + wrongMsg, "GRMG Error", 0);
            } else if (wrongParse) {
                JOptionPane.showMessageDialog(this, "Wrong customizing.\nProblem is " + wrongMsg, "GRMG Error", 0);
            }
        }
    }

    public void valueChanged(TreeSelectionEvent event) {
        Object o = this.customizingTree.getLastSelectedPathComponent();
        if (o == null || o.toString() == null) {
            return;
        }
        GrmgTreeNode treeNode = (GrmgTreeNode)o;
        int nt = treeNode.getNodeType();
        if (nt == 40) {
            this.add.setEnabled(false);
            this.remove.setEnabled(false);
            this.edit.setEnabled(true);
        } else if (nt == 5 || nt == 17 || nt == 26) {
            this.add.setEnabled(true);
            this.remove.setEnabled(false);
            this.edit.setEnabled(false);
        } else if (nt == 6 || nt == 18 || nt == 27) {
            this.add.setEnabled(false);
            this.remove.setEnabled(true);
            this.edit.setEnabled(false);
        } else {
            this.add.setEnabled(false);
            this.remove.setEnabled(false);
            this.edit.setEnabled(false);
        }
        String comment = treeNode.isLeaf() ? ((GrmgTreeNode)treeNode.getParent()).getComment() : treeNode.getComment();
        this.commentForTag.setText(comment);
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
        GrmgTreeNode treeNode;
        int y;
        int x;
        TreePath path;
        if (e.getClickCount() > 1 && !e.isPopupTrigger() && (path = this.customizingTree.getPathForLocation(x = e.getX(), y = e.getY())) != null && (treeNode = (GrmgTreeNode)path.getLastPathComponent()).isLeaf()) {
            this.editTag();
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    private void addScenario(GrmgTreeNode treeNode) {
        Dimension dim = new Dimension(240, 25);
        JLabel label1 = new JLabel("Scenario name");
        JLabel label2 = new JLabel("Scenario version");
        JLabel label3 = new JLabel("Scenario instance");
        JLabel label4 = new JLabel("Scenario type");
        JLabel label5 = new JLabel("Scenario start URL");
        JLabel label6 = new JLabel("Scenario start mode");
        JLabel label7 = new JLabel("Scenario text language");
        JLabel label8 = new JLabel("Scenario description");
        GrmgJTextField text1 = new GrmgJTextField(GrmgTreeNode.maxLength(7));
        text1.addKeyListener(this.maxLengthListerner);
        GrmgJTextField text2 = new GrmgJTextField(GrmgTreeNode.maxLength(8));
        text2.addKeyListener(this.maxLengthListerner);
        GrmgJTextField text3 = new GrmgJTextField(GrmgTreeNode.maxLength(9));
        text3.addKeyListener(this.maxLengthListerner);
        GrmgJTextField text4 = new GrmgJTextField(GrmgTreeNode.maxLength(10));
        text4.addKeyListener(this.maxLengthListerner);
        GrmgJTextField text5 = new GrmgJTextField(GrmgTreeNode.maxLength(11));
        text5.addKeyListener(this.maxLengthListerner);
        GrmgJTextField text6 = new GrmgJTextField(GrmgTreeNode.maxLength(12));
        text6.addKeyListener(this.maxLengthListerner);
        GrmgJTextField text7 = new GrmgJTextField(GrmgTreeNode.maxLength(15));
        text7.addKeyListener(this.maxLengthListerner);
        GrmgJTextField text8 = new GrmgJTextField(GrmgTreeNode.maxLength(16));
        text8.addKeyListener(this.maxLengthListerner);
        JPanel panelInput = new JPanel();
        panelInput.setLayout(new GridLayout(8, 2));
        JPanel temp = new JPanel();
        panelInput.add(label1);
        temp = new JPanel();
        text1.setPreferredSize(dim);
        temp.add(text1);
        panelInput.add(temp);
        panelInput.add(label2);
        temp = new JPanel();
        text2.setPreferredSize(dim);
        temp.add(text2);
        panelInput.add(temp);
        panelInput.add(label3);
        temp = new JPanel();
        text3.setPreferredSize(dim);
        temp.add(text3);
        panelInput.add(temp);
        panelInput.add(label4);
        temp = new JPanel();
        text4.setPreferredSize(dim);
        temp.add(text4);
        panelInput.add(temp);
        panelInput.add(label5);
        temp = new JPanel();
        text5.setPreferredSize(dim);
        temp.add(text5);
        panelInput.add(temp);
        panelInput.add(label6);
        temp = new JPanel();
        text6.setPreferredSize(dim);
        temp.add(text6);
        panelInput.add(temp);
        panelInput.add(label7);
        temp = new JPanel();
        text7.setPreferredSize(dim);
        temp.add(text7);
        panelInput.add(temp);
        panelInput.add(label8);
        temp = new JPanel();
        text8.setPreferredSize(dim);
        temp.add(text8);
        panelInput.add(temp);
        JButton ok = new JButton("OK");
        ok.setPreferredSize(new Dimension(75, 25));
        JPanel panelOK = new JPanel();
        panelOK.setBorder(new EmptyBorder(1, 150, 0, 1));
        panelOK.add(ok);
        JButton cancel = new JButton("Cancel");
        cancel.setPreferredSize(new Dimension(75, 25));
        JPanel panelCancel = new JPanel();
        panelCancel.setBorder(new EmptyBorder(1, 1, 0, 150));
        panelCancel.add(cancel);
        JPanel panelButtons = new JPanel();
        panelButtons.setLayout(new GridLayout(1, 2));
        panelButtons.add(panelOK);
        panelButtons.add(panelCancel);
        JDialog dialog = new JDialog(this.mainFrame);
        dialog.setModal(true);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)panelInput, "Center");
        dialog.getContentPane().add((Component)panelButtons, "South");
        dialog.setTitle("Add Scenario");
        ((Component)dialog).setBounds(this.getX() + this.getWidth() / 2 - addDialogLength / 2, this.getY() + this.getHeight() / 2, addDialogLength, 300);
        dialog.setResizable(false);
        InnerActionListener listener = new InnerActionListener(dialog);
        ok.addActionListener(listener);
        cancel.addActionListener(listener);
        while (true) {
            dialog.show();
            ActionEvent actionEvent = listener.getEvent();
            if (actionEvent == null || actionEvent.getSource().equals(cancel)) {
                return;
            }
            dialog.hide();
            String newScenarioName = text1.getText().trim();
            if (newScenarioName.length() == 0) {
                JOptionPane.showMessageDialog(this, "Your scenario name is empty.", "GRMG Error", 0);
                continue;
            }
            boolean flag = true;
            int i = 0;
            while (i < treeNode.getChildCount()) {
                GrmgTreeNode scenarioNode = (GrmgTreeNode)treeNode.getChildAt(i);
                GrmgTreeNode scenarioNameNode = (GrmgTreeNode)scenarioNode.getChildAt(0).getChildAt(0);
                if (newScenarioName.equals(scenarioNameNode.getUserObject())) {
                    flag = false;
                    break;
                }
                ++i;
            }
            if (flag) break;
            JOptionPane.showMessageDialog(this, "You already have a scenario with name : " + newScenarioName, "GRMG Error", 0);
        }
        GrmgTreeNode scenenameTreeNode = new GrmgTreeNode(7, GrmgTreeNode.GRMG_SCEN_NAME_STR);
        scenenameTreeNode.add(new GrmgTreeNode(40, text1.getText()));
        GrmgTreeNode sceneversionTreeNode = new GrmgTreeNode(8, GrmgTreeNode.GRMG_SCEN_VERSION_STR);
        sceneversionTreeNode.add(new GrmgTreeNode(40, text2.getText()));
        GrmgTreeNode sceneinstTreeNode = new GrmgTreeNode(9, GrmgTreeNode.GRMG_SCEN_INST_STR);
        sceneinstTreeNode.add(new GrmgTreeNode(40, text3.getText()));
        GrmgTreeNode scenetypeTreeNode = new GrmgTreeNode(10, GrmgTreeNode.GRMG_SCEN_TYPE_STR);
        scenetypeTreeNode.add(new GrmgTreeNode(40, text4.getText()));
        GrmgTreeNode sceneurlTreeNode = new GrmgTreeNode(11, GrmgTreeNode.GRMG_SCEN_START_URL_STR);
        sceneurlTreeNode.add(new GrmgTreeNode(40, text5.getText()));
        GrmgTreeNode scenemodTreeNode = new GrmgTreeNode(12, GrmgTreeNode.GRMG_SCEN_START_MOD_STR);
        scenemodTreeNode.add(new GrmgTreeNode(40, text6.getText()));
        GrmgTreeNode scenetextsTreeNode = new GrmgTreeNode(13, GrmgTreeNode.GRMG_SCEN_TEXTS_STR);
        GrmgTreeNode scenelanguTreeNode = new GrmgTreeNode(15, GrmgTreeNode.GRMG_SCEN_LANGU_STR);
        scenelanguTreeNode.add(new GrmgTreeNode(40, text7.getText()));
        GrmgTreeNode scenedescTreeNode = new GrmgTreeNode(16, GrmgTreeNode.GRMG_SCEN_DESC_STR);
        scenedescTreeNode.add(new GrmgTreeNode(40, text8.getText()));
        GrmgTreeNode scenetextTreeNode = new GrmgTreeNode(14, GrmgTreeNode.GRMG_SCEN_TEXT_STR);
        scenetextTreeNode.add(scenelanguTreeNode);
        scenetextTreeNode.add(scenedescTreeNode);
        scenetextsTreeNode.add(scenetextTreeNode);
        GrmgTreeNode scenario = new GrmgTreeNode(6, GrmgTreeNode.GRMG_SCENARIO_STR);
        scenario.add(scenenameTreeNode);
        scenario.add(sceneversionTreeNode);
        scenario.add(sceneinstTreeNode);
        scenario.add(scenetypeTreeNode);
        scenario.add(sceneurlTreeNode);
        scenario.add(scenemodTreeNode);
        scenario.add(scenetextsTreeNode);
        scenario.add(new GrmgTreeNode(17, GrmgTreeNode.GRMG_COMPONENTS_STR));
        treeNode.add(scenario);
        this.customizingModel.nodesWereInserted(treeNode, new int[]{treeNode.getChildCount() - 1});
    }

    private void addComponent(GrmgTreeNode treeNode) {
        Dimension dim = new Dimension(240, 25);
        JLabel label1 = new JLabel("Component name");
        JLabel label2 = new JLabel("Component version");
        JLabel label3 = new JLabel("Component type");
        JLabel label4 = new JLabel("Component text language");
        JLabel label5 = new JLabel("Component description");
        GrmgJTextField text1 = new GrmgJTextField(GrmgTreeNode.maxLength(19));
        text1.addKeyListener(this.maxLengthListerner);
        GrmgJTextField text2 = new GrmgJTextField(GrmgTreeNode.maxLength(20));
        text2.addKeyListener(this.maxLengthListerner);
        GrmgJTextField text3 = new GrmgJTextField(GrmgTreeNode.maxLength(21));
        text3.addKeyListener(this.maxLengthListerner);
        GrmgJTextField text4 = new GrmgJTextField(GrmgTreeNode.maxLength(24));
        text4.addKeyListener(this.maxLengthListerner);
        GrmgJTextField text5 = new GrmgJTextField(GrmgTreeNode.maxLength(25));
        text5.addKeyListener(this.maxLengthListerner);
        JPanel panelInput = new JPanel();
        panelInput.setLayout(new GridLayout(5, 2));
        JPanel temp = new JPanel();
        panelInput.add(label1);
        temp = new JPanel();
        text1.setPreferredSize(dim);
        temp.add(text1);
        panelInput.add(temp);
        panelInput.add(label2);
        temp = new JPanel();
        text2.setPreferredSize(dim);
        temp.add(text2);
        panelInput.add(temp);
        panelInput.add(label3);
        temp = new JPanel();
        text3.setPreferredSize(dim);
        temp.add(text3);
        panelInput.add(temp);
        panelInput.add(label4);
        temp = new JPanel();
        text4.setPreferredSize(dim);
        temp.add(text4);
        panelInput.add(temp);
        panelInput.add(label5);
        temp = new JPanel();
        text5.setPreferredSize(dim);
        temp.add(text5);
        panelInput.add(temp);
        JButton ok = new JButton("OK");
        ok.setPreferredSize(new Dimension(75, 25));
        JPanel panelOK = new JPanel();
        panelOK.setBorder(new EmptyBorder(1, 150, 0, 1));
        panelOK.add(ok);
        JButton cancel = new JButton("Cancel");
        cancel.setPreferredSize(new Dimension(75, 25));
        JPanel panelCancel = new JPanel();
        panelCancel.setBorder(new EmptyBorder(1, 1, 0, 150));
        panelCancel.add(cancel);
        JPanel panelButtons = new JPanel();
        panelButtons.setLayout(new GridLayout(1, 2));
        panelButtons.add(panelOK);
        panelButtons.add(panelCancel);
        JDialog dialog = new JDialog(this.mainFrame);
        dialog.setModal(true);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)panelInput, "Center");
        dialog.getContentPane().add((Component)panelButtons, "South");
        dialog.setTitle("Add Component");
        ((Component)dialog).setBounds(this.getX() + this.getWidth() / 2 - addDialogLength / 2, this.getY() + this.getHeight() / 2, addDialogLength, 200);
        dialog.setResizable(false);
        InnerActionListener listener = new InnerActionListener(dialog);
        ok.addActionListener(listener);
        cancel.addActionListener(listener);
        dialog.show();
        ActionEvent actionEvent = listener.getEvent();
        if (actionEvent == null || actionEvent.getSource().equals(cancel)) {
            return;
        }
        GrmgTreeNode compnameTreeNode = new GrmgTreeNode(19, GrmgTreeNode.GRMG_COMP_NAME_STR);
        compnameTreeNode.add(new GrmgTreeNode(40, text1.getText()));
        GrmgTreeNode compversionTreeNode = new GrmgTreeNode(20, GrmgTreeNode.GRMG_COMP_VERSION_STR);
        compversionTreeNode.add(new GrmgTreeNode(40, text2.getText()));
        GrmgTreeNode comptypeTreeNode = new GrmgTreeNode(21, GrmgTreeNode.GRMG_COMP_TYPE_STR);
        comptypeTreeNode.add(new GrmgTreeNode(40, text3.getText()));
        GrmgTreeNode comptextsTreeNode = new GrmgTreeNode(22, GrmgTreeNode.GRMG_COMP_TEXTS_STR);
        GrmgTreeNode complanguTreeNode = new GrmgTreeNode(24, GrmgTreeNode.GRMG_COMP_LANGU_STR);
        complanguTreeNode.add(new GrmgTreeNode(40, text4.getText()));
        GrmgTreeNode compdescTreeNode = new GrmgTreeNode(25, GrmgTreeNode.GRMG_COMP_DESC_STR);
        compdescTreeNode.add(new GrmgTreeNode(40, text5.getText()));
        GrmgTreeNode comptextTreeNode = new GrmgTreeNode(23, GrmgTreeNode.GRMG_COMP_TEXT_STR);
        comptextTreeNode.add(complanguTreeNode);
        comptextTreeNode.add(compdescTreeNode);
        comptextsTreeNode.add(comptextTreeNode);
        GrmgTreeNode componenet = new GrmgTreeNode(18, GrmgTreeNode.GRMG_COMPONENT_STR);
        componenet.add(compnameTreeNode);
        componenet.add(compversionTreeNode);
        componenet.add(comptypeTreeNode);
        componenet.add(comptextsTreeNode);
        componenet.add(new GrmgTreeNode(26, GrmgTreeNode.GRMG_PROPERTIES_STR));
        treeNode.add(componenet);
        this.customizingModel.nodesWereInserted(treeNode, new int[]{treeNode.getChildCount() - 1});
    }

    private void addComponentProperty(GrmgTreeNode treeNode) {
        Dimension dim = new Dimension(240, 25);
        JLabel label1 = new JLabel("Property name ");
        JLabel label2 = new JLabel("Property type");
        JLabel label3 = new JLabel("Property value");
        GrmgJTextField text1 = new GrmgJTextField(GrmgTreeNode.maxLength(28));
        text1.addKeyListener(this.maxLengthListerner);
        GrmgJTextField text2 = new GrmgJTextField(GrmgTreeNode.maxLength(29));
        text2.addKeyListener(this.maxLengthListerner);
        GrmgJTextField text3 = new GrmgJTextField(GrmgTreeNode.maxLength(30));
        text3.addKeyListener(this.maxLengthListerner);
        JPanel panelInput = new JPanel();
        panelInput.setLayout(new GridLayout(3, 2));
        JPanel temp = new JPanel();
        panelInput.add(label1);
        temp = new JPanel();
        text1.setPreferredSize(dim);
        temp.add(text1);
        panelInput.add(temp);
        panelInput.add(label2);
        temp = new JPanel();
        text2.setPreferredSize(dim);
        temp.add(text2);
        panelInput.add(temp);
        panelInput.add(label3);
        temp = new JPanel();
        text3.setPreferredSize(dim);
        temp.add(text3);
        panelInput.add(temp);
        JButton ok = new JButton("OK");
        ok.setPreferredSize(new Dimension(75, 25));
        JPanel panelOK = new JPanel();
        panelOK.setBorder(new EmptyBorder(1, 150, 0, 1));
        panelOK.add(ok);
        JButton cancel = new JButton("Cancel");
        cancel.setPreferredSize(new Dimension(75, 25));
        JPanel panelCancel = new JPanel();
        panelCancel.setBorder(new EmptyBorder(1, 1, 0, 150));
        panelCancel.add(cancel);
        JPanel panelButtons = new JPanel();
        panelButtons.setLayout(new GridLayout(1, 2));
        panelButtons.add(panelOK);
        panelButtons.add(panelCancel);
        JDialog dialog = new JDialog(this.mainFrame);
        dialog.setModal(true);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)panelInput, "Center");
        dialog.getContentPane().add((Component)panelButtons, "South");
        dialog.setTitle("Add Component property");
        ((Component)dialog).setBounds(this.getX() + this.getWidth() / 2 - addDialogLength / 2, this.getY() + this.getHeight() / 2, addDialogLength, 133);
        dialog.setResizable(false);
        InnerActionListener listener = new InnerActionListener(dialog);
        ok.addActionListener(listener);
        cancel.addActionListener(listener);
        dialog.show();
        ActionEvent actionEvent = listener.getEvent();
        if (actionEvent == null || actionEvent.getSource().equals(cancel)) {
            return;
        }
        GrmgTreeNode propnameTreeNode = new GrmgTreeNode(28, GrmgTreeNode.GRMG_PROP_NAME_STR);
        propnameTreeNode.add(new GrmgTreeNode(40, text1.getText()));
        GrmgTreeNode proptypeTreeNode = new GrmgTreeNode(29, GrmgTreeNode.GRMG_PROP_TYPE_STR);
        proptypeTreeNode.add(new GrmgTreeNode(40, text2.getText()));
        GrmgTreeNode propvalueTreeNode = new GrmgTreeNode(30, GrmgTreeNode.GRMG_PROP_VALUE_STR);
        propvalueTreeNode.add(new GrmgTreeNode(40, text3.getText()));
        GrmgTreeNode property = new GrmgTreeNode(27, GrmgTreeNode.GRMG_PROPERTY_STR);
        property.add(propnameTreeNode);
        property.add(proptypeTreeNode);
        property.add(propvalueTreeNode);
        treeNode.add(property);
        this.customizingModel.nodesWereInserted(treeNode, new int[]{treeNode.getChildCount() - 1});
    }

    private void saveCustomizing() {
        String appName = (String)this.applications.getSelectedValue();
        if (appName == null) {
            return;
        }
        GrmgTreeNode root = (GrmgTreeNode)this.customizingsHash.get(appName);
        if (root == null) {
            return;
        }
        String[] parsedTree = GrmgTreeNode.buildGrmgFile(root, false);
        try {
            this.managementInterface.saveCustomizing(appName, parsedTree[0]);
        }
        catch (RemoteException e) {
            JOptionPane.showMessageDialog(this, "Problem  saving application to DB. \n" + e.getMessage(), "GRMG Error", 0);
            return;
        }
    }

    private void refreshApplications() {
        String[][] test = null;
        boolean wrongAppGet = false;
        try {
            test = this.managementInterface.getApplicationsWithGrmgCustomizing();
        }
        catch (RemoteException e) {
            wrongAppGet = true;
        }
        this.appModel.removeAllElements();
        if (test != null) {
            int i = 0;
            while (i < test[0].length) {
                this.appModel.addElement(test[0][i]);
                ++i;
            }
        }
        this.customizingsHash.clear();
        this.treeScrollPane.getViewport().removeAll();
        this.treeScrollPane.getViewport().add(this.monitorText);
        this.add.setEnabled(false);
        this.remove.setEnabled(false);
        this.edit.setEnabled(false);
        this.save.setEnabled(false);
        this.saveInCCMSAgent.setEnabled(false);
        this.commentForTag.setText("");
        this.treeScrollPane.repaint();
        this.applications.repaint();
        if (wrongAppGet) {
            JOptionPane.showMessageDialog(this, "Problem getting applications names from DB.", "GRMG Error", 0);
        }
    }

    private void editTag() {
        GrmgTreeNode treeNode = (GrmgTreeNode)this.customizingTree.getLastSelectedPathComponent();
        GrmgTreeNode parent = (GrmgTreeNode)treeNode.getParent();
        Dimension dim = new Dimension(480, 25);
        JLabel label1 = new JLabel("Enter value for tag " + parent.getUserObject());
        label1.setPreferredSize(dim);
        GrmgJTextField text1 = new GrmgJTextField(GrmgTreeNode.maxLength(parent.getNodeType()));
        text1.addKeyListener(this.maxLengthListerner);
        text1.setPreferredSize(dim);
        text1.setText((String)treeNode.getUserObject());
        JPanel panelInput = new JPanel();
        panelInput.setLayout(new GridLayout(2, 1));
        panelInput.add(label1);
        panelInput.add(text1);
        JButton ok = new JButton("OK");
        ok.setPreferredSize(new Dimension(75, 25));
        JPanel panelOK = new JPanel();
        panelOK.setBorder(new EmptyBorder(1, 150, 0, 1));
        panelOK.add(ok);
        JButton cancel = new JButton("Cancel");
        cancel.setPreferredSize(new Dimension(75, 25));
        JPanel panelCancel = new JPanel();
        panelCancel.setBorder(new EmptyBorder(1, 1, 0, 150));
        panelCancel.add(cancel);
        JPanel panelButtons = new JPanel();
        panelButtons.setLayout(new GridLayout(1, 2));
        panelButtons.add(panelOK);
        panelButtons.add(panelCancel);
        JDialog dialog = new JDialog(this.mainFrame);
        dialog.setModal(true);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)panelInput, "Center");
        dialog.getContentPane().add((Component)panelButtons, "South");
        dialog.setTitle("Edit tag");
        ((Component)dialog).setBounds(this.getX() + this.getWidth() / 2 - addDialogLength / 2, this.getY() + this.getHeight() / 2, addDialogLength, 110);
        dialog.setResizable(false);
        InnerActionListener listener = new InnerActionListener(dialog);
        ok.addActionListener(listener);
        cancel.addActionListener(listener);
        while (true) {
            String scenName;
            dialog.show();
            ActionEvent actionEvent = listener.getEvent();
            if (actionEvent == null || actionEvent.getSource().equals(cancel)) {
                return;
            }
            dialog.hide();
            if (parent.getNodeType() != 7 || (scenName = text1.getText().trim()).length() > 0) break;
            JOptionPane.showMessageDialog(this, "Enter not empty name for scenario.", "GRMG Error", 0);
        }
        treeNode.setUserObject(text1.getText());
        this.customizingModel.nodeChanged(treeNode);
    }

    private void saveCustomizingInCCMSAgent() {
        String appName = (String)this.applications.getSelectedValue();
        if (appName == null) {
            return;
        }
        GrmgTreeNode root = (GrmgTreeNode)this.customizingsHash.get(appName);
        if (root == null) {
            return;
        }
        String[] parsedTree = GrmgTreeNode.buildGrmgFile(root, true);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setValidating(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.parse(new ByteArrayInputStream(parsedTree[1].getBytes()));
        }
        catch (ParserConfigurationException e) {
            JOptionPane.showMessageDialog(this, "Problems with parser.", "GRMG Error", 0);
            return;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Problems with parser.", "GRMG Error", 0);
            return;
        }
        catch (SAXException e) {
            JOptionPane.showMessageDialog(this, "Customizing is not correct. Look at the dtd file for GRMG.", "GRMG Error", 0);
            return;
        }
        try {
            this.managementInterface.saveCustomizingInCCMSAgent(appName, parsedTree[0]);
        }
        catch (RemoteException e) {
            JOptionPane.showMessageDialog(this, "Problem saving application in CCMS Agent. \n" + e.getMessage(), "GRMG Error", 0);
            return;
        }
    }

    private void removeNode() {
        GrmgTreeNode treeNode = (GrmgTreeNode)this.customizingTree.getLastSelectedPathComponent();
        GrmgTreeNode parent = (GrmgTreeNode)treeNode.getParent();
        int childIndex = parent.getIndex(treeNode);
        parent.remove(treeNode);
        this.customizingModel.nodesWereRemoved(parent, new int[]{childIndex}, new Object[]{treeNode});
        this.remove.setEnabled(false);
        this.commentForTag.setText("");
        this.repaint();
    }

    class MaxLengthActionListner
    implements KeyListener {
        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            try {
                GrmgJTextField textField = (GrmgJTextField)e.getSource();
                if (textField.getText().length() > textField.maxLength) {
                    textField.setText(textField.getText().substring(0, textField.maxLength));
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    class InnerActionListener
    implements ActionListener {
        protected ActionEvent event;
        protected JDialog dialog;

        public InnerActionListener(JDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent event) {
            this.event = event;
            this.dialog.dispose();
        }

        public ActionEvent getEvent() {
            return this.event;
        }
    }
}

