/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.gui;

import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.services.monitor.MonitorRuntimeControlInterface;
import com.sap.engine.services.monitor.gui.IMonitorPanel;
import com.sap.engine.services.monitor.gui.MonitorPanelLogical;
import com.sap.engine.services.monitor.gui.MonitorRuntimeView;
import com.sap.engine.services.monitor.gui.MonitorUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FilterDialog
extends JDialog
implements ActionListener,
KeyListener,
ItemListener,
ChangeListener {
    static String FILE_NAME_SEARCH_IMAGE = "search.gif";
    static String LABEL_BUTTON_SEARCH = "Search";
    static String LABEL_BUTTON_REMOVE_SELECTED = "Remove Selected";
    static String LABEL_FILTER_BY_WORD = "Filter by word:";
    static String ACTION_SEARCH = "actSearch";
    static String ACTION_REMOVE_SELECTED = "actRemove";
    static String ACTION_DONE = "actDone";
    static String ACTION_CANCEL = "actCancel";
    static String ACTION_DEFAULT = "actDefault";
    static int FULL_NAME_COLUMN_INDEX = 0;
    static int TYPE_COLUMN_INDEX = 1;
    static String DIALOG_TITLE = "Customize monitor view ";
    static Object[] COLUMN_NAMES = new Object[]{"full path & name", "type"};
    JButton btnRemoveSelected = new JButton(LABEL_BUTTON_REMOVE_SELECTED);
    JButton btnSearch = new JButton(LABEL_BUTTON_SEARCH, MonitorRuntimeView.getIcon(FILE_NAME_SEARCH_IMAGE));
    JButton btnDone = new JButton("OK");
    JButton btnCancel = new JButton("Cancel");
    JLabel searchLabel = new JLabel(LABEL_FILTER_BY_WORD);
    JTextField txtSearch = new JTextField(12);
    JCheckBox defaultBox = new JCheckBox("no filter,default tree");
    JRadioButton radioTree = new JRadioButton("apply to the current tree");
    JRadioButton radioAllTrees = new JRadioButton("apply to all the trees");
    ButtonGroup group = new ButtonGroup();
    JTable table;
    DefaultTableModel tableModel;
    Vector monitorPathsForDel;
    String[][] dataStr;
    int rows;
    MonitorRuntimeControlInterface m_runtimeInterface;
    IMonitorPanel currentPanel;
    IMonitorPanel[] panels;
    private int numberOfLeafsInDefaultTree;

    public FilterDialog(MonitorRuntimeControlInterface mri, Frame mainFrame, JPanel panel, IMonitorPanel[] panels) {
        super(mainFrame, DIALOG_TITLE, true);
        this.m_runtimeInterface = mri;
        this.panels = panels;
        this.monitorPathsForDel = new Vector();
        if (panel instanceof MonitorPanelLogical) {
            this.currentPanel = (MonitorPanelLogical)panel;
        }
        this.rows = 0;
        this.retriveData();
        this.createComponents();
        ((Component)this).setLocation(200, 200);
        this.pack();
        ((Component)this).setVisible(true);
    }

    private void retriveData() {
        this.dataStr = new String[this.getLeafCount()][2];
        try {
            IMonitorNode[] nodes = this.m_runtimeInterface.getRootNode().getSubNodes();
            if (nodes != null && nodes.length != 0) {
                int i = 0;
                while (i < nodes.length) {
                    this.getData(nodes[i]);
                    ++i;
                }
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    protected int getLeafCount() {
        this.numberOfLeafsInDefaultTree = 0;
        try {
            this.countLeafs(this.m_runtimeInterface.getRootNode());
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return this.numberOfLeafsInDefaultTree;
    }

    private void countLeafs(IMonitorNode node) {
        int i = 0;
        while (i < node.getSubNodes().length) {
            IMonitorNode tempNode = node.getSubNodes()[i];
            IMonitorNode[] children = tempNode.getSubNodes();
            if (children == null || children.length == 0) {
                ++this.numberOfLeafsInDefaultTree;
            } else {
                this.countLeafs(tempNode);
            }
            ++i;
        }
    }

    private void getData(IMonitorNode node) {
        IMonitorNode[] nodes = node.getSubNodes();
        if (nodes == null || nodes.length == 0) {
            this.dataStr[this.rows][FilterDialog.FULL_NAME_COLUMN_INDEX] = node.getPath();
            this.dataStr[this.rows][FilterDialog.TYPE_COLUMN_INDEX] = MonitorUtils.getStringType(node.getTyp(), node);
            ++this.rows;
        } else {
            int i = 0;
            while (i < nodes.length) {
                this.getData(nodes[i]);
                ++i;
            }
        }
    }

    protected void createComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.createTablePanel(), new GridBagConstraints(0, 0, 1, 2, 0.1, 0.0, 17, 0, MonitorUtils.INSETS, 0, 0));
        this.getContentPane().add((Component)this.createBtnPanel(), new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 11, 0, MonitorUtils.INSETS, 0, 0));
        this.getContentPane().add((Component)this.createBtn1Panel(), new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 14, 0, MonitorUtils.INSETS, 0, 0));
    }

    protected JPanel createBtnPanel() {
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new GridBagLayout());
        this.btnSearch.addActionListener(this);
        this.btnSearch.setActionCommand(ACTION_SEARCH);
        this.txtSearch.addKeyListener(this);
        this.btnRemoveSelected.addActionListener(this);
        this.btnRemoveSelected.setActionCommand(ACTION_REMOVE_SELECTED);
        this.defaultBox.addChangeListener(this);
        this.group.add(this.radioTree);
        this.group.add(this.radioAllTrees);
        this.radioTree.setSelected(true);
        this.btnDone.addActionListener(this);
        this.btnDone.setActionCommand(ACTION_DONE);
        this.btnCancel.addActionListener(this);
        this.btnCancel.setActionCommand(ACTION_CANCEL);
        btnPanel.add((Component)this.searchLabel, new GridBagConstraints(0, 2, 2, 1, 0.1, 0.0, 17, 0, MonitorUtils.INSETS, 0, 0));
        btnPanel.add((Component)this.txtSearch, new GridBagConstraints(0, 3, 1, 1, 0.1, 0.0, 17, 0, MonitorUtils.INSETS, 0, 0));
        btnPanel.add((Component)this.btnSearch, new GridBagConstraints(1, 3, 1, 1, 0.1, 0.0, 17, 0, MonitorUtils.INSETS, 0, 0));
        btnPanel.add((Component)this.btnRemoveSelected, new GridBagConstraints(0, 4, 1, 1, 0.1, 0.0, 17, 0, MonitorUtils.INSETS, 0, 0));
        btnPanel.add((Component)this.defaultBox, new GridBagConstraints(0, 5, 2, 1, 0.1, 0.0, 17, 0, MonitorUtils.INSETS, 0, 0));
        btnPanel.add((Component)this.radioAllTrees, new GridBagConstraints(0, 6, 2, 1, 0.1, 0.0, 17, 0, MonitorUtils.INSETS, 0, 0));
        btnPanel.add((Component)this.radioTree, new GridBagConstraints(0, 7, 2, 1, 0.1, 0.0, 17, 0, MonitorUtils.INSETS, 0, 0));
        return btnPanel;
    }

    protected JPanel createTablePanel() {
        JPanel tablePanel = new JPanel();
        this.tableModel = new DefaultTableModel();
        this.table = new JTable();
        this.tableModel = new DefaultTableModel();
        this.tableModel.setDataVector(this.dataStr, COLUMN_NAMES);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(2);
        this.table.setModel(this.tableModel);
        this.table.setPreferredScrollableViewportSize(new Dimension(400, 300));
        this.table.sizeColumnsToFit(FULL_NAME_COLUMN_INDEX);
        this.table.sizeColumnsToFit(TYPE_COLUMN_INDEX);
        tablePanel.add(new JScrollPane(this.table));
        return tablePanel;
    }

    private JPanel createBtn1Panel() {
        JPanel btn1Panel = new JPanel(new GridLayout(1, 2));
        btn1Panel.add(this.btnDone);
        btn1Panel.add(this.btnCancel);
        return btn1Panel;
    }

    public void stateChanged(ChangeEvent che) {
        JCheckBox checkBox = (JCheckBox)che.getSource();
        if (checkBox.isSelected()) {
            this.btnRemoveSelected.setEnabled(false);
            this.btnSearch.setEnabled(false);
            this.searchLabel.setEnabled(false);
            this.txtSearch.setEnabled(false);
            this.table.setEnabled(false);
        } else {
            this.btnRemoveSelected.setEnabled(true);
            this.btnSearch.setEnabled(true);
            this.searchLabel.setEnabled(true);
            this.txtSearch.setEnabled(true);
            this.table.setEnabled(true);
        }
    }

    public void itemStateChanged(ItemEvent ie) {
        String typeToSearch = (String)ie.getItem();
        int dataLength = this.dataStr.length;
        String dataS = null;
        this.tableModel.setDataVector(this.dataStr, COLUMN_NAMES);
        int i = 0;
        int j = 0;
        while (i < dataLength) {
            dataS = this.dataStr[i][TYPE_COLUMN_INDEX];
            if (dataS != null && dataS.indexOf(typeToSearch) == -1) {
                this.tableModel.removeRow(i - j);
                ++j;
            }
            ++i;
        }
        this.table.setModel(this.tableModel);
        this.table.validate();
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(ACTION_SEARCH)) {
            String txtToSearch = this.txtSearch.getText();
            this.txtSearch.setText("");
            this.searchByKey(txtToSearch);
        } else if (action.equals(ACTION_REMOVE_SELECTED)) {
            int[] selectedRows = this.table.getSelectedRows();
            this.removeSelectedRows(selectedRows);
        } else if (action.equals(ACTION_DONE)) {
            if (this.defaultBox.isSelected()) {
                if (this.radioAllTrees.isSelected()) {
                    this.restoreDefaultTrees();
                } else {
                    this.restoreDefaultTree();
                }
            } else if (this.radioAllTrees.isSelected()) {
                this.deletePathsFromAllViews();
            } else {
                this.deletePathsFromView();
            }
            ((Component)this).setVisible(false);
        } else if (action.equals(ACTION_CANCEL)) {
            ((Component)this).setVisible(false);
        }
    }

    public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == 10) {
            String txtToSearch = this.txtSearch.getText();
            this.searchByKey(txtToSearch);
        }
    }

    public void keyTyped(KeyEvent ke) {
    }

    public void keyReleased(KeyEvent ke) {
    }

    private void searchByKey(String txtToSearch) {
        int dataLength = this.dataStr.length;
        this.tableModel.setDataVector(this.dataStr, COLUMN_NAMES);
        String dataS = null;
        int i = 0;
        int j = 0;
        while (i < dataLength) {
            dataS = this.dataStr[i][FULL_NAME_COLUMN_INDEX];
            if (dataS != null && dataS.indexOf(txtToSearch) == -1) {
                this.monitorPathsForDel.add(this.dataStr[i][FULL_NAME_COLUMN_INDEX]);
                this.tableModel.removeRow(i - j);
                ++j;
            }
            ++i;
        }
        this.setNewData();
        this.table.setModel(this.tableModel);
        this.table.validate();
    }

    private void removeSelectedRows(int[] selectedRows) {
        int i = 0;
        while (i < selectedRows.length) {
            this.monitorPathsForDel.add(this.dataStr[selectedRows[i]][FULL_NAME_COLUMN_INDEX]);
            this.tableModel.removeRow(selectedRows[i]);
            ++i;
        }
        this.setNewData();
        this.table.setModel(this.tableModel);
        this.table.validate();
    }

    private void setNewData() {
        Vector<Vector> dataVector = this.tableModel.getDataVector();
        this.dataStr = new String[dataVector.size()][2];
        int i = 0;
        while (i < dataVector.size()) {
            int j = 0;
            while (j < dataVector.elementAt(i).size()) {
                if (dataVector.elementAt(i) != null && dataVector.elementAt(i).elementAt(j) != null) {
                    this.dataStr[i][j] = dataVector.elementAt(i).elementAt(j).toString();
                }
                ++j;
            }
            ++i;
        }
    }

    private void restoreDefaultTree() {
        this.currentPanel.restoreDefault();
    }

    private void restoreDefaultTrees() {
        int i = 0;
        while (i < this.panels.length) {
            this.panels[i].restoreDefault();
            ++i;
        }
    }

    protected void deletePathsFromView() {
        this.currentPanel.getDefaultTreeModel();
        int i = 0;
        while (i < this.monitorPathsForDel.size()) {
            this.removeNode(this.monitorPathsForDel.elementAt(i).toString(), this.currentPanel);
            ++i;
        }
    }

    protected void deletePathsFromAllViews() {
        int i = 0;
        while (i < this.panels.length) {
            this.panels[i].getDefaultTreeModel();
            int j = 0;
            while (j < this.monitorPathsForDel.size()) {
                this.removeNode(this.monitorPathsForDel.elementAt(j).toString(), this.panels[i]);
                ++j;
            }
            ++i;
        }
    }

    protected void removeNode(String path, IMonitorPanel iPanel) {
        TreePath treePath = null;
        try {
            treePath = iPanel.constructPathFromString(path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DefaultMutableTreeNode nodeDel = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        this.checkParent(nodeDel, iPanel);
        iPanel.getTreeModel().reload();
    }

    protected void removeNode(TreePath treePath, IMonitorPanel iPanel) {
        DefaultMutableTreeNode nodeDel = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        this.checkParent(nodeDel, iPanel);
        iPanel.getTreeModel().reload();
    }

    private void checkParent(DefaultMutableTreeNode nodeForDel, IMonitorPanel iPanel) {
        TreeNode parent = nodeForDel.getParent();
        if (parent.getChildCount() == 1) {
            this.checkParent((DefaultMutableTreeNode)parent, iPanel);
        } else {
            iPanel.getTreeModel().removeNodeFromParent(nodeForDel);
        }
    }
}

