/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.dispatcher;

import com.sap.bc.proj.jstartup.JStartupFramework;
import com.sap.engine.frame.CommunicationFrameAdaptor;
import com.sap.engine.frame.CommunicationServiceContext;
import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.container.event.ContainerEventListener;
import com.sap.engine.frame.container.registry.ObjectRegistry;
import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.frame.state.ServiceState;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.ShellInterface;
import com.sap.engine.services.monitor.common.MonitorRuntimeControlImpl;
import com.sap.engine.services.monitor.common.MonitorServiceRuntime;
import com.sap.engine.services.monitor.dispatcher.MonitorServiceDispatcherRuntime;
import com.sap.engine.services.monitor.install.MonitorContextImpl;
import com.sap.engine.services.monitor.shell.ChangeDescriptionCommand;
import com.sap.engine.services.monitor.shell.ChangePeriodCommand;
import com.sap.engine.services.monitor.shell.ChangeReactOnFailureCommand;
import com.sap.engine.services.monitor.shell.ChangeStatesCommand;
import com.sap.engine.services.monitor.shell.ChangeThresholdsCommand;
import com.sap.engine.services.monitor.shell.ListMonitorTreeCommand;
import com.sap.engine.services.monitor.shell.MonitorInfoCommand;
import com.sap.engine.services.monitor.shell.PersistMonitoringDataCommand;
import com.sap.jmx.ObjectNameFactory;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.management.ObjectName;

public class MonitorDispatcherFrame
extends CommunicationFrameAdaptor
implements ContainerEventListener {
    private boolean running = false;
    private MonitorServiceRuntime m_serviceRuntime;
    private CommunicationServiceContext serviceContext = null;
    private Properties properties = null;
    private ServiceState serviceState = null;
    private int shellCommandId = 0;
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$monitor$dispatcher$MonitorDispatcherFrame == null ? (class$com$sap$engine$services$monitor$dispatcher$MonitorDispatcherFrame = MonitorDispatcherFrame.class$("com.sap.engine.services.monitor.dispatcher.MonitorDispatcherFrame")) : class$com$sap$engine$services$monitor$dispatcher$MonitorDispatcherFrame));
    static /* synthetic */ Class class$com$sap$engine$services$monitor$dispatcher$MonitorDispatcherFrame;

    public void start() throws ServiceException {
        try {
            this.serviceState = this.getServiceContext().getServiceState();
            this.serviceContext = this.getServiceContext();
            int nodeId = this.serviceContext.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
            this.m_serviceRuntime = MonitorServiceDispatcherRuntime.createInstance(this, this.serviceState, this.serviceContext.getContainerContext().getSystemMonitor(), nodeId);
            this.serviceState.registerManagementInterface((ManagementInterface)new MonitorRuntimeControlImpl(this.m_serviceRuntime));
            this.m_serviceRuntime.installCcmsConnector();
            this.m_serviceRuntime.installTopNodes();
            ObjectRegistry registry = this.serviceContext.getContainerContext().getObjectRegistry();
            MonitorContextImpl monitorContext = new MonitorContextImpl(this.m_serviceRuntime);
            registry.registerInterfaceProvider("tc~monitoring~api", (Object)monitorContext);
            int mask = 65;
            HashSet<String> names = new HashSet<String>(1);
            names.add("shell");
            this.serviceContext.getServiceState().registerContainerEventListener(mask, names, (ContainerEventListener)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.registerSAPOsColTemplates();
        }
        catch (Exception e) {
            Category.SYSTEM.logThrowableT(500, location, "registerSAPOsColTemplates()", "Could not create template file for monitoring via SapOsCol engine proceses.", new Object[]{this}, (Throwable)e);
        }
    }

    public void stop() {
        ShellInterface shellInterface;
        if (this.m_serviceRuntime != null) {
            this.m_serviceRuntime.stop();
        }
        this.serviceContext.getContainerContext().getObjectRegistry().unregisterInterfaceProvider("tc~monitoring~api");
        this.serviceState.unregisterManagementInterface();
        this.serviceState.unregisterContainerEventListener();
        MonitorServiceDispatcherRuntime.deleteInstance();
        this.m_serviceRuntime = null;
        if (this.serviceContext.getContainerContext().getSystemMonitor().getInterface("shell").getStatus() == 11 && (shellInterface = (ShellInterface)this.serviceContext.getContainerContext().getObjectRegistry().getProvidedInterface("shell")) != null) {
            shellInterface.unregisterCommands(this.shellCommandId);
        }
    }

    public boolean changeProperties(Properties properties) throws IllegalArgumentException {
        if (this.m_serviceRuntime != null) {
            return this.m_serviceRuntime.changeProperties(properties);
        }
        return true;
    }

    public void containerStarted() {
        try {
            this.properties = this.serviceState.getProperties();
            this.m_serviceRuntime.init(this.properties);
            this.m_serviceRuntime.run();
            this.m_serviceRuntime.assureAgentIsRegistered();
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    public void beginContainerStop() {
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
    }

    public void serviceNotStarted(String serviceName) {
    }

    public void beginServiceStop(String serviceName) {
    }

    public void serviceStopped(String serviceName) {
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        if (interfaceName.equals("shell")) {
            ShellInterface shellInterface = (ShellInterface)interfaceImpl;
            this.shellCommandId = shellInterface.registerCommands(this.getMonitorCommands());
        }
    }

    private Command[] getMonitorCommands() {
        return new Command[]{new ListMonitorTreeCommand((ServiceContext)this.serviceContext), new MonitorInfoCommand((ServiceContext)this.serviceContext), new ChangeThresholdsCommand((ServiceContext)this.serviceContext), new ChangeDescriptionCommand((ServiceContext)this.serviceContext), new ChangePeriodCommand((ServiceContext)this.serviceContext), new ChangeReactOnFailureCommand((ServiceContext)this.serviceContext), new ChangeStatesCommand((ServiceContext)this.serviceContext), new PersistMonitoringDataCommand((ServiceContext)this.serviceContext)};
    }

    public void interfaceNotAvailable(String interfaceName) {
    }

    public void markForShutdown(long timeout) {
    }

    public boolean setServiceProperties(Properties properties) {
        return this.changeProperties(properties);
    }

    public boolean setServiceProperty(String key, String value) {
        Properties currentProperties = this.getServiceContext().getServiceState().getProperties();
        Properties properties = (Properties)((Hashtable)currentProperties).clone();
        ((Hashtable)properties).put(key, value);
        return this.changeProperties(properties);
    }

    /*
     * Loose catch block
     */
    protected void registerSAPOsColTemplates() throws Exception {
        block10: {
            String dir = JStartupFramework.getParam((String)"DIR_PERF");
            if (dir == null || dir.length() == 0) {
                throw new Exception("Directory does not exists.");
            }
            String sapSystem = System.getProperty("SAPSYSTEM");
            String sapSystemName = System.getProperty("SAPSYSTEMNAME");
            String userName = System.getProperty("user.name");
            File file = new File(dir + File.separator + "procmon" + File.separator + "J2EE_" + sapSystemName + "_" + sapSystem + "_procmon.ini");
            String dispacherTemplate = "*jlaunch*-DSAPINFO=" + sapSystemName + "_" + sapSystem + "_dispatcher* USER=" + userName + " MTE_NAME=" + sapSystemName + "_" + sapSystem + "_dispatcher MTE_CLASS=J2EE_PROC";
            String serverTemplate = "*jlaunch*-DSAPINFO=" + sapSystemName + "_" + sapSystem + "_server* USER=" + userName + " MTE_NAME=" + sapSystemName + "_" + sapSystem + "_server MTE_CLASS=J2EE_PROC";
            String sdmTemplate = "*jlaunch*-DSAPINFO=" + sapSystemName + "_" + sapSystem + "_sdm* USER=" + userName + " MTE_NAME=" + sapSystemName + "_" + sapSystem + "_sdm MTE_CLASS=J2EE_PROC";
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(file, "rw");
            }
            catch (Exception e) {
                throw new Exception("Could not create SAPOsCol template file. " + e.getMessage());
            }
            this.createNewSapOsColTemplateFile(raf, dispacherTemplate, serverTemplate, sdmTemplate);
            Object var12_12 = null;
            try {
                raf.close();
            }
            catch (Exception e) {
                location.debugT(e.getMessage());
            }
            break block10;
            {
                catch (Exception e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                try {
                    raf.close();
                }
                catch (Exception e) {
                    location.debugT(e.getMessage());
                }
                throw throwable;
            }
        }
    }

    protected void createNewSapOsColTemplateFile(RandomAccessFile raf, String dispacherTemplate, String serverTemplate, String sdmTemplate) throws Exception {
        raf.seek(0L);
        raf.setLength(0L);
        raf.write("$PROC\r\n".getBytes());
        raf.write((dispacherTemplate + "\r\n").getBytes());
        raf.write((serverTemplate + "\r\n").getBytes());
        String msHost = this.serviceContext.getCoreContext().getCoreMonitor().getManagerRuntimeProperty("ClusterManager", "ms.host");
        Boolean central = new Boolean("false");
        try {
            ObjectName instanceON = ObjectNameFactory.getNameForServerChild((String)"SAP_J2EEInstance", (String)"local", null);
            central = (Boolean)MonitorServiceRuntime.getMBeanServer().getAttribute(instanceON, "Central");
            if (central.booleanValue()) {
                raf.write((sdmTemplate + "\r\n").getBytes());
            }
        }
        catch (Exception e) {
            location.debugT("Could not find if the isntance is central or not for SapOsColTemplate." + e.getMessage());
        }
        raf.write("$".getBytes());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

