/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.deployment;

import com.sap.bc.proj.jstartup.JStartupFramework;
import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.services.deploy.container.AdditionalAppInfo;
import com.sap.engine.services.deploy.container.ApplicationDeployInfo;
import com.sap.engine.services.deploy.container.ContainerDeploymentInfo;
import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.ExportInfo;
import com.sap.engine.services.deploy.container.FileUpdateInfo;
import com.sap.engine.services.deploy.container.ProgressListener;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.monitor.deployment.ApplicationLifeCycle;
import com.sap.engine.services.monitor.deployment.MonitorDeploymentException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class MonitorDeploymentContainer
implements ContainerInterface {
    public static final String CONFIG_FILE_NAME = "monitor-configuration.xml";
    public static final String GRMG_FILE_NAME = "grmg-customizing.xml";
    public static final String CONFIG_FILE_PATH = "META-INF/";
    public static final String CONTAINER_NAME = "Monitoring Configurator";
    public static final String MODULE_NAME = "Monitoring Configuration";
    private ContainerInfo info = null;
    private ApplicationLifeCycle appLifeCycle = null;
    private ApplicationServiceContext serviceContext;

    public MonitorDeploymentContainer(ApplicationServiceContext serviceContext, ApplicationLifeCycle appLifeCycle) {
        this.appLifeCycle = appLifeCycle;
        this.info = new ContainerInfo();
        this.info.setFileExtensions(null);
        this.info.setFileNames(new String[]{"META-INF/monitor-configuration.xml", "META-INF/grmg-customizing.xml"});
        this.info.setJ2EEContainer(false);
        this.info.setJ2EEModuleName(null);
        this.info.setModuleName(MODULE_NAME);
        this.info.setName(CONTAINER_NAME);
        this.info.setResourceTypes(null);
        this.info.setServiceName(serviceContext.getServiceState().getServiceName());
        this.info.setSupportingSingleFileUpdate(false);
        this.info.setPriority(0);
        this.serviceContext = serviceContext;
    }

    public ContainerInfo getContainerInfo() {
        return this.info;
    }

    public String getApplicationName(File standaloneFile) throws DeploymentException {
        throw new DeploymentException("Standalone deployment not supported by Monitoring Configurator container");
    }

    public ApplicationDeployInfo deploy(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        Configuration config = null;
        File file = null;
        try {
            config = dInfo.getConfiguration().createSubConfiguration(CONTAINER_NAME);
            file = this.getFileByName(CONFIG_FILE_NAME, archiveFiles);
            if (file != null) {
                config.addFileEntryByKey(CONFIG_FILE_NAME, file);
                this.appLifeCycle.applicationDeployed(dInfo.getApplicationName(), file);
            }
        }
        catch (MonitorDeploymentException mde) {
            throw mde;
        }
        catch (Exception exc) {
            throw new DeploymentException("Deployment of monitoring configuration for application " + dInfo.getApplicationName() + " failed", (Throwable)exc);
        }
        try {
            file = this.getFileByName(GRMG_FILE_NAME, archiveFiles);
            if (file != null) {
                config.addFileEntryByKey(GRMG_FILE_NAME, file);
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Deployment of monitoring configuration for application " + dInfo.getApplicationName() + " failed", (Throwable)e);
        }
        ApplicationDeployInfo appDeployInfo = new ApplicationDeployInfo();
        appDeployInfo.setDeployedComponentNames(new String[]{dInfo.getApplicationName() + " monitoring configuration"});
        appDeployInfo.setOptionalContainer(true);
        return appDeployInfo;
    }

    public void notifyDeployedComponents(String applicationName, Properties props) throws WarningException {
    }

    public void prepareDeploy(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
    }

    public void commitDeploy(String applicationName) throws WarningException {
    }

    public void rollbackDeploy(String applicationName) throws WarningException {
    }

    public boolean needUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        return true;
    }

    public boolean needStopOnUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        return true;
    }

    public ApplicationDeployInfo makeUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        WarningException we = null;
        try {
            this.remove(dInfo.getApplicationName());
        }
        catch (WarningException _we) {
            we = _we;
        }
        try {
            dInfo.getConfiguration().deleteConfiguration(CONTAINER_NAME);
        }
        catch (ConfigurationException cex) {
            cex.log();
        }
        ApplicationDeployInfo appDeployInfo = this.deploy(archiveFiles, dInfo, props);
        if (we != null) {
            appDeployInfo.addWarnings(we.getWarnings());
        }
        return appDeployInfo;
    }

    public void notifyUpdatedComponents(String applicationName, Configuration applicationConfig, Properties props) throws WarningException {
    }

    public void prepareUpdate(String applicationName) throws DeploymentException, WarningException {
    }

    public ApplicationDeployInfo commitUpdate(String applicationName) throws WarningException {
        return null;
    }

    public void rollbackUpdate(String applicationName, Configuration applicationConfig, Properties props) throws WarningException {
    }

    public void remove(String applicationName) throws DeploymentException, WarningException {
        File file;
        String dir = JStartupFramework.getParam((String)"DIR_PERF");
        if ((dir != null || dir.length() != 0) && (file = new File(dir + File.separator + "grmg" + File.separator + applicationName.replace('/', '.') + ".xml")).exists()) {
            file.delete();
        }
        try {
            this.appLifeCycle.applicationRemoved(applicationName);
        }
        catch (Exception exc) {
            throw new WarningException("Removal of monitoring configuration when undeploying application " + applicationName + " failed", exc);
        }
    }

    public void downloadApplicationFiles(String applicationName, Configuration applicationConfig) throws DeploymentException, WarningException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepareStart(String applicationName, Configuration applicationConfig) throws DeploymentException, WarningException {
        InputStream input = null;
        Configuration configuration = null;
        boolean flagMonitor = false;
        boolean flagGRMG = false;
        try {
            configuration = applicationConfig.getSubConfiguration(CONTAINER_NAME);
            flagMonitor = configuration.existsFile(CONFIG_FILE_NAME);
            flagGRMG = configuration.existsFile(GRMG_FILE_NAME);
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to configure monitors of " + applicationName + " application. Persistent data is not accessible.", (Throwable)e);
        }
        if (!flagMonitor && !flagGRMG) {
            throw new WarningException("No configuration files from monitoring service for applicaiton " + applicationName + " found in DB.");
        }
        if (!flagMonitor) {
            return;
        }
        try {
            input = configuration.getFile(CONFIG_FILE_NAME);
        }
        catch (Exception exc) {
            throw new DeploymentException("Failed to configure monitors of " + applicationName + " application. Persistent data is not accessible.", (Throwable)exc);
        }
        try {
            try {
                this.appLifeCycle.applicationStarted(applicationName, input);
            }
            catch (MonitorDeploymentException mde) {
                throw mde;
            }
            catch (Exception exc) {
                throw new WarningException("Configuration of monitors for application " + applicationName + " failed at startup", exc);
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                input.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        input.close();
        return;
    }

    public void commitStart(String applicationName) throws WarningException {
    }

    public void rollbackStart(String applicationName) throws WarningException {
        this.commitStop(applicationName);
    }

    public void prepareStop(String applicationName, Configuration applicationConfig) throws DeploymentException, WarningException {
    }

    public void commitStop(String applicationName) throws WarningException {
        try {
            this.appLifeCycle.applicationStopped(applicationName);
        }
        catch (MonitorDeploymentException mde) {
            throw new WarningException("Removal of monitoring configuration when stopping application " + applicationName + " failed", (Exception)((Object)mde));
        }
    }

    public void rollbackStop(String applicationName) throws WarningException {
    }

    public void notifyRuntimeChanges(String applicationName, Configuration appConfig) throws WarningException {
        this.notifyUpdatedComponents(applicationName, appConfig, null);
    }

    public void prepareRuntimeChanges(String applicationName) throws DeploymentException, WarningException {
    }

    public ApplicationDeployInfo commitRuntimeChanges(String applicationName) throws WarningException {
        return null;
    }

    public void rollbackRuntimeChanges(String applicationName) throws WarningException {
    }

    public File[] getClientJar(String applicationName) {
        return new File[0];
    }

    public void addProgressListener(ProgressListener listener) {
    }

    public void removeProgressListener(ProgressListener listener) {
    }

    public ExportInfo[] getCurrentStatus(String applicationName) throws WarningException {
        return new ExportInfo[0];
    }

    public boolean needStopOnSingleFileUpdate(FileUpdateInfo[] files, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        return false;
    }

    public ApplicationDeployInfo makeSingleFileUpdate(FileUpdateInfo[] files, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        return null;
    }

    public void notifySingleFileUpdate(String applicationName, Configuration config, Properties props) throws WarningException {
    }

    public void prepareSingleFileUpdate(String applicationName) throws DeploymentException, WarningException {
    }

    public ApplicationDeployInfo commitSingleFileUpdate(String applicationName) throws WarningException {
        return null;
    }

    public void rollbackSingleFileUpdate(String applicationName, Configuration config) throws WarningException {
    }

    public void applicationStatusChanged(String applicationName, byte status) {
    }

    public String[] getResourcesForTempLoader(String applicationName) throws DeploymentException {
        return new String[0];
    }

    public boolean acceptedAppInfoChange(String appName, AdditionalAppInfo addAppInfo) throws DeploymentException {
        return false;
    }

    public boolean needStopOnAppInfoChanged(String appName, AdditionalAppInfo addAppInfo) {
        return false;
    }

    public void makeAppInfoChange(String appName, AdditionalAppInfo addAppInfo, Configuration configuration) throws WarningException, DeploymentException {
    }

    public void appInfoChangedCommit(String appName) throws WarningException {
    }

    public void appInfoChangedRollback(String appName) throws WarningException {
    }

    public void notifyAppInfoChanged(String appName) throws WarningException {
    }

    private File getFileByName(String fileName, File[] archiveFiles) {
        if (archiveFiles == null) {
            return null;
        }
        int i = 0;
        while (i < archiveFiles.length) {
            if (archiveFiles[i].getName().endsWith(fileName)) {
                return archiveFiles[i];
            }
            ++i;
        }
        return null;
    }
}

