/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.config;

import com.sap.engine.services.monitor.config.DataCollection;
import com.sap.engine.services.monitor.config.Description;
import com.sap.engine.services.monitor.config.MonitorConfigurationGroup;
import com.sap.engine.services.monitor.config.SimpleConfigurationGroup;
import java.util.Arrays;

public class StateConfigurationGroup
extends MonitorConfigurationGroup {
    public static final int ALWAYS = 1;
    public static final int NEVER = 4;
    public static final int ON_STATE_COLOR_CHANGE = 2;
    public static final int ON_STATE_TEXT_CHANGE = 3;
    private String[] greenStates;
    private String[] yellowStates;
    private String[] redStates;
    private int alertMode;

    public StateConfigurationGroup(String globalConfigurationGroupName, Description description, DataCollection dataCollection, String[] greenStates, String[] yellowStates, String[] redStates, int alertMode, String owner, boolean isCustomized) {
        super(globalConfigurationGroupName, description, dataCollection, owner, isCustomized);
        this.greenStates = greenStates;
        this.yellowStates = yellowStates;
        this.redStates = redStates;
        this.alertMode = alertMode;
    }

    public int getAlertMode() {
        return this.alertMode;
    }

    public String[] getGreenStates() {
        return this.greenStates;
    }

    public String[] getRedStates() {
        return this.redStates;
    }

    public String[] getYellowStates() {
        return this.yellowStates;
    }

    public void setAlertMode(int alertMode) {
        this.alertMode = alertMode;
    }

    public void setGreenStates(String[] greenStates) {
        this.greenStates = greenStates;
    }

    public void setRedStates(String[] redStates) {
        this.redStates = redStates;
    }

    public void setYellowStates(String[] yellowStates) {
        this.yellowStates = yellowStates;
    }

    public boolean equals(StateConfigurationGroup group) {
        if (super.equals(group)) {
            if (Arrays.equals(this.getGreenStates(), group.getGreenStates()) && Arrays.equals(this.getRedStates(), group.getRedStates()) && Arrays.equals(this.getYellowStates(), group.getYellowStates())) {
                return true;
            }
            SimpleConfigurationGroup.location.errorT("[" + group.getGlobalConfigurationGroupName() + "] Equal groups,but with different states mapping arrays. Please change the group name to prevent errors.");
            return false;
        }
        return false;
    }
}

