/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.config;

import com.sap.engine.services.monitor.config.DataCollection;
import com.sap.engine.services.monitor.config.Description;
import com.sap.engine.services.monitor.config.History;
import com.sap.engine.services.monitor.config.MonitorConfigurationGroup;
import com.sap.engine.services.monitor.config.SimpleConfigurationGroup;
import com.sap.engine.services.monitor.config.Thresholds;

public class PerformanceMonitorConfigurationGroup
extends MonitorConfigurationGroup {
    public static final int LAST = 1;
    public static final int DISCRETE_HOUR = 3;
    public static final int DISCRETE_QUARTER = 2;
    public static final int DISCRETE_MINUTE = 4;
    public static final int SLIDING_WINDOW_5_MINUTES = 5;
    public static final int SLIDING_WINDOW_QUARTER = 6;
    private Thresholds thresholds;
    private String unit;
    private int alertRelevantValueType;
    private History history;

    public PerformanceMonitorConfigurationGroup(String globalConfigurationGroupName, Description description, DataCollection dataCollection, Thresholds thresholds, History history, String unit, int alertRelevantValueType, String owner, boolean isCustomized) {
        super(globalConfigurationGroupName, description, dataCollection, owner, isCustomized);
        this.thresholds = thresholds;
        this.history = history;
        this.unit = unit;
        this.alertRelevantValueType = alertRelevantValueType;
    }

    public int getAlertRelevantValueType() {
        return this.alertRelevantValueType;
    }

    public void setAlertRelevantValueType(int alertRelevantValueType) {
        this.alertRelevantValueType = alertRelevantValueType;
    }

    public Thresholds getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(Thresholds thresholds) {
        this.thresholds = thresholds;
    }

    public History getHistory() {
        return this.history;
    }

    public void setHistory(History history) {
        this.history = history;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public boolean equals(PerformanceMonitorConfigurationGroup group) {
        if (super.equals(group)) {
            if (this.getAlertRelevantValueType() != group.getAlertRelevantValueType()) {
                SimpleConfigurationGroup.location.errorT("[" + group.getGlobalConfigurationGroupName() + "] Equal groups,but with different alert relevant types. Please change the group name to prevent errors.");
                return false;
            }
            if (this.getHistory().getAveragingMode() != group.getHistory().getAveragingMode()) {
                SimpleConfigurationGroup.location.errorT("[" + group.getGlobalConfigurationGroupName() + "] Equal groups,but with different averaging modes for history. Please change the group name to prevent errors.");
                return false;
            }
            if (this.getThresholds().getGreen2Yellow() != group.getThresholds().getGreen2Yellow() || this.getThresholds().getRed2Yellow() != group.getThresholds().getRed2Yellow() || this.getThresholds().getYellow2Green() != group.getThresholds().getYellow2Green() || this.getThresholds().getYellow2Red() != group.getThresholds().getYellow2Red()) {
                SimpleConfigurationGroup.location.errorT("[" + group.getGlobalConfigurationGroupName() + "] Equal groups,but with different thresholds. Please change the group name to prevent errors.");
                return false;
            }
            return true;
        }
        return false;
    }
}

