/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.config;

import com.sap.engine.frame.core.configuration.ChangeEvent;
import com.sap.engine.frame.core.configuration.ConfigurationChangedListener;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.impl0.PerformanceMonitorNode;
import com.sap.engine.library.monitor.impl0.StateMonitorNode;
import com.sap.engine.library.monitor.impl0.VariableStateMonitorNode;
import com.sap.engine.library.monitor.mapping.MappingTreeNode;
import com.sap.engine.library.monitor.mapping.ccms.CcmsConnector;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.common.MonitorConfigurationHandler;
import com.sap.engine.services.monitor.common.MonitorServiceRuntime;
import com.sap.engine.services.monitor.config.ConfigurationServiceMBean;
import com.sap.engine.services.monitor.config.DataCollection;
import com.sap.engine.services.monitor.config.Description;
import com.sap.engine.services.monitor.config.MonitorConfigurationGroup;
import com.sap.engine.services.monitor.config.PerformanceMonitorConfigurationGroup;
import com.sap.engine.services.monitor.config.Period;
import com.sap.engine.services.monitor.config.SimpleConfigurationGroup;
import com.sap.engine.services.monitor.config.StateConfigurationGroup;
import com.sap.engine.services.monitor.config.TableConfigurationGroup;
import com.sap.engine.services.monitor.config.Thresholds;
import com.sap.engine.services.monitor.mbeans.Monitor;
import com.sap.engine.services.monitor.mbeans.TimerFilter;
import com.sap.jmx.ObjectNameFactory;
import com.sap.tc.logging.Location;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.ObjectName;

public class ConfigurationService
implements ConfigurationServiceMBean,
ConfigurationChangedListener {
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$monitor$config$ConfigurationService == null ? (class$com$sap$engine$services$monitor$config$ConfigurationService = ConfigurationService.class$("com.sap.engine.services.monitor.config.ConfigurationService")) : class$com$sap$engine$services$monitor$config$ConfigurationService));
    private CcmsConnector ccmsConnector;
    MonitorServiceRuntime msr;
    ConfigurationHandler handler;
    static /* synthetic */ Class class$com$sap$engine$services$monitor$config$ConfigurationService;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Date;

    public ConfigurationService(MonitorServiceRuntime msr, ConfigurationHandler configHandler) {
        this.msr = msr;
        this.handler = configHandler;
        this.ccmsConnector = CcmsConnector.getInstance();
        location.infoT("***************** CONFIGURATION SERVICE MBEAN is created *******************");
    }

    public void setStates(String configGroupName, String[][] states) throws Exception {
        Hashtable groups = MonitorServiceRuntime.getConfigurationGroups();
        StateConfigurationGroup group = null;
        try {
            group = (StateConfigurationGroup)groups.get(configGroupName);
        }
        catch (ClassCastException e) {
            location.errorT("Cannot set states to a not state monitor group:" + configGroupName);
            throw e;
        }
        if (group == null) {
            location.errorT("Cannot set states to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
            throw new Exception("Cannot set states to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
        }
        Vector<String> greenStates = new Vector<String>();
        Vector<String> yellowStates = new Vector<String>();
        Vector<String> redStates = new Vector<String>();
        int i = 0;
        while (i < states.length) {
            if (states[i][2] != null) {
                greenStates.add(states[i][2]);
            }
            if (states[i][1] != null) {
                yellowStates.add(states[i][1]);
            }
            if (states[i][0] != null) {
                redStates.add(states[i][0]);
            }
            ++i;
        }
        String[] greenStatesAr = new String[greenStates.size()];
        String[] yellowStatesAr = new String[yellowStates.size()];
        String[] redStatesAr = new String[redStates.size()];
        int i2 = 0;
        while (i2 < greenStates.size()) {
            greenStatesAr[i2] = (String)greenStates.get(i2);
            ++i2;
        }
        int i3 = 0;
        while (i3 < yellowStates.size()) {
            yellowStatesAr[i3] = (String)yellowStates.get(i3);
            ++i3;
        }
        int i4 = 0;
        while (i4 < redStates.size()) {
            redStatesAr[i4] = (String)redStates.get(i4);
            ++i4;
        }
        group.setGreenStates(greenStatesAr);
        group.setYellowStates(yellowStatesAr);
        group.setRedStates(redStatesAr);
        this.msr.getMonitorConfigurationHandler().customizeGroup(group);
    }

    public void setDescription(String configGroupName, String newDescription) throws Exception {
        Hashtable groups = MonitorServiceRuntime.getConfigurationGroups();
        SimpleConfigurationGroup group = (SimpleConfigurationGroup)groups.get(configGroupName);
        if (group == null) {
            location.errorT("Cannot set description to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
            throw new Exception("Cannot set description to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
        }
        Description oldDescription = group.getDescription();
        oldDescription.setText(newDescription);
        group.setDescription(oldDescription);
        this.msr.getMonitorConfigurationHandler().customizeGroup(group);
    }

    public void setPeriodValue(String configGroupName, int value) throws Exception {
        Hashtable groups = MonitorServiceRuntime.getConfigurationGroups();
        MonitorConfigurationGroup group = null;
        try {
            group = (MonitorConfigurationGroup)groups.get(configGroupName);
        }
        catch (ClassCastException e) {
            location.errorT("Cannot set Data Collection to a simple monitor group:" + configGroupName);
            location.errorT(Util.getStackTraceAsString(e));
            throw e;
        }
        if (group == null) {
            location.errorT("Cannot set period value to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
            throw new Exception("Cannot set period value to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
        }
        DataCollection dataCollection = group.getDataCollection();
        dataCollection.setCollectPeriod(new Period(value, dataCollection.getCollectPeriod().getUnit()));
        group.setDataCollection(dataCollection);
        this.msr.getMonitorConfigurationHandler().customizeGroup(group);
    }

    public void setPeriodUnit(String configGroupName, int unit) throws Exception {
        Hashtable groups = MonitorServiceRuntime.getConfigurationGroups();
        MonitorConfigurationGroup group = null;
        try {
            group = (MonitorConfigurationGroup)groups.get(configGroupName);
        }
        catch (ClassCastException e) {
            location.errorT("Cannot set Data Collection to a simple monitor group:" + configGroupName);
            location.errorT(Util.getStackTraceAsString(e));
            throw e;
        }
        if (group == null) {
            location.errorT("Cannot set period unit to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
            throw new Exception("Cannot set period unit to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
        }
        DataCollection dataCollection = group.getDataCollection();
        dataCollection.setCollectPeriod(new Period(dataCollection.getCollectPeriod().getValue(), unit));
        group.setDataCollection(dataCollection);
        this.msr.getMonitorConfigurationHandler().customizeGroup(group);
    }

    public void setPeriod(String configGroupName, int value, int unit) throws Exception {
        Hashtable groups = MonitorServiceRuntime.getConfigurationGroups();
        MonitorConfigurationGroup group = null;
        try {
            group = (MonitorConfigurationGroup)groups.get(configGroupName);
        }
        catch (ClassCastException e) {
            location.errorT("Cannot set Data Collection to a simple monitor group:" + configGroupName);
            location.errorT(Util.getStackTraceAsString(e));
            throw e;
        }
        if (group == null) {
            location.errorT("Cannot set period to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
            throw new Exception("Cannot set period to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
        }
        DataCollection dataCollection = group.getDataCollection();
        dataCollection.setCollectPeriod(new Period(value, unit));
        group.setDataCollection(dataCollection);
        this.msr.getMonitorConfigurationHandler().customizeGroup(group);
    }

    public void setReactOnCollectionFailure(String configGroupName, int reactOnCollectionFailure) throws Exception {
        Hashtable groups = MonitorServiceRuntime.getConfigurationGroups();
        MonitorConfigurationGroup group = null;
        try {
            group = (MonitorConfigurationGroup)groups.get(configGroupName);
        }
        catch (ClassCastException e) {
            location.errorT("Cannot set Data Collection to a simple monitor group:" + configGroupName);
            location.errorT(Util.getStackTraceAsString(e));
            throw e;
        }
        if (group == null) {
            location.errorT("Cannot set reactOnCollectionFailure to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
            throw new Exception("Cannot set reactOnCollectionFailure to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
        }
        DataCollection dataCollection = group.getDataCollection();
        dataCollection.setReactOnCollectionFailure(reactOnCollectionFailure);
        group.setDataCollection(dataCollection);
        this.msr.getMonitorConfigurationHandler().customizeGroup(group);
    }

    public void setDataCollection(String configGroupName, int periodUnit, int value, int reactOnCollectionFailure) throws Exception {
        Hashtable groups = MonitorServiceRuntime.getConfigurationGroups();
        MonitorConfigurationGroup group = null;
        try {
            group = (MonitorConfigurationGroup)groups.get(configGroupName);
        }
        catch (ClassCastException e) {
            location.errorT("Cannot set Data Collection to a simple monitor group:" + configGroupName);
            location.errorT(Util.getStackTraceAsString(e));
            throw e;
        }
        if (group == null) {
            location.errorT("Cannot set data collection to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
            throw new Exception("Cannot set data collection to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
        }
        DataCollection dataCollection = null;
        if (group.getDataCollection() != null && group.getDataCollection().getDataCollectionType() == DataCollection.POLLED_BY_MONITOR) {
            dataCollection = new DataCollection(group.getDataCollection().getDataCollectionType(), new Period(value, periodUnit), reactOnCollectionFailure);
        } else {
            dataCollection = group.getDataCollection();
            dataCollection.setReactOnCollectionFailure(reactOnCollectionFailure);
        }
        group.setDataCollection(dataCollection);
        this.msr.getMonitorConfigurationHandler().customizeGroup(group);
    }

    public void setThresholdsGreenToYellow(String configGroupName, int greenToYelowValue) throws Exception {
        Hashtable groups = MonitorServiceRuntime.getConfigurationGroups();
        PerformanceMonitorConfigurationGroup group = null;
        try {
            group = (PerformanceMonitorConfigurationGroup)groups.get(configGroupName);
        }
        catch (ClassCastException e) {
            location.errorT("Cannot set Thresholds to a non performance monitor group:" + configGroupName);
            throw e;
        }
        if (group == null) {
            location.errorT("Cannot set thresholds to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
            throw new Exception("Cannot set thresholds to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
        }
        Thresholds oldThresholds = group.getThresholds();
        group.setThresholds(new Thresholds(greenToYelowValue, oldThresholds.getYellow2Red(), oldThresholds.getRed2Yellow(), oldThresholds.getYellow2Green()));
        this.msr.getMonitorConfigurationHandler().customizeGroup(group);
    }

    public void setThresholdsYellowToRed(String configGroupName, int yellowToRedValue) throws Exception {
        Hashtable groups = MonitorServiceRuntime.getConfigurationGroups();
        PerformanceMonitorConfigurationGroup group = null;
        try {
            group = (PerformanceMonitorConfigurationGroup)groups.get(configGroupName);
        }
        catch (ClassCastException e) {
            location.errorT("Cannot set Thresholds to a non performance monitor group:" + configGroupName);
            throw e;
        }
        if (group == null) {
            location.errorT("Cannot set thresholds to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
            throw new Exception("Cannot set thresholds to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
        }
        Thresholds oldThresholds = group.getThresholds();
        group.setThresholds(new Thresholds(oldThresholds.getGreen2Yellow(), yellowToRedValue, oldThresholds.getRed2Yellow(), oldThresholds.getYellow2Green()));
        this.msr.getMonitorConfigurationHandler().customizeGroup(group);
    }

    public void setThresholdsRedToYellow(String configGroupName, int redToYellowValue) throws Exception {
        Hashtable groups = MonitorServiceRuntime.getConfigurationGroups();
        PerformanceMonitorConfigurationGroup group = null;
        try {
            group = (PerformanceMonitorConfigurationGroup)groups.get(configGroupName);
        }
        catch (ClassCastException e) {
            location.errorT("Cannot set Thresholds to a non performance monitor group:" + configGroupName);
            throw e;
        }
        if (group == null) {
            location.errorT("Cannot set thresholds to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
            throw new Exception("Cannot set thresholds to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
        }
        Thresholds oldThresholds = group.getThresholds();
        group.setThresholds(new Thresholds(oldThresholds.getGreen2Yellow(), oldThresholds.getYellow2Red(), redToYellowValue, oldThresholds.getYellow2Green()));
        this.msr.getMonitorConfigurationHandler().customizeGroup(group);
    }

    public void setThresholdsYellowToGreen(String configGroupName, int yellowToGreenValue) throws Exception {
        Hashtable groups = MonitorServiceRuntime.getConfigurationGroups();
        PerformanceMonitorConfigurationGroup group = null;
        try {
            group = (PerformanceMonitorConfigurationGroup)groups.get(configGroupName);
        }
        catch (ClassCastException e) {
            location.errorT("Cannot set Thresholds to a non performance monitor group:" + configGroupName);
            throw e;
        }
        if (group == null) {
            location.errorT("Cannot set thresholds to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
            throw new Exception("Cannot set thresholds to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
        }
        Thresholds oldThresholds = group.getThresholds();
        group.setThresholds(new Thresholds(oldThresholds.getGreen2Yellow(), oldThresholds.getYellow2Red(), oldThresholds.getRed2Yellow(), yellowToGreenValue));
        this.msr.getMonitorConfigurationHandler().customizeGroup(group);
    }

    public void setThresholds(String configGroupName, int greenToYelowValue, int yellowToRedValue, int redToYellowValue, int yellowToGreenValue) throws Exception {
        Hashtable groups = MonitorServiceRuntime.getConfigurationGroups();
        PerformanceMonitorConfigurationGroup group = null;
        try {
            group = (PerformanceMonitorConfigurationGroup)groups.get(configGroupName);
        }
        catch (ClassCastException e) {
            location.errorT("Cannot set Thresholds to a non performance monitor group:" + configGroupName);
            throw e;
        }
        if (group == null) {
            location.errorT("Cannot set thresholds to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
            throw new Exception("Cannot set thresholds to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
        }
        group.setThresholds(new Thresholds(greenToYelowValue, yellowToRedValue, redToYellowValue, yellowToGreenValue));
        this.msr.getMonitorConfigurationHandler().customizeGroup(group);
    }

    public void setGreenStates(String configGroupName, String[] states) throws Exception {
        Hashtable groups = MonitorServiceRuntime.getConfigurationGroups();
        StateConfigurationGroup group = null;
        try {
            group = (StateConfigurationGroup)groups.get(configGroupName);
        }
        catch (ClassCastException e) {
            location.errorT("Cannot set states to a not state monitor group:" + configGroupName);
            throw e;
        }
        if (group == null) {
            location.errorT("Cannot set green states to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
            throw new Exception("Cannot set green states to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
        }
        group.setGreenStates(states);
        this.msr.getMonitorConfigurationHandler().customizeGroup(group);
    }

    public void setYellowStates(String configGroupName, String[] states) throws Exception {
        Hashtable groups = MonitorServiceRuntime.getConfigurationGroups();
        StateConfigurationGroup group = null;
        try {
            group = (StateConfigurationGroup)groups.get(configGroupName);
        }
        catch (ClassCastException e) {
            location.errorT("Cannot set states to a not state monitor group:" + configGroupName);
            throw e;
        }
        if (group == null) {
            location.errorT("Cannot set yellow states to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
            throw new Exception("Cannot set yellow states to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
        }
        group.setYellowStates(states);
        this.msr.getMonitorConfigurationHandler().customizeGroup(group);
    }

    public void setRedStates(String configGroupName, String[] states) throws Exception {
        Hashtable groups = MonitorServiceRuntime.getConfigurationGroups();
        StateConfigurationGroup group = null;
        try {
            group = (StateConfigurationGroup)groups.get(configGroupName);
        }
        catch (ClassCastException e) {
            location.errorT("Cannot set states to a not state monitor group:" + configGroupName);
            throw e;
        }
        if (group == null) {
            location.errorT("Cannot set red states to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
            throw new Exception("Cannot set red states to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
        }
        group.setRedStates(states);
        this.msr.getMonitorConfigurationHandler().customizeGroup(group);
    }

    public void setStates(String configGroupName, String[] greenStates, String[] yellowStates, String[] redStates) throws Exception {
        Hashtable groups = MonitorServiceRuntime.getConfigurationGroups();
        StateConfigurationGroup group = null;
        try {
            group = (StateConfigurationGroup)groups.get(configGroupName);
        }
        catch (ClassCastException e) {
            location.errorT("Cannot set states to a not state monitor group:" + configGroupName);
            throw e;
        }
        if (group == null) {
            location.errorT("Cannot set states to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
            throw new Exception("Cannot set states to a group with name [" + configGroupName + "] , because this group doesn't exist.Please check the group name.");
        }
        group.setGreenStates(greenStates);
        group.setYellowStates(yellowStates);
        group.setRedStates(redStates);
        this.msr.getMonitorConfigurationHandler().customizeGroup(group);
    }

    public void setAlertMode(String configGroupName, int value) throws Exception {
        StateConfigurationGroup group = null;
        try {
            group = (StateConfigurationGroup)MonitorServiceRuntime.getConfigurationGroups().get(configGroupName);
        }
        catch (ClassCastException e) {
            location.errorT("Configuration group [" + configGroupName + "] is not a StateConfigurationGroup.");
            throw e;
        }
        if (group == null) {
            String message = "Configuration group [" + configGroupName + "] does not exist.";
            location.errorT(message);
            throw new Exception(message);
        }
        group.setAlertMode(value);
        this.msr.getMonitorConfigurationHandler().customizeGroup(group);
    }

    public void setAlertRelevantValueType(String configGroupName, int type) throws Exception {
        PerformanceMonitorConfigurationGroup group = null;
        try {
            group = (PerformanceMonitorConfigurationGroup)MonitorServiceRuntime.getConfigurationGroups().get(configGroupName);
        }
        catch (ClassCastException e) {
            location.errorT("Configuration group [" + configGroupName + "] is not a PerformanceMonitorConfigurationGroup.");
            throw e;
        }
        if (group == null) {
            String message = "Configuration group [" + configGroupName + "] does not exist.";
            location.errorT(message);
            throw new Exception(message);
        }
        group.setAlertRelevantValueType(type);
        this.msr.getMonitorConfigurationHandler().customizeGroup(group);
    }

    public void setAutoreactionMethod(String configGroupName, String methodName) throws Exception {
        SimpleConfigurationGroup group = (SimpleConfigurationGroup)MonitorServiceRuntime.getConfigurationGroups().get(configGroupName);
        if (group == null) {
            String message = "Configuration group [" + configGroupName + "] does not exist.";
            location.errorT(message);
            throw new Exception(message);
        }
        group.setAutoreactionMethod(methodName);
        this.msr.getMonitorConfigurationHandler().customizeGroup(group);
    }

    public void setAnalysisMethod(String configGroupName, String methodName) throws Exception {
        SimpleConfigurationGroup group = (SimpleConfigurationGroup)MonitorServiceRuntime.getConfigurationGroups().get(configGroupName);
        if (group == null) {
            String message = "Configuration group [" + configGroupName + "] does not exist.";
            location.errorT(message);
            throw new Exception(message);
        }
        group.setAnalysisMethod(methodName);
        this.msr.getMonitorConfigurationHandler().customizeGroup(group);
    }

    public void setSimpleGroupProperties(String groupName, String description) throws Exception {
        SimpleConfigurationGroup group = (SimpleConfigurationGroup)MonitorServiceRuntime.getConfigurationGroups().get(groupName);
        if (group == null) {
            String message = "Configuration group [" + groupName + "] does not exist.";
            location.errorT(message);
            throw new Exception(message);
        }
        group.setDescription(new Description(group.getDescription().getID(), description));
        this.msr.getMonitorConfigurationHandler().customizeGroup(group);
    }

    public void setConfigGroupProperties(String groupName, String description, int periodValue, int periodUnit, int reactOnCollectionFailure) throws Exception {
        this.setMonitorGroupProperties(groupName, description, periodValue, periodUnit, reactOnCollectionFailure);
    }

    public void setTextGroupProperties(String groupName, String description, int periodValue, int periodUnit, int reactOnCollectionFailure) throws Exception {
        this.setMonitorGroupProperties(groupName, description, periodValue, periodUnit, reactOnCollectionFailure);
    }

    public void setVersionGroupProperties(String groupName, String description, int periodValue, int periodUnit, int reactOnCollectionFailure) throws Exception {
        this.setMonitorGroupProperties(groupName, description, periodValue, periodUnit, reactOnCollectionFailure);
    }

    public void setTableGroupProperties(String groupName, String description, int periodValue, int periodUnit, int reactOnCollectionFailure) throws Exception {
        this.setMonitorGroupProperties(groupName, description, periodValue, periodUnit, reactOnCollectionFailure);
    }

    public void setDurationGroupProperties(String groupName, String description, int periodValue, int periodUnit, int reactOnCollectionFailure, int green2Yellow, int yellow2Red, int yellow2Green, int red2Yellow) throws Exception {
        this.setPerformanceGroupProperties(groupName, description, periodValue, periodUnit, reactOnCollectionFailure, green2Yellow, yellow2Red, yellow2Green, red2Yellow);
    }

    public void setFrequencyGroupProperties(String groupName, String description, int periodValue, int periodUnit, int reactOnCollectionFailure, int green2Yellow, int yellow2Red, int yellow2Green, int red2Yellow) throws Exception {
        this.setPerformanceGroupProperties(groupName, description, periodValue, periodUnit, reactOnCollectionFailure, green2Yellow, yellow2Red, yellow2Green, red2Yellow);
    }

    public void setIntegerGroupProperties(String groupName, String description, int periodValue, int periodUnit, int reactOnCollectionFailure, int green2Yellow, int yellow2Red, int yellow2Green, int red2Yellow) throws Exception {
        this.setPerformanceGroupProperties(groupName, description, periodValue, periodUnit, reactOnCollectionFailure, green2Yellow, yellow2Red, yellow2Green, red2Yellow);
    }

    public void setLongGroupProperties(String groupName, String description, int periodValue, int periodUnit, int reactOnCollectionFailure, int green2Yellow, int yellow2Red, int yellow2Green, int red2Yellow) throws Exception {
        this.setPerformanceGroupProperties(groupName, description, periodValue, periodUnit, reactOnCollectionFailure, green2Yellow, yellow2Red, yellow2Green, red2Yellow);
    }

    public void setQualityRateGroupProperties(String groupName, String description, int periodValue, int periodUnit, int reactOnCollectionFailure, int green2Yellow, int yellow2Red, int yellow2Green, int red2Yellow) throws Exception {
        this.setPerformanceGroupProperties(groupName, description, periodValue, periodUnit, reactOnCollectionFailure, green2Yellow, yellow2Red, yellow2Green, red2Yellow);
    }

    public void setStateGroupProperties(String groupName, String description, int periodValue, int periodUnit, int reactOnCollectionFailure, String[] greenStates, String[] yellowStates, String[] redStates) throws Exception {
        Hashtable groups = MonitorServiceRuntime.getConfigurationGroups();
        StateConfigurationGroup group = null;
        try {
            group = (StateConfigurationGroup)groups.get(groupName);
        }
        catch (ClassCastException e) {
            location.errorT("Cannot set properties to a not state monitor group:" + groupName);
            throw e;
        }
        if (group == null) {
            location.errorT("Cannot set properties to a group with name [" + groupName + "] , because this group doesn't exist.Please check the group name.");
            throw new Exception("Cannot set properties to a group with name [" + groupName + "] , because this group doesn't exist.Please check the group name.");
        }
        group.setDescription(new Description(group.getDescription().getID(), description));
        DataCollection dataCollection = null;
        if (group.getDataCollection() != null && group.getDataCollection().getDataCollectionType() == DataCollection.POLLED_BY_MONITOR) {
            dataCollection = new DataCollection(group.getDataCollection().getDataCollectionType(), new Period(periodValue, periodUnit), reactOnCollectionFailure);
        } else {
            dataCollection = group.getDataCollection();
            dataCollection.setReactOnCollectionFailure(reactOnCollectionFailure);
        }
        group.setDataCollection(dataCollection);
        group.setGreenStates(greenStates);
        group.setYellowStates(yellowStates);
        group.setRedStates(redStates);
        this.msr.getMonitorConfigurationHandler().customizeGroup(group);
    }

    public void setMonitorGroupProperties(String groupName, String description, int periodValue, int periodUnit, int reactOnCollectionFailure) throws Exception {
        Hashtable groups = MonitorServiceRuntime.getConfigurationGroups();
        MonitorConfigurationGroup group = null;
        try {
            group = (MonitorConfigurationGroup)groups.get(groupName);
        }
        catch (ClassCastException e) {
            location.errorT("Cannot set properties to a simple monitor group:" + groupName);
            location.errorT(Util.getStackTraceAsString(e));
            throw e;
        }
        if (group == null) {
            location.errorT("Cannot set properties to a group with name [" + groupName + "] , because this group doesn't exist.Please check the group name.");
            throw new Exception("Cannot set properties to a group with name [" + groupName + "] , because this group doesn't exist.Please check the group name.");
        }
        group.setDescription(new Description(group.getDescription().getID(), description));
        DataCollection dataCollection = null;
        if (group.getDataCollection() != null && group.getDataCollection().getDataCollectionType() == DataCollection.POLLED_BY_MONITOR) {
            dataCollection = new DataCollection(group.getDataCollection().getDataCollectionType(), new Period(periodValue, periodUnit), reactOnCollectionFailure);
        } else {
            dataCollection = group.getDataCollection();
            dataCollection.setReactOnCollectionFailure(reactOnCollectionFailure);
        }
        group.setDataCollection(dataCollection);
        this.msr.getMonitorConfigurationHandler().customizeGroup(group);
    }

    public void setPerformanceGroupProperties(String groupName, String description, int periodValue, int periodUnit, int reactOnCollectionFailure, int green2Yellow, int yellow2Red, int yellow2Green, int red2Yellow) throws Exception {
        Hashtable groups = MonitorServiceRuntime.getConfigurationGroups();
        PerformanceMonitorConfigurationGroup group = null;
        try {
            group = (PerformanceMonitorConfigurationGroup)groups.get(groupName);
        }
        catch (ClassCastException e) {
            location.errorT("Cannot set properties to a non performance monitor group:" + groupName);
            throw e;
        }
        if (group == null) {
            location.errorT("Cannot set properties to a group with name [" + groupName + "] , because this group doesn't exist.Please check the group name.");
            throw new Exception("Cannot set properties to a group with name [" + groupName + "] , because this group doesn't exist.Please check the group name.");
        }
        group.setDescription(new Description(group.getDescription().getID(), description));
        DataCollection dataCollection = null;
        if (group.getDataCollection() != null && group.getDataCollection().getDataCollectionType() == DataCollection.POLLED_BY_MONITOR) {
            dataCollection = new DataCollection(group.getDataCollection().getDataCollectionType(), new Period(periodValue, periodUnit), reactOnCollectionFailure);
        } else {
            dataCollection = group.getDataCollection();
            dataCollection.setReactOnCollectionFailure(reactOnCollectionFailure);
        }
        group.setDataCollection(dataCollection);
        group.setThresholds(new Thresholds(green2Yellow, yellow2Red, red2Yellow, yellow2Green));
        this.msr.getMonitorConfigurationHandler().customizeGroup(group);
    }

    public void restoreDefaultConfiguration(String configGroupName) throws Exception {
        SimpleConfigurationGroup group = (SimpleConfigurationGroup)MonitorServiceRuntime.getConfigurationGroups().get(configGroupName);
        if (group == null) {
            location.errorT("Configuration group [" + configGroupName + "] does not exist.");
            throw new Exception("Configuration group [" + configGroupName + "] does not exist.");
        }
        if (!group.getCustomized()) {
            location.infoT("The group [" + configGroupName + "] hasn't been changed");
            return;
        }
        this.msr.getMonitorConfigurationHandler().deleteGroup(configGroupName);
    }

    public void restoreAllDefaultConfigurations() throws Exception {
        location.infoT("Must restore all configuration groups !");
        Hashtable groups = MonitorServiceRuntime.getConfigurationGroups();
        Enumeration groupNames = groups.keys();
        while (groupNames.hasMoreElements()) {
            SimpleConfigurationGroup group = (SimpleConfigurationGroup)groups.get(groupNames.nextElement());
            if (!group.getCustomized()) continue;
            location.infoT("Must restore:" + group.getGlobalConfigurationGroupName());
            try {
                this.restoreDefaultConfiguration(group.getGlobalConfigurationGroupName());
            }
            catch (Exception e) {
                location.errorT("Cannot restore [" + group.getGlobalConfigurationGroupName() + "]");
                location.throwing((Throwable)e);
            }
        }
    }

    private void changeNodeProperties(IMonitorNode node, SimpleConfigurationGroup defaultGroup) {
        switch (node.getTyp()) {
            case 1: 
            case 2: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                this.changePerformanceNodeProps((PerformanceMonitorNode)node, (PerformanceMonitorConfigurationGroup)defaultGroup);
                break;
            }
            case 6: 
            case 18: 
            case 19: {
                this.changeMonitorNodeProps(node, (MonitorConfigurationGroup)defaultGroup);
                break;
            }
            case 10: {
                this.changeStateMonitorNodeProps((VariableStateMonitorNode)node, (StateConfigurationGroup)defaultGroup);
                break;
            }
            case 9: {
                this.changeStateMonitorNodeProps((StateMonitorNode)node, (StateConfigurationGroup)defaultGroup);
                break;
            }
            case 7: {
                this.changeTableNodeProps(node, (TableConfigurationGroup)defaultGroup);
                break;
            }
            default: {
                this.changeSimpleMonitorNodeProps(node, defaultGroup);
            }
        }
    }

    private void changePerformanceNodeProps(PerformanceMonitorNode node, PerformanceMonitorConfigurationGroup defaultGroup) {
        node.setDescription(defaultGroup.getDescription().getText());
        if (defaultGroup.getDataCollection() != null) {
            if (defaultGroup.getDataCollection().getDataCollectionType() == DataCollection.POLLED_BY_MONITOR && (node.getPeriodUnit() != defaultGroup.getDataCollection().getCollectPeriod().getValue() || node.getPeriodValue() != defaultGroup.getDataCollection().getCollectPeriod().getUnit())) {
                node.setPeriodValue(defaultGroup.getDataCollection().getCollectPeriod().getValue());
                node.setPeriodUnit(defaultGroup.getDataCollection().getCollectPeriod().getUnit());
                this.changeBehaviourOfMonitor((IMonitorNode)node, defaultGroup.getDataCollection());
            }
            node.setReactOnCollectionFailure(defaultGroup.getDataCollection().getReactOnCollectionFailure());
        }
        node.setAlertRelevantValueType(defaultGroup.getAlertRelevantValueType());
        try {
            node.setThresholdsAndCheck(Monitor.monitorObjectFactory.createThresholds(defaultGroup.getThresholds().getGreen2Yellow(), defaultGroup.getThresholds().getYellow2Red(), defaultGroup.getThresholds().getYellow2Green(), defaultGroup.getThresholds().getRed2Yellow()));
        }
        catch (Exception e) {
            location.errorT(e.getMessage());
        }
    }

    private void changeMonitorNodeProps(IMonitorNode node, MonitorConfigurationGroup defaultGroup) {
        node.setDescription(defaultGroup.getDescription().getText());
        if (defaultGroup.getDataCollection() != null) {
            if (defaultGroup.getDataCollection().getDataCollectionType() == DataCollection.POLLED_BY_MONITOR && (node.getPeriodUnit() != defaultGroup.getDataCollection().getCollectPeriod().getValue() || node.getPeriodValue() != defaultGroup.getDataCollection().getCollectPeriod().getUnit())) {
                node.setPeriodValue(defaultGroup.getDataCollection().getCollectPeriod().getValue());
                node.setPeriodUnit(defaultGroup.getDataCollection().getCollectPeriod().getUnit());
                this.changeBehaviourOfMonitor(node, defaultGroup.getDataCollection());
            }
            node.setReactOnCollectionFailure(defaultGroup.getDataCollection().getReactOnCollectionFailure());
        }
    }

    private void changeStateMonitorNodeProps(StateMonitorNode node, StateConfigurationGroup defaultGroup) {
        node.setDescription(defaultGroup.getDescription().getText());
        if (defaultGroup.getDataCollection() != null) {
            if (defaultGroup.getDataCollection().getDataCollectionType() == DataCollection.POLLED_BY_MONITOR && (node.getPeriodUnit() != defaultGroup.getDataCollection().getCollectPeriod().getValue() || node.getPeriodValue() != defaultGroup.getDataCollection().getCollectPeriod().getUnit())) {
                node.setPeriodValue(defaultGroup.getDataCollection().getCollectPeriod().getValue());
                node.setPeriodUnit(defaultGroup.getDataCollection().getCollectPeriod().getUnit());
                this.changeBehaviourOfMonitor((IMonitorNode)node, defaultGroup.getDataCollection());
            }
            node.setReactOnCollectionFailure(defaultGroup.getDataCollection().getReactOnCollectionFailure());
        }
        node.setAlertMode(defaultGroup.getAlertMode());
        node.setGreenStates(defaultGroup.getGreenStates());
        node.setYellowStates(defaultGroup.getYellowStates());
        node.setRedStates(defaultGroup.getRedStates());
    }

    private void changeStateMonitorNodeProps(VariableStateMonitorNode node, StateConfigurationGroup defaultGroup) {
        node.setDescription(defaultGroup.getDescription().getText());
        if (defaultGroup.getDataCollection() != null) {
            if (defaultGroup.getDataCollection().getDataCollectionType() == DataCollection.POLLED_BY_MONITOR && (node.getPeriodUnit() != defaultGroup.getDataCollection().getCollectPeriod().getValue() || node.getPeriodValue() != defaultGroup.getDataCollection().getCollectPeriod().getUnit())) {
                node.setPeriodValue(defaultGroup.getDataCollection().getCollectPeriod().getValue());
                node.setPeriodUnit(defaultGroup.getDataCollection().getCollectPeriod().getUnit());
                this.changeBehaviourOfMonitor((IMonitorNode)node, defaultGroup.getDataCollection());
            }
            node.setReactOnCollectionFailure(defaultGroup.getDataCollection().getReactOnCollectionFailure());
        }
        node.setAlertMode(defaultGroup.getAlertMode());
    }

    private void changeTableNodeProps(IMonitorNode node, TableConfigurationGroup defaultGroup) {
        node.setDescription(defaultGroup.getDescription().getText());
        if (defaultGroup.getDataCollection() != null) {
            if (defaultGroup.getDataCollection().getDataCollectionType() == DataCollection.POLLED_BY_MONITOR && (node.getPeriodUnit() != defaultGroup.getDataCollection().getCollectPeriod().getValue() || node.getPeriodValue() != defaultGroup.getDataCollection().getCollectPeriod().getUnit())) {
                node.setPeriodValue(defaultGroup.getDataCollection().getCollectPeriod().getValue());
                node.setPeriodUnit(defaultGroup.getDataCollection().getCollectPeriod().getUnit());
                this.changeBehaviourOfMonitor(node, defaultGroup.getDataCollection());
            }
            node.setReactOnCollectionFailure(defaultGroup.getDataCollection().getReactOnCollectionFailure());
        }
    }

    private void changeSimpleMonitorNodeProps(IMonitorNode node, SimpleConfigurationGroup defaultGroup) {
        node.setDescription(defaultGroup.getDescription().getText());
    }

    private void changeBehaviourOfMonitor(IMonitorNode monitorNode, DataCollection dataCollection) {
        ObjectName objName = null;
        MBeanServer mbs = MonitorServiceRuntime.getMBeanServer();
        try {
            objName = ObjectNameFactory.getNameForMonitorPerNode((String)ObjectName.quote(monitorNode.getPath()), null, null);
        }
        catch (MalformedObjectNameException e) {
            location.errorT(Util.getStackTraceAsString(e));
        }
        Integer notificationId = null;
        ObjectName timer = null;
        try {
            timer = ObjectNameFactory.getNameForServerChildPerNode((String)"Services", (String)"TimerService", null, null);
        }
        catch (MalformedObjectNameException ex) {
            location.errorT(Util.getStackTraceAsString(ex));
        }
        try {
            mbs.removeNotificationListener(timer, objName);
        }
        catch (InstanceNotFoundException e) {
            location.errorT("There is no MBean with name: " + objName + " in the MBean server");
            location.errorT(Util.getStackTraceAsString(e));
        }
        catch (ListenerNotFoundException ex) {
            location.errorT("There is no notification listener for: " + objName);
            location.errorT(Util.getStackTraceAsString(ex));
        }
        try {
            notificationId = (Integer)mbs.invoke(timer, "addNotification", new Object[]{"timer.notification", "Activate timer", null, new Date(System.currentTimeMillis()), new Long(Util.getGranularityPeriod(dataCollection.getCollectPeriod().getUnit(), dataCollection.getCollectPeriod().getValue()))}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = ConfigurationService.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$lang$String == null ? (class$java$lang$String = ConfigurationService.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$lang$Object == null ? (class$java$lang$Object = ConfigurationService.class$("java.lang.Object")) : class$java$lang$Object).getName(), (class$java$util$Date == null ? (class$java$util$Date = ConfigurationService.class$("java.util.Date")) : class$java$util$Date).getName(), "long"});
        }
        catch (JMException ex) {
            location.errorT("Cannot create notification ID for:" + objName);
            location.errorT(Util.getStackTraceAsString(ex));
        }
        try {
            mbs.addNotificationListener(timer, objName, (NotificationFilter)new TimerFilter(notificationId), (Object)"TimerNotification");
        }
        catch (JMException ex) {
            location.errorT("Cannot add notification listeren for:" + objName);
            location.errorT(Util.getStackTraceAsString(ex));
        }
    }

    public void configurationChanged(ChangeEvent event) {
        ChangeEvent[] changeEvent = event.getDetailedChangeEvents();
        ChangeEvent tempEvent = null;
        int i = 0;
        while (i < changeEvent.length) {
            tempEvent = changeEvent[i];
            String propertySheet = tempEvent.getPath();
            int actionPropSheet = tempEvent.getAction();
            StringBuffer app = new StringBuffer(propertySheet);
            app.delete(0, MonitorConfigurationHandler.MONITOR_SEMANTICS_PATH.length() + 1);
            String groupName = app.toString();
            if (!groupName.equals("")) {
                switch (actionPropSheet) {
                    case 0: 
                    case 1: {
                        location.infoT("CREATE/MODIFY event for group with name :" + groupName);
                        SimpleConfigurationGroup group = this.msr.getMonitorConfigurationHandler().getGroup(groupName, this.handler);
                        if (group != null) {
                            this.setGroupToNodes(group);
                            break;
                        }
                        location.errorT("Failed to get the new properties for group [" + groupName + "] from Data Base ");
                        break;
                    }
                    case 2: {
                        SimpleConfigurationGroup tempGroup = (SimpleConfigurationGroup)MonitorServiceRuntime.getConfigurationGroups().get(groupName);
                        if (tempGroup != null) {
                            String owner = tempGroup.getGroupOwner();
                            SimpleConfigurationGroup defaultGroup = this.msr.findDefaultGroup(groupName, owner);
                            if (defaultGroup != null) {
                                this.msr.getMonitorConfigurationHandler().replaceOldWithNewGroup(defaultGroup);
                                this.setGroupToNodes(defaultGroup);
                                break;
                            }
                            this.msr.getMonitorConfigurationHandler().deleteGroupFromMemmory(tempGroup);
                            location.warningT("There is no default group for groupName [" + groupName + "] and owner " + owner);
                            break;
                        }
                        location.warningT("Cannot find a group with name [" + groupName + "]");
                        break;
                    }
                    default: {
                        location.errorT("Some error in " + actionPropSheet + "occur");
                    }
                }
            }
            ++i;
        }
    }

    void setGroupToNodes(SimpleConfigurationGroup group) {
        Vector nodes = MonitorServiceRuntime.getMappedTree().getNodesForGroupName(group.getGlobalConfigurationGroupName());
        Vector<IMonitorNode> nodeCollection = new Vector<IMonitorNode>(nodes.size());
        int i = 0;
        while (i < nodes.size()) {
            MappingTreeNode mapNode = (MappingTreeNode)nodes.elementAt(i);
            if (mapNode != null) {
                IMonitorNode node = mapNode.getMonitorObject();
                this.changeNodeProperties(node, group);
                nodeCollection.add(node);
            } else {
                String message = "Monitor node is null";
                location.errorT(message);
            }
            ++i;
        }
        if (group == null) {
            location.errorT("Cannot customize group in ccms which is null ");
        } else if (this.ccmsConnector != null) {
            this.ccmsConnector.customizeGroup(group.getGlobalConfigurationGroupName(), nodeCollection);
        } else {
            location.warningT("CCMS connector is null.Changes are not sent to CCMS");
        }
    }

    void deleteNodes(SimpleConfigurationGroup group) {
        Vector nodes = MonitorServiceRuntime.getMappedTree().getNodesForGroupName(group.getGlobalConfigurationGroupName());
        int i = 0;
        while (i < nodes.size()) {
            MappingTreeNode mapNode = (MappingTreeNode)nodes.elementAt(i);
            try {
                if (mapNode != null) {
                    mapNode.removeAllChildren();
                    mapNode.removeFromParent();
                } else {
                    String message = "Monitor node is null";
                    location.errorT(message);
                }
            }
            catch (Exception e) {
                location.warningT("Cannot remove a node for group " + group.getGlobalConfigurationGroupName());
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

