/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.common;

import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.IMonitorObjectFactory;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.common.MonitorServiceRuntime;
import com.sap.engine.services.monitor.config.ConfigConfigurationGroup;
import com.sap.engine.services.monitor.config.DataCollection;
import com.sap.engine.services.monitor.config.Description;
import com.sap.engine.services.monitor.config.Period;
import com.sap.engine.services.monitor.config.SimpleConfigurationGroup;
import com.sap.engine.services.monitor.config.TableConfigurationGroup;
import com.sap.engine.services.monitor.install.InstallationInfo;
import com.sap.engine.services.monitor.install.MonitorInstallationInfo;
import com.sap.engine.services.monitor.install.MonitorInstaller;
import com.sap.engine.services.monitor.install.TableMonitorInstallationInfo;
import com.sap.engine.services.monitor.mbeans.AttributeMappingInfo;
import com.sap.engine.services.monitor.mbeans.MBeanCallInfo;
import com.sap.mw.jco.JCO;
import com.sap.tc.logging.Location;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class SystemMonitorHelper {
    private static final String SYSTEM_DESCRIPTION = "Root of the J2EE system";
    private static final String SYSTEM_CONFIG_GROUP = "J2EE System";
    private static final String SYSTEM_DESCRIPTION_ID = "J2EE system root";
    private static final String SYSTEM_PROP_DESCRIPTION_ID = "J2EE system props";
    private static final String SYSTEM_PROP_DESCRIPTION = "J2EE system properties";
    private static final String SYSTEM_PROP_CONFIG_GROUP = "J2EE System props";
    private static final String SYSTEM_INFO_DESCRIPTION = "J2EE System Info node properties";
    private static final String SYSTEM_INFO_DESCRIPTION_ID = "J2EE System Info node";
    private static final String SYSTEM_INFO_CONFIG_GROUP_NAME = "J2EE System Info node";
    private IMonitorObjectFactory m_monitorNodeFactory;
    private Location location = Location.getLocation((String)"com.sap.engine.services.monitor.common.SystemMonitorHelper");

    public SystemMonitorHelper(IMonitorObjectFactory m_monitorNodeFactory) {
        this.m_monitorNodeFactory = m_monitorNodeFactory;
    }

    protected void installSystemPropsNode() {
        try {
            InstallationInfo sysInfo = new InstallationInfo("System", this.m_monitorNodeFactory.getRootNode(), new SimpleConfigurationGroup(SYSTEM_CONFIG_GROUP, new Description(SYSTEM_DESCRIPTION_ID, SYSTEM_DESCRIPTION), "System", false));
            IMonitorNode systemRoot = MonitorInstaller.installObject(sysInfo);
            systemRoot.setPath();
            Vector<String> columns = new Vector<String>(2);
            columns.addElement("System property");
            columns.addElement("Value");
            DataCollection dataCollection = new DataCollection(DataCollection.POLLED_BY_MONITOR, new Period(1, 1), 4);
            TableConfigurationGroup tableGroup = new TableConfigurationGroup(SYSTEM_PROP_CONFIG_GROUP, new Description(SYSTEM_PROP_DESCRIPTION_ID, SYSTEM_PROP_DESCRIPTION), dataCollection, columns, "System:SystemProperties", false);
            try {
                MonitorServiceRuntime.addToAllGroups(tableGroup);
            }
            catch (Exception e) {
                this.location.errorT("Cannot add System Properties node to the set of groups.Reason" + e.getMessage());
            }
            Vector<AttributeMappingInfo> attributeMappings = new Vector<AttributeMappingInfo>();
            attributeMappings.addElement(new AttributeMappingInfo("Entries", new MBeanCallInfo("SystemProperties")));
            TableMonitorInstallationInfo installInfo = new TableMonitorInstallationInfo("System Properties", systemRoot, tableGroup, "monitor", "SERVICE", attributeMappings, "SYSTEM_TABLE");
            MonitorInstaller.installTableMonitor(installInfo);
            ConfigConfigurationGroup configGroup = new ConfigConfigurationGroup("J2EE System Info node", new Description("J2EE System Info node", SYSTEM_INFO_DESCRIPTION), dataCollection, "System:SystemInfo", false);
            try {
                MonitorServiceRuntime.addToAllGroups(configGroup);
            }
            catch (Exception e) {
                this.location.errorT("Cannot add System Info node to the set of groups.Reason" + e.getMessage());
            }
            this.location.infoT("Start to install  System info nodes....");
            Vector<AttributeMappingInfo> attributeMappings1 = new Vector<AttributeMappingInfo>();
            attributeMappings1.addElement(new AttributeMappingInfo("Configuration", new MBeanCallInfo("VMInfo")));
            MonitorInstallationInfo vMInfoInstallInfo = new MonitorInstallationInfo("VM Info", systemRoot, configGroup, "monitor", "SERVICE", attributeMappings1);
            MonitorInstaller.installConfigurationMonitor(vMInfoInstallInfo);
            this.location.infoT("VM Info node installed successfully");
            Vector<AttributeMappingInfo> attributeMappings2 = new Vector<AttributeMappingInfo>();
            attributeMappings2.addElement(new AttributeMappingInfo("Configuration", new MBeanCallInfo("ClusterNodeInfo")));
            MonitorInstallationInfo clusterNodeInstallInfo = new MonitorInstallationInfo("Cluster Node Info", systemRoot, configGroup, "monitor", "SERVICE", attributeMappings2);
            MonitorInstaller.installConfigurationMonitor(clusterNodeInstallInfo);
            this.location.infoT("Cluster Node Info node installed successfully");
            Vector<AttributeMappingInfo> attributeMappings3 = new Vector<AttributeMappingInfo>();
            attributeMappings3.addElement(new AttributeMappingInfo("Configuration", new MBeanCallInfo("SCSInstanceInfo")));
            MonitorInstallationInfo scsInstanceInfoInstallInfo = new MonitorInstallationInfo("SCS Instance Info", systemRoot, configGroup, "monitor", "SERVICE", attributeMappings3);
            MonitorInstaller.installConfigurationMonitor(scsInstanceInfoInstallInfo);
            this.location.infoT("SCS Instance Info node installed successfully");
            Vector<AttributeMappingInfo> attributeMappings4 = new Vector<AttributeMappingInfo>();
            attributeMappings4.addElement(new AttributeMappingInfo("Configuration", new MBeanCallInfo("InstanceInfo")));
            MonitorInstallationInfo instanceInstallInfo = new MonitorInstallationInfo("Instance Info", systemRoot, configGroup, "monitor", "SERVICE", attributeMappings4);
            MonitorInstaller.installConfigurationMonitor(instanceInstallInfo);
            this.location.infoT("Instance Info node installed successfully");
        }
        catch (Exception e) {
            this.location.errorT(Util.getStackTraceAsString(e));
        }
    }

    public String[][] getProperties() {
        String[][] systemProps = SystemMonitorHelper.getSystemProperties();
        String[][] jcoProps = SystemMonitorHelper.getJCOProperties();
        int newLenght = systemProps.length + jcoProps.length;
        String[][] properties = new String[newLenght][2];
        int i = 0;
        while (i < systemProps.length) {
            properties[i][0] = systemProps[i][0];
            properties[i][1] = systemProps[i][1];
            ++i;
        }
        int i2 = systemProps.length;
        int j = 0;
        while (i2 < newLenght) {
            properties[i2][0] = jcoProps[j][0];
            properties[i2][1] = jcoProps[j][1];
            ++i2;
            ++j;
        }
        return Util.sortTwoDimArray(properties);
    }

    private static String[][] getSystemProperties() {
        Properties p = System.getProperties();
        int len = ((Hashtable)p).size();
        String[][] result = new String[len][2];
        Enumeration e = ((Hashtable)p).keys();
        int i = 0;
        while (e.hasMoreElements()) {
            String name;
            result[i][0] = name = (String)e.nextElement();
            result[i][1] = p.getProperty(name);
            ++i;
        }
        return result;
    }

    private static String[][] getJCOProperties() {
        String[][] jcoProperties = new String[6][2];
        jcoProperties[0][0] = "JCO:Java Part Version";
        jcoProperties[0][1] = JCO.getVersion();
        jcoProperties[1][0] = "JCO:Java Middleware Part Version";
        jcoProperties[1][1] = JCO.getMiddlewareVersion();
        jcoProperties[2][0] = "JCO:JNI Layer Version";
        jcoProperties[2][1] = JCO.getMiddlewareProperty((String)"jco.middleware.libjrfc_version");
        jcoProperties[3][0] = "JCO:RFC Layer Version";
        jcoProperties[3][1] = JCO.getMiddlewareProperty((String)"jco.middleware.librfc_version");
        jcoProperties[4][0] = "JCO:jco.middleware.libjrfc_path";
        jcoProperties[4][1] = JCO.getMiddlewareProperty((String)"jco.middleware.libjrfc_path");
        String librfc_version = JCO.getMiddlewareProperty((String)"jco.middleware.librfc_path");
        if (librfc_version != null) {
            int i1 = librfc_version.indexOf("***") + 4;
            int i2 = librfc_version.indexOf("***", i1);
            if (i2 >= i1) {
                librfc_version = librfc_version.substring(i1, i2);
            }
        } else {
            librfc_version = "system defined path";
        }
        jcoProperties[5][0] = "JCO:jco.middleware.librfc_path";
        jcoProperties[5][1] = librfc_version;
        return jcoProperties;
    }
}

