/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.common;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.container.monitor.ServiceMonitor;
import com.sap.engine.frame.container.monitor.SystemMonitor;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationChangedListener;
import com.sap.engine.frame.core.configuration.ConfigurationContext;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.state.ServiceState;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.IMonitorObjectFactory;
import com.sap.engine.library.monitor.ISummaryMonitorNode;
import com.sap.engine.library.monitor.MonitorFactory;
import com.sap.engine.library.monitor.impl0.AbstractMonitorNode;
import com.sap.engine.library.monitor.impl0.PerformanceMonitorNode;
import com.sap.engine.library.monitor.mapping.MappedTree;
import com.sap.engine.library.monitor.mapping.MappingTreeNode;
import com.sap.engine.library.monitor.mapping.ccms.CcmsConnector;
import com.sap.engine.library.monitor.mapping.ccms.CcmsConnectorException;
import com.sap.engine.services.monitor.MonitorConstants;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.common.CcmsConnectorInfo;
import com.sap.engine.services.monitor.common.MonitorConfigurationHandler;
import com.sap.engine.services.monitor.common.MonitorGroupXMLAnalyzer;
import com.sap.engine.services.monitor.common.MonitorInstallationXMLAnalyzer;
import com.sap.engine.services.monitor.common.MonitorXMLParser;
import com.sap.engine.services.monitor.common.StandardMBeanWrapper;
import com.sap.engine.services.monitor.common.SystemMonitorHelper;
import com.sap.engine.services.monitor.config.ConfigurationService;
import com.sap.engine.services.monitor.config.DataCollection;
import com.sap.engine.services.monitor.config.Description;
import com.sap.engine.services.monitor.config.MonitorConfigurationGroup;
import com.sap.engine.services.monitor.config.PerformanceMonitorConfigurationGroup;
import com.sap.engine.services.monitor.config.SimpleConfigurationGroup;
import com.sap.engine.services.monitor.config.StateConfigurationGroup;
import com.sap.engine.services.monitor.config.TableConfigurationGroup;
import com.sap.engine.services.monitor.config.Thresholds;
import com.sap.engine.services.monitor.dispatcher.MonitorServiceDispatcherRuntime;
import com.sap.engine.services.monitor.install.InstallationInfo;
import com.sap.engine.services.monitor.install.MonitorInstaller;
import com.sap.engine.services.monitor.mbeans.CcmsConnectorProxy;
import com.sap.engine.services.monitor.mbeans.GenericConfigurationResource;
import com.sap.engine.services.monitor.mbeans.Monitor;
import com.sap.engine.services.monitor.mbeans.Template;
import com.sap.engine.services.monitor.mbeans.TimerFilter;
import com.sap.engine.services.monitor.server.MonitorServiceServerRuntime;
import com.sap.jmx.ObjectNameFactory;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class MonitorServiceRuntime {
    public static final String S_DEFAULT_MAPPING_NAME = "default";
    public static final int DISPATCHER = 0;
    public static final int SERVER = 1;
    private static final String KERNEL_DESCRIPTION_ID = "J2EE kernel root";
    private static final String SERVICES_DESCRIPTION_ID = "J2EE services root";
    private static final String APPLICATIONS_DESCRIPTION_ID = "J2EE applications root";
    private static final String PERFORMANCE_DESCRIPTION_ID = "J2EE performance root";
    private static final String KERNEL_DESCRIPTION = "Root of the J2EE kernel";
    private static final String SERVICES_DESCRIPTION = "Root of the J2EE services";
    private static final String APPLICATIONS_DESCRIPTION = "Root of the J2EE applications";
    private static final String PERFORMANCE_DESCRIPTION = "Root for J2EE performance measurements";
    private static final String KERNEL_CONFIG_GROUP = "J2EE kernel root";
    private static final String SERVICES_CONFIG_GROUP = "J2EE services root";
    private static final String APPLICATIONS_CONFIG_GROUP = "SAP J2EE Applications";
    private static final String PERFORMANCE_CONFIG_GROUP = "J2EE performance";
    public static final String KERNEL_OWNER = "kernel";
    public static final String SERVICE_OWNER_PREFIX = "service ";
    public static final String APPLICATION_OWNER_PREFIX = "application ";
    public static final String LIBRARY_OWNER_PREFIX = "library ";
    public static final String MONITOR_SERVICE_OWNER = "monitor ";
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$monitor$mbeans$Monitor == null ? (class$com$sap$engine$services$monitor$mbeans$Monitor = MonitorServiceRuntime.class$("com.sap.engine.services.monitor.mbeans.Monitor")) : class$com$sap$engine$services$monitor$mbeans$Monitor));
    public static boolean isDefaultMappingDone;
    private MonitorXMLParser monitorXMLParser;
    private static Hashtable monitorGroups;
    private static Hashtable monitorTemplates;
    private static MappedTree m_defaultMapping;
    private static IMonitorObjectFactory m_monitorNodeFactory;
    private static int nodeType;
    private static Location location;
    protected static MBeanServer mbs;
    protected static ObjectName configurationServiceObjectName;
    private ServiceState serviceState = null;
    private SystemMonitor systemMonitor = null;
    private SystemMonitorHelper systemMonitorHelper = null;
    private ConfigurationHandler configurationHandler = null;
    private MonitorConfigurationHandler monitorConfigHandl = null;
    private ConfigurationService configService = null;
    int nodeId;
    static /* synthetic */ Class class$com$sap$engine$services$monitor$mbeans$Monitor;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Date;

    public MonitorServiceRuntime(ServiceState serviceState, SystemMonitor systemMonitor, int nodeType, int nodeId) {
        m_monitorNodeFactory = MonitorFactory.createMonitorObjectFactory();
        m_defaultMapping = new MappedTree(m_monitorNodeFactory.getRootNode(), S_DEFAULT_MAPPING_NAME);
        this.serviceState = serviceState;
        this.systemMonitor = systemMonitor;
        this.nodeId = nodeId;
        MonitorServiceRuntime.nodeType = nodeType;
        Monitor.init();
        MonitorInstaller.initialize();
    }

    public static synchronized MappedTree getMappedTree() {
        return m_defaultMapping;
    }

    public static MonitorServiceRuntime getMSRInstance() {
        MonitorServiceRuntime msr = null;
        switch (MonitorServiceRuntime.getNodeType()) {
            case 0: {
                msr = MonitorServiceDispatcherRuntime.getInstance();
                break;
            }
            case 1: {
                msr = MonitorServiceServerRuntime.getInstance();
            }
        }
        return msr;
    }

    public static int getNodeType() {
        return nodeType;
    }

    public static Hashtable getConfigurationGroups() {
        return monitorGroups;
    }

    public static Hashtable getMonitorTemplates() {
        return monitorTemplates;
    }

    public static void addTemplate(String templateName, Template template) {
        monitorTemplates.put(templateName, template);
    }

    public static void deleteTemplates(String applicationName) {
        Enumeration keys = monitorTemplates.keys();
        Template tempTemplate = null;
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            tempTemplate = (Template)monitorTemplates.get(key);
            if (!tempTemplate.getApplicationName().equals(applicationName)) continue;
            tempTemplate.unregisterForTimerEvents();
            monitorTemplates.remove(key);
            return;
        }
    }

    public static MBeanServer getMBeanServer() {
        return mbs;
    }

    public void run() {
        location.infoT("*************** MonitorServiceRuntime run() ************");
        if (m_monitorNodeFactory == null) {
            m_monitorNodeFactory = MonitorFactory.createMonitorObjectFactory();
        }
        this.monitorXMLParser = new MonitorXMLParser();
        this.systemMonitorHelper = new SystemMonitorHelper(m_monitorNodeFactory);
        this.monitorXMLParser.configureParser();
        monitorTemplates = new Hashtable();
        isDefaultMappingDone = true;
        try {
            ConfigurationContext configurationContext = (ConfigurationContext)this.getServiceContext().getCoreContext().getConfigurationHandlerFactory();
            this.configurationHandler = configurationContext.getConfigurationHandler();
            ConfigurationHandler configurationHandlerForRead = configurationContext.getConfigurationHandler();
            this.configService = new ConfigurationService(this, configurationHandlerForRead);
            this.monitorConfigHandl = new MonitorConfigurationHandler();
            this.configurationHandler.addConfigurationChangedListener((ConfigurationChangedListener)this.configService, MonitorConfigurationHandler.MONITOR_SEMANTICS_PATH, 2);
            this.monitorConfigHandl.setMonitorConfigurationHandler(this.configurationHandler);
            monitorGroups = this.monitorConfigHandl.getAllSavedGroups(configurationHandlerForRead);
        }
        catch (Exception e) {
            location.errorT(Util.getStackTraceAsString(e));
        }
        this.registerGenericConfigurationMBean();
        this.installTimerService();
        this.installConfigurationService();
        this.installConnectorMBean();
        this.systemMonitorHelper.installSystemPropsNode();
        this.installMonitors();
    }

    public void stop() {
        this.deregisterMonitors();
        this.unregisterGenericConfigurationMBean();
        this.uninstallCcmsConnector();
        this.uninstallTimerService();
        this.uninstallConfigurationService();
        this.clearTemplates();
        AbstractMonitorNode.deleteRootInstance();
        Monitor.destroy();
        MonitorInstaller.destroy();
        this.configurationHandler.removeConfigurationChangedListener((ConfigurationChangedListener)this.configService, MonitorConfigurationHandler.MONITOR_SEMANTICS_PATH);
        this.configurationHandler = null;
        this.configService = null;
        isDefaultMappingDone = false;
        this.monitorXMLParser = null;
        monitorGroups = null;
        monitorTemplates = null;
        m_defaultMapping = null;
        m_monitorNodeFactory = null;
        this.systemMonitorHelper = null;
    }

    private void clearTemplates() {
        try {
            Enumeration enumeration = monitorTemplates.elements();
            Template template = null;
            while (enumeration.hasMoreElements()) {
                template = (Template)enumeration.nextElement();
                if (template == null) continue;
                template.removeNotificationForTemplate();
            }
        }
        catch (Exception e) {
            LoggingHelper.logThrowable((int)500, (Category)LoggingHelper.SYS_SERVER, (Location)location, (String)"clearTemplates()", (String)"Monitor Service could not uninstall templates", (Throwable)e);
        }
    }

    public void init(Properties properties) {
    }

    public IMonitorObjectFactory getMonitorFactory() {
        return m_monitorNodeFactory;
    }

    public void treatConfigFile(InputStream configurationFileStream, String owner, boolean isApp) {
        Document configXml = this.monitorXMLParser.parse(configurationFileStream);
        if (configXml != null) {
            Element monitorConfigurationRoot = configXml.getDocumentElement();
            MonitorServiceRuntime.persistSemantics(monitorConfigurationRoot, owner);
            this.installMonitors(monitorConfigurationRoot);
        } else {
            location.errorT("error in XML file:Document parsed from input stream is null");
        }
    }

    public void treatConfigFile(InputStream configurationFileStream, String applicationName) {
        location.infoT("Start parsing the monitor-configuration.xml for [" + applicationName + "]");
        Document configXml = this.monitorXMLParser.parse(configurationFileStream);
        if (configXml != null) {
            Element monitorConfigurationRoot = configXml.getDocumentElement();
            location.infoT("Start persist semantic.....");
            MonitorServiceRuntime.persistSemantics(monitorConfigurationRoot, applicationName);
            location.infoT("Start install monitors...");
            this.installMonitors(monitorConfigurationRoot, applicationName);
            location.infoT("End persistance/installation for owner [" + applicationName + "]");
        } else {
            location.warningT("Cannot parse monitor-configuration.xml for application [" + applicationName + "] because xml is null");
        }
    }

    public String[] getMappingNames() {
        return new String[]{m_defaultMapping.getName()};
    }

    public MappedTree getMapping(String name) {
        return m_defaultMapping;
    }

    private synchronized void waitTillMappingsAreSet() {
        try {
            while (!isDefaultMappingDone) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean changeProperties(Properties properties) {
        return true;
    }

    public String[][] getApplicationsWithGrmgCustomizing() throws RemoteException {
        return null;
    }

    public String getCustomizing(String application) throws RemoteException {
        return null;
    }

    public void saveCustomizing(String application, String customizing) throws RemoteException {
    }

    public void saveCustomizingInCCMSAgent(String application, String customizing) throws RemoteException {
    }

    public boolean isServer() throws RemoteException {
        return nodeType == 1;
    }

    public void assureAgentIsRegistered() {
    }

    protected static MappingTreeNode generateMappingTree(BufferedReader in) {
        String s = null;
        StringBuffer xmlFileContent = new StringBuffer();
        try {
            while ((s = in.readLine()) != null) {
                xmlFileContent.append(s);
            }
            in.close();
            MappedTree tree = new MappedTree(xmlFileContent.toString());
            tree.reactOnNodesAdded();
            return tree.getRootNode();
        }
        catch (Exception e) {
            LoggingHelper.logThrowable((int)500, (Category)LoggingHelper.SYS_SERVER, (Location)location, (String)"generateMappingTree(BufferedReader)", (String)"Monitor service could not generate monitor tree", (Throwable)e);
            return null;
        }
    }

    protected ConfigurationHandler getConfigurationHandler() throws ConfigurationException {
        return this.configurationHandler;
    }

    protected void installMonitors() {
        try {
            InputStream kernelConfigurationStream = this.serviceState.getPersistentContainer().getPersistentEntryStream("monitor-configuration.xml", false);
            this.treatConfigFile(kernelConfigurationStream, KERNEL_OWNER, false);
        }
        catch (ServiceException exc) {
            exc.log();
        }
        ServiceMonitor[] services = this.systemMonitor.getServices();
        int i = 0;
        while (i < services.length) {
            try {
                ServiceMonitor service = services[i];
                InputStream serviceConfigurationStream = service.getDescriptorContainer().getPersistentEntryStream("monitor-configuration.xml", false);
                String serviceName = service.getComponentName();
                if (serviceConfigurationStream != null) {
                    this.treatConfigFile(serviceConfigurationStream, SERVICE_OWNER_PREFIX + serviceName, false);
                }
            }
            catch (Exception e) {
                LoggingHelper.logThrowable((int)400, (Category)LoggingHelper.SYS_SERVER, (Location)location, (String)"installMonitors()", (String)("Monitor Service could not istall monitors for service " + services[i].getComponentName()), (Throwable)e);
            }
            ++i;
        }
    }

    private static void persistSemantics(Element monitorConfigurationRoot, String owner) {
        MonitorGroupXMLAnalyzer groupAnalyser = new MonitorGroupXMLAnalyzer(monitorConfigurationRoot);
        Vector newMonitorGroups = groupAnalyser.getMonitorGroups(owner);
        MonitorServiceRuntime.addToAllGroups(newMonitorGroups);
    }

    public static void addToAllGroups(Vector newMonitorGroups) {
        int i = 0;
        while (i < newMonitorGroups.size()) {
            try {
                MonitorServiceRuntime.addToAllGroups((SimpleConfigurationGroup)newMonitorGroups.elementAt(i));
            }
            catch (Exception e) {
                location.errorT(e.getMessage());
            }
            ++i;
        }
    }

    public static void addToAllGroups(SimpleConfigurationGroup monitorGroup) throws Exception {
        SimpleConfigurationGroup oldMonitorGroup = (SimpleConfigurationGroup)monitorGroups.get(monitorGroup.getGlobalConfigurationGroupName());
        if (oldMonitorGroup != null) {
            if (oldMonitorGroup.getGroupOwner().equals(monitorGroup.getGroupOwner())) {
                if (monitorGroup.getCustomized()) {
                    location.infoT("Group with name [" + monitorGroup.getGlobalConfigurationGroupName() + "] is in the list of groups and in the data base too.It has been customized.");
                }
            } else if (oldMonitorGroup instanceof PerformanceMonitorConfigurationGroup && monitorGroup instanceof PerformanceMonitorConfigurationGroup) {
                if (!((PerformanceMonitorConfigurationGroup)oldMonitorGroup).equals((PerformanceMonitorConfigurationGroup)monitorGroup)) {
                    throw new Exception("error :Performance monitor configuration group with name [" + monitorGroup.getGlobalConfigurationGroupName() + "] already exists.");
                }
            } else if (oldMonitorGroup instanceof StateConfigurationGroup && monitorGroup instanceof StateConfigurationGroup) {
                if (!((StateConfigurationGroup)oldMonitorGroup).equals((StateConfigurationGroup)monitorGroup)) {
                    throw new Exception("error :State configuration monitor group with name [" + monitorGroup.getGlobalConfigurationGroupName() + "] already exists.");
                }
            } else if (oldMonitorGroup instanceof TableConfigurationGroup && monitorGroup instanceof TableConfigurationGroup) {
                if (!((TableConfigurationGroup)oldMonitorGroup).equals((TableConfigurationGroup)monitorGroup)) {
                    throw new Exception("error :Table configuration monitor group with name [" + monitorGroup.getGlobalConfigurationGroupName() + "] already exists.");
                }
            } else if (oldMonitorGroup instanceof MonitorConfigurationGroup && monitorGroup instanceof MonitorConfigurationGroup) {
                if (!((MonitorConfigurationGroup)oldMonitorGroup).equals((MonitorConfigurationGroup)monitorGroup)) {
                    throw new Exception("error :Monitor configuration group with name [" + monitorGroup.getGlobalConfigurationGroupName() + "] already exists.");
                }
            } else if (!oldMonitorGroup.equals(monitorGroup)) {
                throw new Exception("error :Simple Configuration group with name [" + monitorGroup.getGlobalConfigurationGroupName() + "] already exists.");
            }
        } else {
            location.infoT("Add new monitor group with name [" + monitorGroup.getGlobalConfigurationGroupName() + "] to the hashtable with all groups.");
            monitorGroups.put(monitorGroup.getGlobalConfigurationGroupName(), monitorGroup);
        }
    }

    public static void deleteConfigurationGroup(String groupName) {
        monitorGroups.remove(groupName);
    }

    private static String extractMonitorNameFromPath(String treePath) {
        int lastSlashInPath = treePath.lastIndexOf("/");
        return treePath.substring(lastSlashInPath + 1);
    }

    private static String getFileContent(Configuration config, String filename) throws Exception {
        InputStream is = config.getFile(filename);
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader reader = new BufferedReader(isr);
        String s = null;
        String result = "";
        while ((s = reader.readLine()) != null) {
            result = result + s;
        }
        return result;
    }

    private static void configureMonitorNode(IMonitorNode node, String descriptionID, String descriptionText, String globalConfigurationGroupName) {
        node.setDescriptionID(descriptionID);
        node.setDescription(descriptionText);
        node.setConfigurationGroup(globalConfigurationGroupName);
        node.setPath();
        node.setConfigured(true);
    }

    private void installMonitors(Element monitorConfigurationRoot) {
        MonitorInstallationXMLAnalyzer installAnalyser = new MonitorInstallationXMLAnalyzer(monitorConfigurationRoot, monitorGroups);
        installAnalyser.analyseMonitorInstallation();
    }

    private void installMonitors(Element monitorConfigurationRoot, String applicationName) {
        MonitorInstallationXMLAnalyzer installAnalyser = new MonitorInstallationXMLAnalyzer(monitorConfigurationRoot, monitorGroups, applicationName);
        installAnalyser.analyseMonitorInstallation();
    }

    public void installCcmsConnector() {
        if (this.serviceState.getProperty("CCMS_Mapping").equals("true")) {
            CcmsConnectorInfo info = this.getCcmsConnectorInfo();
            String sid = info.getSID();
            int jInstanceID = info.getJInstanceID();
            int jNodeID = info.getJNodeID();
            boolean isJDispatcher = info.isJDispatcher();
            String jProfile = info.getJ2eeProfile();
            String dirPerf = info.getCcmsRootDirectory();
            try {
                String system = this.serviceState.getProperty("CCMS_System_Mode");
                boolean systemMode = Boolean.valueOf(system);
                String trace = this.serviceState.getProperty("CCMS_Trace");
                int tracelevel = 0;
                try {
                    tracelevel = Integer.parseInt(trace);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                CcmsConnector.createInstance((String)sid, (int)jInstanceID, (int)jNodeID, (boolean)isJDispatcher, (String)jProfile, (String)dirPerf, (int)tracelevel, (boolean)systemMode);
            }
            catch (CcmsConnectorException exConn) {
                LoggingHelper.logThrowable((int)400, (Category)LoggingHelper.SYS_SERVER, (Location)location, (String)"installCcmsConnector()", (String)"Monitor service could not establish connection to CCMS.The monitors won't be sent to the CCMS.", (Throwable)exConn);
            }
        }
    }

    private void uninstallCcmsConnector() {
        try {
            this.uninstallConnectorMBean();
            CcmsConnector.removeInstance();
        }
        catch (CcmsConnectorException exConn) {
            LoggingHelper.logThrowable((int)400, (Category)LoggingHelper.SYS_SERVER, (Location)location, (String)"uninstallCcmsConnector()", (String)"Monitor service could not uninstall CCMS connector", (Throwable)exConn);
        }
    }

    private InstallationInfo getInstallationInfo(String mteName, IMonitorNode parent, String descripID, String descripTxt, String configGroupName, String owner, boolean customized) {
        return new InstallationInfo(mteName, parent, new SimpleConfigurationGroup(configGroupName, new Description(descripID, descripTxt), owner, customized));
    }

    public void installTopNodes() {
        try {
            IMonitorObjectFactory fac = MonitorFactory.createMonitorObjectFactory();
            IMonitorNode root = fac.getRootNode();
            root.setPath();
            root.addToCcms();
            InstallationInfo kernelInfo = this.getInstallationInfo("Kernel", root, "J2EE kernel root", KERNEL_DESCRIPTION, "J2EE kernel root", MONITOR_SERVICE_OWNER, false);
            IMonitorNode kernelNode = MonitorInstaller.installSummary(kernelInfo);
            kernelNode.setPath();
            IMonitorNode servicesNode = MonitorInstaller.installSummary(this.getInstallationInfo("Services", root, "J2EE services root", SERVICES_DESCRIPTION, "J2EE services root", MONITOR_SERVICE_OWNER, false));
            servicesNode.setPath();
            if (MonitorServiceRuntime.getNodeType() == 1) {
                IMonitorNode applicationsNode = MonitorInstaller.installSummary(this.getInstallationInfo("Applications", root, APPLICATIONS_DESCRIPTION_ID, APPLICATIONS_DESCRIPTION, APPLICATIONS_CONFIG_GROUP, MONITOR_SERVICE_OWNER, false));
                applicationsNode.setPath();
            }
            IMonitorNode performanceNode = MonitorInstaller.installSummary(this.getInstallationInfo("Performance", root, PERFORMANCE_DESCRIPTION_ID, PERFORMANCE_DESCRIPTION, PERFORMANCE_CONFIG_GROUP, MONITOR_SERVICE_OWNER, false));
            performanceNode.setPath();
        }
        catch (Exception e) {
            LoggingHelper.logThrowable((int)400, (Category)LoggingHelper.SYS_SERVER, (Location)location, (String)"installTopNodes()", (String)"Monitor service could not install top monitor tree nodes", (Throwable)e);
        }
    }

    public String[][] getSystemProperties() {
        return this.systemMonitorHelper.getProperties();
    }

    private void deregisterMonitors() {
        MonitorInstaller.uninstallSummary((ISummaryMonitorNode)m_monitorNodeFactory.getRootNode(), null);
    }

    private void installTimerService() {
        ObjectName timerName = null;
        try {
            timerName = ObjectNameFactory.getNameForServerChildPerNode((String)"Services", (String)"TimerService", null, null);
            ObjectName timerFactoryName = ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EETimerFactory", (String)"TimerFactory", null, null);
            mbs.invoke(timerFactoryName, "createTimer", new Object[]{timerName, new Boolean(true)}, new String[]{"javax.management.ObjectName", "boolean"});
            mbs.invoke(timerName, "start", null, null);
        }
        catch (MalformedObjectNameException mone) {
            LoggingHelper.logThrowable((int)500, (Category)LoggingHelper.SYS_SERVER, (Location)location, (String)"installTimerService()", (String)"Monitor Service could not install timer service.", (Throwable)mone);
        }
        catch (InstanceNotFoundException infe) {
            LoggingHelper.logThrowable((int)500, (Category)LoggingHelper.SYS_SERVER, (Location)location, (String)"installTimerService()", (String)"Monitor Service could not install timer service.", (Throwable)infe);
        }
        catch (MBeanException mbe) {
            LoggingHelper.logThrowable((int)500, (Category)LoggingHelper.SYS_SERVER, (Location)location, (String)"installTimerService()", (String)"Monitor Service could not install timer service", (Throwable)mbe);
        }
        catch (ReflectionException re) {
            LoggingHelper.logThrowable((int)500, (Category)LoggingHelper.SYS_SERVER, (Location)location, (String)"installTimerService()", (String)"Monitor Service could not install timer service", (Throwable)re);
        }
    }

    private void uninstallTimerService() {
        ObjectName timerName = null;
        try {
            timerName = ObjectNameFactory.getNameForServerChildPerNode((String)"Services", (String)"TimerService", null, null);
        }
        catch (MalformedObjectNameException malEx) {
            LoggingHelper.traceThrowable((int)500, (Location)location, (String)"uninstallTimerService()", (Throwable)malEx);
        }
        try {
            mbs.invoke(timerName, "stop", null, null);
            mbs.unregisterMBean(timerName);
        }
        catch (JMException ex) {
            LoggingHelper.traceThrowable((int)500, (Location)location, (String)"uninstallTimerService()", (Throwable)ex);
        }
    }

    private void installConnectorMBean() {
        try {
            if (CcmsConnector.getInstance() != null) {
                ObjectName timerName = ObjectNameFactory.getNameForServerChildPerNode((String)"Services", (String)"TimerService", null, null);
                Integer notificationId = (Integer)mbs.invoke(timerName, "addNotification", new Object[]{"timer.notification", "Trigger the CcmsConnector", null, new Date(System.currentTimeMillis() + 5000L), new Long(30000L)}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = MonitorServiceRuntime.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$lang$String == null ? (class$java$lang$String = MonitorServiceRuntime.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$lang$Object == null ? (class$java$lang$Object = MonitorServiceRuntime.class$("java.lang.Object")) : class$java$lang$Object).getName(), (class$java$util$Date == null ? (class$java$util$Date = MonitorServiceRuntime.class$("java.util.Date")) : class$java$util$Date).getName(), "long"});
                mbs.addNotificationListener(timerName, CcmsConnectorProxy.getProxy(), (NotificationFilter)new TimerFilter(notificationId), (Object)"TimerNotification");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void uninstallConnectorMBean() {
        try {
            if (CcmsConnector.getInstance() != null) {
                ObjectName timerName = ObjectNameFactory.getNameForServerChildPerNode((String)"Services", (String)"TimerService", null, null);
                mbs.removeNotificationListener(timerName, CcmsConnectorProxy.getProxy());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerMonitor(Object monitorInstance, Class monitorIF, ObjectName monitorName) {
        try {
            mbs.registerMBean(new StandardMBeanWrapper(monitorInstance, monitorIF), monitorName);
        }
        catch (JMException ex) {
            LoggingHelper.logThrowable((int)500, (Category)LoggingHelper.SYS_SERVER, (Location)location, (String)"registerMonitor()", (String)("Could not register monitor with name " + monitorName), (Throwable)ex);
        }
    }

    protected abstract ServiceContext getServiceContext();

    protected abstract void accessMBeanServer();

    protected abstract CcmsConnectorInfo getCcmsConnectorInfo();

    public IMonitorNode getChangedMonitorNode(IMonitorNode monitorNode) {
        ObjectName objName = null;
        try {
            objName = ObjectNameFactory.getNameForMonitorPerNode((String)ObjectName.quote(monitorNode.getPath()), null, null);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        Integer notificationId = null;
        ObjectName timer = null;
        try {
            timer = ObjectNameFactory.getNameForServerChildPerNode((String)"Services", (String)"TimerService", null, null);
        }
        catch (MalformedObjectNameException ex) {
            LOCATION.errorT(Util.getStackTraceAsString(ex));
        }
        try {
            notificationId = (Integer)mbs.invoke(timer, "addNotification", new Object[]{"timer.notification", "Trigger a monitor", null, new Date(System.currentTimeMillis()), new Integer(0)}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = MonitorServiceRuntime.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$lang$String == null ? (class$java$lang$String = MonitorServiceRuntime.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$lang$Object == null ? (class$java$lang$Object = MonitorServiceRuntime.class$("java.lang.Object")) : class$java$lang$Object).getName(), (class$java$util$Date == null ? (class$java$util$Date = MonitorServiceRuntime.class$("java.util.Date")) : class$java$util$Date).getName(), "long"});
        }
        catch (JMException ex) {
            LOCATION.errorT(Util.getStackTraceAsString(ex));
        }
        try {
            mbs.addNotificationListener(timer, objName, (NotificationFilter)new TimerFilter(notificationId), (Object)"TimerNotification");
        }
        catch (JMException ex) {
            LOCATION.errorT(Util.getStackTraceAsString(ex));
        }
        return MonitorServiceRuntime.getMappedTree().search(monitorNode).getMonitorObject();
    }

    public void registerGenericConfigurationMBean() {
        ConfigurationHandler configHandler = null;
        try {
            configHandler = this.getConfigurationHandler();
        }
        catch (ConfigurationException e) {
            location.errorT(Util.getStackTraceAsString((Exception)((Object)e)));
        }
        if (configHandler != null) {
            try {
                GenericConfigurationResource genMbean = new GenericConfigurationResource(configHandler, this.systemMonitor, this.isServer());
                ObjectName genMBeanName = ObjectNameFactory.getObjectName((String)MonitorConstants.CONFIGURATION_RESOURCE_MBEAN_TYPE, (String)MonitorConstants.CONFIGURATION_RESOURCE_MBEAN_NAME);
                mbs.registerMBean(genMbean, genMBeanName);
            }
            catch (MalformedObjectNameException e) {
                location.errorT(Util.getStackTraceAsString(e));
            }
            catch (NullPointerException ex) {
                location.errorT(Util.getStackTraceAsString(ex));
            }
            catch (InstanceAlreadyExistsException e) {
                location.errorT(Util.getStackTraceAsString(e));
            }
            catch (MBeanRegistrationException e) {
                location.errorT(Util.getStackTraceAsString(e));
            }
            catch (NotCompliantMBeanException e) {
                location.errorT(Util.getStackTraceAsString(e));
            }
            catch (Exception e) {
                location.errorT(Util.getStackTraceAsString(e));
            }
        } else {
            location.errorT("ConfigurationHandler is null");
        }
    }

    public void unregisterGenericConfigurationMBean() {
        try {
            mbs.unregisterMBean(ObjectNameFactory.getObjectName((String)MonitorConstants.CONFIGURATION_RESOURCE_MBEAN_TYPE, (String)MonitorConstants.CONFIGURATION_RESOURCE_MBEAN_NAME));
        }
        catch (MalformedObjectNameException e) {
            location.errorT(Util.getStackTraceAsString(e));
        }
        catch (InstanceNotFoundException e) {
            location.errorT(Util.getStackTraceAsString(e));
        }
        catch (MBeanRegistrationException e) {
            location.errorT(Util.getStackTraceAsString(e));
        }
    }

    private void installConfigurationService() {
        try {
            configurationServiceObjectName = ObjectNameFactory.getNameForServerChildPerNode((String)"Services", (String)"MonitorConfigurationService", null, null);
        }
        catch (MalformedObjectNameException malEx) {
            malEx.printStackTrace();
        }
        try {
            mbs.registerMBean(this.configService, configurationServiceObjectName);
        }
        catch (InstanceAlreadyExistsException existEx) {
        }
        catch (JMException ex) {
            ex.printStackTrace();
        }
    }

    private void uninstallConfigurationService() {
        try {
            mbs.unregisterMBean(configurationServiceObjectName);
        }
        catch (JMException ex) {
            ex.printStackTrace();
        }
    }

    public boolean changeThresholds(String configurationGroup, Thresholds thresholds) throws Exception {
        try {
            this.configService.setThresholds(configurationGroup, thresholds.getGreen2Yellow(), thresholds.getYellow2Red(), thresholds.getRed2Yellow(), thresholds.getYellow2Green());
        }
        catch (MBeanException e) {
            throw e.getTargetException();
        }
        catch (Exception e) {
            throw e;
        }
        return true;
    }

    public boolean changeDescriptionText(String configurationGroup, String text) throws Exception {
        try {
            this.configService.setDescription(configurationGroup, text);
        }
        catch (MBeanException e) {
            e.printStackTrace();
            throw e.getTargetException();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return true;
    }

    public boolean changeDataColection(String configurationGroup, DataCollection dataCollection) throws Exception {
        try {
            if (dataCollection.getCollectPeriod() == null) {
                this.configService.setReactOnCollectionFailure(configurationGroup, dataCollection.getReactOnCollectionFailure());
            } else {
                this.configService.setDataCollection(configurationGroup, dataCollection.getCollectPeriod().getUnit(), dataCollection.getCollectPeriod().getValue(), dataCollection.getReactOnCollectionFailure());
            }
        }
        catch (MBeanException e) {
            throw e.getTargetException();
        }
        catch (Exception e) {
            throw e;
        }
        return true;
    }

    public boolean changeMonitorGroupProperties(String configurationGroup, String descriptionText, DataCollection dataCollection) throws Exception {
        try {
            if (dataCollection.getDataCollectionType() == DataCollection.POLLED_BY_MONITOR) {
                this.configService.setMonitorGroupProperties(configurationGroup, descriptionText, dataCollection.getCollectPeriod().getValue(), dataCollection.getCollectPeriod().getUnit(), dataCollection.getReactOnCollectionFailure());
            } else {
                this.configService.setMonitorGroupProperties(configurationGroup, descriptionText, -1, -1, dataCollection.getReactOnCollectionFailure());
            }
        }
        catch (MBeanException e) {
            e.printStackTrace();
            throw e.getTargetException();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return true;
    }

    public boolean stopMonitor(IMonitorNode node) {
        ObjectName objName = null;
        try {
            objName = ObjectNameFactory.getNameForMonitorPerNode((String)ObjectName.quote(node.getPath()), null, null);
        }
        catch (MalformedObjectNameException e) {
            location.errorT(Util.getStackTraceAsString(e));
            return false;
        }
        if (node.getDataCollectionType() == DataCollection.POLLED_BY_MONITOR) {
            ObjectName timer = null;
            try {
                timer = ObjectNameFactory.getNameForServerChildPerNode((String)"Services", (String)"TimerService", null, null);
            }
            catch (MalformedObjectNameException ex) {
                location.errorT(Util.getStackTraceAsString(ex));
                return false;
            }
            try {
                mbs.removeNotificationListener(timer, objName);
            }
            catch (InstanceNotFoundException e) {
                location.errorT("There is no MBean with name: " + objName + " in the MBean server");
                location.errorT(Util.getStackTraceAsString(e));
                return false;
            }
            catch (ListenerNotFoundException ex) {
                location.errorT("There is no notification listener for: " + objName);
                location.errorT(Util.getStackTraceAsString(ex));
                return false;
            }
        }
        if (node.getDataCollectionType() == DataCollection.PUSHED_BY_RESOURCE) {
            // empty if block
        }
        if (node instanceof PerformanceMonitorNode) {
            ((PerformanceMonitorNode)node).setKeepingHistory(false, ((PerformanceMonitorNode)node).getAlertRelevantValueType());
        }
        return true;
    }

    public boolean setStates(String configurationGroup, String[][] states) throws Exception {
        try {
            this.configService.setStates(configurationGroup, states);
            return true;
        }
        catch (Exception e) {
            location.errorT(Util.getStackTraceAsString(e));
            return false;
        }
    }

    public boolean restoreGroupToDefault(String configurationGroup) {
        try {
            this.configService.restoreDefaultConfiguration(configurationGroup);
            return true;
        }
        catch (Exception e) {
            location.errorT(Util.getStackTraceAsString(e));
            return false;
        }
    }

    public boolean restoreALLGroupsToDefault() {
        try {
            this.configService.restoreAllDefaultConfigurations();
            return true;
        }
        catch (Exception e) {
            location.errorT(Util.getStackTraceAsString(e));
            return false;
        }
    }

    public boolean stopCollectHistory(IMonitorNode node) throws Exception {
        if (node instanceof PerformanceMonitorNode) {
            ((PerformanceMonitorNode)node).setKeepingHistory(false, ((PerformanceMonitorNode)node).getAlertRelevantValueType());
            location.infoT("Collecting history for a monitor node with path[" + node.getPath() + "] is stopped.");
            return true;
        }
        location.errorT("Cannot stop collecting history for a not performance monitor node with path:" + node.getPath());
        return false;
    }

    public boolean startCollectHistory(IMonitorNode node) throws Exception {
        if (node instanceof PerformanceMonitorNode) {
            ((PerformanceMonitorNode)node).setKeepingHistory(true, ((PerformanceMonitorNode)node).getAlertRelevantValueType());
            location.infoT("Collecting history for a monitor node with path[" + node.getPath() + "] is started.");
            return true;
        }
        location.errorT("Cannot start collecting history for a not performance monitor node with path:" + node.getPath());
        return false;
    }

    public MonitorConfigurationHandler getMonitorConfigurationHandler() {
        return this.monitorConfigHandl;
    }

    public SimpleConfigurationGroup findDefaultGroup(String configGroupName, String owner) {
        location.infoT("Search a group[" + configGroupName + "] with owner:" + owner);
        if (owner.startsWith(KERNEL_OWNER)) {
            return this.getDefaultGroupFromKernel(configGroupName, owner);
        }
        if (owner.startsWith(SERVICE_OWNER_PREFIX)) {
            StringBuffer app = new StringBuffer(owner);
            app.delete(0, SERVICE_OWNER_PREFIX.length());
            String serviceName = app.toString();
            return this.getDefaultGroupFromService(configGroupName, owner, serviceName);
        }
        if (owner.startsWith(APPLICATION_OWNER_PREFIX)) {
            StringBuffer app = new StringBuffer(owner);
            app.delete(0, APPLICATION_OWNER_PREFIX.length());
            String appName = app.toString();
            return this.getDefaultGroupFromApplication(configGroupName, owner, appName);
        }
        if (owner.startsWith(LIBRARY_OWNER_PREFIX)) {
            location.infoT("This is a library.");
        } else if (owner.startsWith(MONITOR_SERVICE_OWNER)) {
            location.infoT("This is a programaticaly created group, canot get the default.");
        } else {
            location.warningT("Unknown owner");
        }
        return null;
    }

    /*
     * Loose catch block
     */
    SimpleConfigurationGroup getDefaultGroupFromKernel(String configGroupName, String owner) {
        SimpleConfigurationGroup newGroup;
        block12: {
            block11: {
                newGroup = null;
                location.infoT("Try to get default configuration group with name [" + configGroupName + "] , with owner [" + owner + "] for kernel");
                InputStream kernelConfigurationStream = this.serviceState.getPersistentContainer().getPersistentEntryStream("monitor-configuration.xml", false);
                Document configXml = this.monitorXMLParser.parse(kernelConfigurationStream);
                if (configXml != null) {
                    Element monitorConfigurationRoot = configXml.getDocumentElement();
                    MonitorGroupXMLAnalyzer groupAnalyser = new MonitorGroupXMLAnalyzer(monitorConfigurationRoot);
                    Vector newMonitorGroups = groupAnalyser.getMonitorGroups(owner);
                    SimpleConfigurationGroup group = null;
                    int i = 0;
                    while (i < newMonitorGroups.size()) {
                        group = (SimpleConfigurationGroup)newMonitorGroups.get(i);
                        if (group.getGlobalConfigurationGroupName().equals(configGroupName)) {
                            group.setCustomized(false);
                            newGroup = group;
                        }
                        ++i;
                    }
                    break block11;
                }
                location.errorT("error in XML file:Document for kernel parsed from input stream is null");
            }
            Object var12_12 = null;
            try {
                this.configurationHandler.closeAllConfigurations();
            }
            catch (ConfigurationException e2) {
                location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
            }
            break block12;
            {
                catch (Exception e) {
                    Object var12_13 = null;
                    try {
                        this.configurationHandler.closeAllConfigurations();
                    }
                    catch (ConfigurationException e2) {
                        location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    this.configurationHandler.closeAllConfigurations();
                }
                catch (ConfigurationException e2) {
                    location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                }
                throw throwable;
            }
        }
        return newGroup;
    }

    /*
     * Loose catch block
     */
    SimpleConfigurationGroup getDefaultGroupFromService(String configGroupName, String owner, String servicename) {
        SimpleConfigurationGroup newGroup = null;
        location.infoT("Try to get default configuration group with name [" + configGroupName + "] , with owner [" + owner + "] for service with name:" + servicename);
        ServiceMonitor[] services = this.systemMonitor.getServices();
        int i = 0;
        while (i < services.length) {
            block13: {
                ServiceMonitor service = services[i];
                String serviceName = service.getComponentName();
                if (serviceName.equals(servicename)) {
                    block12: {
                        Document configXml;
                        InputStream serviceConfigurationStream = service.getDescriptorContainer().getPersistentEntryStream("monitor-configuration.xml", false);
                        if (serviceConfigurationStream == null || (configXml = this.monitorXMLParser.parse(serviceConfigurationStream)) == null) break block12;
                        Element monitorConfigurationRoot = configXml.getDocumentElement();
                        MonitorGroupXMLAnalyzer groupAnalyser = new MonitorGroupXMLAnalyzer(monitorConfigurationRoot);
                        Vector newMonitorGroups = groupAnalyser.getMonitorGroups(owner);
                        SimpleConfigurationGroup group = null;
                        int j = 0;
                        while (j < newMonitorGroups.size()) {
                            group = (SimpleConfigurationGroup)newMonitorGroups.get(j);
                            if (group.getGlobalConfigurationGroupName().equals(configGroupName)) {
                                group.setCustomized(false);
                                newGroup = group;
                            }
                            ++j;
                        }
                    }
                    Object var17_17 = null;
                    try {
                        this.configurationHandler.closeAllConfigurations();
                    }
                    catch (ConfigurationException e2) {
                        location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                    }
                    break block13;
                    {
                        catch (Exception e) {
                            location.errorT("Cannot get default group [" + configGroupName + "] for owner [" + owner + "]");
                            var17_17 = null;
                            try {
                                this.configurationHandler.closeAllConfigurations();
                            }
                            catch (ConfigurationException e2) {
                                location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        var17_17 = null;
                        try {
                            this.configurationHandler.closeAllConfigurations();
                        }
                        catch (ConfigurationException e2) {
                            location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                        }
                        throw throwable;
                    }
                }
            }
            ++i;
        }
        return newGroup;
    }

    /*
     * Loose catch block
     */
    SimpleConfigurationGroup getDefaultGroupFromApplication(String configGroupName, String owner, String appName) {
        SimpleConfigurationGroup newGroup;
        block11: {
            block10: {
                Document configXml;
                newGroup = null;
                String configPath = "apps/" + appName + "/" + "Monitoring Configurator";
                location.infoT("Try to get default configuration group with name [" + configGroupName + "] , with owner [" + appName + "] for application with path:" + configPath);
                Configuration configuration = this.configurationHandler.openConfiguration(configPath, 0);
                InputStream serviceConfigurationStream = configuration.getFile("monitor-configuration.xml");
                if (serviceConfigurationStream == null || (configXml = this.monitorXMLParser.parse(serviceConfigurationStream)) == null) break block10;
                Element monitorConfigurationRoot = configXml.getDocumentElement();
                MonitorGroupXMLAnalyzer groupAnalyser = new MonitorGroupXMLAnalyzer(monitorConfigurationRoot);
                Vector newMonitorGroups = groupAnalyser.getMonitorGroups(owner);
                SimpleConfigurationGroup group = null;
                int j = 0;
                while (j < newMonitorGroups.size()) {
                    group = (SimpleConfigurationGroup)newMonitorGroups.get(j);
                    if (group.getGlobalConfigurationGroupName().equals(configGroupName)) {
                        group.setCustomized(false);
                        newGroup = group;
                    }
                    ++j;
                }
            }
            Object var15_15 = null;
            try {
                this.configurationHandler.closeAllConfigurations();
            }
            catch (ConfigurationException e2) {
                location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
            }
            break block11;
            {
                catch (ConfigurationException e) {
                    Object var15_16 = null;
                    try {
                        this.configurationHandler.closeAllConfigurations();
                    }
                    catch (ConfigurationException e2) {
                        location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                try {
                    this.configurationHandler.closeAllConfigurations();
                }
                catch (ConfigurationException e2) {
                    location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                }
                throw throwable;
            }
        }
        return newGroup;
    }

    public int getNodeID() {
        return this.nodeId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        m_defaultMapping = null;
        location = Location.getLocation((String)"com.sap.engine.services.monitor.common");
        mbs = null;
    }
}

