/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.common;

import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.state.ManagementListener;
import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.library.monitor.mapping.MappedTree;
import com.sap.engine.services.monitor.MonitorRuntimeControlInterface;
import com.sap.engine.services.monitor.agent.AbstractAgent;
import com.sap.engine.services.monitor.agent.InstallationInformation;
import com.sap.engine.services.monitor.agent.J2EEAgent;
import com.sap.engine.services.monitor.agent.server.AbstractAgentImpl;
import com.sap.engine.services.monitor.agent.server.CcmsRegistration;
import com.sap.engine.services.monitor.agent.server.Conf;
import com.sap.engine.services.monitor.agent.server.ConfigFileCache;
import com.sap.engine.services.monitor.agent.server.ExecutableCache;
import com.sap.engine.services.monitor.agent.server.InstallationInformationImpl;
import com.sap.engine.services.monitor.agent.server.J2EEAgentImpl;
import com.sap.engine.services.monitor.agent.server.J2EEServerAgentImpl;
import com.sap.engine.services.monitor.agent.server.Profile;
import com.sap.engine.services.monitor.agent.server.ProfileCache;
import com.sap.engine.services.monitor.agent.server.StandaloneAgentImpl;
import com.sap.engine.services.monitor.common.MonitorServiceRuntime;
import com.sap.engine.services.monitor.config.DataCollection;
import com.sap.engine.services.monitor.config.Thresholds;
import com.sap.jmx.ObjectNameFactory;
import com.sap.jmx.monitoring.api.ConfigurationList;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class MonitorRuntimeControlImpl
implements MonitorRuntimeControlInterface {
    MonitorServiceRuntime m_serviceRuntime = null;
    private InstallationInformation m_installationInfo = null;
    private static HashMap agentCache = new HashMap();
    private static ProfileCache profileCache = null;
    private static ConfigFileCache configFileCache = null;
    private static ExecutableCache executableCache = null;
    private static Location location = Location.getLocation((Class)(class$com$sap$engine$services$monitor$common$MonitorRuntimeControlImpl == null ? (class$com$sap$engine$services$monitor$common$MonitorRuntimeControlImpl = MonitorRuntimeControlImpl.class$("com.sap.engine.services.monitor.common.MonitorRuntimeControlImpl")) : class$com$sap$engine$services$monitor$common$MonitorRuntimeControlImpl));
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sap$engine$services$monitor$common$MonitorRuntimeControlImpl;

    public MonitorRuntimeControlImpl(MonitorServiceRuntime serviceRuntime) throws RemoteException {
        this.m_serviceRuntime = serviceRuntime;
    }

    public IMonitorNode getRootNode() throws RemoteException {
        IMonitorNode rootNode = null;
        if (this.m_serviceRuntime != null) {
            rootNode = this.m_serviceRuntime.getMonitorFactory().getRootNode();
        }
        return rootNode;
    }

    public void registerManagementListener(ManagementListener managementListener) {
    }

    public MappedTree getMapping(String mappingName) throws RemoteException {
        if (this.m_serviceRuntime != null) {
            this.waitTillMappingsAreSet();
            return this.m_serviceRuntime.getMapping(mappingName);
        }
        return null;
    }

    private void waitTillMappingsAreSet() {
        try {
            while (!MonitorServiceRuntime.isDefaultMappingDone) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String[] getMappings() throws RemoteException {
        if (this.m_serviceRuntime != null) {
            return this.m_serviceRuntime.getMappingNames();
        }
        return new String[0];
    }

    public Hashtable getConfigurationGroups() throws RemoteException {
        if (this.m_serviceRuntime != null) {
            return MonitorServiceRuntime.getConfigurationGroups();
        }
        return new Hashtable();
    }

    public String[][] getApplicationsWithGrmgCustomizing() throws RemoteException {
        if (this.m_serviceRuntime != null) {
            return this.m_serviceRuntime.getApplicationsWithGrmgCustomizing();
        }
        return null;
    }

    public String getCustomizing(String application) throws RemoteException {
        if (this.m_serviceRuntime != null) {
            return this.m_serviceRuntime.getCustomizing(application);
        }
        return null;
    }

    public void saveCustomizing(String application, String customizing) throws RemoteException {
        if (this.m_serviceRuntime != null) {
            this.m_serviceRuntime.saveCustomizing(application, customizing);
        }
    }

    public void saveCustomizingInCCMSAgent(String application, String customizing) throws RemoteException {
        if (this.m_serviceRuntime != null) {
            this.m_serviceRuntime.saveCustomizingInCCMSAgent(application, customizing);
        }
    }

    public boolean isServer() throws RemoteException {
        boolean isServer = false;
        if (this.m_serviceRuntime != null) {
            isServer = this.m_serviceRuntime.isServer();
        }
        return isServer;
    }

    public IMonitorNode getChangedMonitorNode(IMonitorNode monitorNode) throws RemoteException {
        IMonitorNode result = null;
        if (this.m_serviceRuntime != null) {
            result = this.m_serviceRuntime.getChangedMonitorNode(monitorNode);
        }
        return result;
    }

    public boolean changeThresholds(String configurationGroup, Thresholds thresholds) throws RemoteException {
        try {
            this.m_serviceRuntime.changeThresholds(configurationGroup, thresholds);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RemoteException(e.getMessage());
        }
        return true;
    }

    public boolean changeDescriptionText(String configurationGroup, String text) throws RemoteException {
        try {
            this.m_serviceRuntime.changeDescriptionText(configurationGroup, text);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RemoteException(e.getMessage());
        }
        return true;
    }

    public boolean changeMonitorGroupProperties(String configurationGroup, String text, DataCollection dataCollection) throws RemoteException {
        try {
            this.m_serviceRuntime.changeMonitorGroupProperties(configurationGroup, text, dataCollection);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RemoteException(e.getMessage());
        }
        return true;
    }

    public boolean setDataCollection(String configurationGroup, DataCollection dataCollection) throws RemoteException {
        try {
            this.m_serviceRuntime.changeDataColection(configurationGroup, dataCollection);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
        return true;
    }

    public boolean stopMonitor(IMonitorNode node) throws RemoteException {
        return this.m_serviceRuntime.stopMonitor(node);
    }

    public boolean startMonitor(IMonitorNode node) throws RemoteException {
        return false;
    }

    public boolean setStates(String configurationGroup, String[][] states) throws RemoteException {
        try {
            this.m_serviceRuntime.setStates(configurationGroup, states);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
        return true;
    }

    public boolean stopCollectHistory(IMonitorNode node) throws RemoteException {
        try {
            this.m_serviceRuntime.stopCollectHistory(node);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
        return true;
    }

    public boolean startCollectHistory(IMonitorNode node) throws RemoteException {
        try {
            this.m_serviceRuntime.startCollectHistory(node);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
        return true;
    }

    public String[][] getSystemProperties() throws RemoteException {
        String[][] sysProps = null;
        try {
            sysProps = this.m_serviceRuntime.getSystemProperties();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
        return sysProps;
    }

    public boolean restoreGroupToDefault(String groupName) throws RemoteException {
        try {
            this.m_serviceRuntime.restoreGroupToDefault(groupName);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
        return true;
    }

    public boolean restoreAllGroupsToDefault() throws RemoteException {
        try {
            this.m_serviceRuntime.restoreALLGroupsToDefault();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
        return true;
    }

    public ConfigurationList getVMInfo() throws RemoteException {
        String clusterID = this.m_serviceRuntime.getNodeID() + "";
        MBeanServer mbs = MonitorServiceRuntime.getMBeanServer();
        ConfigurationList cl = new ConfigurationList();
        try {
            ObjectName on = ObjectNameFactory.getNameForServerChild((String)"SAP_J2EEClusterNode", (String)clusterID, (String)"\"\"");
            cl.setConfigurationParameter("PID", ((Long)mbs.getAttribute(on, "ProcessId")).toString());
            Properties systemProps = (Properties)mbs.getAttribute(on, "SystemProperties");
            cl.setConfigurationParameter("Name", systemProps.getProperty("java.vm.name"));
            cl.setConfigurationParameter("Vendor", systemProps.getProperty("java.vm.vendor"));
            cl.setConfigurationParameter("Version", systemProps.getProperty("java.vm.version"));
            String[] vmParams = (String[])mbs.getAttribute(on, "VmParameters");
            Comparator stringIgnoreCaseComparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    String str1 = (String)o1;
                    String str2 = (String)o2;
                    return str1.compareToIgnoreCase(str2);
                }
            };
            Arrays.sort(vmParams, stringIgnoreCaseComparator);
            int size = vmParams.length;
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < size) {
                String p = vmParams[i];
                if (p.startsWith("-X")) {
                    sb.append(p);
                    if (i + 1 < size) {
                        sb.append(';').append(' ');
                    }
                }
                ++i;
            }
            ArrayList<String> list = new ArrayList<String>();
            int i2 = vmParams.length;
            while (i2-- > 0) {
                String p = vmParams[i2];
                if (!p.startsWith("-X")) continue;
                list.add(p);
            }
            cl.setConfigurationParameter("Parameters", sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RemoteException(e.getMessage());
        }
        return cl;
    }

    public ConfigurationList getClusterNodeInfo() throws RemoteException {
        String clusterID = this.m_serviceRuntime.getNodeID() + "";
        MBeanServer mbs = MonitorServiceRuntime.getMBeanServer();
        ConfigurationList cl = new ConfigurationList();
        try {
            ObjectName on = ObjectNameFactory.getNameForServerChild((String)"SAP_J2EEClusterNode", (String)clusterID, (String)"\"\"");
            Properties info = (Properties)mbs.getAttribute(on, "Info");
            cl.setConfigurationParameter("Cluster ID", info.getProperty("ID"));
            cl.setConfigurationParameter("Kernel Version", info.getProperty("KernelVersion"));
            cl.setConfigurationParameter("Debug Mode", info.getProperty("DebugMode"));
            cl.setConfigurationParameter("Debuggable", info.getProperty("Debuggable"));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RemoteException(e.getMessage());
        }
        return cl;
    }

    public ConfigurationList getSCSInstanceInfo() throws RemoteException {
        MBeanServer mbs = MonitorServiceRuntime.getMBeanServer();
        ConfigurationList cl = new ConfigurationList();
        try {
            ObjectName kernelQuery = ObjectNameFactory.getPatternForServerChildPerNode((String)"SAP_J2EEKernelPerNode", null, null);
            Iterator<ObjectName> namesIter = mbs.queryNames(kernelQuery, null).iterator();
            if (!namesIter.hasNext()) {
                throw new InstanceNotFoundException("unable to get system info, no kernel MBean found, query was " + kernelQuery);
            }
            ObjectName kernelName = namesIter.next();
            String msHost = (String)mbs.invoke(kernelName, "getManagerProperty", new Object[]{"ClusterManager", "ms.host"}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = MonitorRuntimeControlImpl.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$lang$String == null ? (class$java$lang$String = MonitorRuntimeControlImpl.class$("java.lang.String")) : class$java$lang$String).getName()});
            cl.setConfigurationParameter("Host", msHost);
            cl.setConfigurationParameter("IP", MonitorRuntimeControlImpl.resolveHostIP(msHost));
            String msPortString = (String)mbs.invoke(kernelName, "getManagerProperty", new Object[]{"ClusterManager", "ms.port"}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = MonitorRuntimeControlImpl.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$lang$String == null ? (class$java$lang$String = MonitorRuntimeControlImpl.class$("java.lang.String")) : class$java$lang$String).getName()});
            cl.setConfigurationParameter("Message Server Port", msPortString);
            String enquPortString = (String)mbs.invoke(kernelName, "getManagerProperty", new Object[]{"LockingManager", "enqu.port"}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = MonitorRuntimeControlImpl.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$lang$String == null ? (class$java$lang$String = MonitorRuntimeControlImpl.class$("java.lang.String")) : class$java$lang$String).getName()});
            cl.setConfigurationParameter("Enqueue Server Port", enquPortString);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RemoteException(e.getMessage());
        }
        return cl;
    }

    public ConfigurationList getInstanceInfo() throws RemoteException {
        String clusterID = this.m_serviceRuntime.getNodeID() + "";
        MBeanServer mbs = MonitorServiceRuntime.getMBeanServer();
        ConfigurationList cl = new ConfigurationList();
        try {
            ObjectName on = ObjectNameFactory.getNameForServerChild((String)"SAP_J2EEInstance", (String)"local", null);
            cl.setConfigurationParameter("Name", (String)mbs.getAttribute(on, "Name"));
            String hostname = (String)mbs.getAttribute(on, "Host");
            cl.setConfigurationParameter("Host", hostname);
            cl.setConfigurationParameter("IP", MonitorRuntimeControlImpl.resolveHostIP(hostname));
            cl.setConfigurationParameter("HttpPort", ((Integer)mbs.getAttribute(on, "HttpPort")).toString());
            cl.setConfigurationParameter("HttpsPort", ((Integer)mbs.getAttribute(on, "HttpsPort")).toString());
            cl.setConfigurationParameter("P4Port", ((Integer)mbs.getAttribute(on, "P4Port")).toString());
            cl.setConfigurationParameter("TelnetPort", ((Integer)mbs.getAttribute(on, "TelnetPort")).toString());
            on = ObjectNameFactory.getNameForServerChild((String)"SAP_J2EEClusterNode", (String)clusterID, (String)"\"\"");
            Properties systemProps = (Properties)mbs.getAttribute(on, "SystemProperties");
            cl.setConfigurationParameter("OS Version", systemProps.getProperty("os.version"));
            cl.setConfigurationParameter("OS Architecture", systemProps.getProperty("os.arch"));
            cl.setConfigurationParameter("OS Name", systemProps.getProperty("os.name"));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RemoteException(e.getMessage());
        }
        return cl;
    }

    private static final String resolveHostIP(String hostName) {
        try {
            InetAddress ia = InetAddress.getByName(hostName);
            return ia.getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "unknown";
        }
    }

    public boolean isWindowsPlatform() {
        location.infoT(Category.SYS_SERVER, "isWindowsPlatform()");
        boolean isWindows = this.getInstallationInfo().isWindowsPlatform();
        location.infoT(Category.SYS_SERVER, "isWindowsPlatform()", String.valueOf(isWindows));
        return isWindows;
    }

    public String[] allSystems() {
        location.infoT(Category.SYS_SERVER, "allSystems()");
        String[] allSystems = this.getInstallationInfo().allSystems();
        location.infoT(Category.SYS_SERVER, "allSystems()", String.valueOf(allSystems != null ? allSystems.length : 0));
        return allSystems;
    }

    public String[] instanceNumbers(String systemName) {
        String me = "instanceNumbers(" + systemName + ")";
        location.infoT(Category.SYS_SERVER, me);
        String[] instanceNumbers = this.getInstallationInfo().instanceNumbers(systemName);
        location.infoT(Category.SYS_SERVER, me, String.valueOf(instanceNumbers != null ? instanceNumbers.length : 0));
        return instanceNumbers;
    }

    public boolean isSystemExisting(String systemName) {
        String me = "isSystemExisting(" + systemName + ")";
        location.infoT(Category.SYS_SERVER, me);
        boolean isExisting = this.getInstallationInfo().isSystemExisting(systemName);
        location.infoT(Category.SYS_SERVER, me, String.valueOf(isExisting));
        return isExisting;
    }

    public boolean matchesProfileFileNamePattern(String fileName) {
        String me = "matchesProfileFileNamePattern(" + fileName + ")";
        location.infoT(Category.SYS_SERVER, me);
        boolean matches = this.getInstallationInfo().matchesProfileFileNamePattern(fileName);
        location.infoT(Category.SYS_SERVER, me, String.valueOf(matches));
        return matches;
    }

    public void addInstallledSystem(String systemName, String instanceNumber) {
        String me = "addInstallledSystem(, " + instanceNumber + ")";
        location.infoT(Category.SYS_SERVER, me);
        this.getInstallationInfo().addInstallledSystem(systemName, instanceNumber);
        location.infoT(Category.SYS_SERVER, me, "done");
    }

    public Integer createStandaloneAgent() {
        String me = "createStandaloneAgent()";
        location.infoT(Category.SYS_SERVER, "createStandaloneAgent()");
        StandaloneAgentImpl agent = new StandaloneAgentImpl();
        Integer key = this.addToCache(agent);
        location.infoT(Category.SYS_SERVER, "createStandaloneAgent()", key.toString());
        return key;
    }

    public Integer createJ2EEAgent(String systemName, String instanceNumber) {
        String me = "createJ2EEAgent(" + systemName + ", " + instanceNumber != null ? instanceNumber : "null)";
        location.infoT(Category.SYS_SERVER, me);
        AbstractAgentImpl agent = null;
        agent = instanceNumber == null ? new J2EEServerAgentImpl(systemName) : new J2EEAgentImpl(systemName, instanceNumber);
        Integer key = this.addToCache(agent);
        location.infoT(Category.SYS_SERVER, me, key.toString());
        return key;
    }

    public void delete(Integer agentKey) {
        String me = "delete(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        this.removeFromCache(agentKey);
        location.infoT(Category.SYS_SERVER, me, "done");
    }

    public int register(Integer agentKey) throws Exception {
        String me = "register(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        int rc = this.getAgent(agentKey).register();
        location.infoT(Category.SYS_SERVER, me, String.valueOf(rc));
        return rc;
    }

    public int unregister(Integer agentKey) throws Exception {
        String me = "unregister(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        int rc = this.getAgent(agentKey).unregister();
        location.infoT(Category.SYS_SERVER, me, String.valueOf(rc));
        return rc;
    }

    public int version(Integer agentKey) throws Exception {
        String me = "version(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        int rc = this.getAgent(agentKey).version();
        location.infoT(Category.SYS_SERVER, me, String.valueOf(rc));
        return rc;
    }

    public void refresh(Integer agentKey) {
        String me = "refresh(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        this.getAgent(agentKey).refresh();
        location.infoT(Category.SYS_SERVER, me, "done");
    }

    public boolean isConfigFileValid(Integer agentKey) {
        String me = "isConfigFileValid(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        boolean rc = this.getAgent(agentKey).isConfigFileValid();
        location.infoT(Category.SYS_SERVER, me, String.valueOf(rc));
        return rc;
    }

    public boolean isExecutableValid(Integer agentKey) {
        String me = "isExecutableValid(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        boolean rc = this.getAgent(agentKey).isExecutableValid();
        location.infoT(Category.SYS_SERVER, me, String.valueOf(rc));
        return rc;
    }

    public boolean isValid(Integer agentKey) {
        String me = "isValid(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        boolean rc = this.getAgent(agentKey).isValid();
        location.infoT(Category.SYS_SERVER, me, String.valueOf(rc));
        return rc;
    }

    public byte[] getOutput(Integer agentKey) {
        String me = "getOutput(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        InputStream output = this.getAgent(agentKey).getOutput();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        if (output != null) {
            try {
                int size = 0;
                size = output.available();
                byte[] buf = new byte[size];
                while (output.read(buf) != -1) {
                    result.write(buf);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        location.infoT(Category.SYS_SERVER, me, "done");
        return result.toByteArray();
    }

    public int start(Integer agentKey) throws Exception {
        String me = "start(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        int rc = this.getAgent(agentKey).start();
        location.infoT(Category.SYS_SERVER, me, String.valueOf(rc));
        return rc;
    }

    public int stop(Integer agentKey) throws Exception {
        String me = "stop(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        int rc = this.getAgent(agentKey).stop();
        location.infoT(Category.SYS_SERVER, me, String.valueOf(rc));
        return rc;
    }

    public String getDefaultConfigurationDirectory(Integer agentKey) {
        String me = "getDefaultConfigurationDirectory(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        String rc = this.getAgent(agentKey).getDefaultConfigurationDirectory();
        location.infoT(Category.SYS_SERVER, me, rc);
        return rc;
    }

    public String getDefaultAgentDirectory(Integer agentKey) {
        String me = "getDefaultAgentDirectory(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        String rc = this.getAgent(agentKey).getDefaultAgentDirectory();
        location.infoT(Category.SYS_SERVER, me, rc);
        return rc;
    }

    public String getAgentConfigurationBaseFileName(Integer agentKey) {
        String me = "getAgentConfigurationBaseFileName(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        String rc = this.getAgent(agentKey).getAgentConfigurationBaseFileName();
        location.infoT(Category.SYS_SERVER, me, rc);
        return rc;
    }

    public String getAgentBaseFileName(Integer agentKey) {
        String me = "getAgentBaseFileName(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        String rc = this.getAgent(agentKey).getAgentBaseFileName();
        location.infoT(Category.SYS_SERVER, me, rc);
        return rc;
    }

    public int status(Integer agentKey) throws Exception {
        String me = "status(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        int rc = this.getAgent(agentKey).status();
        location.infoT(Category.SYS_SERVER, me, String.valueOf(rc));
        return rc;
    }

    public void printLog(Integer agentKey) {
    }

    public boolean makePersistent(Integer agentKey) {
        String me = "makePersistent(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        boolean rc = this.getAgent(agentKey).makePersistent();
        location.infoT(Category.SYS_SERVER, me, String.valueOf(rc));
        return rc;
    }

    public String getConfigFileName(Integer agentKey) {
        String me = "getConfigFileName(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        String rc = this.getAgent(agentKey).getConfigFileName();
        location.infoT(Category.SYS_SERVER, me, rc);
        return rc;
    }

    public void setConfigFileName(Integer agentKey, String configFileName) {
        String me = "setConfigFileName(" + agentKey.toString() + ", " + configFileName + ")";
        location.infoT(Category.SYS_SERVER, me);
        this.getAgent(agentKey).setConfigFileName(configFileName);
        location.infoT(Category.SYS_SERVER, me, "done");
    }

    public String getExecutableFileName(Integer agentKey) {
        String me = "getExecutableFileName(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        String rc = this.getAgent(agentKey).getExecutableFileName();
        location.infoT(Category.SYS_SERVER, me, rc);
        return rc;
    }

    public void setExecutableFileName(Integer agentKey, String executableFileName) {
        String me = "setExecutableFileName(" + agentKey.toString() + ", " + executableFileName + ")";
        location.infoT(Category.SYS_SERVER, me);
        this.getAgent(agentKey).setExecutableFileName(executableFileName);
        location.infoT(Category.SYS_SERVER, me, "done");
    }

    public String getAdminSystem(Integer agentKey) {
        String me = "getAdminSystem(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        String rc = this.getAgent(agentKey).getAdminSystem();
        location.infoT(Category.SYS_SERVER, me, rc);
        return rc;
    }

    public String getAdminUser(Integer agentKey) {
        String me = "getAdminUser(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        String rc = this.getAgent(agentKey).getAdminUser();
        location.infoT(Category.SYS_SERVER, me, rc);
        return rc;
    }

    public String getAdminClient(Integer agentKey) {
        String me = "getAdminClient(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        String rc = this.getAgent(agentKey).getAdminClient();
        location.infoT(Category.SYS_SERVER, me, rc);
        return rc;
    }

    public String getCsmregSystem(Integer agentKey) {
        String me = "getCsmregSystem(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        String rc = this.getAgent(agentKey).getCsmregSystem();
        location.infoT(Category.SYS_SERVER, me, rc);
        return rc;
    }

    public String getCsmregUser(Integer agentKey) {
        String me = "getCsmregUser(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        String rc = this.getAgent(agentKey).getCsmregUser();
        location.infoT(Category.SYS_SERVER, me, rc);
        return rc;
    }

    public String getCsmregClient(Integer agentKey) {
        String me = "getCsmregClient(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        String rc = this.getAgent(agentKey).getCsmregClient();
        location.infoT(Category.SYS_SERVER, me, rc);
        return rc;
    }

    public void setAdminPassword(Integer agentKey, String password) {
        String me = "setAdminPassword(" + agentKey.toString() + ", XXXXXX)";
        location.infoT(Category.SYS_SERVER, me);
        this.getAgent(agentKey).setAdminPassword(password);
        location.infoT(Category.SYS_SERVER, me, "done");
    }

    public String getAdminPassword(Integer agentKey) {
        String me = "getAdminPassword(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        String rc = this.getAgent(agentKey).getAdminPassword();
        location.infoT(Category.SYS_SERVER, me, "XXXXXX");
        return rc;
    }

    public void setCsmregPassword(Integer agentKey, String password) {
        String me = "setCsmregPassword(" + agentKey.toString() + ", XXXXXX)";
        location.infoT(Category.SYS_SERVER, me);
        this.getAgent(agentKey).setCsmregPassword(password);
        location.infoT(Category.SYS_SERVER, me, "done");
    }

    public String getCsmregPassword(Integer agentKey) {
        String me = "getCsmregPassword(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        String rc = this.getAgent(agentKey).getCsmregPassword();
        location.infoT(Category.SYS_SERVER, me, "XXXXXX");
        return rc;
    }

    public byte[] getConf(Integer agentKey) {
        String me = "getConf(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        byte[] rc = this.getAgent(agentKey).getConf().toByteArray();
        location.infoT(Category.SYS_SERVER, me, rc == null ? "null" : String.valueOf(rc.length));
        return rc;
    }

    public void setConf(Integer agentKey, byte[] buf) {
        String me = "setConf(" + agentKey.toString() + ", " + buf == null ? "null" : String.valueOf(buf.length) + ")";
        location.infoT(Category.SYS_SERVER, me);
        Conf conf = null;
        try {
            conf = new Conf(buf);
        }
        catch (IOException e) {
            Category.SYS_SERVER.error(location, me, (Object)e);
            location.traceThrowableT(500, me, (Throwable)e);
        }
        this.getAgent(agentKey).setConf(conf);
        location.infoT(Category.SYS_SERVER, me, "done");
    }

    public void setConf(Integer agentKey, String configFileName, byte[] buf) {
        String me = "setConf(" + agentKey.toString() + ", " + configFileName + ", " + buf == null ? "null" : String.valueOf(buf.length) + ")";
        location.infoT(Category.SYS_SERVER, me);
        Conf conf = null;
        try {
            conf = new Conf(buf);
        }
        catch (IOException e) {
            Category.SYS_SERVER.error(location, me, (Object)e);
            location.traceThrowableT(500, me, (Throwable)e);
        }
        this.getAgent(agentKey).setConfigFile(configFileName, conf);
        location.infoT(Category.SYS_SERVER, me, "done");
    }

    public boolean isProfileFileValid(Integer agentKey) {
        String me = "isProfileFileValid(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        boolean rc = ((J2EEAgent)this.getAgent(agentKey)).isProfileFileValid();
        location.infoT(Category.SYS_SERVER, me, String.valueOf(rc));
        return rc;
    }

    public String getProfileName(Integer agentKey) {
        String me = "getProfileName(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        String rc = ((J2EEAgent)this.getAgent(agentKey)).getProfileName();
        location.infoT(Category.SYS_SERVER, me, rc);
        return rc;
    }

    public void setProfileName(Integer agentKey, String profileName) {
        String me = "setProfileName(" + agentKey.toString() + ", " + profileName + ")";
        location.infoT(Category.SYS_SERVER, me);
        ((J2EEAgent)this.getAgent(agentKey)).setProfileName(profileName);
        location.infoT(Category.SYS_SERVER, me, "done");
    }

    public String getDefaultProfileDirectory(Integer agentKey) {
        String me = "getDefaultProfileDirectory(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        String rc = ((J2EEAgent)this.getAgent(agentKey)).getDefaultProfileDirectory();
        location.infoT(Category.SYS_SERVER, me, rc);
        return rc;
    }

    public String getDefaultProfileFileName(Integer agentKey) {
        String me = "getDefaultProfileFileName(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        String rc = ((J2EEAgent)this.getAgent(agentKey)).getDefaultProfileFileName();
        location.infoT(Category.SYS_SERVER, me, rc);
        return rc;
    }

    public String getLongSID(Integer agentKey) {
        String me = "getLongSID(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        String rc = ((J2EEAgent)this.getAgent(agentKey)).getLongSID();
        location.infoT(Category.SYS_SERVER, me, rc);
        return rc;
    }

    public void setLongSID(Integer agentKey, String longSID) {
        String me = "setLongSID(" + agentKey.toString() + ", " + longSID + ")";
        location.infoT(Category.SYS_SERVER, me);
        ((J2EEAgent)this.getAgent(agentKey)).setLongSID(longSID);
        location.infoT(Category.SYS_SERVER, me, "done");
    }

    public void enableCcmsCustomizing(Integer agentKey, Boolean enable) {
        String me = "enableCcmsCustomizing(" + agentKey.toString() + ", " + String.valueOf(enable) + ")";
        location.infoT(Category.SYS_SERVER, me);
        ((J2EEAgent)this.getAgent(agentKey)).enableCcmsCustomizing(enable);
        location.infoT(Category.SYS_SERVER, me, "done");
    }

    public boolean isCcmsCustomizingEnabled(Integer agentKey) {
        String me = "isCcmsCustomizingEnabled(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        boolean rc = ((J2EEAgent)this.getAgent(agentKey)).isCcmsCustomizingEnabled();
        location.infoT(Category.SYS_SERVER, me, String.valueOf(rc));
        return rc;
    }

    public void registerCcmsCustomizing(Integer agentKey) {
        String me = "registerCcmsCustomizing(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        ((J2EEAgent)this.getAgent(agentKey)).registerCcmsCustomizing();
        location.infoT(Category.SYS_SERVER, me, "done");
    }

    public void unregisterCcmsCustomizing(Integer agentKey) {
        String me = "unregisterCcmsCustomizing(" + agentKey.toString() + ")";
        location.infoT(Category.SYS_SERVER, me);
        ((J2EEAgent)this.getAgent(agentKey)).unregisterCcmsCustomizing();
        location.infoT(Category.SYS_SERVER, me, "done");
    }

    private InstallationInformation getInstallationInfo() {
        if (this.m_installationInfo == null) {
            InstallationInformationImpl installationInfo = InstallationInformationImpl.getInstallationInformation();
            installationInfo.setSystemNameFilter(new String[]{this.getSystemName()});
            this.m_installationInfo = installationInfo;
        }
        return this.m_installationInfo;
    }

    private Integer addToCache(AbstractAgent agent) {
        Integer key = new Integer(agent.hashCode());
        if (agentCache == null) {
            agentCache = new HashMap();
        }
        while (agentCache.containsKey(key)) {
            key = new Integer(key + 1);
        }
        agentCache.put(key, agent);
        return key;
    }

    private void removeFromCache(Integer agentKey) {
        if (agentCache == null) {
            return;
        }
        agentCache.remove(agentKey);
    }

    private AbstractAgent getAgent(Integer key) {
        return (AbstractAgent)agentCache.get(key);
    }

    public boolean isProfileValid(String profileName) {
        String me = "isProfileValid(" + profileName + ")";
        location.infoT(Category.SYS_SERVER, me);
        Profile profile = this.getProfileCache().getProfile(profileName);
        boolean rc = profile == null ? false : profile.isValid();
        location.infoT(Category.SYS_SERVER, me, String.valueOf(rc));
        return rc;
    }

    public String getSystemNameFromProfile(String profileName) {
        String me = "getSystemNameFromProfile(" + profileName + ")";
        location.infoT(Category.SYS_SERVER, me);
        Profile profile = this.getProfileCache().getProfile(profileName);
        String rc = profile == null ? null : profile.getSystemName();
        location.infoT(Category.SYS_SERVER, me, rc);
        return rc;
    }

    public String getInstanceNumberFromProfile(String profileName) {
        String me = "getInstanceNumberFromProfile(" + profileName + ")";
        location.infoT(Category.SYS_SERVER, me);
        Profile profile = this.getProfileCache().getProfile(profileName);
        String rc = profile == null ? null : profile.getInstanceNumber();
        location.infoT(Category.SYS_SERVER, me, rc);
        return rc;
    }

    public boolean isConfigFileValid(String configFileName) {
        String me = "isConfigFileValid(" + configFileName + ")";
        location.infoT(Category.SYS_SERVER, me);
        Conf conf = this.getConfigFileCache().getConf(configFileName);
        boolean rc = conf == null ? false : conf.isValid();
        location.infoT(Category.SYS_SERVER, me, String.valueOf(rc));
        return rc;
    }

    public boolean isExecutableValid(String executableName) {
        String me = "isExecutableValid(" + executableName + ")";
        location.infoT(Category.SYS_SERVER, me);
        boolean rc = this.getExecutableCache().isValid(executableName);
        location.infoT(Category.SYS_SERVER, me, String.valueOf(rc));
        return rc;
    }

    public void setExecutableValid(String executableName) {
        String me = "setExecutableValid(" + executableName + ")";
        location.infoT(Category.SYS_SERVER, me);
        this.getExecutableCache().setValid(executableName);
        location.infoT(Category.SYS_SERVER, me, "done");
    }

    private ProfileCache getProfileCache() {
        if (profileCache == null) {
            profileCache = ProfileCache.getProfileCache();
        }
        return profileCache;
    }

    private ConfigFileCache getConfigFileCache() {
        if (configFileCache == null) {
            configFileCache = ConfigFileCache.getConfigFileCache();
        }
        return configFileCache;
    }

    private ExecutableCache getExecutableCache() {
        if (executableCache == null) {
            executableCache = ExecutableCache.getExecutableCache();
        }
        return executableCache;
    }

    public String getSystemName() {
        return System.getProperty("SAPSYSTEMNAME");
    }

    public boolean isRunningInJ2eeEngine() {
        return true;
    }

    public static ConfigurationHandler getConfigurationHandler() {
        ConfigurationHandler configurationHandler = null;
        try {
            configurationHandler = MonitorServiceRuntime.getMSRInstance().getConfigurationHandler();
        }
        catch (ConfigurationException e) {
            configurationHandler = null;
        }
        return configurationHandler;
    }

    public boolean isCentral() throws RemoteException {
        String me = "isCentral()";
        location.infoT(Category.SYS_SERVER, "isCentral()");
        Boolean central = new Boolean("false");
        try {
            ObjectName instanceON = ObjectNameFactory.getNameForServerChild((String)"SAP_J2EEInstance", (String)"local", null);
            central = (Boolean)MonitorServiceRuntime.getMBeanServer().getAttribute(instanceON, "Central");
        }
        catch (Exception e) {
            throw new RemoteException("", e);
        }
        location.infoT(Category.SYS_SERVER, "isCentral()", central.toString());
        return central;
    }

    public void registerCcmsCustomizing(String systemID, String cenSystemPassword) {
        String me = "registerCcmsCustomizing(" + systemID + ", XXXXXX)";
        location.infoT(Category.SYS_SERVER, me);
        CcmsRegistration ccms = new CcmsRegistration();
        ccms.registerCcmsCustomizing(systemID, cenSystemPassword);
        location.infoT(Category.SYS_SERVER, me, "done");
    }

    public void unregisterCcmsCustomizing(String systemID) {
        String me = "unregisterCcmsCustomizing(" + systemID + ")";
        location.infoT(Category.SYS_SERVER, me);
        CcmsRegistration ccms = new CcmsRegistration();
        ccms.unregisterCcmsCustomizing(systemID);
        location.infoT(Category.SYS_SERVER, me, "done");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

