/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.common;

import com.sap.engine.library.monitor.IMonitorNode;
import com.sap.engine.services.monitor.MonitorConstants;
import com.sap.engine.services.monitor.common.MonitorServiceRuntime;
import com.sap.engine.services.monitor.common.Parameter;
import com.sap.engine.services.monitor.config.Period;
import com.sap.engine.services.monitor.config.SimpleConfigurationGroup;
import com.sap.engine.services.monitor.config.StateConfigurationGroup;
import com.sap.engine.services.monitor.install.InstallationInfo;
import com.sap.engine.services.monitor.install.MonitorInstallationInfo;
import com.sap.engine.services.monitor.install.MonitorInstaller;
import com.sap.engine.services.monitor.install.StateMonitorInstallationInfo;
import com.sap.engine.services.monitor.install.TableMonitorInstallationInfo;
import com.sap.engine.services.monitor.install.TemplateInstallationInfo;
import com.sap.engine.services.monitor.install.TemplateTreeNode;
import com.sap.engine.services.monitor.mbeans.AttributeMappingInfo;
import com.sap.engine.services.monitor.mbeans.MBeanCallInfo;
import com.sap.engine.services.monitor.mbeans.Template;
import com.sap.engine.services.monitor.mbeans.TemplateAttributeMappingInfo;
import com.sap.tc.logging.Location;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MonitorInstallationXMLAnalyzer {
    private Element monitorConfigurationRoot;
    private Hashtable groups;
    private String applicationName = null;
    private Location location = Location.getLocation((String)"com.sap.engine.services.monitor.common.MonitorInstallationXMLAnalyzer");
    static /* synthetic */ Class array$Ljava$lang$String;

    public MonitorInstallationXMLAnalyzer(Element monitorConfigurationRoot, Hashtable groups) {
        this.monitorConfigurationRoot = monitorConfigurationRoot;
        this.groups = groups;
    }

    public MonitorInstallationXMLAnalyzer(Element monitorConfigurationRoot, Hashtable groups, String applicationName) {
        this.monitorConfigurationRoot = monitorConfigurationRoot;
        this.groups = groups;
        this.applicationName = applicationName;
    }

    public void analyseMonitorInstallation() {
        this.analyseMonitorTree();
    }

    public void analyseMonitorTree() {
        this.analyseSubRoot("kernel");
        this.analyseSubRoot("services");
        this.analyseSubRoot("applications");
        this.analyseSubRoot("performance");
    }

    public void analyseSubRoot(String subRootType) {
        Element subRoot = (Element)this.monitorConfigurationRoot.getElementsByTagName(subRootType).item(0);
        if (subRoot != null) {
            IMonitorNode parent = null;
            NodeList children = subRoot.getChildNodes();
            if (subRootType.equals("kernel")) {
                parent = MonitorInstaller.getKernelRootNode();
            } else if (subRootType.equals("services")) {
                parent = MonitorInstaller.getServicesRootNode();
            } else if (subRootType.equals("applications")) {
                parent = MonitorInstaller.getApplicationsRootNode();
            } else if (subRootType.equals("performance")) {
                parent = MonitorInstaller.getPerformanceRootNode();
            }
            this.analyseChildren(children, parent);
        }
    }

    private void analyseChildren(NodeList nodeList, IMonitorNode parent) {
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals("summary")) {
                this.treatSummary((Element)node, parent);
            } else if (nodeName.equals("object")) {
                this.treatObject((Element)node, parent);
            } else if (nodeName.equals("pool-monitor")) {
                this.treatPoolMonitor((Element)node, parent);
            } else if (nodeName.equals("cache-monitor")) {
                this.treatCacheMonitor((Element)node, parent);
            }
            ++i;
        }
    }

    private IMonitorNode treatSummary(Element summary, IMonitorNode parent) {
        NodeList templateInfo = summary.getElementsByTagName("template-info");
        if (templateInfo.getLength() != 0 && this.isImmediatePredecessor(summary, templateInfo.item(0))) {
            String templateName = ((Element)templateInfo.item(0)).getAttribute("template-name");
            TemplateInstallationInfo templateInstallationInfo = this.getTemplateInstallationInfo((Element)templateInfo.item(0));
            TemplateTreeNode templateTree = this.treatTemplate(summary, (byte)1);
            Template template = new Template(templateName, templateTree, parent, templateInstallationInfo, this.groups, this.applicationName);
            MonitorServiceRuntime.addTemplate(templateName, template);
            template.start();
            return null;
        }
        String name = summary.getAttribute("name");
        String groupName = summary.getAttribute("configuration-group");
        if (this.groups.get(groupName) != null) {
            InstallationInfo summaryInfo = new InstallationInfo(name, parent, (SimpleConfigurationGroup)this.groups.get(groupName), this.applicationName);
            summaryInfo.setVolatile(this.isVolatile(summary));
            IMonitorNode summaryNode = MonitorInstaller.installSummary(summaryInfo);
            NodeList summaryChildren = summary.getChildNodes();
            this.analyseChildren(summaryChildren, summaryNode);
            return summaryNode;
        }
        this.location.errorT("error in XML file:Group with name " + groupName + " does not exist.Installation info for " + name + " won't be created");
        return null;
    }

    private IMonitorNode treatObject(Element object, IMonitorNode parent) {
        NodeList templateInfo = object.getElementsByTagName("template-info");
        if (templateInfo.getLength() != 0 && this.isImmediatePredecessor(object, templateInfo.item(0))) {
            String templateName = ((Element)templateInfo.item(0)).getAttribute("template-name");
            TemplateInstallationInfo templateInstallationInfo = this.getTemplateInstallationInfo((Element)templateInfo.item(0));
            TemplateTreeNode templateTree = this.treatTemplate(object, (byte)2);
            Template template = new Template(templateName, templateTree, parent, templateInstallationInfo, this.groups, this.applicationName);
            MonitorServiceRuntime.addTemplate(templateName, template);
            template.start();
            return null;
        }
        String name = object.getAttribute("name");
        String groupName = object.getAttribute("configuration-group");
        if (this.groups.get(groupName) != null) {
            InstallationInfo objectInfo = new InstallationInfo(name, parent, (SimpleConfigurationGroup)this.groups.get(groupName), this.applicationName);
            objectInfo.setVolatile(this.isVolatile(object));
            IMonitorNode objectNode = MonitorInstaller.installObject(objectInfo);
            this.treatObjectChildren(object, objectNode);
            return objectNode;
        }
        this.location.errorT("error in XML file:Group with name " + groupName + " does not exist.Installation info for " + name + " won't be created");
        return null;
    }

    private void treatObjectChildren(Element object, IMonitorNode parent) {
        this.extractTextMonitors(object, parent);
        this.extractStateMonitors(object, parent);
        this.extractTableMonitors(object, parent);
        this.extractVersionMonitors(object, parent);
        this.extractConfigurationMonitors(object, parent);
        this.extractIntegerMonitors(object, parent);
        this.extractLongMonitors(object, parent);
        this.extractAvailabilityMonitors(object, parent);
        this.extractFrequencyMonitors(object, parent);
        this.extractQualityRateMonitors(object, parent);
        this.extractDurationMonitors(object, parent);
    }

    private void treatPoolMonitor(Element monitor, IMonitorNode parent) {
        Vector<String> attributeNames = new Vector<String>();
        Vector<String> attributeMappings = new Vector<String>();
        attributeNames.add("current-usage-attribute");
        attributeNames.add("initial-size-attribute");
        attributeNames.add("min-size-attribute");
        attributeNames.add("current-size-attribute");
        attributeNames.add("max-size-attribute");
        attributeNames.add("increment-step-attribute");
        attributeMappings.add("NumberOfCurrentUsedObjects");
        attributeMappings.add("InitialPoolSize");
        attributeMappings.add("MinPoolSize");
        attributeMappings.add("CurrentPoolSize");
        attributeMappings.add("MaxPoolSize");
        attributeMappings.add("IncrementSize");
        this.treatMonitor(monitor, parent, attributeNames, attributeMappings);
    }

    private void treatCacheMonitor(Element monitor, IMonitorNode parent) {
        Vector<String> attributeNames = new Vector<String>();
        Vector<String> attributeMappings = new Vector<String>();
        attributeNames.add("current-usage-attribute");
        attributeNames.add("max-size-attribute");
        attributeMappings.add("currentUsage");
        attributeMappings.add("maxSize");
        this.treatMonitor(monitor, parent, attributeNames, attributeMappings);
    }

    private void extractIntegerMonitors(Element object, IMonitorNode parent) {
        NodeList integerMonitors = object.getElementsByTagName("integer-monitor");
        Vector<String> attributeNames = new Vector<String>();
        Vector<String> attributeMappings = new Vector<String>();
        attributeNames.add("integer-attribute");
        attributeMappings.add("Value");
        int i = 0;
        while (i < integerMonitors.getLength()) {
            Element monitor = (Element)integerMonitors.item(i);
            NodeList templateInfo = monitor.getElementsByTagName("template-info");
            if (templateInfo.getLength() != 0) {
                String templateName = ((Element)templateInfo.item(0)).getAttribute("template-name");
                TemplateInstallationInfo templateInstallationInfo = this.getTemplateInstallationInfo((Element)templateInfo.item(0));
                TemplateTreeNode templateTree = this.treatTemplate(monitor, (byte)9);
                Template template = new Template(templateName, templateTree, parent, templateInstallationInfo, this.groups, this.applicationName);
                MonitorServiceRuntime.addTemplate(templateName, template);
                template.start();
            } else {
                this.treatMonitor(monitor, parent, attributeNames, attributeMappings);
            }
            ++i;
        }
    }

    private void extractLongMonitors(Element object, IMonitorNode parent) {
        NodeList longMonitors = object.getElementsByTagName("long-monitor");
        Vector<String> attributeNames = new Vector<String>();
        Vector<String> attributeMappings = new Vector<String>();
        attributeNames.add("long-attribute");
        attributeMappings.add("Value");
        int i = 0;
        while (i < longMonitors.getLength()) {
            Element monitor = (Element)longMonitors.item(i);
            NodeList templateInfo = monitor.getElementsByTagName("template-info");
            if (templateInfo.getLength() != 0) {
                String templateName = ((Element)templateInfo.item(0)).getAttribute("template-name");
                TemplateInstallationInfo templateInstallationInfo = this.getTemplateInstallationInfo((Element)templateInfo.item(0));
                TemplateTreeNode templateTree = this.treatTemplate(monitor, (byte)10);
                Template template = new Template(templateName, templateTree, parent, templateInstallationInfo, this.groups, this.applicationName);
                MonitorServiceRuntime.addTemplate(templateName, template);
                template.start();
            } else {
                this.treatMonitor(monitor, parent, attributeNames, attributeMappings);
            }
            ++i;
        }
    }

    private void extractStateMonitors(Element object, IMonitorNode parent) {
        NodeList monitors = object.getElementsByTagName("state-monitor");
        Vector<String> attributeNames = new Vector<String>();
        Vector<String> attributeMappings = new Vector<String>();
        attributeNames.add("state-attribute");
        attributeMappings.add("State");
        int i = 0;
        while (i < monitors.getLength()) {
            Element monitor = (Element)monitors.item(i);
            NodeList templateInfo = monitor.getElementsByTagName("template-info");
            if (templateInfo.getLength() != 0) {
                String templateName = ((Element)templateInfo.item(0)).getAttribute("template-name");
                TemplateInstallationInfo templateInstallationInfo = this.getTemplateInstallationInfo((Element)templateInfo.item(0));
                TemplateTreeNode templateTree = this.treatTemplate(monitor, (byte)4);
                Template template = new Template(templateName, templateTree, parent, templateInstallationInfo, this.groups, this.applicationName);
                MonitorServiceRuntime.addTemplate(templateName, template);
                template.start();
            } else {
                this.treatStateMonitor(monitor, parent, attributeNames, attributeMappings);
            }
            ++i;
        }
    }

    private void extractTableMonitors(Element object, IMonitorNode parent) {
        NodeList monitors = object.getElementsByTagName("table-monitor");
        Vector<String> attributeNames = new Vector<String>();
        Vector<String> attributeMappings = new Vector<String>();
        attributeNames.add("table-entries-attribute");
        attributeMappings.add("Entries");
        int i = 0;
        while (i < monitors.getLength()) {
            Element monitor = (Element)monitors.item(i);
            NodeList templateInfo = monitor.getElementsByTagName("template-info");
            if (templateInfo.getLength() != 0) {
                String templateName = ((Element)templateInfo.item(0)).getAttribute("template-name");
                TemplateInstallationInfo templateInstallationInfo = this.getTemplateInstallationInfo((Element)templateInfo.item(0));
                TemplateTreeNode templateTree = this.treatTemplate(monitor, (byte)5);
                Template template = new Template(templateName, templateTree, parent, templateInstallationInfo, this.groups, this.applicationName);
                MonitorServiceRuntime.addTemplate(templateName, template);
                template.start();
            } else {
                this.treatTableMonitor(monitor, parent, attributeNames, attributeMappings);
            }
            ++i;
        }
    }

    private void extractConfigurationMonitors(Element object, IMonitorNode parent) {
        NodeList monitors = object.getElementsByTagName("configuration-monitor");
        Vector<String> attributeNames = new Vector<String>();
        Vector<String> attributeMappings = new Vector<String>();
        attributeNames.add("configuration-attribute");
        attributeMappings.add("Configuration");
        int i = 0;
        while (i < monitors.getLength()) {
            Element monitor = (Element)monitors.item(i);
            NodeList templateInfo = monitor.getElementsByTagName("template-info");
            if (templateInfo.getLength() != 0) {
                String templateName = ((Element)templateInfo.item(0)).getAttribute("template-name");
                TemplateInstallationInfo templateInstallationInfo = this.getTemplateInstallationInfo((Element)templateInfo.item(0));
                TemplateTreeNode templateTree = this.treatTemplate(monitor, (byte)7);
                Template template = new Template(templateName, templateTree, parent, templateInstallationInfo, this.groups, this.applicationName);
                template.start();
            } else {
                this.treatMonitor(monitor, parent, attributeNames, attributeMappings);
            }
            ++i;
        }
    }

    private void extractVersionMonitors(Element object, IMonitorNode parent) {
        NodeList monitors = object.getElementsByTagName("version-monitor");
        Vector<String> attributeNames = new Vector<String>();
        Vector<String> attributeMappings = new Vector<String>();
        attributeNames.add("version-attribute");
        attributeMappings.add("Version");
        int i = 0;
        while (i < monitors.getLength()) {
            Element monitor = (Element)monitors.item(i);
            NodeList templateInfo = monitor.getElementsByTagName("template-info");
            if (templateInfo.getLength() != 0) {
                String templateName = ((Element)templateInfo.item(0)).getAttribute("template-name");
                TemplateInstallationInfo templateInstallationInfo = this.getTemplateInstallationInfo((Element)templateInfo.item(0));
                TemplateTreeNode templateTree = this.treatTemplate(monitor, (byte)6);
                Template template = new Template(templateName, templateTree, parent, templateInstallationInfo, this.groups, this.applicationName);
                template.start();
            } else {
                this.treatMonitor(monitor, parent, attributeNames, attributeMappings);
            }
            ++i;
        }
    }

    private void extractAvailabilityMonitors(Element object, IMonitorNode parent) {
        NodeList monitors = object.getElementsByTagName("availability-monitor");
        Vector<String> attributeNames = new Vector<String>();
        Vector<String> attributeMappings = new Vector<String>();
        attributeNames.add("availability-attribute");
        attributeMappings.add("Value");
        int i = 0;
        while (i < monitors.getLength()) {
            Element monitor = (Element)monitors.item(i);
            NodeList templateInfo = monitor.getElementsByTagName("template-info");
            if (templateInfo.getLength() != 0) {
                String templateName = ((Element)templateInfo.item(0)).getAttribute("template-name");
                TemplateInstallationInfo templateInstallationInfo = this.getTemplateInstallationInfo((Element)templateInfo.item(0));
                TemplateTreeNode templateTree = this.treatTemplate(monitor, (byte)8);
                Template template = new Template(templateName, templateTree, parent, templateInstallationInfo, this.groups, this.applicationName);
                MonitorServiceRuntime.addTemplate(templateName, template);
                template.start();
            } else {
                this.treatMonitor(monitor, parent, attributeNames, attributeMappings);
            }
            ++i;
        }
    }

    private void extractFrequencyMonitors(Element object, IMonitorNode parent) {
        NodeList monitors = object.getElementsByTagName("frequency-monitor");
        Vector<String> attributeNames = new Vector<String>();
        Vector<String> attributeMappings = new Vector<String>();
        attributeNames.add("reported-events-attribute");
        attributeMappings.add("ReportedEvents");
        int i = 0;
        while (i < monitors.getLength()) {
            Element monitor = (Element)monitors.item(i);
            NodeList templateInfo = monitor.getElementsByTagName("template-info");
            if (templateInfo.getLength() != 0) {
                String templateName = ((Element)templateInfo.item(0)).getAttribute("template-name");
                TemplateInstallationInfo templateInstallationInfo = this.getTemplateInstallationInfo((Element)templateInfo.item(0));
                TemplateTreeNode templateTree = this.treatTemplate(monitor, (byte)11);
                Template template = new Template(templateName, templateTree, parent, templateInstallationInfo, this.groups, this.applicationName);
                MonitorServiceRuntime.addTemplate(templateName, template);
                template.start();
            } else {
                this.treatMonitor(monitor, parent, attributeNames, attributeMappings);
            }
            ++i;
        }
    }

    private void extractQualityRateMonitors(Element object, IMonitorNode parent) {
        NodeList monitors = object.getElementsByTagName("quality-rate-monitor");
        Vector<String> attributeNames = new Vector<String>();
        Vector<String> attributeMappings = new Vector<String>();
        int i = 0;
        while (i < monitors.getLength()) {
            Element monitor = (Element)monitors.item(i);
            attributeNames.clear();
            attributeMappings.clear();
            Element qualityAttribute = (Element)monitor.getElementsByTagName("quality-rate-attribute").item(0);
            if (qualityAttribute == null) {
                attributeNames.add("total-tries-attribute");
                attributeNames.add("total-hits-attribute");
                attributeMappings.add("TotalTriesFromStartup");
                attributeMappings.add("TotalSuccessfulTriesFromStartup");
            } else {
                attributeNames.add("quality-rate-attribute");
                attributeMappings.add("quality-rate-attribute");
            }
            NodeList templateInfo = monitor.getElementsByTagName("template-info");
            if (templateInfo.getLength() != 0) {
                String templateName = ((Element)templateInfo.item(0)).getAttribute("template-name");
                TemplateInstallationInfo templateInstallationInfo = this.getTemplateInstallationInfo((Element)templateInfo.item(0));
                TemplateTreeNode templateTree = this.treatTemplate(monitor, (byte)12);
                Template template = new Template(templateName, templateTree, parent, templateInstallationInfo, this.groups, this.applicationName);
                MonitorServiceRuntime.addTemplate(templateName, template);
                template.start();
            } else {
                this.treatMonitor(monitor, parent, attributeNames, attributeMappings);
            }
            ++i;
        }
    }

    private void extractDurationMonitors(Element object, IMonitorNode parent) {
        NodeList monitors = object.getElementsByTagName("duration-monitor");
        Vector<String> attributeNames = new Vector<String>();
        Vector<String> attributeMappings = new Vector<String>();
        attributeNames.add("total-number-attribute");
        attributeNames.add("total-time-attribute");
        attributeMappings.add("TotalNumberFromStartup");
        attributeMappings.add("TotalTimeFromStartup");
        int i = 0;
        while (i < monitors.getLength()) {
            Element monitor = (Element)monitors.item(i);
            attributeNames.clear();
            attributeMappings.clear();
            Element durationAttribute = (Element)monitor.getElementsByTagName("duration-attribute").item(0);
            if (durationAttribute == null) {
                attributeNames.add("total-number-attribute");
                attributeNames.add("total-time-attribute");
                attributeMappings.add("TotalNumberFromStartup");
                attributeMappings.add("TotalTimeFromStartup");
            } else {
                attributeNames.add("duration-attribute");
                attributeMappings.add("duration-attribute");
            }
            NodeList templateInfo = monitor.getElementsByTagName("template-info");
            if (templateInfo.getLength() != 0) {
                String templateName = ((Element)templateInfo.item(0)).getAttribute("template-name");
                TemplateInstallationInfo templateInstallationInfo = this.getTemplateInstallationInfo((Element)templateInfo.item(0));
                TemplateTreeNode templateTree = this.treatTemplate(monitor, (byte)13);
                Template template = new Template(templateName, templateTree, parent, templateInstallationInfo, this.groups, this.applicationName);
                MonitorServiceRuntime.addTemplate(templateName, template);
                template.start();
            } else {
                this.treatMonitor(monitor, parent, attributeNames, attributeMappings);
            }
            ++i;
        }
    }

    private void extractTextMonitors(Element object, IMonitorNode parent) {
        NodeList monitors = object.getElementsByTagName("text-monitor");
        Vector<String> attributeNames = new Vector<String>();
        Vector<String> attributeMappings = new Vector<String>();
        attributeNames.add("text-attribute");
        attributeMappings.add("Text");
        int i = 0;
        while (i < monitors.getLength()) {
            Element monitor = (Element)monitors.item(i);
            NodeList templateInfo = monitor.getElementsByTagName("template-info");
            if (templateInfo.getLength() != 0) {
                String templateName = ((Element)templateInfo.item(0)).getAttribute("template-name");
                TemplateInstallationInfo templateInstallationInfo = this.getTemplateInstallationInfo((Element)templateInfo.item(0));
                TemplateTreeNode templateTree = this.treatTemplate(monitor, (byte)3);
                Template template = new Template(templateName, templateTree, parent, templateInstallationInfo, this.groups, this.applicationName);
                MonitorServiceRuntime.addTemplate(templateName, template);
                template.start();
            } else {
                this.treatMonitor(monitor, parent, attributeNames, attributeMappings);
            }
            ++i;
        }
    }

    private void treatTableMonitor(Element monitor, IMonitorNode parent, Vector monitorAttributeTagNames, Vector monitorAttributeNames) {
        String typeOfMonitor = monitor.getNodeName();
        String monitorNodeName = monitor.getAttribute("name");
        String filename = monitor.getAttribute("filename");
        String groupName = monitor.getAttribute("configuration-group");
        Element monitoredResource = (Element)monitor.getElementsByTagName("monitored-resource").item(0);
        String monitoredResourceName = monitoredResource.getAttribute("name");
        String monitoredResourceType = monitoredResource.getAttribute("type");
        Vector attributeMappings = this.extractAttributeMappingInfos(monitor, monitorAttributeTagNames, monitorAttributeNames);
        if (this.groups.get(groupName) != null) {
            TableMonitorInstallationInfo info = this.applicationName == null ? new TableMonitorInstallationInfo(monitorNodeName, parent, (SimpleConfigurationGroup)this.groups.get(groupName), monitoredResourceName, monitoredResourceType, attributeMappings, filename) : new TableMonitorInstallationInfo(monitorNodeName, parent, (SimpleConfigurationGroup)this.groups.get(groupName), monitoredResourceName, monitoredResourceType, attributeMappings, filename, this.applicationName);
            info.setVolatile(this.isVolatile(monitor));
            MonitorInstaller.installTableMonitor(info);
        } else {
            this.location.errorT("error in XML file:Group with name " + groupName + " does not exist.Installation info for " + monitorNodeName + " won't be created");
        }
    }

    private void treatStateMonitor(Element monitor, IMonitorNode parent, Vector monitorAttributeTagNames, Vector monitorAttributeNames) {
        String typeOfMonitor = monitor.getNodeName();
        String monitorNodeName = monitor.getAttribute("name");
        String explicitGreen = monitor.getAttribute("explicit-green");
        String groupName = monitor.getAttribute("configuration-group");
        Element monitoredResource = (Element)monitor.getElementsByTagName("monitored-resource").item(0);
        String monitoredResourceName = monitoredResource.getAttribute("name");
        String monitoredResourceType = monitoredResource.getAttribute("type");
        Vector attributeMappings = this.extractAttributeMappingInfos(monitor, monitorAttributeTagNames, monitorAttributeNames);
        if (this.groups.get(groupName) != null) {
            StateMonitorInstallationInfo info = this.applicationName == null ? new StateMonitorInstallationInfo(monitorNodeName, parent, (SimpleConfigurationGroup)this.groups.get(groupName), monitoredResourceName, monitoredResourceType, attributeMappings, explicitGreen.equals("TRUE")) : new StateMonitorInstallationInfo(monitorNodeName, parent, (SimpleConfigurationGroup)this.groups.get(groupName), monitoredResourceName, monitoredResourceType, attributeMappings, explicitGreen.equals("TRUE"), this.applicationName);
            info.setVolatile(this.isVolatile(monitor));
            StateConfigurationGroup stateGroup = (StateConfigurationGroup)info.getConfigurationGroup();
            if (!(stateGroup.getGreenStates() != null && stateGroup.getGreenStates().length != 0 || stateGroup.getYellowStates() != null && stateGroup.getYellowStates().length != 0 || stateGroup.getRedStates() != null && stateGroup.getRedStates().length != 0)) {
                MonitorInstaller.installVariableStateMonitor(info);
            } else {
                MonitorInstaller.installStateMonitor(info);
            }
        } else {
            this.location.errorT("error in XML file:Group with name " + groupName + " does not exist.Installation info for " + monitorNodeName + " won't be created");
        }
    }

    private void treatMonitor(Element monitor, IMonitorNode parent, Vector monitorAttributeTagNames, Vector monitorAttributeNames) {
        String typeOfMonitor = monitor.getNodeName();
        String monitorNodeName = monitor.getAttribute("name");
        String groupName = monitor.getAttribute("configuration-group");
        Element monitoredResource = (Element)monitor.getElementsByTagName("monitored-resource").item(0);
        String monitoredResourceName = null;
        String monitoredResourceType = null;
        if (monitoredResource != null) {
            monitoredResourceName = monitoredResource.getAttribute("name");
            monitoredResourceType = monitoredResource.getAttribute("type");
        }
        Vector attributeMappings = this.extractAttributeMappingInfos(monitor, monitorAttributeTagNames, monitorAttributeNames);
        if (this.groups.get(groupName) != null) {
            MonitorInstallationInfo info = this.applicationName == null ? new MonitorInstallationInfo(monitorNodeName, parent, (SimpleConfigurationGroup)this.groups.get(groupName), monitoredResourceName, monitoredResourceType, attributeMappings) : new MonitorInstallationInfo(monitorNodeName, parent, (SimpleConfigurationGroup)this.groups.get(groupName), monitoredResourceName, monitoredResourceType, attributeMappings, this.applicationName);
            info.setVolatile(this.isVolatile(monitor));
            this.installMonitorNode(typeOfMonitor, info);
        } else {
            this.location.errorT("error in XML file:Group with name " + groupName + " does not exist.Installation info for " + monitorNodeName + " won't be created");
        }
    }

    private Vector extractAttributeMappingInfos(Element monitor, Vector monitorAttributeTagNames, Vector monitorAttributeNames) {
        Vector<AttributeMappingInfo> attributesMappingInfo = new Vector<AttributeMappingInfo>();
        int j = 0;
        while (j < monitorAttributeTagNames.size()) {
            attributesMappingInfo.add(this.extractAttributeMappingInfo(monitor, (String)monitorAttributeTagNames.get(j), (String)monitorAttributeNames.get(j)));
            ++j;
        }
        return attributesMappingInfo;
    }

    private AttributeMappingInfo extractAttributeMappingInfo(Element monitor, String monitorAttributeTagName, String monitorAttributeName) {
        MBeanCallInfo mBeanCallInfo = this.extractSpecificAttributes(monitor, monitorAttributeTagName);
        return new AttributeMappingInfo(monitorAttributeName, mBeanCallInfo);
    }

    private MBeanCallInfo extractSpecificAttributes(Element monitor, String monitorAttributeTagName) {
        Element attributeMapping = (Element)monitor.getElementsByTagName(monitorAttributeTagName).item(0);
        MBeanCallInfo mBeanCallInfo = null;
        Element atr = (Element)attributeMapping.getElementsByTagName("observed-resource-attribute").item(0);
        if (atr != null) {
            String mBeanAttributeName = atr.getAttribute("name");
            mBeanCallInfo = new MBeanCallInfo(mBeanAttributeName);
        } else {
            atr = (Element)attributeMapping.getElementsByTagName("invoked-resource-method").item(0);
            if (atr != null) {
                String mBeanOperationName = atr.getAttribute("name");
                NodeList parametersList = atr.getElementsByTagName("parameter");
                int numberOfParameters = parametersList.getLength();
                Object[] parameters = new Parameter[numberOfParameters];
                int i = 0;
                while (i < numberOfParameters) {
                    Element parameterElement = (Element)parametersList.item(i);
                    int position = Integer.parseInt(parameterElement.getAttribute("position"));
                    String type = parameterElement.getAttribute("type");
                    String value = parameterElement.getAttribute("value");
                    parameters[i] = new Parameter(position, type, value);
                    ++i;
                }
                mBeanCallInfo = this.convertToMBeanCallInfo(mBeanOperationName, parameters);
            } else {
                atr = (Element)attributeMapping.getElementsByTagName("observed-property-sheet").item(0);
                Element absolutePath = (Element)atr.getElementsByTagName("absolute-path").item(0);
                String propertyPath = null;
                Element properties = (Element)atr.getElementsByTagName("reported-properties").item(0);
                if (absolutePath != null) {
                    propertyPath = absolutePath.getAttribute("path");
                    String[] reportedProps = this.getReportedProperties(properties);
                    mBeanCallInfo = new MBeanCallInfo(MonitorConstants.OPERATION_GET_CONFIGURATION_FOR_PATH, new Object[]{propertyPath, reportedProps}, new String[]{"java.lang.String", (array$Ljava$lang$String == null ? (array$Ljava$lang$String = MonitorInstallationXMLAnalyzer.class$("[Ljava.lang.String;")) : array$Ljava$lang$String).getName()});
                } else {
                    absolutePath = (Element)atr.getElementsByTagName("service-properties").item(0);
                    String serviceName = absolutePath.getAttribute("service-name");
                    String[] reportedProps = this.getReportedProperties(properties);
                    mBeanCallInfo = new MBeanCallInfo(MonitorConstants.OPERATION_GET_CONFIGURATION_FOR_SERVICE_NAME, new Object[]{serviceName, reportedProps}, new String[]{"java.lang.String", (array$Ljava$lang$String == null ? (array$Ljava$lang$String = MonitorInstallationXMLAnalyzer.class$("[Ljava.lang.String;")) : array$Ljava$lang$String).getName()});
                }
            }
        }
        return mBeanCallInfo;
    }

    private String[] getReportedProperties(Element properties) {
        String[] props = null;
        if (properties != null) {
            NodeList parametersList = properties.getElementsByTagName("name");
            int numberOfParameters = parametersList.getLength();
            props = new String[numberOfParameters];
            int i = 0;
            while (i < numberOfParameters) {
                props[i] = parametersList.item(i).getFirstChild().getNodeValue();
                ++i;
            }
        }
        return props;
    }

    private MBeanCallInfo convertToMBeanCallInfo(String mBeanOperationName, Object[] parameters) {
        Arrays.sort(parameters);
        Object[] parametersArray = new Object[parameters.length];
        String[] signaturesArray = new String[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            Parameter parameter = (Parameter)parameters[i];
            String paramType = parameter.getType();
            String paramValue = parameter.getValue();
            try {
                if (paramType.equals("int")) {
                    parametersArray[i] = new Integer(paramValue);
                    signaturesArray[i] = paramType;
                } else if (paramType.equals("String")) {
                    parametersArray[i] = paramValue;
                    signaturesArray[i] = "java.lang.String";
                } else if (paramType.equals("boolean")) {
                    parametersArray[i] = new Boolean(paramValue);
                    signaturesArray[i] = paramType;
                } else if (paramType.equals("char")) {
                    parametersArray[i] = new Character(paramValue.charAt(0));
                    signaturesArray[i] = paramType;
                } else if (paramType.equals("byte")) {
                    parametersArray[i] = new Byte(paramValue);
                    signaturesArray[i] = paramType;
                } else if (paramType.equals("short")) {
                    parametersArray[i] = new Short(paramValue);
                    signaturesArray[i] = paramType;
                } else if (paramType.equals("long")) {
                    parametersArray[i] = new Long(paramValue);
                    signaturesArray[i] = paramType;
                } else if (paramType.equals("float")) {
                    parametersArray[i] = new Float(paramValue);
                    signaturesArray[i] = paramType;
                } else if (paramType.equals("double")) {
                    parametersArray[i] = new Double(paramValue);
                    signaturesArray[i] = paramType;
                }
            }
            catch (NumberFormatException ex) {
                this.location.errorT("error in XML:Parameter value [" + paramValue + "cannot be parsed to type [" + paramType + "], error message: " + ex.getMessage());
            }
            ++i;
        }
        return new MBeanCallInfo(mBeanOperationName, parametersArray, signaturesArray);
    }

    private void installMonitorNode(String typeOfMonitor, MonitorInstallationInfo info) {
        if (typeOfMonitor.equals("text-monitor")) {
            MonitorInstaller.installTextMonitor(info);
        } else if (typeOfMonitor.equals("version-monitor")) {
            MonitorInstaller.installVersionMonitor(info);
        } else if (typeOfMonitor.equals("configuration-monitor")) {
            MonitorInstaller.installConfigurationMonitor(info);
        } else if (typeOfMonitor.equals("availability-monitor")) {
            MonitorInstaller.installAvailabilityMonitor(info);
        } else if (typeOfMonitor.equals("integer-monitor")) {
            MonitorInstaller.installIntegerMonitor(info);
        } else if (typeOfMonitor.equals("long-monitor")) {
            MonitorInstaller.installLongMonitor(info);
        } else if (typeOfMonitor.equals("frequency-monitor")) {
            MonitorInstaller.installFrequencyMonitor(info);
        } else if (typeOfMonitor.equals("quality-rate-monitor")) {
            MonitorInstaller.installQualityRateMonitor(info);
        } else if (typeOfMonitor.equals("duration-monitor")) {
            MonitorInstaller.installDurationMonitor(info);
        } else if (typeOfMonitor.equals("cache-monitor")) {
            MonitorInstaller.installCacheMonitor(info);
        } else if (typeOfMonitor.equals("pool-monitor")) {
            MonitorInstaller.installPoolMonitor(info);
        }
    }

    private TemplateTreeNode treatTemplate(Element element, byte elementType) {
        TemplateTreeNode templateTreeNode = new TemplateTreeNode(elementType);
        switch (elementType) {
            case 1: {
                this.setNameAndSemantics(element, templateTreeNode);
                this.treatTemplateChildren(element, templateTreeNode);
                break;
            }
            case 2: {
                this.setNameAndSemantics(element, templateTreeNode);
                this.treatTemplateChildren(element, templateTreeNode);
                break;
            }
            case 3: {
                this.setNameAndSemantics(element, templateTreeNode);
                this.setMonitoredResource(element, templateTreeNode);
                Vector<TemplateAttributeMappingInfo> attributeMappings = new Vector<TemplateAttributeMappingInfo>();
                String monitorAttributeName = "Text";
                Element domAttribute = (Element)element.getElementsByTagName("text-attribute").item(0);
                TemplateAttributeMappingInfo attributeMappingInfo = this.getAttributeMappingInfo(monitorAttributeName, domAttribute);
                attributeMappings.add(attributeMappingInfo);
                templateTreeNode.setAttributeMappings(attributeMappings);
                break;
            }
            case 4: {
                this.setNameAndSemantics(element, templateTreeNode);
                this.setMonitoredResource(element, templateTreeNode);
                templateTreeNode.setExplicitGreen(element.getAttribute("explicit-green").equals("TRUE"));
                Vector<TemplateAttributeMappingInfo> attributeMappings = new Vector<TemplateAttributeMappingInfo>();
                String monitorAttributeName = "State";
                Element domAttribute = (Element)element.getElementsByTagName("state-attribute").item(0);
                TemplateAttributeMappingInfo attributeMappingInfo = this.getAttributeMappingInfo(monitorAttributeName, domAttribute);
                attributeMappings.add(attributeMappingInfo);
                templateTreeNode.setAttributeMappings(attributeMappings);
                break;
            }
            case 5: {
                this.setNameAndSemantics(element, templateTreeNode);
                this.setMonitoredResource(element, templateTreeNode);
                templateTreeNode.setFileName(element.getAttribute("filename"));
                Vector<TemplateAttributeMappingInfo> attributeMappings = new Vector<TemplateAttributeMappingInfo>();
                String monitorAttributeName = "Entries";
                Element domAttribute = (Element)element.getElementsByTagName("table-entries-attribute").item(0);
                TemplateAttributeMappingInfo attributeMappingInfo = this.getAttributeMappingInfo(monitorAttributeName, domAttribute);
                attributeMappings.add(attributeMappingInfo);
                templateTreeNode.setAttributeMappings(attributeMappings);
                break;
            }
            case 6: {
                this.setNameAndSemantics(element, templateTreeNode);
                this.setMonitoredResource(element, templateTreeNode);
                Vector<TemplateAttributeMappingInfo> attributeMappings = new Vector<TemplateAttributeMappingInfo>();
                String monitorAttributeName = "Version";
                Element domAttribute = (Element)element.getElementsByTagName("version-attribute").item(0);
                TemplateAttributeMappingInfo attributeMappingInfo = this.getAttributeMappingInfo(monitorAttributeName, domAttribute);
                attributeMappings.add(attributeMappingInfo);
                templateTreeNode.setAttributeMappings(attributeMappings);
                break;
            }
            case 7: {
                this.setNameAndSemantics(element, templateTreeNode);
                this.setMonitoredResource(element, templateTreeNode);
                Vector<TemplateAttributeMappingInfo> attributeMappings = new Vector<TemplateAttributeMappingInfo>();
                String monitorAttributeName = "Configuration";
                Element domAttribute = (Element)element.getElementsByTagName("configuration-attribute").item(0);
                TemplateAttributeMappingInfo attributeMappingInfo = this.getAttributeMappingInfo(monitorAttributeName, domAttribute);
                attributeMappings.add(attributeMappingInfo);
                templateTreeNode.setAttributeMappings(attributeMappings);
                break;
            }
            case 8: {
                this.setNameAndSemantics(element, templateTreeNode);
                this.setMonitoredResource(element, templateTreeNode);
                Vector<TemplateAttributeMappingInfo> attributeMappings = new Vector<TemplateAttributeMappingInfo>();
                String monitorAttributeName = "Value";
                Element domAttribute = (Element)element.getElementsByTagName("availability-attribute").item(0);
                TemplateAttributeMappingInfo attributeMappingInfo = this.getAttributeMappingInfo(monitorAttributeName, domAttribute);
                attributeMappings.add(attributeMappingInfo);
                templateTreeNode.setAttributeMappings(attributeMappings);
                break;
            }
            case 9: {
                this.setNameAndSemantics(element, templateTreeNode);
                this.setMonitoredResource(element, templateTreeNode);
                Vector<TemplateAttributeMappingInfo> attributeMappings = new Vector<TemplateAttributeMappingInfo>();
                String monitorAttributeName = "Value";
                Element domAttribute = (Element)element.getElementsByTagName("integer-attribute").item(0);
                TemplateAttributeMappingInfo attributeMappingInfo = this.getAttributeMappingInfo(monitorAttributeName, domAttribute);
                attributeMappings.add(attributeMappingInfo);
                templateTreeNode.setAttributeMappings(attributeMappings);
                break;
            }
            case 10: {
                this.setNameAndSemantics(element, templateTreeNode);
                this.setMonitoredResource(element, templateTreeNode);
                Vector<TemplateAttributeMappingInfo> attributeMappings = new Vector<TemplateAttributeMappingInfo>();
                String monitorAttributeName = "Value";
                Element domAttribute = (Element)element.getElementsByTagName("long-attribute").item(0);
                TemplateAttributeMappingInfo attributeMappingInfo = this.getAttributeMappingInfo(monitorAttributeName, domAttribute);
                attributeMappings.add(attributeMappingInfo);
                templateTreeNode.setAttributeMappings(attributeMappings);
                break;
            }
            case 11: {
                this.setNameAndSemantics(element, templateTreeNode);
                this.setMonitoredResource(element, templateTreeNode);
                Vector<TemplateAttributeMappingInfo> attributeMappings = new Vector<TemplateAttributeMappingInfo>();
                String monitorAttributeName = "ReportedEvents";
                Element domAttribute = (Element)element.getElementsByTagName("reported-events-attribute").item(0);
                TemplateAttributeMappingInfo attributeMappingInfo = this.getAttributeMappingInfo(monitorAttributeName, domAttribute);
                attributeMappings.add(attributeMappingInfo);
                templateTreeNode.setAttributeMappings(attributeMappings);
                break;
            }
            case 12: {
                this.setNameAndSemantics(element, templateTreeNode);
                this.setMonitoredResource(element, templateTreeNode);
                Vector<TemplateAttributeMappingInfo> attributeMappings = new Vector<TemplateAttributeMappingInfo>();
                String monitorAttributeName = "TotalTriesFromStartup";
                Element domAttribute = (Element)element.getElementsByTagName("total-tries-attribute").item(0);
                TemplateAttributeMappingInfo attributeMappingInfo = this.getAttributeMappingInfo(monitorAttributeName, domAttribute);
                attributeMappings.add(attributeMappingInfo);
                monitorAttributeName = "TotalSuccessfulTriesFromStartup";
                domAttribute = (Element)element.getElementsByTagName("total-hits-attribute").item(0);
                attributeMappingInfo = this.getAttributeMappingInfo(monitorAttributeName, domAttribute);
                attributeMappings.add(attributeMappingInfo);
                templateTreeNode.setAttributeMappings(attributeMappings);
                break;
            }
            case 13: {
                this.setNameAndSemantics(element, templateTreeNode);
                this.setMonitoredResource(element, templateTreeNode);
                Vector<TemplateAttributeMappingInfo> attributeMappings = new Vector<TemplateAttributeMappingInfo>();
                String monitorAttributeName = "TotalNumberFromStartup";
                Element domAttribute = (Element)element.getElementsByTagName("total-number-attribute").item(0);
                TemplateAttributeMappingInfo attributeMappingInfo = this.getAttributeMappingInfo(monitorAttributeName, domAttribute);
                attributeMappings.add(attributeMappingInfo);
                monitorAttributeName = "TotalTimeFromStartup";
                domAttribute = (Element)element.getElementsByTagName("total-time-attribute").item(0);
                attributeMappingInfo = this.getAttributeMappingInfo(monitorAttributeName, domAttribute);
                attributeMappings.add(attributeMappingInfo);
                templateTreeNode.setAttributeMappings(attributeMappings);
                break;
            }
        }
        return templateTreeNode;
    }

    private void setNameAndSemantics(Element element, TemplateTreeNode templateTreeNode) {
        templateTreeNode.setName(element.getAttribute("name"));
        templateTreeNode.setGroupName(element.getAttribute("configuration-group"));
    }

    private void setMonitoredResource(Element element, TemplateTreeNode templateTreeNode) {
        Element monitoredResource = (Element)element.getElementsByTagName("monitored-resource").item(0);
        templateTreeNode.setMonitoredResourceName(monitoredResource.getAttribute("name"));
        templateTreeNode.setMonitoredResourceType(monitoredResource.getAttribute("type"));
    }

    private void treatTemplateChildren(Element element, TemplateTreeNode templateTreeNode) {
        NodeList domChildren = element.getChildNodes();
        int i = 0;
        while (i < domChildren.getLength()) {
            Element domElement;
            String domElementName;
            byte domElementType;
            Node domNode = domChildren.item(i);
            if (domNode.getNodeType() == 1 && (domElementType = this.getMappedNodeType(domElementName = (domElement = (Element)domChildren.item(i)).getNodeName())) != -1) {
                TemplateTreeNode childNode = this.treatTemplate(domElement, domElementType);
                childNode.setParent(templateTreeNode);
                templateTreeNode.addChild(childNode);
            }
            ++i;
        }
    }

    private TemplateInstallationInfo getTemplateInstallationInfo(Element element) {
        TemplateInstallationInfo templateInstallationInfo = new TemplateInstallationInfo();
        NodeList dataCollection = element.getElementsByTagName("polled-by-template");
        if (dataCollection.getLength() != 0) {
            templateInstallationInfo.setDataCollectionType((byte)1);
            Period period = this.getPeriod((Element)dataCollection.item(0));
            templateInstallationInfo.setPeriod(period);
            this.setGeneratingResource((Element)((Element)dataCollection.item(0)).getElementsByTagName("generating-resource").item(0), templateInstallationInfo);
            Element templateAttributeMapping = (Element)((Element)dataCollection.item(0)).getElementsByTagName("template-attribute-mapping").item(0);
            MBeanCallInfo mBeanCallInfo = this.getMBeanCallInfo(templateAttributeMapping);
            templateInstallationInfo.setMBeanCallInfo(mBeanCallInfo);
        } else {
            dataCollection = element.getElementsByTagName("pushed-by-resource-via-notification");
            if (dataCollection.getLength() != 0) {
                templateInstallationInfo.setDataCollectionType((byte)2);
                this.setGeneratingResource((Element)((Element)dataCollection.item(0)).getElementsByTagName("generating-resource").item(0), templateInstallationInfo);
                Element templateAttributeMapping = (Element)((Element)dataCollection.item(0)).getElementsByTagName("template-attribute-mapping").item(0);
                if (templateAttributeMapping != null) {
                    MBeanCallInfo mBeanCallInfo = this.getMBeanCallInfo(templateAttributeMapping);
                    templateInstallationInfo.setMBeanCallInfo(mBeanCallInfo);
                }
            } else {
                templateInstallationInfo.setDataCollectionType((byte)3);
            }
        }
        return templateInstallationInfo;
    }

    private TemplateAttributeMappingInfo getAttributeMappingInfo(String monitorAttributeName, Element monitorAttributeElement) {
        TemplateAttributeMappingInfo templateAttributeMappingInfo = null;
        NodeList domAttributeChildren = monitorAttributeElement.getElementsByTagName("observed-resource-attribute");
        if (domAttributeChildren.getLength() != 0) {
            Element domAttributeMapping = (Element)domAttributeChildren.item(0);
            String mBeanAttributeName = domAttributeMapping.getAttribute("name");
            templateAttributeMappingInfo = new TemplateAttributeMappingInfo(monitorAttributeName, mBeanAttributeName);
        } else {
            Element domAttributeMapping = (Element)monitorAttributeElement.getElementsByTagName("invoked-resource-method").item(0);
            String mbeanOperationName = domAttributeMapping.getAttribute("name");
            NodeList domParameters = domAttributeMapping.getElementsByTagName("parameter");
            Parameter[] parameters = new Parameter[domParameters.getLength()];
            int i = 0;
            while (i < domParameters.getLength()) {
                Element domParameter = (Element)domParameters.item(i);
                int position = Integer.parseInt(domParameter.getAttribute("position"));
                String type = domParameter.getAttribute("type");
                String value = domParameter.getAttribute("value");
                parameters[i] = new Parameter(position, type, value);
                ++i;
            }
            templateAttributeMappingInfo = new TemplateAttributeMappingInfo(monitorAttributeName, mbeanOperationName, parameters);
        }
        return templateAttributeMappingInfo;
    }

    private MBeanCallInfo getMBeanCallInfo(Element element) {
        MBeanCallInfo mBeanCallInfo = null;
        NodeList domAttributeChildren = element.getElementsByTagName("observed-resource-attribute");
        if (domAttributeChildren.getLength() != 0) {
            Element domAttributeMapping = (Element)domAttributeChildren.item(0);
            mBeanCallInfo = new MBeanCallInfo(domAttributeMapping.getAttribute("name"));
        } else {
            Element domAttributeMapping = (Element)element.getElementsByTagName("invoked-resource-method").item(0);
            String mbeanOperationName = domAttributeMapping.getAttribute("name");
            NodeList domParameters = domAttributeMapping.getElementsByTagName("parameter");
            Object[] parameters = new Parameter[domParameters.getLength()];
            int i = 0;
            while (i < domParameters.getLength()) {
                Element domParameter = (Element)domParameters.item(i);
                int position = Integer.parseInt(domParameter.getAttribute("position"));
                String type = domParameter.getAttribute("type");
                String value = domParameter.getAttribute("value");
                parameters[i] = new Parameter(position, type, value);
                ++i;
            }
            mBeanCallInfo = this.convertToMBeanCallInfo(mbeanOperationName, parameters);
        }
        return mBeanCallInfo;
    }

    private void setGeneratingResource(Element generatingResourceElement, TemplateInstallationInfo templateInstallationInfo) {
        templateInstallationInfo.setGeneratingResourceName(generatingResourceElement.getAttribute("name"));
        templateInstallationInfo.setGeneratingResourceType(generatingResourceElement.getAttribute("type"));
    }

    private Period getPeriod(Element polledByTemplateElement) {
        int timerPeriod = 0;
        try {
            timerPeriod = Integer.parseInt(polledByTemplateElement.getAttribute("period"));
        }
        catch (NumberFormatException e) {
            this.location.errorT("error in XML file:Period " + polledByTemplateElement.getAttribute("period") + "is not a valid Integer.");
        }
        String timerUnit = polledByTemplateElement.getAttribute("unit");
        int unit = -1;
        if (timerUnit.equals("MINUTE")) {
            unit = 0;
        } else if (timerUnit.equals("HOUR")) {
            unit = 1;
        } else if (timerUnit.equals("DAY")) {
            unit = 2;
        }
        return new Period(timerPeriod, unit);
    }

    protected boolean isTemplate(Element element) {
        NodeList templateInfo = element.getElementsByTagName("template-info");
        return templateInfo.getLength() != 0;
    }

    protected byte getMappedNodeType(String nodeType) {
        if ("summary".equals(nodeType)) {
            return 1;
        }
        if ("object".equals(nodeType)) {
            return 2;
        }
        if ("text-monitor".equals(nodeType)) {
            return 3;
        }
        if ("state-monitor".equals(nodeType)) {
            return 4;
        }
        if ("table-monitor".equals(nodeType)) {
            return 5;
        }
        if ("version-monitor".equals(nodeType)) {
            return 6;
        }
        if ("configuration-monitor".equals(nodeType)) {
            return 7;
        }
        if ("availability-monitor".equals(nodeType)) {
            return 8;
        }
        if ("integer-monitor".equals(nodeType)) {
            return 9;
        }
        if ("long-monitor".equals(nodeType)) {
            return 10;
        }
        if ("frequency-monitor".equals(nodeType)) {
            return 11;
        }
        if ("quality-rate-monitor".equals(nodeType)) {
            return 12;
        }
        if ("duration-monitor".equals(nodeType)) {
            return 13;
        }
        return -1;
    }

    protected boolean isImmediatePredecessor(Node predecessor, Node successor) {
        return successor.getParentNode().equals(predecessor);
    }

    private boolean isVolatile(Element element) {
        String volatility = element.getAttribute("volatile");
        if (volatility == null) {
            return false;
        }
        return volatility.equals("TRUE");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

