/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.common;

import com.sap.engine.services.monitor.config.AvailabilityConfigurationGroup;
import com.sap.engine.services.monitor.config.CacheConfigurationGroup;
import com.sap.engine.services.monitor.config.ConfigConfigurationGroup;
import com.sap.engine.services.monitor.config.DataCollection;
import com.sap.engine.services.monitor.config.Description;
import com.sap.engine.services.monitor.config.DurationConfigurationGroup;
import com.sap.engine.services.monitor.config.FrequencyConfigurationGroup;
import com.sap.engine.services.monitor.config.History;
import com.sap.engine.services.monitor.config.IntegerConfigurationGroup;
import com.sap.engine.services.monitor.config.LongConfigurationGroup;
import com.sap.engine.services.monitor.config.PerformanceAttributeSemantic;
import com.sap.engine.services.monitor.config.Period;
import com.sap.engine.services.monitor.config.PoolConfigurationGroup;
import com.sap.engine.services.monitor.config.QualityRateConfigurationGroup;
import com.sap.engine.services.monitor.config.SimpleConfigurationGroup;
import com.sap.engine.services.monitor.config.StateConfigurationGroup;
import com.sap.engine.services.monitor.config.TableConfigurationGroup;
import com.sap.engine.services.monitor.config.TextConfigurationGroup;
import com.sap.engine.services.monitor.config.Thresholds;
import com.sap.engine.services.monitor.config.VersionConfigurationGroup;
import com.sap.tc.logging.Location;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MonitorGroupXMLAnalyzer {
    static final byte TYPE_DEFAULT = 0;
    static final byte TYPE_INT = 1;
    static final byte TYPE_LONG = 2;
    static final byte TYPE_AVAILABILITY = 3;
    static final byte TYPE_FREQUENCY = 4;
    static final byte TYPE_QUALITY_RATE = 5;
    static final byte TYPE_DURATION = 6;
    Element monitorConfigurationRoot;
    private Location location = Location.getLocation((String)"com.sap.engine.services.monitor.common.MonitorGroupXMLAnalyzer");

    public MonitorGroupXMLAnalyzer(Element monitorConfigurationRoot) {
        this.monitorConfigurationRoot = monitorConfigurationRoot;
    }

    public Vector getMonitorGroups(String owner) {
        Vector monitorGroups = new Vector();
        this.addSpecificMonitorGroup(monitorGroups, "simple-configuration-group", owner);
        this.addSpecificMonitorGroup(monitorGroups, "table-configuration-group", owner);
        this.addSpecificMonitorGroup(monitorGroups, "state-configuration-group", owner);
        this.addSpecificMonitorGroup(monitorGroups, "text-configuration-group", owner);
        this.addSpecificMonitorGroup(monitorGroups, "version-configuration-group", owner);
        this.addSpecificMonitorGroup(monitorGroups, "config-configuration-group", owner);
        this.addSpecificMonitorGroup(monitorGroups, "availability-configuration-group", owner);
        this.addSpecificMonitorGroup(monitorGroups, "integer-configuration-group", owner);
        this.addSpecificMonitorGroup(monitorGroups, "frequency-configuration-group", owner);
        this.addSpecificMonitorGroup(monitorGroups, "quality-rate-configuration-group", owner);
        this.addSpecificMonitorGroup(monitorGroups, "duration-configuration-group", owner);
        this.addSpecificMonitorGroup(monitorGroups, "cache-configuration-group", owner);
        this.addSpecificMonitorGroup(monitorGroups, "pool-configuration-group", owner);
        this.addSpecificMonitorGroup(monitorGroups, "long-configuration-group", owner);
        return monitorGroups;
    }

    public SimpleConfigurationGroup extractMonitorGroupInfo(Element group, String owner) {
        SimpleConfigurationGroup groupInfo = null;
        String groupType = group.getNodeName();
        String groupName = group.getAttribute("name");
        if (groupName.length() > 40) {
            this.location.warningT("error in XML file -> Group name:[" + groupName + " ]is more than 40 characters and won't be sent to CCMS.");
        }
        if (groupType.equals("simple-configuration-group")) {
            groupInfo = this.createSimpleConfigurationGroup(groupName, group, owner);
        } else if (groupType.equals("text-configuration-group")) {
            groupInfo = this.createTextConfigurationGroup(groupName, group, owner);
        } else if (groupType.equals("state-configuration-group")) {
            groupInfo = this.createStateConfigurationGroup(groupName, group, owner);
        } else if (groupType.equals("table-configuration-group")) {
            groupInfo = this.createTableConfigurationGroup(groupName, group, owner);
        } else if (groupType.equals("version-configuration-group")) {
            groupInfo = this.createVersionConfigurationGroup(groupName, group, owner);
        } else if (groupType.equals("config-configuration-group")) {
            groupInfo = this.createConfigConfigurationGroup(groupName, group, owner);
        } else if (groupType.equals("availability-configuration-group")) {
            groupInfo = this.createAvailabilityConfigurationGroup(groupName, group, owner);
        } else if (groupType.equals("integer-configuration-group")) {
            groupInfo = this.createIntegerConfigurationGroup(groupName, group, owner);
        } else if (groupType.equals("frequency-configuration-group")) {
            groupInfo = this.createFrequencyConfigurationGroup(groupName, group, owner);
        } else if (groupType.equals("quality-rate-configuration-group")) {
            groupInfo = this.createQualityRateConfigurationGroup(groupName, group, owner);
        } else if (groupType.equals("duration-configuration-group")) {
            groupInfo = this.createDurationConfigurationGroup(groupName, group, owner);
        } else if (groupType.equals("cache-configuration-group")) {
            groupInfo = this.createCacheConfigurationGroup(groupName, group, owner);
        } else if (groupType.equals("pool-configuration-group")) {
            groupInfo = this.createPoolConfigurationGroup(groupName, group, owner);
        } else if (groupType.equals("long-configuration-group")) {
            groupInfo = this.createLongConfigurationGroup(groupName, group, owner);
        } else {
            this.location.errorT("error in XML file ->No such group type:" + groupInfo);
        }
        return groupInfo;
    }

    private void addSpecificMonitorGroup(Vector monitorGroups, String tagForGroup, String owner) {
        NodeList groupList = this.monitorConfigurationRoot.getElementsByTagName(tagForGroup);
        SimpleConfigurationGroup monitorGroup = null;
        int i = 0;
        while (i < groupList.getLength()) {
            Element monitor = (Element)groupList.item(i);
            monitorGroup = this.extractMonitorGroupInfo(monitor, owner);
            monitorGroups.add(monitorGroup);
            ++i;
        }
    }

    private SimpleConfigurationGroup createSimpleConfigurationGroup(String globalGroupName, Element group, String owner) {
        Description description = this.extractDescription(group);
        return new SimpleConfigurationGroup(globalGroupName, description, owner, false);
    }

    private TextConfigurationGroup createTextConfigurationGroup(String globalGroupName, Element group, String owner) {
        Description description = this.extractDescription(group);
        DataCollection dataCollection = this.extractDataCollection(group);
        return new TextConfigurationGroup(globalGroupName, description, dataCollection, owner, false);
    }

    private StateConfigurationGroup createStateConfigurationGroup(String globalGroupName, Element group, String owner) {
        Description description = this.extractDescription(group);
        DataCollection dataCollection = this.extractDataCollection(group);
        String[] greenStates = this.extractStates(group, "green-states");
        String[] yellowStates = this.extractStates(group, "yellow-states");
        String[] redStates = this.extractStates(group, "red-states");
        int alertMode = this.extractAlertMode(group);
        return new StateConfigurationGroup(globalGroupName, description, dataCollection, greenStates, yellowStates, redStates, alertMode, owner, false);
    }

    private TableConfigurationGroup createTableConfigurationGroup(String globalGroupName, Element group, String owner) {
        Description description = this.extractDescription(group);
        DataCollection dataCollection = this.extractDataCollection(group);
        NodeList columnNodes = group.getElementsByTagName("column");
        Vector<String> columns = new Vector<String>();
        int i = 0;
        while (i < columnNodes.getLength()) {
            columns.add(columnNodes.item(i).getFirstChild().getNodeValue());
            ++i;
        }
        return new TableConfigurationGroup(globalGroupName, description, dataCollection, columns, owner, false);
    }

    private ConfigConfigurationGroup createConfigConfigurationGroup(String globalGroupName, Element group, String owner) {
        Description description = this.extractDescription(group);
        DataCollection dataCollection = this.extractDataCollection(group);
        return new ConfigConfigurationGroup(globalGroupName, description, dataCollection, owner, false);
    }

    private VersionConfigurationGroup createVersionConfigurationGroup(String globalGroupName, Element group, String owner) {
        Description description = this.extractDescription(group);
        DataCollection dataCollection = this.extractDataCollection(group);
        return new VersionConfigurationGroup(globalGroupName, description, dataCollection, owner, false);
    }

    private AvailabilityConfigurationGroup createAvailabilityConfigurationGroup(String globalGroupName, Element group, String owner) {
        Description description = this.extractDescription(group);
        DataCollection dataCollection = this.extractDataCollection(group);
        Thresholds thresholds = this.extractThresholds(group, (byte)3);
        History history = this.extractHistory(group);
        String unit = group.getAttribute("unit");
        int alertRelevantValueType = this.extractAlertRelevantType(group);
        return new AvailabilityConfigurationGroup(globalGroupName, description, dataCollection, thresholds, history, unit, alertRelevantValueType, owner, false);
    }

    private IntegerConfigurationGroup createIntegerConfigurationGroup(String globalGroupName, Element group, String owner) {
        Description description = this.extractDescription(group);
        DataCollection dataCollection = this.extractDataCollection(group);
        Thresholds thresholds = this.extractThresholds(group, (byte)1);
        History history = this.extractHistory(group);
        String unit = group.getAttribute("unit");
        int alertRelevantValueType = this.extractAlertRelevantType(group);
        return new IntegerConfigurationGroup(globalGroupName, description, dataCollection, thresholds, history, unit, alertRelevantValueType, owner, false);
    }

    private FrequencyConfigurationGroup createFrequencyConfigurationGroup(String globalGroupName, Element group, String owner) {
        Description description = this.extractDescription(group);
        DataCollection dataCollection = this.extractDataCollection(group);
        Thresholds thresholds = this.extractThresholds(group, (byte)4);
        History history = this.extractHistory(group);
        String unit = group.getAttribute("unit");
        int alertRelevantValueType = this.extractAlertRelevantType(group);
        return new FrequencyConfigurationGroup(globalGroupName, description, dataCollection, thresholds, history, unit, alertRelevantValueType, owner, false);
    }

    private QualityRateConfigurationGroup createQualityRateConfigurationGroup(String globalGroupName, Element group, String owner) {
        Description description = this.extractDescription(group);
        DataCollection dataCollection = this.extractDataCollection(group);
        Thresholds thresholds = this.extractThresholds(group, (byte)5);
        History history = this.extractHistory(group);
        String unit = group.getAttribute("unit");
        int alertRelevantValueType = this.extractAlertRelevantType(group);
        return new QualityRateConfigurationGroup(globalGroupName, description, dataCollection, thresholds, history, unit, alertRelevantValueType, owner, false);
    }

    private DurationConfigurationGroup createDurationConfigurationGroup(String globalGroupName, Element group, String owner) {
        Description description = this.extractDescription(group);
        DataCollection dataCollection = this.extractDataCollection(group);
        Thresholds thresholds = this.extractThresholds(group, (byte)6);
        History history = this.extractHistory(group);
        String unit = group.getAttribute("unit");
        int alertRelevantValueType = this.extractAlertRelevantType(group);
        return new DurationConfigurationGroup(globalGroupName, description, dataCollection, thresholds, history, unit, alertRelevantValueType, owner, false);
    }

    private CacheConfigurationGroup createCacheConfigurationGroup(String globalGroupName, Element group, String owner) {
        Description description = this.extractDescription(group);
        DataCollection dataCollection = this.extractDataCollection(group);
        PerformanceAttributeSemantic currentUsageSemantic = this.extractPerformanceAttrSemantic(group, "current-usage-semantics");
        PerformanceAttributeSemantic maxSizeSemantic = this.extractPerformanceAttrSemantic(group, "max-size-semantics");
        return new CacheConfigurationGroup(globalGroupName, description, dataCollection, currentUsageSemantic, maxSizeSemantic, owner, false);
    }

    private PoolConfigurationGroup createPoolConfigurationGroup(String globalGroupName, Element group, String owner) {
        Description description = this.extractDescription(group);
        DataCollection dataCollection = this.extractDataCollection(group);
        PerformanceAttributeSemantic currentSizeSemantic = this.extractPerformanceAttrSemantic(group, "current-size-semantics");
        PerformanceAttributeSemantic currentUsageSemantic = this.extractPerformanceAttrSemantic(group, "current-usage-semantics");
        PerformanceAttributeSemantic initialSizeSemantic = this.extractPerformanceAttrSemantic(group, "initial-size-semantics");
        PerformanceAttributeSemantic minSizeSemantic = this.extractPerformanceAttrSemantic(group, "min-size-semantics");
        PerformanceAttributeSemantic maxSizeSemantic = this.extractPerformanceAttrSemantic(group, "max-size-semantics");
        PerformanceAttributeSemantic incrementStepSemantic = this.extractPerformanceAttrSemantic(group, "increment-step-semantics");
        return new PoolConfigurationGroup(globalGroupName, description, dataCollection, currentSizeSemantic, currentUsageSemantic, initialSizeSemantic, minSizeSemantic, maxSizeSemantic, incrementStepSemantic, owner, false);
    }

    private LongConfigurationGroup createLongConfigurationGroup(String globalGroupName, Element group, String owner) {
        Description description = this.extractDescription(group);
        DataCollection dataCollection = this.extractDataCollection(group);
        Thresholds thresholds = this.extractThresholds(group, (byte)2);
        History history = this.extractHistory(group);
        String unit = group.getAttribute("unit");
        int alertRelevantValueType = this.extractAlertRelevantType(group);
        return new LongConfigurationGroup(globalGroupName, description, dataCollection, thresholds, history, unit, alertRelevantValueType, owner, false);
    }

    private PerformanceAttributeSemantic extractPerformanceAttrSemantic(Element group, String semanticNameTag) {
        Element semantic = (Element)group.getElementsByTagName(semanticNameTag).item(0);
        String attributeName = "";
        Description attributeDescription = this.extractDescription(semantic);
        Thresholds thresholds = this.extractThresholds(semantic, (byte)0);
        History history = this.extractHistory(semantic);
        String unit = semantic.getAttribute("unit");
        int alertRelevantValueType = this.extractAlertRelevantType(semantic);
        return new PerformanceAttributeSemantic(attributeName, attributeDescription, thresholds, history, unit, alertRelevantValueType);
    }

    private History extractHistory(Element group) {
        String averagingMode;
        Element hist = (Element)group.getElementsByTagName("history").item(0);
        History history = hist != null ? ((averagingMode = hist.getAttribute("averaging-mode")).equals("TIME_WEIGHTED") ? new History(1) : (averagingMode.equals("ARITHMETICALLY") ? new History(0) : new History(1))) : (group.getTagName().equals("quality-rate-configuration-group") || group.getTagName().equals("duration-configuration-group") ? new History(0) : new History(1));
        return history;
    }

    private Description extractDescription(Element group) {
        String descriptionID;
        Element descriptionElement = (Element)group.getElementsByTagName("description").item(0);
        Node descriptionNode = descriptionElement.getFirstChild();
        String descriptionTxt = "";
        if (descriptionNode != null) {
            descriptionTxt = descriptionNode.getNodeValue();
        }
        if ((descriptionID = descriptionElement.getAttribute("ID")).length() > 30) {
            this.location.warningT("error in XML file -> Description ID:[" + descriptionID + " ]is more than 30 characters and won't be sent to CCMS.");
        }
        Description description = new Description(descriptionID, descriptionTxt);
        return description;
    }

    private DataCollection extractDataCollection(Element group) {
        Element dataCollection = (Element)group.getElementsByTagName("data-collection").item(0);
        String reactOnCollectionFailure = dataCollection.getAttribute("react-on-failure");
        Element dataCollectionTag = (Element)dataCollection.getElementsByTagName("polled-by-monitor").item(0);
        int dataCollectionTypeInt = -1;
        Period period = null;
        if (dataCollectionTag != null) {
            dataCollectionTypeInt = DataCollection.POLLED_BY_MONITOR;
            period = this.extractPeriod(dataCollection);
        } else {
            dataCollectionTag = (Element)dataCollection.getElementsByTagName("pushed-by-resource").item(0);
            dataCollectionTypeInt = DataCollection.PUSHED_BY_RESOURCE;
        }
        int reactOnFailure = -1;
        if (reactOnCollectionFailure.equals("UNREGISTER_MONITOR")) {
            reactOnFailure = 3;
        } else if (reactOnCollectionFailure.equals("IGNORE")) {
            reactOnFailure = 4;
        }
        DataCollection data = new DataCollection(dataCollectionTypeInt, period, reactOnFailure);
        return data;
    }

    private Period extractPeriod(Element dataCollection) {
        Element periodically = (Element)dataCollection.getElementsByTagName("polled-by-monitor").item(0);
        int timerPeriod = Integer.parseInt(periodically.getAttribute("period"));
        String timerUnit = periodically.getAttribute("unit");
        int unit = -1;
        if (timerUnit.equals("MINUTE")) {
            unit = 0;
        } else if (timerUnit.equals("HOUR")) {
            unit = 1;
        } else if (timerUnit.equals("DAY")) {
            unit = 2;
        }
        return new Period(timerPeriod, unit);
    }

    private String[] extractStates(Element group, String colorStateTag) {
        Element colorState = (Element)group.getElementsByTagName(colorStateTag).item(0);
        if (colorState == null) {
            return null;
        }
        NodeList stateList = colorState.getElementsByTagName("state");
        String[] states = new String[stateList.getLength()];
        int i = 0;
        while (i < states.length) {
            states[i] = stateList.item(i).getFirstChild().getNodeValue();
            ++i;
        }
        return states;
    }

    private int extractAlertMode(Element group) {
        String alertModeTxt = group.getAttribute("alert-mode");
        int alertMode = 1;
        if (alertModeTxt.equals("NEVER")) {
            alertMode = 4;
        } else if (alertModeTxt.equals("ON_STATE_COLOR_CHANGE")) {
            alertMode = 2;
        } else if (alertModeTxt.equals("ON_STATE_TEXT_CHANGE")) {
            alertMode = 3;
        }
        return alertMode;
    }

    private Thresholds extractThresholds(Element group, byte type) {
        Element thresholdsElement = (Element)group.getElementsByTagName("thresholds").item(0);
        int greenToYellow = this.extractThresholdValueG2Y(thresholdsElement, type);
        int yellowToRed = this.extractThresholdValueY2R(thresholdsElement, type);
        int redToYellow = this.extractThresholdValueR3Y(thresholdsElement, type);
        int yellowToGreen = this.extractThresholdValueY2G(thresholdsElement, type);
        return new Thresholds(greenToYellow, yellowToRed, redToYellow, yellowToGreen);
    }

    private int extractThresholdValueG2Y(Element thresholdsElement, byte type) {
        String valueStr = thresholdsElement.getAttribute("green-to-yellow");
        int value = 0;
        if (valueStr == null || valueStr.trim().equals("")) {
            value = this.getValue(valueStr, type) - 1;
        } else {
            try {
                value = Integer.parseInt(valueStr);
            }
            catch (NumberFormatException nEx) {
                this.location.errorT("error in XML file:Value for threshold must be integer, not [" + valueStr + "]");
            }
        }
        return value;
    }

    private int extractThresholdValueY2R(Element thresholdsElement, byte type) {
        String valueStr = thresholdsElement.getAttribute("yellow-to-red");
        int value = 0;
        if (valueStr == null || valueStr.trim().equals("")) {
            value = this.getValue(valueStr, type);
        } else {
            try {
                value = Integer.parseInt(valueStr);
            }
            catch (NumberFormatException nEx) {
                this.location.errorT("error in XML file:Value for threshold must be integer, not [" + valueStr + "]");
            }
        }
        return value;
    }

    private int extractThresholdValueR3Y(Element thresholdsElement, byte type) {
        String valueStr = thresholdsElement.getAttribute("red-to-yellow");
        int value = 0;
        if (valueStr == null || valueStr.trim().equals("")) {
            value = this.getValue(valueStr, type);
        } else {
            try {
                value = Integer.parseInt(valueStr);
            }
            catch (NumberFormatException nEx) {
                this.location.errorT("error in XML file:Value for threshold must be integer, not [" + valueStr + "]");
            }
        }
        return value;
    }

    private int extractThresholdValueY2G(Element thresholdsElement, byte type) {
        String valueStr = thresholdsElement.getAttribute("yellow-to-green");
        int value = 0;
        if (valueStr == null || valueStr.trim().equals("")) {
            value = this.getValue(valueStr, type) - 1;
        } else {
            try {
                value = Integer.parseInt(valueStr);
            }
            catch (NumberFormatException nEx) {
                this.location.errorT("error in XML file:Value for threshold must be integer, not [" + valueStr + "]");
            }
        }
        return value;
    }

    private int getValue(String valueStr, byte type) {
        switch (type) {
            case 1: {
                return Integer.MAX_VALUE;
            }
            case 2: {
                return Integer.MAX_VALUE;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 100;
            }
            case 6: {
                return 0;
            }
            case 0: {
                return 0;
            }
        }
        return 0;
    }

    private int extractAlertRelevantType(Element group) {
        String alertRelevantTypeStr = group.getAttribute("alert-relevant-value-type");
        int alertRelevantType = 1;
        if (alertRelevantTypeStr.equals("DISCRETE_HOUR")) {
            alertRelevantType = 3;
        } else if (alertRelevantTypeStr.equals("DISCRETE_QUARTER")) {
            alertRelevantType = 2;
        } else if (alertRelevantTypeStr.equals("DISCRETE_MINUTE")) {
            alertRelevantType = 4;
        } else if (alertRelevantTypeStr.equals("SLIDING_WINDOW_5_MINUTES")) {
            alertRelevantType = 5;
        } else if (alertRelevantTypeStr.equals("SLIDING_WINDOW_QUARTER")) {
            alertRelevantType = 6;
        }
        return alertRelevantType;
    }
}

