/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.common;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.engine.services.monitor.Util;
import com.sap.engine.services.monitor.common.MonitorServiceRuntime;
import com.sap.engine.services.monitor.config.AvailabilityConfigurationGroup;
import com.sap.engine.services.monitor.config.ConfigConfigurationGroup;
import com.sap.engine.services.monitor.config.DataCollection;
import com.sap.engine.services.monitor.config.Description;
import com.sap.engine.services.monitor.config.DurationConfigurationGroup;
import com.sap.engine.services.monitor.config.FrequencyConfigurationGroup;
import com.sap.engine.services.monitor.config.History;
import com.sap.engine.services.monitor.config.IntegerConfigurationGroup;
import com.sap.engine.services.monitor.config.LongConfigurationGroup;
import com.sap.engine.services.monitor.config.MonitorConfigurationGroup;
import com.sap.engine.services.monitor.config.PerformanceMonitorConfigurationGroup;
import com.sap.engine.services.monitor.config.Period;
import com.sap.engine.services.monitor.config.QualityRateConfigurationGroup;
import com.sap.engine.services.monitor.config.SimpleConfigurationGroup;
import com.sap.engine.services.monitor.config.StateConfigurationGroup;
import com.sap.engine.services.monitor.config.TableConfigurationGroup;
import com.sap.engine.services.monitor.config.TextConfigurationGroup;
import com.sap.engine.services.monitor.config.Thresholds;
import com.sap.engine.services.monitor.config.VersionConfigurationGroup;
import com.sap.tc.logging.Location;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class MonitorConfigurationHandler {
    public static final String SIMPLE_GROUP = "Simple configuration group";
    public static final String TEXT_MONITOR_GROUP = "Text configuration group";
    public static final String STATE_MONITOR_GROUP = "State configuration group";
    public static final String TABLE_MONITOR_GROUP = "Table configuration group";
    public static final String VERSION_MONITOR_GROUP = "Version configuration group";
    public static final String CONFIGURATION_MONITOR_GROUP = "Config list configuration group";
    public static final String AVAILABILITY_MONITOR_GROUP = "Availability configuration group";
    public static final String INTEGER_MONITOR_GROUP = "Integer configuration group";
    public static final String LONG_MONITOR_GROUP = "Long configuration group";
    public static final String FREQUENCY_MONITOR_GROUP = "Frequency configuration group";
    public static final String QUALITY_RATE_MONITOR_GROUP = "Quality configuration group";
    public static final String DURATION_MONITOR_GROUP = "Duration configuration group";
    public static final String CACHE_MONITOR_GROUP = "Cache configuration group";
    public static final String POOL_MONITOR_GROUP = "Pool configuration group";
    private static final String PROPERTY_TYPE = "group type";
    private static final String PROPERTY_GROUP_OWNER = "group owner";
    private static final String PROPERTY_DESCRIPTION_ID = "description id";
    private static final String PROPERTY_DESCRIPTION_TEXT = "description text";
    private static final String PROPERTY_DATA_COLLECTION_TYPE = "data collection type";
    private static final String PROPERTY_COLLECT_PERIOD_VALUE = "data collect period value";
    private static final String PROPERTY_COLLECT_PERIOD_UNIT = "data collect period unit";
    private static final String PROPERTY_REACT_ON_COLLECTION_FAILURE = "react on collection failure";
    private static final String PROPERTY_THRESH_GREEN_TO_YELLOW = "threshold green to yellow";
    private static final String PROPERTY_THRESH_YELLOW_TO_RED = "threshold yellow to red";
    private static final String PROPERTY_THRESH_RED_TO_YELLOW = "threshold red to yellow";
    private static final String PROPERTY_THRESH_YELLOW_TO_GREEN = "threshold yellow to green";
    private static final String PROPERTY_DATA_UNIT = "data unit";
    private static final String PROPERTY_ALERT_RELEVANT_VALUE_TYPE = "alert relevant value type";
    private static final String PROPERTY_HISTORY_AVERAGING_MODE = "history averaging mode";
    private static final String PROPERTY_AUTO_REACTION_METHOD = "auto reaction method";
    private static final String PROPERTY_ANALISYS_METHOD = "analysis method";
    private static final String PROPERTY_GREEN_STATES = "green states";
    private static final String PROPERTY_YELLOW_STATES = "yellow states";
    private static final String PROPERTY_RED_STATES = "red states";
    private static final String PROPERTY_ALERT_MODE = "alert mode";
    private static final String PROPERTY_TABLE_COLUMNS = "column names";
    private ConfigurationHandler configurationHandler;
    private static String MONITORING_ROOT_NAME = "monitoring";
    private static String MONITOR_SEMANTICS_NAME = "monitor semantics";
    public static String MONITOR_SEMANTICS_PATH = "monitoring/monitor semantics";
    private static String SLASH = "/";
    private static boolean IS_PERSISTANT = true;
    Location location = Location.getLocation((String)"com.sap.engine.services.monitor.common.MonitorConfigurationHandler");

    public void setMonitorConfigurationHandler(ConfigurationHandler configHandler) {
        this.location.infoT("Create MonitorConfigurationHandler.");
        this.configurationHandler = configHandler;
        try {
            String[] rootNames = this.configurationHandler.getAllRootNames();
            int i = 0;
            while (i < rootNames.length) {
                if (MONITORING_ROOT_NAME.equals(rootNames[i])) {
                    this.location.infoT(" \"monitoring\" configuration root exists ");
                    return;
                }
                ++i;
            }
            this.location.infoT("Start creating  \"monitoring\" configuration root....");
            Configuration monitorRoot = this.configurationHandler.createRootConfiguration(MONITORING_ROOT_NAME);
            monitorRoot.createSubConfiguration(MONITOR_SEMANTICS_NAME);
            this.configurationHandler.commit();
            this.location.infoT("Creating of \"monitoring\" configuration root and monitor semantics node finished succesfully.");
        }
        catch (ConfigurationException e) {
            this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e)));
        }
        try {
            this.configurationHandler.closeAllConfigurations();
        }
        catch (ConfigurationException e) {
            this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e)));
        }
    }

    public void customizeGroup(SimpleConfigurationGroup group) {
        if (group instanceof LongConfigurationGroup) {
            this.location.infoT("Start to customize a Long configuration group with name [" + group.getGlobalConfigurationGroupName() + "] in the data base");
            this.customizePerformanceGroup((LongConfigurationGroup)group, LONG_MONITOR_GROUP);
        } else if (group instanceof IntegerConfigurationGroup) {
            this.location.infoT("Start to customize a Integer configuration group with name [" + group.getGlobalConfigurationGroupName() + "] in the data base");
            this.customizePerformanceGroup((IntegerConfigurationGroup)group, INTEGER_MONITOR_GROUP);
        } else if (group instanceof FrequencyConfigurationGroup) {
            this.location.infoT("Start to customize a Frequency configuration group with name [" + group.getGlobalConfigurationGroupName() + "] in the data base");
            this.customizePerformanceGroup((FrequencyConfigurationGroup)group, FREQUENCY_MONITOR_GROUP);
        } else if (group instanceof DurationConfigurationGroup) {
            this.location.infoT("Start to customize a Duration configuration group with name [" + group.getGlobalConfigurationGroupName() + "] in the data base");
            this.customizePerformanceGroup((DurationConfigurationGroup)group, DURATION_MONITOR_GROUP);
        } else if (group instanceof QualityRateConfigurationGroup) {
            this.location.infoT("Start to customize a Quality configuration group with name [" + group.getGlobalConfigurationGroupName() + "] in the data base");
            this.customizePerformanceGroup((QualityRateConfigurationGroup)group, QUALITY_RATE_MONITOR_GROUP);
        } else if (group instanceof AvailabilityConfigurationGroup) {
            this.location.infoT("Start to customize a Availability configuration group with name [" + group.getGlobalConfigurationGroupName() + "] in the data base");
            this.customizePerformanceGroup((AvailabilityConfigurationGroup)group, AVAILABILITY_MONITOR_GROUP);
        } else if (group instanceof VersionConfigurationGroup) {
            this.location.infoT("Start to customize a Version configuration group with name [" + group.getGlobalConfigurationGroupName() + "] in the data base");
            this.customizeMonitorGroup((VersionConfigurationGroup)group, VERSION_MONITOR_GROUP);
        } else if (group instanceof ConfigConfigurationGroup) {
            this.location.infoT("Start to customize a Config list configuration group with name [" + group.getGlobalConfigurationGroupName() + "] in the data base");
            this.customizeMonitorGroup((ConfigConfigurationGroup)group, CONFIGURATION_MONITOR_GROUP);
        } else if (group instanceof TextConfigurationGroup) {
            this.location.infoT("Start to customize a Text configuration group with name [" + group.getGlobalConfigurationGroupName() + "] in the data base");
            this.customizeMonitorGroup((TextConfigurationGroup)group, TEXT_MONITOR_GROUP);
        } else if (group instanceof StateConfigurationGroup) {
            this.location.infoT("Start to customize a State configuration group with name [" + group.getGlobalConfigurationGroupName() + "] in the data base");
            this.customizeStateGroup((StateConfigurationGroup)group);
        } else if (group instanceof TableConfigurationGroup) {
            this.location.infoT("Start to customize a Table configuration group with name [" + group.getGlobalConfigurationGroupName() + "] in the data base");
            this.customizeTableMonitorGroup((TableConfigurationGroup)group);
        } else if (group instanceof SimpleConfigurationGroup) {
            this.location.infoT("Start to customize a Simple configuration group with name [" + group.getGlobalConfigurationGroupName() + "] in the data base");
            this.customizeSimpleGroup(group);
        }
    }

    public void replaceOldWithNewGroup(SimpleConfigurationGroup group) {
        if (group != null) {
            try {
                MonitorServiceRuntime.deleteConfigurationGroup(group.getGlobalConfigurationGroupName());
            }
            catch (Exception e) {
                this.location.errorT("Cannot delete the group [" + group.getGlobalConfigurationGroupName() + "] from the memmory persistance");
                this.location.errorT(Util.getStackTraceAsString(e));
            }
            try {
                MonitorServiceRuntime.addToAllGroups(group);
            }
            catch (Exception e) {
                this.location.errorT("Cannot add group[" + group.getGlobalConfigurationGroupName() + "] to the memory persitance.Group is already saved in DB. ");
                this.location.errorT(Util.getStackTraceAsString(e));
            }
        } else {
            this.location.warningT("Cannot replace group, which is null");
        }
    }

    public void deleteGroupFromMemmory(SimpleConfigurationGroup group) {
        try {
            MonitorServiceRuntime.deleteConfigurationGroup(group.getGlobalConfigurationGroupName());
        }
        catch (Exception e) {
            this.location.errorT("Cannot delete the group [" + group.getGlobalConfigurationGroupName() + "] from the memmory persistance");
            this.location.errorT(Util.getStackTraceAsString(e));
        }
    }

    /*
     * Loose catch block
     */
    public void customizePerformanceGroup(PerformanceMonitorConfigurationGroup group, String type) {
        block12: {
            String groupName = group.getGlobalConfigurationGroupName();
            Configuration groupConfiguration = null;
            try {
                groupConfiguration = this.configurationHandler.openConfiguration(MONITOR_SEMANTICS_PATH + SLASH + groupName, 1);
                PropertySheet props = groupConfiguration.getPropertySheetInterface();
                props.getPropertyEntry(PROPERTY_DESCRIPTION_TEXT).setValue((Object)group.getDescription().getText());
                props.getPropertyEntry(PROPERTY_AUTO_REACTION_METHOD).setValue((Object)group.getAutoreactionMethod());
                props.getPropertyEntry(PROPERTY_ANALISYS_METHOD).setValue((Object)group.getAnalysisMethod());
                props.getPropertyEntry(PROPERTY_REACT_ON_COLLECTION_FAILURE).setValue((Object)(group.getDataCollection().getReactOnCollectionFailure() + ""));
                if (group.getDataCollection().getDataCollectionType() == DataCollection.POLLED_BY_MONITOR) {
                    props.getPropertyEntry(PROPERTY_COLLECT_PERIOD_VALUE).setValue((Object)(group.getDataCollection().getCollectPeriod().getValue() + ""));
                    props.getPropertyEntry(PROPERTY_COLLECT_PERIOD_UNIT).setValue((Object)(group.getDataCollection().getCollectPeriod().getUnit() + ""));
                }
                props.getPropertyEntry(PROPERTY_THRESH_GREEN_TO_YELLOW).setValue((Object)(group.getThresholds().getGreen2Yellow() + ""));
                props.getPropertyEntry(PROPERTY_THRESH_YELLOW_TO_RED).setValue((Object)(group.getThresholds().getYellow2Red() + ""));
                props.getPropertyEntry(PROPERTY_THRESH_RED_TO_YELLOW).setValue((Object)(group.getThresholds().getYellow2Red() + ""));
                props.getPropertyEntry(PROPERTY_THRESH_YELLOW_TO_GREEN).setValue((Object)(group.getThresholds().getYellow2Green() + ""));
                props.getPropertyEntry(PROPERTY_ALERT_RELEVANT_VALUE_TYPE).setValue((Object)(group.getAlertRelevantValueType() + ""));
            }
            catch (NameNotFoundException a) {
                Configuration monitorSemanticConfiguration = this.configurationHandler.openConfiguration(MONITOR_SEMANTICS_PATH, 1);
                groupConfiguration = monitorSemanticConfiguration.createSubConfiguration(groupName, 1);
                PropertySheet props = groupConfiguration.getPropertySheetInterface();
                props.createPropertyEntry(PROPERTY_TYPE, (Object)type, null);
                props.createPropertyEntry(PROPERTY_GROUP_OWNER, (Object)group.getGroupOwner(), null);
                props.createPropertyEntry(PROPERTY_DESCRIPTION_ID, (Object)group.getDescription().getID(), null);
                props.createPropertyEntry(PROPERTY_DESCRIPTION_TEXT, (Object)group.getDescription().getText(), null);
                props.createPropertyEntry(PROPERTY_AUTO_REACTION_METHOD, (Object)group.getAutoreactionMethod(), null);
                props.createPropertyEntry(PROPERTY_ANALISYS_METHOD, (Object)group.getAnalysisMethod(), null);
                int dataCollectionType = group.getDataCollection().getDataCollectionType();
                props.createPropertyEntry(PROPERTY_DATA_COLLECTION_TYPE, (Object)(dataCollectionType + ""), null);
                props.createPropertyEntry(PROPERTY_REACT_ON_COLLECTION_FAILURE, (Object)(group.getDataCollection().getReactOnCollectionFailure() + ""), null);
                if (dataCollectionType == DataCollection.POLLED_BY_MONITOR) {
                    props.createPropertyEntry(PROPERTY_COLLECT_PERIOD_VALUE, (Object)(group.getDataCollection().getCollectPeriod().getValue() + ""), null);
                    props.createPropertyEntry(PROPERTY_COLLECT_PERIOD_UNIT, (Object)(group.getDataCollection().getCollectPeriod().getUnit() + ""), null);
                }
                props.createPropertyEntry(PROPERTY_THRESH_GREEN_TO_YELLOW, (Object)(group.getThresholds().getGreen2Yellow() + ""), null);
                props.createPropertyEntry(PROPERTY_THRESH_YELLOW_TO_RED, (Object)(group.getThresholds().getYellow2Red() + ""), null);
                props.createPropertyEntry(PROPERTY_THRESH_RED_TO_YELLOW, (Object)(group.getThresholds().getYellow2Red() + ""), null);
                props.createPropertyEntry(PROPERTY_THRESH_YELLOW_TO_GREEN, (Object)(group.getThresholds().getYellow2Green() + ""), null);
                props.createPropertyEntry(PROPERTY_DATA_UNIT, (Object)group.getUnit(), null);
                props.createPropertyEntry(PROPERTY_ALERT_RELEVANT_VALUE_TYPE, (Object)(group.getAlertRelevantValueType() + ""), null);
                props.createPropertyEntry(PROPERTY_HISTORY_AVERAGING_MODE, (Object)(group.getHistory().getAveragingMode() + ""), null);
            }
            this.configurationHandler.commit();
            group.setCustomized(true);
            this.replaceOldWithNewGroup(group);
            this.location.infoT("Customizing process for [" + groupName + "]has finished  succesfully");
            Object var10_11 = null;
            try {
                this.configurationHandler.closeAllConfigurations();
            }
            catch (ConfigurationException e2) {
                this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
            }
            break block12;
            {
                catch (ConfigurationException e) {
                    this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e)));
                    Object var10_12 = null;
                    try {
                        this.configurationHandler.closeAllConfigurations();
                    }
                    catch (ConfigurationException e2) {
                        this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    this.configurationHandler.closeAllConfigurations();
                }
                catch (ConfigurationException e2) {
                    this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void customizeMonitorGroup(MonitorConfigurationGroup group, String type) {
        block12: {
            String groupName;
            block11: {
                groupName = group.getGlobalConfigurationGroupName();
                Configuration groupConfiguration = null;
                try {
                    groupConfiguration = this.configurationHandler.openConfiguration(MONITOR_SEMANTICS_PATH + SLASH + groupName, 1);
                    PropertySheet props = groupConfiguration.getPropertySheetInterface();
                    props.getPropertyEntry(PROPERTY_DESCRIPTION_TEXT).setValue((Object)group.getDescription().getText());
                    props.getPropertyEntry(PROPERTY_AUTO_REACTION_METHOD).setValue((Object)group.getAutoreactionMethod());
                    props.getPropertyEntry(PROPERTY_ANALISYS_METHOD).setValue((Object)group.getAnalysisMethod());
                    props.getPropertyEntry(PROPERTY_REACT_ON_COLLECTION_FAILURE).setValue((Object)(group.getDataCollection().getReactOnCollectionFailure() + ""));
                    if (group.getDataCollection().getDataCollectionType() == DataCollection.POLLED_BY_MONITOR) {
                        props.getPropertyEntry(PROPERTY_COLLECT_PERIOD_VALUE).setValue((Object)(group.getDataCollection().getCollectPeriod().getValue() + ""));
                        props.getPropertyEntry(PROPERTY_COLLECT_PERIOD_UNIT).setValue((Object)(group.getDataCollection().getCollectPeriod().getUnit() + ""));
                    }
                }
                catch (NameNotFoundException a) {
                    Configuration monitorSemanticConfiguration = this.configurationHandler.openConfiguration(MONITOR_SEMANTICS_PATH, 1);
                    groupConfiguration = monitorSemanticConfiguration.createSubConfiguration(groupName, 1);
                    PropertySheet props = groupConfiguration.getPropertySheetInterface();
                    props.createPropertyEntry(PROPERTY_TYPE, (Object)type, null);
                    props.createPropertyEntry(PROPERTY_GROUP_OWNER, (Object)group.getGroupOwner(), null);
                    props.createPropertyEntry(PROPERTY_DESCRIPTION_ID, (Object)group.getDescription().getID(), null);
                    props.createPropertyEntry(PROPERTY_DESCRIPTION_TEXT, (Object)group.getDescription().getText(), null);
                    props.createPropertyEntry(PROPERTY_AUTO_REACTION_METHOD, (Object)group.getAutoreactionMethod(), null);
                    props.createPropertyEntry(PROPERTY_ANALISYS_METHOD, (Object)group.getAnalysisMethod(), null);
                    int dataCollectionType = group.getDataCollection().getDataCollectionType();
                    props.createPropertyEntry(PROPERTY_DATA_COLLECTION_TYPE, (Object)(dataCollectionType + ""), null);
                    props.createPropertyEntry(PROPERTY_REACT_ON_COLLECTION_FAILURE, (Object)(group.getDataCollection().getReactOnCollectionFailure() + ""), null);
                    if (dataCollectionType != DataCollection.POLLED_BY_MONITOR) break block11;
                    props.createPropertyEntry(PROPERTY_COLLECT_PERIOD_VALUE, (Object)(group.getDataCollection().getCollectPeriod().getValue() + ""), null);
                    props.createPropertyEntry(PROPERTY_COLLECT_PERIOD_UNIT, (Object)(group.getDataCollection().getCollectPeriod().getUnit() + ""), null);
                }
            }
            group.setCustomized(true);
            this.replaceOldWithNewGroup(group);
            this.configurationHandler.commit();
            this.location.infoT("Customizing process for [" + groupName + "]has finished  succesfully");
            Object var10_11 = null;
            try {
                this.configurationHandler.closeAllConfigurations();
            }
            catch (ConfigurationException e2) {
                this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
            }
            break block12;
            {
                catch (ConfigurationException e) {
                    this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e)));
                    Object var10_12 = null;
                    try {
                        this.configurationHandler.closeAllConfigurations();
                    }
                    catch (ConfigurationException e2) {
                        this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    this.configurationHandler.closeAllConfigurations();
                }
                catch (ConfigurationException e2) {
                    this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void customizeStateGroup(StateConfigurationGroup group) {
        block12: {
            String groupName = group.getGlobalConfigurationGroupName();
            Configuration groupConfiguration = null;
            try {
                groupConfiguration = this.configurationHandler.openConfiguration(MONITOR_SEMANTICS_PATH + SLASH + groupName, 1);
                PropertySheet props = groupConfiguration.getPropertySheetInterface();
                props.getPropertyEntry(PROPERTY_DESCRIPTION_TEXT).setValue((Object)group.getDescription().getText());
                props.getPropertyEntry(PROPERTY_AUTO_REACTION_METHOD).setValue((Object)group.getAutoreactionMethod());
                props.getPropertyEntry(PROPERTY_ANALISYS_METHOD).setValue((Object)group.getAnalysisMethod());
                props.getPropertyEntry(PROPERTY_REACT_ON_COLLECTION_FAILURE).setValue((Object)(group.getDataCollection().getReactOnCollectionFailure() + ""));
                if (group.getDataCollection().getDataCollectionType() == DataCollection.POLLED_BY_MONITOR) {
                    props.getPropertyEntry(PROPERTY_COLLECT_PERIOD_VALUE).setValue((Object)(group.getDataCollection().getCollectPeriod().getValue() + ""));
                    props.getPropertyEntry(PROPERTY_COLLECT_PERIOD_UNIT).setValue((Object)(group.getDataCollection().getCollectPeriod().getUnit() + ""));
                }
                props.getPropertyEntry(PROPERTY_GREEN_STATES).setValue((Object)this.convertStringArrayToString(group.getGreenStates()));
                props.getPropertyEntry(PROPERTY_YELLOW_STATES).setValue((Object)this.convertStringArrayToString(group.getYellowStates()));
                props.getPropertyEntry(PROPERTY_RED_STATES).setValue((Object)this.convertStringArrayToString(group.getRedStates()));
                props.getPropertyEntry(PROPERTY_ALERT_MODE).setValue((Object)(group.getAlertMode() + ""));
            }
            catch (NameNotFoundException a) {
                Configuration monitorSemanticConfiguration = this.configurationHandler.openConfiguration(MONITOR_SEMANTICS_PATH, 1);
                groupConfiguration = monitorSemanticConfiguration.createSubConfiguration(groupName, 1);
                PropertySheet props = groupConfiguration.getPropertySheetInterface();
                props.createPropertyEntry(PROPERTY_TYPE, (Object)STATE_MONITOR_GROUP, null);
                props.createPropertyEntry(PROPERTY_GROUP_OWNER, (Object)group.getGroupOwner(), null);
                props.createPropertyEntry(PROPERTY_DESCRIPTION_ID, (Object)group.getDescription().getID(), null);
                props.createPropertyEntry(PROPERTY_DESCRIPTION_TEXT, (Object)group.getDescription().getText(), null);
                props.createPropertyEntry(PROPERTY_AUTO_REACTION_METHOD, (Object)group.getAutoreactionMethod(), null);
                props.createPropertyEntry(PROPERTY_ANALISYS_METHOD, (Object)group.getAnalysisMethod(), null);
                int dataCollectionType = group.getDataCollection().getDataCollectionType();
                props.createPropertyEntry(PROPERTY_DATA_COLLECTION_TYPE, (Object)(dataCollectionType + ""), null);
                props.createPropertyEntry(PROPERTY_REACT_ON_COLLECTION_FAILURE, (Object)(group.getDataCollection().getReactOnCollectionFailure() + ""), null);
                if (dataCollectionType == DataCollection.POLLED_BY_MONITOR) {
                    props.createPropertyEntry(PROPERTY_COLLECT_PERIOD_VALUE, (Object)(group.getDataCollection().getCollectPeriod().getValue() + ""), null);
                    props.createPropertyEntry(PROPERTY_COLLECT_PERIOD_UNIT, (Object)(group.getDataCollection().getCollectPeriod().getUnit() + ""), null);
                }
                props.createPropertyEntry(PROPERTY_GREEN_STATES, (Object)this.convertStringArrayToString(group.getGreenStates()), null);
                props.createPropertyEntry(PROPERTY_YELLOW_STATES, (Object)this.convertStringArrayToString(group.getYellowStates()), null);
                props.createPropertyEntry(PROPERTY_RED_STATES, (Object)this.convertStringArrayToString(group.getRedStates()), null);
                props.createPropertyEntry(PROPERTY_ALERT_MODE, (Object)(group.getAlertMode() + ""), null);
            }
            this.configurationHandler.commit();
            group.setCustomized(true);
            this.replaceOldWithNewGroup(group);
            this.location.infoT("Customizing process for [" + groupName + "]has finished  succesfully");
            Object var9_10 = null;
            try {
                this.configurationHandler.closeAllConfigurations();
            }
            catch (ConfigurationException e2) {
                this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
            }
            break block12;
            {
                catch (ConfigurationException e) {
                    this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e)));
                    Object var9_11 = null;
                    try {
                        this.configurationHandler.closeAllConfigurations();
                    }
                    catch (ConfigurationException e2) {
                        this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                try {
                    this.configurationHandler.closeAllConfigurations();
                }
                catch (ConfigurationException e2) {
                    this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void customizeTableMonitorGroup(TableConfigurationGroup group) {
        block12: {
            String groupName = group.getGlobalConfigurationGroupName();
            Configuration groupConfiguration = null;
            try {
                groupConfiguration = this.configurationHandler.openConfiguration(MONITOR_SEMANTICS_PATH + SLASH + groupName, 1);
                PropertySheet props = groupConfiguration.getPropertySheetInterface();
                props.getPropertyEntry(PROPERTY_DESCRIPTION_TEXT).setValue((Object)group.getDescription().getText());
                props.getPropertyEntry(PROPERTY_AUTO_REACTION_METHOD).setValue((Object)group.getAutoreactionMethod());
                props.getPropertyEntry(PROPERTY_ANALISYS_METHOD).setValue((Object)group.getAnalysisMethod());
                props.getPropertyEntry(PROPERTY_REACT_ON_COLLECTION_FAILURE).setValue((Object)(group.getDataCollection().getReactOnCollectionFailure() + ""));
                if (group.getDataCollection().getDataCollectionType() == DataCollection.POLLED_BY_MONITOR) {
                    props.getPropertyEntry(PROPERTY_COLLECT_PERIOD_VALUE).setValue((Object)(group.getDataCollection().getCollectPeriod().getValue() + ""));
                    props.getPropertyEntry(PROPERTY_COLLECT_PERIOD_UNIT).setValue((Object)(group.getDataCollection().getCollectPeriod().getUnit() + ""));
                }
                props.getPropertyEntry(PROPERTY_TABLE_COLUMNS).setValue((Object)this.convertVectorToString(group.getColumns()));
            }
            catch (NameNotFoundException a) {
                Configuration monitorSemanticConfiguration = this.configurationHandler.openConfiguration(MONITOR_SEMANTICS_PATH, 1);
                groupConfiguration = monitorSemanticConfiguration.createSubConfiguration(groupName, 1);
                PropertySheet props = groupConfiguration.getPropertySheetInterface();
                props.createPropertyEntry(PROPERTY_TYPE, (Object)TABLE_MONITOR_GROUP, null);
                props.createPropertyEntry(PROPERTY_GROUP_OWNER, (Object)group.getGroupOwner(), null);
                props.createPropertyEntry(PROPERTY_DESCRIPTION_ID, (Object)group.getDescription().getID(), null);
                props.createPropertyEntry(PROPERTY_DESCRIPTION_TEXT, (Object)group.getDescription().getText(), null);
                props.createPropertyEntry(PROPERTY_AUTO_REACTION_METHOD, (Object)group.getAutoreactionMethod(), null);
                props.createPropertyEntry(PROPERTY_ANALISYS_METHOD, (Object)group.getAnalysisMethod(), null);
                int dataCollectionType = group.getDataCollection().getDataCollectionType();
                props.createPropertyEntry(PROPERTY_DATA_COLLECTION_TYPE, (Object)(dataCollectionType + ""), null);
                props.createPropertyEntry(PROPERTY_REACT_ON_COLLECTION_FAILURE, (Object)(group.getDataCollection().getReactOnCollectionFailure() + ""), null);
                if (dataCollectionType == DataCollection.POLLED_BY_MONITOR) {
                    props.createPropertyEntry(PROPERTY_COLLECT_PERIOD_VALUE, (Object)(group.getDataCollection().getCollectPeriod().getValue() + ""), null);
                    props.createPropertyEntry(PROPERTY_COLLECT_PERIOD_UNIT, (Object)(group.getDataCollection().getCollectPeriod().getUnit() + ""), null);
                }
                props.createPropertyEntry(PROPERTY_TABLE_COLUMNS, (Object)this.convertVectorToString(group.getColumns()), null);
            }
            this.configurationHandler.commit();
            this.location.infoT("Customizing process for [" + groupName + "]has finished  succesfully");
            group.setCustomized(true);
            this.replaceOldWithNewGroup(group);
            Object var9_10 = null;
            try {
                this.configurationHandler.closeAllConfigurations();
            }
            catch (ConfigurationException e2) {
                this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
            }
            break block12;
            {
                catch (ConfigurationException e) {
                    this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e)));
                    Object var9_11 = null;
                    try {
                        this.configurationHandler.closeAllConfigurations();
                    }
                    catch (ConfigurationException e2) {
                        this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                try {
                    this.configurationHandler.closeAllConfigurations();
                }
                catch (ConfigurationException e2) {
                    this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void customizeSimpleGroup(SimpleConfigurationGroup group) {
        block10: {
            String groupName = group.getGlobalConfigurationGroupName();
            Configuration groupConfiguration = null;
            try {
                groupConfiguration = this.configurationHandler.openConfiguration(MONITOR_SEMANTICS_PATH + SLASH + groupName, 1);
                PropertySheet props = groupConfiguration.getPropertySheetInterface();
                props.getPropertyEntry(PROPERTY_DESCRIPTION_TEXT).setValue((Object)group.getDescription().getText());
                props.getPropertyEntry(PROPERTY_AUTO_REACTION_METHOD).setValue((Object)group.getAutoreactionMethod());
                props.getPropertyEntry(PROPERTY_ANALISYS_METHOD).setValue((Object)group.getAnalysisMethod());
            }
            catch (NameNotFoundException a) {
                Configuration monitorSemanticConfiguration = this.configurationHandler.openConfiguration(MONITOR_SEMANTICS_PATH, 1);
                groupConfiguration = monitorSemanticConfiguration.createSubConfiguration(groupName, 1);
                PropertySheet props = groupConfiguration.getPropertySheetInterface();
                props.createPropertyEntry(PROPERTY_TYPE, (Object)SIMPLE_GROUP, null);
                props.createPropertyEntry(PROPERTY_GROUP_OWNER, (Object)group.getGroupOwner(), null);
                props.createPropertyEntry(PROPERTY_DESCRIPTION_ID, (Object)group.getDescription().getID(), null);
                props.createPropertyEntry(PROPERTY_DESCRIPTION_TEXT, (Object)group.getDescription().getText(), null);
                props.createPropertyEntry(PROPERTY_AUTO_REACTION_METHOD, (Object)group.getAutoreactionMethod(), null);
                props.createPropertyEntry(PROPERTY_ANALISYS_METHOD, (Object)group.getAnalysisMethod(), null);
            }
            this.configurationHandler.commit();
            group.setCustomized(true);
            this.replaceOldWithNewGroup(group);
            this.location.infoT("Customizing process for [" + groupName + "]has finished  succesfully");
            Object var8_9 = null;
            try {
                this.configurationHandler.closeAllConfigurations();
            }
            catch (ConfigurationException e2) {
                this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
            }
            break block10;
            {
                catch (ConfigurationException e) {
                    this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e)));
                    Object var8_10 = null;
                    try {
                        this.configurationHandler.closeAllConfigurations();
                    }
                    catch (ConfigurationException e2) {
                        this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    this.configurationHandler.closeAllConfigurations();
                }
                catch (ConfigurationException e2) {
                    this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                }
                throw throwable;
            }
        }
    }

    public String getMonitorConfiguration(String name) {
        return null;
    }

    /*
     * Loose catch block
     */
    public boolean deleteGroup(String configGroupName) {
        boolean result;
        block8: {
            result = false;
            Configuration group = this.configurationHandler.openConfiguration(MONITOR_SEMANTICS_PATH + "/" + configGroupName, 1);
            this.location.infoT("Must delete " + group.getPath());
            group.deleteConfiguration();
            this.configurationHandler.commit();
            result = true;
            Object var5_5 = null;
            try {
                this.configurationHandler.closeAllConfigurations();
            }
            catch (ConfigurationException e2) {
                this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
            }
            break block8;
            {
                catch (Exception e) {
                    this.location.errorT(Util.getStackTraceAsString(e));
                    Object var5_6 = null;
                    try {
                        this.configurationHandler.closeAllConfigurations();
                    }
                    catch (ConfigurationException e2) {
                        this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    this.configurationHandler.closeAllConfigurations();
                }
                catch (ConfigurationException e2) {
                    this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                }
                throw throwable;
            }
        }
        return result;
    }

    /*
     * Loose catch block
     */
    public String getOwner(String configGroupName) {
        String owner;
        block8: {
            owner = null;
            Configuration group = this.configurationHandler.openConfiguration(MONITOR_SEMANTICS_PATH + "/" + configGroupName, 0);
            PropertySheet props = group.getPropertySheetInterface();
            owner = this.createGroupOwner(props, configGroupName);
            Object var6_6 = null;
            try {
                this.configurationHandler.closeAllConfigurations();
            }
            catch (ConfigurationException e2) {
                this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
            }
            break block8;
            {
                catch (Exception e) {
                    this.location.errorT(Util.getStackTraceAsString(e));
                    Object var6_7 = null;
                    try {
                        this.configurationHandler.closeAllConfigurations();
                    }
                    catch (ConfigurationException e2) {
                        this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    this.configurationHandler.closeAllConfigurations();
                }
                catch (ConfigurationException e2) {
                    this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                }
                throw throwable;
            }
        }
        return owner;
    }

    /*
     * Loose catch block
     */
    public Hashtable getAllSavedGroups(ConfigurationHandler configHandler) {
        Hashtable<String, SimpleConfigurationGroup> groups;
        block9: {
            this.location.infoT("Get all groups, which are saved in the data base");
            groups = new Hashtable<String, SimpleConfigurationGroup>();
            Configuration monitorSemantic = configHandler.openConfiguration(MONITOR_SEMANTICS_PATH, 1);
            String[] groupNames = monitorSemantic.getAllSubConfigurationNames();
            int i = 0;
            while (i < groupNames.length) {
                this.location.infoT("Try to open configuration for a group with name " + groupNames[i]);
                Configuration configGroup = monitorSemantic.getSubConfiguration(groupNames[i]);
                PropertySheet props = configGroup.getPropertySheetInterface();
                SimpleConfigurationGroup group = this.createGroupFromProperies(props, groupNames[i], configHandler);
                groups.put(group.getGlobalConfigurationGroupName(), group);
                ++i;
            }
            Object var10_10 = null;
            try {
                configHandler.closeAllConfigurations();
            }
            catch (ConfigurationException e2) {
                this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
            }
            break block9;
            {
                catch (Exception e) {
                    this.location.errorT(Util.getStackTraceAsString(e));
                    Object var10_11 = null;
                    try {
                        configHandler.closeAllConfigurations();
                    }
                    catch (ConfigurationException e2) {
                        this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    configHandler.closeAllConfigurations();
                }
                catch (ConfigurationException e2) {
                    this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                }
                throw throwable;
            }
        }
        return groups;
    }

    private SimpleConfigurationGroup createGroupFromProperies(PropertySheet props, String groupName, ConfigurationHandler configHandler) {
        SimpleConfigurationGroup group = null;
        try {
            String typeOfGroup = (String)props.getPropertyEntry(PROPERTY_TYPE).getValue();
            if (typeOfGroup.equals(SIMPLE_GROUP)) {
                group = this.createSimpleGroup(props, groupName);
            } else if (typeOfGroup.equals(LONG_MONITOR_GROUP)) {
                group = this.createLongMonitorGroup(props, groupName, configHandler);
            } else if (typeOfGroup.equals(INTEGER_MONITOR_GROUP)) {
                group = this.createIntegerMonitorGroup(props, groupName, configHandler);
            } else if (typeOfGroup.equals(AVAILABILITY_MONITOR_GROUP)) {
                group = this.createAvailabilityMonitorGroup(props, groupName, configHandler);
            } else if (typeOfGroup.equals(FREQUENCY_MONITOR_GROUP)) {
                group = this.createFrequencyMonitorGroup(props, groupName, configHandler);
            } else if (typeOfGroup.equals(QUALITY_RATE_MONITOR_GROUP)) {
                group = this.createQualityRateMonitorGroup(props, groupName, configHandler);
            } else if (typeOfGroup.equals(DURATION_MONITOR_GROUP)) {
                group = this.createDurationMonitorGroup(props, groupName, configHandler);
            } else if (typeOfGroup.equals(CONFIGURATION_MONITOR_GROUP)) {
                group = this.createConfigMonitorGroup(props, groupName);
            } else if (typeOfGroup.equals(VERSION_MONITOR_GROUP)) {
                group = this.createVersionMonitorGroup(props, groupName);
            } else if (typeOfGroup.equals(TABLE_MONITOR_GROUP)) {
                group = this.createTableMonitorGroup(props, groupName);
            } else if (typeOfGroup.equals(TEXT_MONITOR_GROUP)) {
                group = this.createTextMonitorGroup(props, groupName);
            } else if (typeOfGroup.equals(STATE_MONITOR_GROUP)) {
                group = this.createStateMonitorGroup(props, groupName, configHandler);
            } else if (!typeOfGroup.equals(CACHE_MONITOR_GROUP) && !typeOfGroup.equals(POOL_MONITOR_GROUP)) {
                this.location.errorT("Some error in Data Base properties, group of type [" + typeOfGroup + "] is not supported");
            }
            group.setAutoreactionMethod((String)props.getPropertyEntry(PROPERTY_AUTO_REACTION_METHOD).getValue());
            group.setAnalysisMethod((String)props.getPropertyEntry(PROPERTY_ANALISYS_METHOD).getValue());
            group.setGlobalConfigurationGroupName(groupName);
        }
        catch (ConfigurationException e) {
            this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e)));
        }
        return group;
    }

    private SimpleConfigurationGroup createSimpleGroup(PropertySheet props, String groupName) {
        return new SimpleConfigurationGroup(groupName, this.createDescription(props, groupName), this.createGroupOwner(props, groupName), IS_PERSISTANT);
    }

    private LongConfigurationGroup createLongMonitorGroup(PropertySheet props, String groupName, ConfigurationHandler configHandler) {
        return new LongConfigurationGroup(groupName, this.createDescription(props, groupName), this.createDataCollection(props, groupName), this.createThresholds(props, groupName), this.createHistory(props, groupName), this.createDataUnit(props, groupName), this.createAlertRelevantValueType(props, groupName, configHandler), this.createGroupOwner(props, groupName), IS_PERSISTANT);
    }

    private IntegerConfigurationGroup createIntegerMonitorGroup(PropertySheet props, String groupName, ConfigurationHandler configHandler) {
        return new IntegerConfigurationGroup(groupName, this.createDescription(props, groupName), this.createDataCollection(props, groupName), this.createThresholds(props, groupName), this.createHistory(props, groupName), this.createDataUnit(props, groupName), this.createAlertRelevantValueType(props, groupName, configHandler), this.createGroupOwner(props, groupName), IS_PERSISTANT);
    }

    private AvailabilityConfigurationGroup createAvailabilityMonitorGroup(PropertySheet props, String groupName, ConfigurationHandler configHandler) {
        return new AvailabilityConfigurationGroup(groupName, this.createDescription(props, groupName), this.createDataCollection(props, groupName), this.createThresholds(props, groupName), this.createHistory(props, groupName), this.createDataUnit(props, groupName), this.createAlertRelevantValueType(props, groupName, configHandler), this.createGroupOwner(props, groupName), IS_PERSISTANT);
    }

    private FrequencyConfigurationGroup createFrequencyMonitorGroup(PropertySheet props, String groupName, ConfigurationHandler configHandler) {
        return new FrequencyConfigurationGroup(groupName, this.createDescription(props, groupName), this.createDataCollection(props, groupName), this.createThresholds(props, groupName), this.createHistory(props, groupName), this.createDataUnit(props, groupName), this.createAlertRelevantValueType(props, groupName, configHandler), this.createGroupOwner(props, groupName), IS_PERSISTANT);
    }

    private QualityRateConfigurationGroup createQualityRateMonitorGroup(PropertySheet props, String groupName, ConfigurationHandler configHandler) {
        return new QualityRateConfigurationGroup(groupName, this.createDescription(props, groupName), this.createDataCollection(props, groupName), this.createThresholds(props, groupName), this.createHistory(props, groupName), this.createDataUnit(props, groupName), this.createAlertRelevantValueType(props, groupName, configHandler), this.createGroupOwner(props, groupName), IS_PERSISTANT);
    }

    private DurationConfigurationGroup createDurationMonitorGroup(PropertySheet props, String groupName, ConfigurationHandler configHandler) {
        return new DurationConfigurationGroup(groupName, this.createDescription(props, groupName), this.createDataCollection(props, groupName), this.createThresholds(props, groupName), this.createHistory(props, groupName), this.createDataUnit(props, groupName), this.createAlertRelevantValueType(props, groupName, configHandler), this.createGroupOwner(props, groupName), IS_PERSISTANT);
    }

    private ConfigConfigurationGroup createConfigMonitorGroup(PropertySheet props, String groupName) {
        return new ConfigConfigurationGroup(groupName, this.createDescription(props, groupName), this.createDataCollection(props, groupName), this.createGroupOwner(props, groupName), IS_PERSISTANT);
    }

    private VersionConfigurationGroup createVersionMonitorGroup(PropertySheet props, String groupName) {
        return new VersionConfigurationGroup(groupName, this.createDescription(props, groupName), this.createDataCollection(props, groupName), this.createGroupOwner(props, groupName), IS_PERSISTANT);
    }

    private TableConfigurationGroup createTableMonitorGroup(PropertySheet props, String groupName) {
        return new TableConfigurationGroup(groupName, this.createDescription(props, groupName), this.createDataCollection(props, groupName), this.createColumns(props, groupName), this.createGroupOwner(props, groupName), IS_PERSISTANT);
    }

    private TextConfigurationGroup createTextMonitorGroup(PropertySheet props, String groupName) {
        return new TextConfigurationGroup(groupName, this.createDescription(props, groupName), this.createDataCollection(props, groupName), this.createGroupOwner(props, groupName), IS_PERSISTANT);
    }

    private StateConfigurationGroup createStateMonitorGroup(PropertySheet props, String groupName, ConfigurationHandler configHandler) {
        return new StateConfigurationGroup(groupName, this.createDescription(props, groupName), this.createDataCollection(props, groupName), this.createGreenStates(props, groupName), this.createYellowStates(props, groupName), this.createRedStates(props, groupName), this.createAlertMode(props, groupName, configHandler), this.createGroupOwner(props, groupName), IS_PERSISTANT);
    }

    private Description createDescription(PropertySheet props, String groupName) {
        try {
            return new Description((String)props.getPropertyEntry(PROPERTY_DESCRIPTION_ID).getValue(), (String)props.getPropertyEntry(PROPERTY_DESCRIPTION_TEXT).getValue());
        }
        catch (ConfigurationException e) {
            this.location.errorT("Cannot create a description from the property sheet for a group with name[" + groupName + "]");
            this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e)));
            return null;
        }
    }

    private DataCollection createDataCollection(PropertySheet props, String groupName) {
        DataCollection dataCollection = null;
        try {
            int dataCollectionType = Integer.parseInt((String)props.getPropertyEntry(PROPERTY_DATA_COLLECTION_TYPE).getValue());
            int reactOnResourceFailure = Integer.parseInt((String)props.getPropertyEntry(PROPERTY_REACT_ON_COLLECTION_FAILURE).getValue());
            Period period = null;
            if (dataCollectionType == DataCollection.POLLED_BY_MONITOR) {
                period = new Period(Integer.parseInt((String)props.getPropertyEntry(PROPERTY_COLLECT_PERIOD_VALUE).getValue()), Integer.parseInt((String)props.getPropertyEntry(PROPERTY_COLLECT_PERIOD_UNIT).getValue()));
            }
            dataCollection = new DataCollection(dataCollectionType, period, reactOnResourceFailure);
        }
        catch (ConfigurationException e) {
            this.location.errorT("Cannot create a data collection from the property sheet for a group with name[" + groupName + "]");
            this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e)));
        }
        return dataCollection;
    }

    private Thresholds createThresholds(PropertySheet props, String groupName) {
        Thresholds thresholds = null;
        try {
            int green2Yellow = Integer.parseInt((String)props.getPropertyEntry(PROPERTY_THRESH_GREEN_TO_YELLOW).getValue());
            int yellow2Red = Integer.parseInt((String)props.getPropertyEntry(PROPERTY_THRESH_YELLOW_TO_RED).getValue());
            int red2Yellow = Integer.parseInt((String)props.getPropertyEntry(PROPERTY_THRESH_RED_TO_YELLOW).getValue());
            int yellow2Green = Integer.parseInt((String)props.getPropertyEntry(PROPERTY_THRESH_YELLOW_TO_GREEN).getValue());
            thresholds = new Thresholds(green2Yellow, yellow2Red, red2Yellow, yellow2Green);
        }
        catch (ConfigurationException e) {
            this.location.errorT("Cannot create Thresholds from the property sheet for a group with name[" + groupName + "]");
            this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e)));
        }
        return thresholds;
    }

    private History createHistory(PropertySheet props, String groupName) {
        try {
            return new History(Integer.parseInt((String)props.getPropertyEntry(PROPERTY_HISTORY_AVERAGING_MODE).getValue()));
        }
        catch (ConfigurationException e) {
            this.location.errorT("Cannot create a history from the property sheet for a group with name[" + groupName + "]");
            this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e)));
            return null;
        }
    }

    private String createDataUnit(PropertySheet props, String groupName) {
        try {
            return (String)props.getPropertyEntry(PROPERTY_DATA_UNIT).getValue();
        }
        catch (ConfigurationException e) {
            this.location.errorT("Cannot create a data unit from the property sheet for a group with name[" + groupName + "]");
            this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e)));
            return "";
        }
    }

    private Vector createColumns(PropertySheet props, String groupName) {
        try {
            String columNames = (String)props.getPropertyEntry(PROPERTY_TABLE_COLUMNS).getValue();
            return this.convertStringToVector(columNames);
        }
        catch (ConfigurationException e) {
            this.location.errorT("Cannot create columns from the property sheet for a group with name[" + groupName + "]");
            this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e)));
            return null;
        }
    }

    private int createAlertRelevantValueType(PropertySheet props, String groupName, ConfigurationHandler configHandler) {
        try {
            int alertRelevantValueType = Integer.parseInt((String)props.getPropertyEntry(PROPERTY_ALERT_RELEVANT_VALUE_TYPE).getValue());
            if (alertRelevantValueType == 0) {
                alertRelevantValueType = 1;
                props.getPropertyEntry(PROPERTY_ALERT_RELEVANT_VALUE_TYPE).setValue((Object)(alertRelevantValueType + ""));
                configHandler.commit();
            }
            return alertRelevantValueType;
        }
        catch (ConfigurationException e) {
            this.location.errorT("Cannot create an alert relevant value type from the property sheet for a group with name[" + groupName + "]");
            this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e)));
            return 1;
        }
    }

    private String[] createGreenStates(PropertySheet props, String groupName) {
        try {
            return this.convertStringToStringArray((String)props.getPropertyEntry(PROPERTY_GREEN_STATES).getValue());
        }
        catch (ConfigurationException e) {
            this.location.errorT("Cannot create  green states type from the property sheet for a group with name[" + groupName + "]");
            this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e)));
            return null;
        }
    }

    private String[] createYellowStates(PropertySheet props, String groupName) {
        try {
            return this.convertStringToStringArray((String)props.getPropertyEntry(PROPERTY_YELLOW_STATES).getValue());
        }
        catch (ConfigurationException e) {
            this.location.errorT("Cannot create yellow states type from the property sheet for a group with name[" + groupName + "]");
            this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e)));
            return null;
        }
    }

    private String[] createRedStates(PropertySheet props, String groupName) {
        try {
            return this.convertStringToStringArray((String)props.getPropertyEntry(PROPERTY_RED_STATES).getValue());
        }
        catch (ConfigurationException e) {
            this.location.errorT("Cannot create red states type from the property sheet for a group with name[" + groupName + "]");
            this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e)));
            return null;
        }
    }

    private int createAlertMode(PropertySheet props, String groupName, ConfigurationHandler configHandler) {
        try {
            int alertMode = Integer.parseInt((String)props.getPropertyEntry(PROPERTY_ALERT_MODE).getValue());
            if (alertMode == 0) {
                alertMode = 1;
                props.getPropertyEntry(PROPERTY_ALERT_MODE).setValue((Object)(alertMode + ""));
                configHandler.commit();
            }
            return alertMode;
        }
        catch (ConfigurationException e) {
            this.location.errorT("Cannot create an alert mode type from the property sheet for a group with name[" + groupName + "]");
            this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e)));
            return 1;
        }
    }

    private String createGroupOwner(PropertySheet props, String groupName) {
        try {
            String groupOwner = (String)props.getPropertyEntry(PROPERTY_GROUP_OWNER).getValue();
            return groupOwner;
        }
        catch (ConfigurationException e) {
            this.location.errorT("Cannot create owner from the property sheet for a group with name[" + groupName + "]");
            this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e)));
            return null;
        }
    }

    private String convertStringArrayToString(String[] strArray) {
        StringBuffer strBfr = new StringBuffer("");
        if (strArray != null) {
            int i = 0;
            while (i < strArray.length) {
                strBfr.append(strArray[i]);
                strBfr.append(";");
                ++i;
            }
        }
        return strBfr.toString();
    }

    private String convertVectorToString(Vector vector) {
        StringBuffer strBfr = new StringBuffer("");
        if (vector != null) {
            int i = 0;
            while (i < vector.size()) {
                strBfr.append(vector.get(i));
                strBfr.append(";");
                ++i;
            }
        }
        return strBfr.toString();
    }

    private String[] convertStringToStringArray(String value) {
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, ";", false);
            String[] stringArr = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                stringArr[i] = tokenizer.nextToken();
                ++i;
            }
            return stringArr;
        }
        return null;
    }

    private Vector convertStringToVector(String value) {
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, ";", false);
            Vector<String> vector = new Vector<String>();
            while (tokenizer.hasMoreTokens()) {
                vector.add(tokenizer.nextToken());
            }
            return vector;
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public SimpleConfigurationGroup getGroup(String groupName, ConfigurationHandler handler) {
        SimpleConfigurationGroup group = null;
        Configuration configGroup = null;
        boolean configObtained = false;
        while (!configObtained) {
            this.location.infoT("Try to open configuration for " + groupName);
            configGroup = handler.openConfiguration(MONITOR_SEMANTICS_PATH + "/" + groupName, 0);
            configObtained = true;
            PropertySheet props = configGroup.getPropertySheetInterface();
            group = this.createGroupFromProperies(props, groupName, this.configurationHandler);
            Object var9_11 = null;
            try {
                handler.closeConfiguration(configGroup);
            }
            catch (ConfigurationException e2) {
                this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
            }
            continue;
            {
                catch (ConfigurationLockedException e) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException f) {
                    }
                    var9_11 = null;
                    try {
                        handler.closeConfiguration(configGroup);
                    }
                    catch (ConfigurationException e2) {
                        this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                    }
                    continue;
                }
                catch (Exception ex) {
                    this.location.errorT(Util.getStackTraceAsString(ex));
                    var9_11 = null;
                    try {
                        handler.closeConfiguration(configGroup);
                    }
                    catch (ConfigurationException e2) {
                        this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                var9_11 = null;
                try {
                    handler.closeConfiguration(configGroup);
                }
                catch (ConfigurationException e2) {
                    this.location.errorT(Util.getStackTraceAsString((Exception)((Object)e2)));
                }
                throw throwable;
            }
        }
        return group;
    }
}

