/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.common;

import com.sap.bc.proj.jstartup.JStartupFramework;
import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.CommunicationServiceContext;
import com.sap.engine.frame.state.ServiceState;

public class CcmsConnectorInfo {
    private static final int COMMUNICATION_SERVICE_CONTEXT = 0;
    private static final int APPLICATION_SERVICE_CONTEXT = 1;
    private static final String SAPSYSTEM = "SAPSYSTEM";
    private CommunicationServiceContext commSrvCtxt = null;
    private ApplicationServiceContext appSrvCtxt = null;
    private int type;
    private ServiceState serviceState = null;

    public CcmsConnectorInfo(CommunicationServiceContext commSrvCtxt) {
        this.commSrvCtxt = commSrvCtxt;
        this.serviceState = commSrvCtxt.getServiceState();
        this.type = 0;
    }

    public CcmsConnectorInfo(ApplicationServiceContext appSrvCtxt) {
        this.appSrvCtxt = appSrvCtxt;
        this.serviceState = appSrvCtxt.getServiceState();
        this.type = 1;
    }

    public String getSID() {
        String sid = null;
        switch (this.type) {
            case 0: {
                sid = this.commSrvCtxt.getClusterContext().getClusterMonitor().getClusterName();
                break;
            }
            case 1: {
                sid = this.appSrvCtxt.getClusterContext().getClusterMonitor().getClusterName();
            }
        }
        return sid;
    }

    public int getJInstanceID() {
        String sapSystem = null;
        String SAP_SYSTEM_FAILURE = "-1";
        try {
            sapSystem = System.getProperty(SAPSYSTEM);
            if (sapSystem == null) {
                sapSystem = "-1";
            }
        }
        catch (SecurityException ex) {
            sapSystem = "-1";
        }
        return new Integer(sapSystem);
    }

    public int getJNodeID() {
        int JNodeID = 0;
        switch (this.type) {
            case 0: {
                JNodeID = this.commSrvCtxt.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
                break;
            }
            case 1: {
                JNodeID = this.appSrvCtxt.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
            }
        }
        return JNodeID;
    }

    public boolean isJDispatcher() {
        boolean isJDispatcher = true;
        switch (this.type) {
            case 0: {
                byte clusterType = this.commSrvCtxt.getClusterContext().getClusterMonitor().getCurrentParticipant().getType();
                if (clusterType == 1) {
                    isJDispatcher = true;
                    break;
                }
                isJDispatcher = false;
                break;
            }
            case 1: {
                byte clusterType = this.appSrvCtxt.getClusterContext().getClusterMonitor().getCurrentParticipant().getType();
                if (clusterType == 1) {
                    isJDispatcher = true;
                    break;
                }
                isJDispatcher = false;
                break;
            }
        }
        return isJDispatcher;
    }

    public String getCcmsRootDirectory() {
        String directory = JStartupFramework.getParam((String)"DIR_CCMS");
        return directory;
    }

    public String getJ2eeProfile() {
        String profile = JStartupFramework.getParam((String)"SAPPROFILE");
        return profile;
    }
}

