/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.agent.server;

import com.sap.engine.services.monitor.agent.server.Profile;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class ProfileCache {
    private static HashMap cache = new HashMap();
    private static ProfileCache singleton = null;
    private static final boolean isDebugEnabled = new Boolean(System.getProperty("DEBUG_CACHE"));

    private ProfileCache() {
    }

    public static ProfileCache getProfileCache() {
        if (singleton == null) {
            singleton = new ProfileCache();
        }
        return singleton;
    }

    public Profile getProfile(String profileName) {
        if (profileName == null) {
            return null;
        }
        String fullProfileName = this.getFullName(profileName);
        if (fullProfileName == null) {
            return null;
        }
        ProfileFileData data = (ProfileFileData)cache.get(fullProfileName);
        if (data == null) {
            try {
                if (isDebugEnabled) {
                    System.out.println("Profile add for : " + fullProfileName);
                }
                data = new ProfileFileData(fullProfileName);
            }
            catch (IOException e) {
                return null;
            }
            if (data == null) {
                return null;
            }
            cache.put(fullProfileName, data);
        }
        Profile profile = null;
        try {
            profile = data.getProfile();
        }
        catch (IOException e) {
            profile = null;
        }
        if (isDebugEnabled) {
            System.out.println("Profile get for : " + fullProfileName);
        }
        return profile;
    }

    private String getFullName(String profileName) {
        if (profileName == null) {
            return null;
        }
        File file = new File(profileName);
        String fullName = file.getAbsolutePath();
        if (new File(fullName).isDirectory()) {
            return null;
        }
        return fullName;
    }

    private class ProfileFileData {
        private String fileName = null;
        private Profile profile = null;
        private long lastUpdate = 0L;
        private long fileLength = 0L;

        public ProfileFileData(String profileName) throws IOException {
            this.profile = new Profile(profileName);
            this.fileName = profileName;
            File file = new File(profileName);
            this.lastUpdate = file.lastModified();
            this.fileLength = file.length();
        }

        public Profile getProfile() throws IOException {
            File file = new File(this.fileName);
            if (this.lastUpdate != file.lastModified() || this.fileLength != file.length()) {
                if (isDebugEnabled) {
                    System.out.println("Profile update for : " + this.fileName);
                }
                this.profile = new Profile(this.fileName);
                this.lastUpdate = file.lastModified();
            }
            return this.profile;
        }
    }
}

