/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.agent.server;

import com.sap.engine.services.monitor.agent.server.InstallationInformationImpl;
import com.sap.engine.services.monitor.agent.server.Properties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class Profile {
    private String profileFileName = null;
    private String defaultProfileFileName = null;
    private Properties properties = null;
    private Properties defaultProperties = null;
    private Boolean isValid = null;
    private static final String SYSTEM_NAME_PROPERTY = "SAPSYSTEMNAME";
    private static final String INSTANCE_NUMBER_PROPERTY = "SAPSYSTEM";
    private static final String DIR_GLOBAL_PROPERTY = "DIR_GLOBAL";
    private static final String DIR_PROFILE_PROPERTY = "DIR_PROFILE";
    private static final String DIR_EXECUTABLE_PROPERTY = "DIR_EXECUTABLE";
    private static final String SAPGLOBALHOST_PROPERTY1 = "SAPGLOBALHOST";
    public static final String LONG_SID_PROPERTY = "alert/longsid";

    Profile(String profileFileName) throws IOException {
        this.properties = this.load(profileFileName);
        this.profileFileName = profileFileName;
        try {
            File f = new File(profileFileName);
            String defaultProfileFileName = null;
            String profileDirectory = f.getParent();
            defaultProfileFileName = profileDirectory == null ? InstallationInformationImpl.getInstallationInformation().getDefaultProfileFileName() : profileDirectory + File.separator + InstallationInformationImpl.getInstallationInformation().getDefaultProfileFileName();
            this.defaultProperties = this.load(defaultProfileFileName);
            this.defaultProfileFileName = defaultProfileFileName;
        }
        catch (IOException e) {
            this.defaultProperties = null;
            this.defaultProfileFileName = null;
        }
    }

    public String getSystemName() {
        return this.getProperty(SYSTEM_NAME_PROPERTY);
    }

    public String getInstanceNumber() {
        return this.getProperty(INSTANCE_NUMBER_PROPERTY);
    }

    public String getLongSID() {
        return this.getProperty(LONG_SID_PROPERTY);
    }

    public boolean isLongSIDinDefault() {
        return this.defaultProperties != null && this.defaultProperties.getProperty(LONG_SID_PROPERTY) != null;
    }

    public String getDirExecutable() {
        return this.getProperty(DIR_EXECUTABLE_PROPERTY);
    }

    public boolean isValid() {
        if (this.isValid == null) {
            boolean isValid = this.getProperty(SYSTEM_NAME_PROPERTY) != null && this.getProperty(INSTANCE_NUMBER_PROPERTY) != null;
            this.isValid = new Boolean(isValid);
        }
        return this.isValid;
    }

    private Properties load(String profileFileName) throws IOException {
        FileInputStream inputStream = null;
        inputStream = new FileInputStream(new File(profileFileName));
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        Properties properties = this.load(reader);
        if (inputStream != null) {
            inputStream.close();
        }
        return properties;
    }

    private Properties load(BufferedReader r) throws IOException {
        String line = null;
        Properties props = new Properties();
        line = r.readLine();
        while (line != null) {
            int i;
            if (!line.startsWith("#") && (i = line.indexOf("=")) >= 0 && props != null) {
                String value;
                String name = line.substring(0, i);
                if (name != null) {
                    name = name.trim();
                }
                if ((value = line.substring(i + 1)) != null) {
                    value = value.trim();
                }
                if (name != null & name.length() > 0) {
                    props.setProperty(name, value);
                }
            }
            line = r.readLine();
        }
        return props;
    }

    private String getProperty(String property) {
        String propertyValue = null;
        if (this.properties != null) {
            propertyValue = (String)this.properties.getProperty(property);
        }
        if (propertyValue == null && this.defaultProperties != null) {
            propertyValue = (String)this.defaultProperties.getProperty(property);
        }
        return propertyValue;
    }
}

