/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.agent.server;

import com.sap.engine.services.monitor.common.MonitorServiceRuntime;
import com.sap.jmx.ObjectNameFactory;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class J2EEServerInformation {
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$monitor$agent$server$J2EEServerInformation == null ? (class$com$sap$engine$services$monitor$agent$server$J2EEServerInformation = J2EEServerInformation.class$("com.sap.engine.services.monitor.agent.server.J2EEServerInformation")) : class$com$sap$engine$services$monitor$agent$server$J2EEServerInformation));
    private static final MBeanServer mBeanServer = MonitorServiceRuntime.getMBeanServer();
    private static final String systemName = System.getProperty("SAPSYSTEMNAME");
    static /* synthetic */ Class class$com$sap$engine$services$monitor$agent$server$J2EEServerInformation;

    private J2EEServerInformation() {
    }

    private static String getDispatcherID(String instanceName) {
        String dispatcherID = null;
        String me = "J2EEServerInformation:getDispatcherID(" + instanceName + ")";
        try {
            J2EEServerInformation.log(me);
            ObjectName clusterON = ObjectNameFactory.getObjectName((String)"SAP_J2EECluster", (String)System.getProperty("SAPSYSTEMNAME"));
            String[] instanceNodeIDs = (String[])mBeanServer.invoke(clusterON, "getInstanceNodeIDs", new Object[]{instanceName}, new String[]{"java.lang.String"});
            int i = 0;
            while (i < instanceNodeIDs.length) {
                if (instanceNodeIDs[i].trim().endsWith("00")) {
                    dispatcherID = instanceNodeIDs[i];
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Category.SYS_SERVER.error(location, me, (Object)e);
            location.traceThrowableT(500, me, (Throwable)e);
        }
        J2EEServerInformation.log(me, dispatcherID != null ? dispatcherID : "not found");
        return dispatcherID;
    }

    public static ObjectName getObjectNameForMonitorService(String instanceName) {
        String me = "J2EEServerInformation:getObjectNameForMonitorService(" + instanceName + ")";
        J2EEServerInformation.log(me);
        ObjectName objectName = null;
        try {
            objectName = ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEServiceRuntimePerNode", (String)"monitor", (String)J2EEServerInformation.getDispatcherID(instanceName), (String)System.getProperty("SAPSYSTEMNAME"));
        }
        catch (Exception e) {
            Category.SYS_SERVER.error(location, me, (Object)e);
            location.traceThrowableT(500, me, (Throwable)e);
        }
        J2EEServerInformation.log(me, objectName != null ? objectName.getCanonicalName() : "null");
        return objectName;
    }

    public static String[] getAllInstanceNames() {
        String me = "J2EEServerInformation:getAllInstanceNames()";
        System.out.println("J2EEServerInformation:getAllInstanceNames()");
        J2EEServerInformation.log("J2EEServerInformation:getAllInstanceNames()");
        String[] instanceNames = null;
        try {
            ObjectName clusterON = ObjectNameFactory.getObjectName((String)"SAP_J2EECluster", (String)System.getProperty("SAPSYSTEMNAME"));
            instanceNames = (String[])mBeanServer.getAttribute(clusterON, "InstanceNames");
        }
        catch (Exception e) {
            Category.SYS_SERVER.error(location, "J2EEServerInformation:getAllInstanceNames()", (Object)e);
            location.traceThrowableT(500, "J2EEServerInformation:getAllInstanceNames()", (Throwable)e);
            instanceNames = new String[]{};
        }
        J2EEServerInformation.log("J2EEServerInformation:getAllInstanceNames()", String.valueOf(instanceNames.length));
        return instanceNames;
    }

    public static String getCentralInstanceName() {
        String me = "J2EEServerInformation:getCentralInstanceName()";
        J2EEServerInformation.log("J2EEServerInformation:getCentralInstanceName()");
        String centralInstanceName = null;
        try {
            ObjectName clusterON = ObjectNameFactory.getObjectName((String)"SAP_J2EECluster", (String)System.getProperty("SAPSYSTEMNAME"));
            String[] instanceNames = J2EEServerInformation.getAllInstanceNames();
            int i = 0;
            while (i < instanceNames.length) {
                ObjectName monitorOnDispatcherON = J2EEServerInformation.getObjectNameForMonitorService(instanceNames[i]);
                Boolean central = (Boolean)mBeanServer.getAttribute(monitorOnDispatcherON, "Central");
                if (central.booleanValue()) {
                    centralInstanceName = instanceNames[i];
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Category.SYS_SERVER.error(location, "J2EEServerInformation:getCentralInstanceName()", (Object)e);
            location.traceThrowableT(500, "J2EEServerInformation:getCentralInstanceName()", (Throwable)e);
        }
        J2EEServerInformation.log("J2EEServerInformation:getCentralInstanceName()", centralInstanceName);
        return centralInstanceName;
    }

    public static String getMyInstanceName() {
        String me = "J2EEServerInformation:getMyInstanceName()";
        String instanceName = null;
        try {
            J2EEServerInformation.log("J2EEServerInformation:getMyInstanceName()");
            ObjectName instanceON = ObjectNameFactory.getNameForServerChild((String)"SAP_J2EEInstance", (String)"local", null);
            instanceName = (String)mBeanServer.getAttribute(instanceON, "Name");
        }
        catch (Exception e) {
            Category.SYS_SERVER.error(location, "J2EEServerInformation:getMyInstanceName()", (Object)e);
            location.traceThrowableT(500, "J2EEServerInformation:getMyInstanceName()", (Throwable)e);
        }
        J2EEServerInformation.log("J2EEServerInformation:getMyInstanceName()", instanceName);
        return instanceName;
    }

    public static ObjectName getRfcRuntimeObjectName() {
        String me = "J2EEServerInformation:getRfcRuntimeObjectName()";
        J2EEServerInformation.log("J2EEServerInformation:getRfcRuntimeObjectName()");
        ObjectName rfcRuntime = null;
        try {
            ObjectName clusterON = ObjectNameFactory.getObjectName((String)"SAP_J2EECluster", (String)System.getProperty("SAPSYSTEMNAME"));
            String[] instanceNodeIDs = (String[])mBeanServer.invoke(clusterON, "getInstanceNodeIDs", new Object[]{J2EEServerInformation.getCentralInstanceName()}, new String[]{"java.lang.String"});
            int i = 0;
            while (i < instanceNodeIDs.length) {
                block5: {
                    try {
                        ObjectName monitor = ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEServiceRuntimePerNode", (String)"monitor", (String)instanceNodeIDs[i], (String)System.getProperty("SAPSYSTEMNAME"));
                        Boolean isServer = (Boolean)mBeanServer.getAttribute(monitor, "Server");
                        if (!isServer.booleanValue()) break block5;
                        rfcRuntime = ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEServiceRuntimePerNode", (String)"rfcengine", (String)instanceNodeIDs[i], (String)System.getProperty("SAPSYSTEMNAME"));
                        Integer maxProcesses = (Integer)mBeanServer.invoke(rfcRuntime, "getMaxProcesses", null, null);
                        break;
                    }
                    catch (Exception e) {
                        rfcRuntime = null;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            Category.SYS_SERVER.error(location, "J2EEServerInformation:getRfcRuntimeObjectName()", (Object)e);
            location.traceThrowableT(500, "J2EEServerInformation:getRfcRuntimeObjectName()", (Throwable)e);
            rfcRuntime = null;
        }
        J2EEServerInformation.log("J2EEServerInformation:getRfcRuntimeObjectName()", rfcRuntime != null ? rfcRuntime.getCanonicalName() : "null");
        return rfcRuntime;
    }

    public static ObjectName getObjectNameForMonitorServiceOnRfcEnabledNode() {
        String me = "J2EEServerInformation:getObjectNameForMonitorServiceOnRfcEnabledNode()";
        J2EEServerInformation.log("J2EEServerInformation:getObjectNameForMonitorServiceOnRfcEnabledNode()");
        ObjectName rfcRuntime = null;
        ObjectName monitorService = null;
        try {
            String systemName = System.getProperty("SAPSYSTEMNAME");
            J2EEServerInformation.log("J2EEServerInformation:getObjectNameForMonitorServiceOnRfcEnabledNode()", "systemName : " + systemName);
            ObjectName clusterON = ObjectNameFactory.getObjectName((String)"SAP_J2EECluster", (String)systemName);
            String[] instanceNodeIDs = (String[])mBeanServer.invoke(clusterON, "getInstanceNodeIDs", new Object[]{J2EEServerInformation.getCentralInstanceName()}, new String[]{"java.lang.String"});
            int i = 0;
            while (i < instanceNodeIDs.length) {
                try {
                    monitorService = ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEServiceRuntimePerNode", (String)"monitor", (String)instanceNodeIDs[i], (String)systemName);
                    Boolean isServer = (Boolean)mBeanServer.getAttribute(monitorService, "Server");
                    if (isServer.booleanValue()) {
                        rfcRuntime = ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEServiceRuntimePerNode", (String)"rfcengine", (String)instanceNodeIDs[i], (String)systemName);
                        Integer maxProcesses = (Integer)mBeanServer.invoke(rfcRuntime, "getMaxProcesses", null, null);
                        J2EEServerInformation.log("J2EEServerInformation:getObjectNameForMonitorServiceOnRfcEnabledNode()", "monitorService : " + monitorService.getCanonicalName());
                        break;
                    }
                    monitorService = null;
                }
                catch (InstanceNotFoundException e) {
                    monitorService = null;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Category.SYS_SERVER.error(location, "J2EEServerInformation:getObjectNameForMonitorServiceOnRfcEnabledNode()", (Object)e);
            location.traceThrowableT(500, "J2EEServerInformation:getObjectNameForMonitorServiceOnRfcEnabledNode()", (Throwable)e);
        }
        J2EEServerInformation.log("J2EEServerInformation:getObjectNameForMonitorServiceOnRfcEnabledNode()", monitorService.getCanonicalName());
        return monitorService;
    }

    public static String getInstanceNumber(String instanceName) {
        return instanceName.substring(instanceName.lastIndexOf("_") + 1);
    }

    private static void log(String msg) {
        location.infoT(Category.SYS_SERVER, msg);
    }

    private static void log(String msg1, String msg2) {
        location.infoT(Category.SYS_SERVER, msg1, msg2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

