/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.agent.server;

import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.services.monitor.agent.AbstractAgent;
import com.sap.engine.services.monitor.agent.J2EEAgent;
import com.sap.engine.services.monitor.agent.server.AbstractAgentImpl;
import com.sap.engine.services.monitor.agent.server.AgentPersistencyHandler;
import com.sap.engine.services.monitor.agent.server.Conf;
import com.sap.engine.services.monitor.agent.server.J2EEAgentImpl;
import com.sap.engine.services.monitor.agent.server.J2EEAgentProxy;
import com.sap.engine.services.monitor.agent.server.J2EEServerInformation;
import com.sap.engine.services.monitor.common.MonitorServiceRuntime;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class J2EEServerAgentImpl
extends AbstractAgentImpl
implements J2EEAgent {
    private String systemName = null;
    private J2EEAgent[] allAgents = null;
    private HashMap instanceNames = null;
    private J2EEAgent myAgent = null;
    private String myInstanceName = null;
    private J2EEAgent requestDispatcher = null;
    private Hashtable dispatchedResult = null;
    private String longSID = null;
    private String centralInstanceName = null;
    private String adminPassword = null;
    private String csmregPassword = null;
    private static Location location = Location.getLocation((Class)(class$com$sap$engine$services$monitor$agent$server$J2EEServerAgentImpl == null ? (class$com$sap$engine$services$monitor$agent$server$J2EEServerAgentImpl = J2EEServerAgentImpl.class$("com.sap.engine.services.monitor.agent.server.J2EEServerAgentImpl")) : class$com$sap$engine$services$monitor$agent$server$J2EEServerAgentImpl));
    static /* synthetic */ Class class$com$sap$engine$services$monitor$agent$server$J2EEServerAgentImpl;
    static /* synthetic */ Class class$com$sap$engine$services$monitor$agent$J2EEAgent;

    public J2EEServerAgentImpl(String systemName) {
        this.systemName = systemName;
    }

    protected void refreshFileNames() {
    }

    public String getDefaultConfigurationDirectory() {
        location.infoT(Category.SYS_SERVER, "getDefaultConfigurationDirectory()");
        String directory = this.getCentralInstanceAgent().getDefaultConfigurationDirectory();
        location.infoT(Category.SYS_SERVER, "getDefaultConfigurationDirectory()", directory);
        return directory;
    }

    public String getDefaultAgentDirectory() {
        location.infoT(Category.SYS_SERVER, "getDefaultAgentDirectory()");
        String directory = this.getCentralInstanceAgent().getDefaultAgentDirectory();
        location.infoT(Category.SYS_SERVER, "getDefaultAgentDirectory()", directory);
        return directory;
    }

    public boolean isProfileFileValid() {
        location.infoT(Category.SYS_SERVER, "isProfileFileValid()");
        boolean isValid = this.getCentralInstanceAgent().isProfileFileValid();
        location.infoT(Category.SYS_SERVER, "isProfileFileValid()", String.valueOf(isValid));
        return isValid;
    }

    public String getProfileName() {
        location.infoT(Category.SYS_SERVER, "getProfilename()");
        String profileName = this.getServerFileName(this.getCentralInstanceAgent().getProfileName());
        location.infoT(Category.SYS_SERVER, "getProfilename()", profileName);
        return profileName;
    }

    public void setProfileName(String profileName) {
    }

    public String getDefaultProfileDirectory() {
        location.infoT(Category.SYS_SERVER, "getDefaultProfileDirectory()");
        String directory = this.getCentralInstanceAgent().getDefaultProfileDirectory();
        location.infoT(Category.SYS_SERVER, "getDefaultProfileDirectory()", directory);
        return directory;
    }

    public String getDefaultProfileFileName() {
        location.infoT(Category.SYS_SERVER, "getDefaultProfileFileName()");
        String fileName = this.getCentralInstanceAgent().getDefaultProfileFileName();
        location.infoT(Category.SYS_SERVER, "getDefaultProfileFileName()", fileName);
        return fileName;
    }

    public String getLongSID() {
        location.infoT(Category.SYS_SERVER, "getLongSID()");
        String longSID = this.getCentralInstanceAgent().getLongSID();
        location.infoT(Category.SYS_SERVER, "getLongSID()", longSID);
        return longSID;
    }

    public void setLongSID(String longSID) {
        location.infoT(Category.SYS_SERVER, "setLongSID()", longSID);
        this.getRequestDispatcher().setLongSID(longSID);
        this.longSID = longSID == null ? "" : longSID;
        location.infoT(Category.SYS_SERVER, "setLongSID()");
    }

    public String getAdminClient() {
        location.infoT(Category.SYS_SERVER, "getAdminClient()");
        String adminClient = this.getCentralInstanceAgent().getAdminClient();
        location.infoT(Category.SYS_SERVER, "getAdminClient()", adminClient);
        return adminClient;
    }

    public String getAdminPassword() {
        location.infoT(Category.SYS_SERVER, "getAdminPassword()");
        String adminPassword = this.getCentralInstanceAgent().getAdminPassword();
        location.infoT(Category.SYS_SERVER, "getAdminPassword()", "XXXXXX");
        return adminPassword;
    }

    public String getAdminSystem() {
        location.infoT(Category.SYS_SERVER, "getAdminSystem()");
        String adminSystem = this.getCentralInstanceAgent().getAdminSystem();
        location.infoT(Category.SYS_SERVER, "getAdminSystem()", adminSystem);
        return adminSystem;
    }

    public String getAdminUser() {
        location.infoT(Category.SYS_SERVER, "getAdminUser()");
        String adminUser = this.getCentralInstanceAgent().getAdminUser();
        location.infoT(Category.SYS_SERVER, "getAdminUser()", adminUser);
        return adminUser;
    }

    public String getAgentBaseFileName() {
        location.infoT(Category.SYS_SERVER, "getAgentBaseFileName()");
        String fileName = this.getCentralInstanceAgent().getAgentBaseFileName();
        location.infoT(Category.SYS_SERVER, "getAgentBaseFileName()", fileName);
        return fileName;
    }

    public String getAgentConfigurationBaseFileName() {
        location.infoT(Category.SYS_SERVER, "getAgentConfigurationBaseFileName()");
        String fileName = this.getCentralInstanceAgent().getAgentConfigurationBaseFileName();
        location.infoT(Category.SYS_SERVER, "getAgentConfigurationBaseFileName()", fileName);
        return fileName;
    }

    public Conf getConf() {
        location.infoT(Category.SYS_SERVER, "getConf()");
        Conf conf = this.getCentralInstanceAgent().getConf();
        location.infoT(Category.SYS_SERVER, "getConf()", "*");
        return conf;
    }

    public String getConfigFileName() {
        location.infoT(Category.SYS_SERVER, "getConfigFileName()");
        String fileName = this.getServerFileName(this.getCentralInstanceAgent().getConfigFileName());
        location.infoT(Category.SYS_SERVER, "getConfigFileName()", fileName);
        return fileName;
    }

    public String getCsmregClient() {
        location.infoT(Category.SYS_SERVER, "getCsmregClient()");
        String csmregClient = this.getCentralInstanceAgent().getCsmregClient();
        location.infoT(Category.SYS_SERVER, "getCsmregClient()", csmregClient);
        return csmregClient;
    }

    public String getCsmregPassword() {
        location.infoT(Category.SYS_SERVER, "getCsmregPassword()");
        String password = this.getCentralInstanceAgent().getCsmregPassword();
        location.infoT(Category.SYS_SERVER, "getCsmregPassword()", "XXXXXX");
        return password;
    }

    public String getCsmregSystem() {
        location.infoT(Category.SYS_SERVER, "getCsmregSystem()");
        String csmregSystem = this.getCentralInstanceAgent().getCsmregSystem();
        location.infoT(Category.SYS_SERVER, "getCsmregSystem()", csmregSystem);
        return csmregSystem;
    }

    public String getCsmregUser() {
        location.infoT(Category.SYS_SERVER, "getCsmregUser()");
        String csmregUser = this.getCentralInstanceAgent().getCsmregUser();
        location.infoT(Category.SYS_SERVER, "getCsmregUser()", csmregUser);
        return csmregUser;
    }

    public String getExecutableFileName() {
        location.infoT(Category.SYS_SERVER, "getExecutableFileName()");
        String fileName = this.getServerFileName(this.getCentralInstanceAgent().getExecutableFileName());
        location.infoT(Category.SYS_SERVER, "getExecutableFileName()", fileName);
        return fileName;
    }

    public InputStream getOutput() {
        location.infoT(Category.SYS_SERVER, "getOutput()");
        InputStream singleAgentOutput = this.getRequestDispatcher().getOutput();
        Hashtable result = this.getResult();
        if (result == null || result.isEmpty()) {
            location.infoT(Category.SYS_SERVER, "getOutput()", "null");
            return null;
        }
        if (result.size() == 1) {
            location.infoT(Category.SYS_SERVER, "getOutput()", "single");
            return singleAgentOutput;
        }
        J2EEAgent centralInstanceAgent = this.getCentralInstanceAgent();
        Object theAgent = null;
        if (centralInstanceAgent != null && result.containsKey(centralInstanceAgent)) {
            singleAgentOutput = (InputStream)result.get(centralInstanceAgent);
            result.remove(centralInstanceAgent);
        }
        Enumeration allAgentsOutput = result.elements();
        if (singleAgentOutput == null) {
            singleAgentOutput = (InputStream)allAgentsOutput.nextElement();
        }
        boolean size = false;
        byte[] buf = new byte[8192];
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        while (singleAgentOutput != null) {
            try {
                int got = singleAgentOutput.read(buf);
                while (got >= 0) {
                    buffer.write(buf, 0, got);
                    got = singleAgentOutput.read(buf);
                }
            }
            catch (Exception e) {
                Category.SYS_SERVER.error(location, "getOutput()", (Object)e);
                location.traceThrowableT(500, "getOutput()", (Throwable)e);
            }
            singleAgentOutput = allAgentsOutput.hasMoreElements() ? allAgentsOutput.nextElement() : null;
        }
        location.infoT(Category.SYS_SERVER, "getOutput()", String.valueOf(result.size()));
        return new ByteArrayInputStream(buffer.toByteArray());
    }

    public boolean isConfigFileValid() {
        location.infoT(Category.SYS_SERVER, "isConfigFileValid()");
        boolean isValid = this.getCentralInstanceAgent().isConfigFileValid();
        location.infoT(Category.SYS_SERVER, "isConfigFileValid()", String.valueOf(isValid));
        return isValid;
    }

    public boolean isExecutableValid() {
        location.infoT(Category.SYS_SERVER, "isExecutableValid()");
        boolean isValid = this.getCentralInstanceAgent().isExecutableValid();
        location.infoT(Category.SYS_SERVER, "isExecutableValid()", String.valueOf(isValid));
        return isValid;
    }

    public boolean isValid() {
        location.infoT(Category.SYS_SERVER, "isValid()");
        boolean isValid = this.getCentralInstanceAgent().isValid();
        location.infoT(Category.SYS_SERVER, "isValid()", String.valueOf(isValid));
        return isValid;
    }

    public boolean makePersistent() {
        location.infoT(Category.SYS_SERVER, "makePersistent()");
        boolean result = this.makePersistent(null);
        location.infoT(Category.SYS_SERVER, "makePersistent()", String.valueOf(result));
        return result;
    }

    public boolean makePersistent(Component parent) {
        location.infoT(Category.SYS_SERVER, "makePersistent(parent)");
        if (parent == null) {
            this.getCentralInstanceAgent().makePersistent();
        } else {
            this.getCentralInstanceAgent().makePersistent(parent);
        }
        if (this.longSID == null) {
            this.longSID = this.getCentralInstanceAgent().getLongSID();
            location.infoT(Category.SYS_SERVER, "makePersistent() : centralInstanceLongSID retrieved", this.longSID);
        }
        Conf centralConf = this.getCentralInstanceAgent().getConf();
        J2EEAgent[] agents = this.getAllAgents();
        int index = 1;
        while (index < agents.length) {
            location.infoT(Category.SYS_SERVER, "makePersistent() : setLongSID(" + (String)this.instanceNames.get(agents[index]) + ")", this.longSID);
            agents[index].setLongSID(this.longSID);
            location.infoT(Category.SYS_SERVER, "makePersistent() : setConf(" + (String)this.instanceNames.get(agents[index]) + ")");
            agents[index].setConf(centralConf);
            ++index;
        }
        this.longSID = null;
        location.infoT(Category.SYS_SERVER, "makePersistent(parent)");
        boolean result = false;
        result = parent == null ? this.getRequestDispatcher().makePersistent() : this.getRequestDispatcher().makePersistent(parent);
        location.infoT(Category.SYS_SERVER, "makePersistent(parent)", String.valueOf(result));
        return result;
    }

    public void printLog() {
        super.printLog();
    }

    public void refresh() {
        location.infoT(Category.SYS_SERVER, "refresh()");
        this.getRequestDispatcher().refresh();
        location.infoT(Category.SYS_SERVER, "refresh()", "done");
    }

    public int register() throws Exception {
        boolean isOK = true;
        location.infoT(Category.SYS_SERVER, "register()");
        J2EEAgent[] agents = this.getAllAgents();
        AgentPersistencyHandler handler = new AgentPersistencyHandler(this.systemName);
        try {
            try {
                handler.open(1);
                handler.setAdminPassword(this.adminPassword);
                handler.setCsmregPassword(this.csmregPassword);
                int index = 0;
                while (index < agents.length) {
                    int result = -1;
                    try {
                        result = agents[index].register();
                    }
                    catch (Throwable t) {
                        Category.SYS_SERVER.error(location, "register()", (Object)t);
                        location.traceThrowableT(500, "register()", t);
                        result = -1;
                    }
                    isOK &= result == 0;
                    handler.setRegistered(this.getInstanceName(agents[index]), result == 0);
                    ++index;
                }
            }
            catch (ConfigurationException e) {
                Category.SYS_SERVER.error(location, "register()", (Object)e);
                location.traceThrowableT(500, "register()", (Throwable)e);
                Object var8_9 = null;
                handler.close();
            }
            Object var8_8 = null;
            handler.close();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            handler.close();
            throw throwable;
        }
        location.infoT(Category.SYS_SERVER, "register()", String.valueOf(isOK));
        return isOK ? 0 : -1;
    }

    public void setAdminPassword(String password) {
        location.infoT(Category.SYS_SERVER, "setAdminPassword()", "XXXXXX");
        this.adminPassword = password;
        this.getRequestDispatcher().setAdminPassword(password);
        location.infoT(Category.SYS_SERVER, "setAdminPassword()");
    }

    public void setConfigFileName(String configFileName) {
        location.infoT(Category.SYS_SERVER, "setConfigFileName()", configFileName);
        this.getRequestDispatcher().setConfigFileName(this.getLocalFileName(configFileName));
        location.infoT(Category.SYS_SERVER, "setConfigFileName()");
    }

    public void setCsmregPassword(String password) {
        location.infoT(Category.SYS_SERVER, "setCsmregPassword()", "XXXXXX");
        this.csmregPassword = password;
        this.getRequestDispatcher().setCsmregPassword(password);
        location.infoT(Category.SYS_SERVER, "setCsmregPassword()");
    }

    public void setExecutableFileName(String executableFileName) {
        String fileName = this.getLocalFileName(executableFileName);
        location.infoT(Category.SYS_SERVER, "setExecutableFileName()", fileName);
        this.getRequestDispatcher().setExecutableFileName(fileName);
        location.infoT(Category.SYS_SERVER, "setExecutableFileName()");
    }

    public int start() throws Exception {
        location.infoT(Category.SYS_SERVER, "start()");
        int rc = this.getRequestDispatcher().start();
        location.infoT(Category.SYS_SERVER, "start()", String.valueOf(rc));
        return rc;
    }

    public int status() throws Exception {
        location.infoT(Category.SYS_SERVER, "status()");
        int rc = this.getRequestDispatcher().status();
        location.infoT(Category.SYS_SERVER, "status()", String.valueOf(rc));
        return rc;
    }

    public int stop() throws Exception {
        location.infoT(Category.SYS_SERVER, "stop()");
        int rc = this.getRequestDispatcher().stop();
        location.infoT(Category.SYS_SERVER, "stop()", String.valueOf(rc));
        return rc;
    }

    public int unregister() throws Exception {
        location.infoT(Category.SYS_SERVER, "unregister()");
        int rc = this.getRequestDispatcher().unregister();
        AgentPersistencyHandler.removeAll();
        location.infoT(Category.SYS_SERVER, "unregister()", String.valueOf(rc));
        return rc;
    }

    public int version() throws Exception {
        location.infoT(Category.SYS_SERVER, "version()");
        int rc = this.getCentralInstanceAgent().version();
        location.infoT(Category.SYS_SERVER, "version()", String.valueOf(rc));
        return rc;
    }

    public void enableCcmsCustomizing(boolean enable) {
        location.infoT(Category.SYS_SERVER, "enableCcmsCustomizing()", String.valueOf(enable));
        this.getRequestDispatcher().enableCcmsCustomizing(enable);
        location.infoT(Category.SYS_SERVER, "enableCcmsCustomizing()");
    }

    public boolean isCcmsCustomizingEnabled() {
        location.infoT(Category.SYS_SERVER, "isCcmsCustomizingEnabled()");
        boolean isEnabled = this.getCentralInstanceAgent().isCcmsCustomizingEnabled();
        location.infoT(Category.SYS_SERVER, "isCcmsCustomizingEnabled()", String.valueOf(isEnabled));
        return isEnabled;
    }

    public void registerCcmsCustomizing() {
        ObjectName monitorService = J2EEServerInformation.getObjectNameForMonitorServiceOnRfcEnabledNode();
        MBeanServer mBeanServer = MonitorServiceRuntime.getMBeanServer();
        location.infoT(Category.SYS_SERVER, "registerCcmsCustomizing()", "MBS : " + mBeanServer.toString() + ", ON : " + monitorService.getCanonicalName());
        try {
            mBeanServer.invoke(monitorService, "registerCcmsCustomizing", new Object[]{this.getSystemID(), this.adminPassword}, new String[]{"java.lang.String", "java.lang.String"});
        }
        catch (Exception e) {
            Category.SYS_SERVER.error(location, "registerCcmsCustomizing()", (Object)e);
            location.traceThrowableT(500, "registerCcmsCustomizing()", (Throwable)e);
        }
        location.infoT(Category.SYS_SERVER, "registerCcmsCustomizing()", "done");
    }

    public void unregisterCcmsCustomizing() {
        ObjectName monitorService = J2EEServerInformation.getObjectNameForMonitorServiceOnRfcEnabledNode();
        MBeanServer mBeanServer = MonitorServiceRuntime.getMBeanServer();
        location.infoT(Category.SYS_SERVER, "unregisterCcmsCustomizing()", "MBS : " + mBeanServer.toString() + ", ON : " + monitorService.getCanonicalName());
        try {
            mBeanServer.invoke(monitorService, "unregisterCcmsCustomizing", new Object[]{this.getSystemID()}, new String[]{"java.lang.String"});
        }
        catch (Exception e) {
            Category.SYS_SERVER.error(location, "unregisterCcmsCustomizing()", (Object)e);
            location.traceThrowableT(500, "unregisterCcmsCustomizing()", (Throwable)e);
        }
        location.infoT(Category.SYS_SERVER, "unregisterCcmsCustomizing()", "done");
    }

    public void setConf(Conf conf) {
        location.infoT(Category.SYS_SERVER, "setConf()", "*");
        this.getRequestDispatcher().setConf(conf);
        location.infoT(Category.SYS_SERVER, "setConf()");
    }

    public void setConfigFile(String configFileName, Conf conf) {
        String fileName = this.getLocalFileName(configFileName);
        location.infoT(Category.SYS_SERVER, "setConfigFile()", fileName + " *");
        this.getRequestDispatcher().setConfigFile(this.getLocalFileName(configFileName), conf);
        location.infoT(Category.SYS_SERVER, "setConfigFile()");
    }

    protected String[] createExecArguments(String[] args) {
        return null;
    }

    private J2EEAgent getCentralInstanceAgent() {
        return this.getAllAgents()[0];
    }

    private String getInstanceName(AbstractAgent agent) {
        if (this.instanceNames == null) {
            return null;
        }
        return (String)this.instanceNames.get(agent);
    }

    private J2EEAgent[] getAllAgents() {
        if (this.allAgents == null) {
            location.infoT(Category.SYS_SERVER, "getAllAgents()");
            this.instanceNames = new HashMap();
            String[] allInstanceNames = J2EEServerInformation.getAllInstanceNames();
            int numberOfInstances = allInstanceNames.length;
            this.allAgents = new J2EEAgent[numberOfInstances];
            int index = 0;
            while (index < numberOfInstances) {
                String theInstanceName = allInstanceNames[index];
                if (theInstanceName.equals(this.getMyInstanceName())) {
                    location.infoT(Category.SYS_SERVER, "getAllAgents() : myInstance", theInstanceName);
                    this.allAgents[index] = this.getMyAgent();
                } else {
                    this.allAgents[index] = J2EEAgentProxy.create(this.systemName, theInstanceName);
                }
                this.instanceNames.put(this.allAgents[index], theInstanceName);
                if (theInstanceName.equals(this.getCentralInstanceName())) {
                    location.infoT(Category.SYS_SERVER, "getAllAgents() : centralInstance", theInstanceName);
                    if (index != 0) {
                        J2EEAgent centralInstanceAgent = this.allAgents[index];
                        this.allAgents[index] = this.allAgents[0];
                        this.allAgents[0] = centralInstanceAgent;
                    }
                }
                ++index;
            }
            location.infoT(Category.SYS_SERVER, "getAllAgents()", String.valueOf(this.allAgents.length));
        }
        return this.allAgents;
    }

    private String getCentralInstanceName() {
        if (this.centralInstanceName == null) {
            this.centralInstanceName = J2EEServerInformation.getCentralInstanceName();
        }
        return this.centralInstanceName;
    }

    private String getMyInstanceName() {
        if (this.myInstanceName == null) {
            this.myInstanceName = J2EEServerInformation.getMyInstanceName();
        }
        return this.myInstanceName;
    }

    private J2EEAgent getMyAgent() {
        if (this.myAgent == null) {
            this.myAgent = new J2EEAgentImpl(this.systemName, J2EEServerInformation.getInstanceNumber(this.getMyInstanceName()));
        }
        return this.myAgent;
    }

    private J2EEAgent getRequestDispatcher() {
        if (this.requestDispatcher == null) {
            ClassLoader cl = (class$com$sap$engine$services$monitor$agent$J2EEAgent == null ? (class$com$sap$engine$services$monitor$agent$J2EEAgent = J2EEServerAgentImpl.class$("com.sap.engine.services.monitor.agent.J2EEAgent")) : class$com$sap$engine$services$monitor$agent$J2EEAgent).getClassLoader();
            this.requestDispatcher = (J2EEAgent)Proxy.newProxyInstance(cl, new Class[]{class$com$sap$engine$services$monitor$agent$J2EEAgent == null ? (class$com$sap$engine$services$monitor$agent$J2EEAgent = J2EEServerAgentImpl.class$("com.sap.engine.services.monitor.agent.J2EEAgent")) : class$com$sap$engine$services$monitor$agent$J2EEAgent}, (InvocationHandler)new RequestDispatcher());
        }
        return this.requestDispatcher;
    }

    private void setResult(Hashtable result) {
        this.dispatchedResult = result;
    }

    private Hashtable getResult() {
        return this.dispatchedResult;
    }

    private String getServerFileName(String fileName) {
        return fileName == null ? null : this.getCentralInstanceNamePrefix() + fileName;
    }

    private String getLocalFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        String prefix = this.getCentralInstanceNamePrefix();
        if (fileName.startsWith(prefix)) {
            fileName = fileName.substring(prefix.length());
        }
        return fileName;
    }

    private String getCentralInstanceNamePrefix() {
        String centralInstanceName = this.getCentralInstanceName();
        return centralInstanceName == null ? "" : "(" + centralInstanceName + ") ";
    }

    private String getSystemID() {
        if (this.longSID != null) {
            return this.longSID;
        }
        String centralInstanceLongSID = this.getCentralInstanceAgent().getLongSID();
        return centralInstanceLongSID != null && centralInstanceLongSID.length() > 0 ? centralInstanceLongSID : this.systemName;
    }

    public static void assureAgentIsRegistered() {
        block7: {
            String me = "assureAgentIsRegistered()";
            try {
                location.infoT(Category.SYS_SERVER, "assureAgentIsRegistered()");
                String instanceName = J2EEServerInformation.getMyInstanceName();
                String systemName = System.getProperty("SAPSYSTEMNAME");
                AgentPersistencyHandler handler = new AgentPersistencyHandler(systemName);
                try {
                    block6: {
                        try {
                            handler.open(1);
                            if (!handler.isRegistrationRequired(instanceName)) break block6;
                            location.infoT(Category.SYS_SERVER, "assureAgentIsRegistered()", "Registration required");
                            J2EEAgentImpl agent = new J2EEAgentImpl(systemName, J2EEServerInformation.getInstanceNumber(instanceName));
                            String centralInstanceName = J2EEServerInformation.getCentralInstanceName();
                            ObjectName centralInstanceON = J2EEServerInformation.getObjectNameForMonitorService(centralInstanceName);
                            J2EEAgent centralInstanceAgent = J2EEAgentProxy.create(systemName, centralInstanceName);
                            Conf conf = centralInstanceAgent.getConf();
                            agent.setConf(conf);
                            String longSID = centralInstanceAgent.getLongSID();
                            agent.setLongSID(longSID);
                            agent.makePersistent();
                            agent.setAdminPassword(handler.getAdminPassword());
                            agent.setCsmregPassword(handler.getCsmregPassword());
                            int rc = agent.register();
                            handler.setRegistered(instanceName, rc == 0);
                        }
                        catch (ConfigurationException e) {
                            Category.SYS_SERVER.error(location, "assureAgentIsRegistered()", (Object)e);
                            location.traceThrowableT(500, "assureAgentIsRegistered()", (Throwable)e);
                            Object var12_14 = null;
                            handler.close();
                            break block7;
                        }
                    }
                    Object var12_13 = null;
                    handler.close();
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    handler.close();
                    throw throwable;
                }
            }
            catch (Throwable t) {
                Category.SYS_SERVER.error(location, "assureAgentIsRegistered()", (Object)t);
                location.traceThrowableT(500, "assureAgentIsRegistered()", t);
            }
        }
        location.infoT(Category.SYS_SERVER, "assureAgentIsRegistered()", "done");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RequestDispatcher
    implements InvocationHandler {
        private RequestDispatcher() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            J2EEAgent[] agents = J2EEServerAgentImpl.this.getAllAgents();
            J2EEServerAgentImpl.this.setResult(null);
            Hashtable<J2EEAgent, Object> allResults = new Hashtable<J2EEAgent, Object>();
            int index = 0;
            while (index < agents.length) {
                String me = "invoke(" + method.getName() + ") " + (String)J2EEServerAgentImpl.this.instanceNames.get(agents[index]);
                location.infoT(Category.SYS_SERVER, me);
                Object result = method.invoke((Object)agents[index], args);
                if (result != null) {
                    allResults.put(agents[index], result);
                }
                location.infoT(Category.SYS_SERVER, me, "done");
                ++index;
            }
            J2EEServerAgentImpl.this.setResult(allResults);
            return agents.length > 0 ? allResults.get(agents[0]) : null;
        }
    }
}

