/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.agent.server;

import com.sap.engine.services.monitor.agent.J2EEAgent;
import com.sap.engine.services.monitor.agent.StringUtils;
import com.sap.engine.services.monitor.agent.server.AbstractAgentImpl;
import com.sap.engine.services.monitor.agent.server.DataCopy;
import com.sap.engine.services.monitor.agent.server.Profile;
import com.sap.engine.services.monitor.agent.server.ProfileCache;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import javax.swing.JOptionPane;

public class J2EEAgentImpl
extends AbstractAgentImpl
implements J2EEAgent {
    private String defaultProfileName = null;
    private String currentProfileName = null;
    private String systemName = null;
    private String instanceNumber = null;
    private String defaultLongSID = null;
    private String currentLongSID = null;
    private boolean currentLongSIDhasChanged = false;
    private String longSIDfromProfile = null;
    private String longSIDfromIniFile = null;
    private byte[] iniFileContents = null;
    private boolean isCcmsCustomizingEnabled = true;
    private static final String LONG_SID = "LongSid";
    private static final String PROFILE_SYSTEM_NAME = "SAPSYSTEMNAME";
    private static final String PROFILE_SAP_SYSTEM = "SAPSYSTEM";

    public J2EEAgentImpl(String systemName, String instanceNumber) {
        super(AbstractAgentImpl.getInstallationInformation().getJ2EEAgentFileName(systemName, instanceNumber), AbstractAgentImpl.getInstallationInformation().getJ2EEAgentConfigurationFileName(systemName, instanceNumber));
        this.systemName = systemName;
        this.instanceNumber = instanceNumber;
        this.setDefaultProfileFileName();
    }

    public boolean isProfileFileValid() {
        Profile profile = this.getProfile();
        return profile == null ? false : profile.isValid();
    }

    public String getProfileName() {
        return this.currentProfileName != null ? this.currentProfileName : this.defaultProfileName;
    }

    public void setProfileName(String profileName) {
        this.currentProfileName = profileName;
    }

    protected String[] createExecArguments(String[] args) {
        if (args == null || args.length == 0) {
            return null;
        }
        int argCount = 3 + args.length;
        String[] execArgs = new String[argCount];
        int argIndex = 0;
        execArgs[argIndex++] = this.getExecutableFileName();
        execArgs[argIndex++] = "-j2ee";
        int index = 0;
        while (index < args.length) {
            execArgs[argIndex++] = args[index];
            ++index;
        }
        execArgs[argIndex++] = this.createProfileArgument();
        return execArgs;
    }

    private String createProfileArgument() {
        String profileName = this.getProfileName();
        String profileArgument = "";
        if (profileName != null) {
            try {
                File file = new File(profileName);
                profileArgument = "pf=" + file.getAbsolutePath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return profileArgument;
    }

    private void setDefaultProfileFileName() {
        this.defaultProfileName = AbstractAgentImpl.getInstallationInformation().getProfileFileName(this.systemName, this.getInstanceNumber());
    }

    public boolean isValid() {
        return this.isProfileFileValid() && super.isValid();
    }

    private String getLongSIDfromProfile() {
        if (this.longSIDfromProfile == null) {
            String longSID = null;
            Profile profile = this.getProfile();
            if (profile != null) {
                longSID = profile.getLongSID();
            }
            this.longSIDfromProfile = longSID == null ? "" : longSID;
        }
        return this.longSIDfromProfile;
    }

    private boolean isLongSIDinDefaultProfile() {
        Profile profile = this.getProfile();
        return profile == null ? false : profile.isLongSIDinDefault();
    }

    private String getLongSIDfromIniFile() {
        if (this.longSIDfromIniFile == null) {
            String longSID = null;
            byte[] iniFileContents = this.getIniFileContents();
            if (iniFileContents == null) {
                return "";
            }
            String lineBuffer = null;
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(iniFileContents)));
                while ((lineBuffer = in.readLine()) != null) {
                    String[] elems = StringUtils.split(lineBuffer);
                    if (elems == null || elems.length != 2 || elems[0].compareToIgnoreCase(LONG_SID) != 0) continue;
                    longSID = elems[1];
                    break;
                }
                in.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.longSIDfromIniFile = longSID == null ? "" : longSID;
        }
        return this.longSIDfromIniFile;
    }

    private Profile getProfile() {
        String profileName = this.getProfileName();
        if (profileName == null) {
            return null;
        }
        return ProfileCache.getProfileCache().getProfile(profileName);
    }

    public String getDefaultProfileDirectory() {
        return AbstractAgentImpl.getInstallationInformation().getProfileDirectory(this.systemName);
    }

    public String getDefaultProfileFileName() {
        return AbstractAgentImpl.getInstallationInformation().getProfileFileName(this.systemName, this.getInstanceNumber());
    }

    public String getLongSID() {
        if (this.defaultLongSID == null && this.currentLongSID == null) {
            this.defaultLongSID = this.getDefaultLongSID();
        }
        return this.currentLongSID != null ? this.currentLongSID : this.defaultLongSID;
    }

    public void setLongSID(String longSID) {
        if (this.currentLongSID == null && longSID == null) {
            return;
        }
        if (this.currentLongSID != null && longSID != null && this.currentLongSID.compareTo(longSID) == 0) {
            return;
        }
        this.currentLongSIDhasChanged = true;
        this.currentLongSID = longSID != null && longSID.length() == 0 ? null : longSID;
    }

    private String getEffectiveLongSID() {
        String effectiveLongSID = this.currentLongSID;
        if (effectiveLongSID == null || effectiveLongSID.compareTo(this.systemName) == 0) {
            effectiveLongSID = "";
        }
        return effectiveLongSID;
    }

    private boolean longSIDhasChanged() {
        boolean hasCurrentLongSID;
        if (!this.currentLongSIDhasChanged) {
            return false;
        }
        if (this.defaultLongSID == null) {
            this.defaultLongSID = this.getDefaultLongSID();
        }
        boolean hasDefaultLongSID = this.defaultLongSID != null && this.defaultLongSID.length() > 0;
        boolean bl = hasCurrentLongSID = this.currentLongSID != null && this.currentLongSID.length() > 0;
        if (!hasDefaultLongSID && !hasCurrentLongSID) {
            return false;
        }
        if (hasDefaultLongSID && hasCurrentLongSID) {
            return this.defaultLongSID.compareToIgnoreCase(this.getEffectiveLongSID()) != 0;
        }
        return true;
    }

    private void deleteLongSID(String fileName) {
        this.deleteLongSID(fileName, LONG_SID);
    }

    private void deleteLongSID(String fileName, String pattern) {
        DataCopy copy = new DataCopy();
        try {
            copy.setDataSource(fileName);
            copy.setDataDestination(fileName);
            copy.setRemove(pattern);
            copy.doCopy();
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
    }

    private void addLongSID() {
        DataCopy copy = new DataCopy();
        String iniFileName = AbstractAgentImpl.getInstallationInformation().getJ2EEAgentIniFileName(this.systemName, this.getInstanceNumber());
        try {
            File file = new File(iniFileName);
            if (file.exists()) {
                copy.setDataSource(iniFileName);
            } else {
                copy.setDataSource(this.getIniFileContents());
            }
            copy.setDataDestination(iniFileName);
            copy.setAddAtEmptyLine(LONG_SID, this.currentLongSID);
            copy.doCopy();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void replaceLongSID() {
        DataCopy copy = new DataCopy();
        String iniFileName = AbstractAgentImpl.getInstallationInformation().getJ2EEAgentIniFileName(this.systemName, this.getInstanceNumber());
        try {
            copy.setDataSource(iniFileName);
            copy.setDataDestination(iniFileName);
            copy.setReplace(LONG_SID, this.currentLongSID);
            copy.doCopy();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public boolean makePersistent(Component parent) {
        boolean deleteLongSID;
        boolean isOK = super.makePersistent(parent);
        if (!isOK) {
            return false;
        }
        this.assureProfileIsExisting();
        if (!this.longSIDhasChanged()) {
            return true;
        }
        boolean addLongSID = this.defaultLongSID == null || this.defaultLongSID.length() == 0;
        boolean bl = deleteLongSID = this.getEffectiveLongSID().length() == 0;
        if (deleteLongSID) {
            if (this.getLongSIDfromProfile().length() != 0) {
                if (this.isLongSIDinDefaultProfile()) {
                    if (parent != null) {
                        Object[] options = new Object[]{"YES", "NO"};
                        int selectedOption = JOptionPane.showOptionDialog(parent, "LongSid in DEFAULT.PFL will not be deleted, continue anyway ?", "LongSid change ignored", 0, 2, null, options, options[1]);
                        if (selectedOption == 1) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                this.deleteLongSID(this.getProfileName(), "alert/longsid");
            }
            if (this.getLongSIDfromIniFile().length() != 0) {
                this.deleteLongSID(AbstractAgentImpl.getInstallationInformation().getJ2EEAgentIniFileName(this.systemName, this.getInstanceNumber()));
            }
            this.defaultLongSID = null;
            this.currentLongSID = null;
        } else if (addLongSID || this.longSIDfromProfile != null && this.longSIDfromProfile.length() != 0) {
            this.addLongSID();
            this.defaultLongSID = this.currentLongSID;
            this.currentLongSID = null;
        } else {
            this.replaceLongSID();
            this.defaultLongSID = this.currentLongSID;
            this.currentLongSID = null;
        }
        this.resetCachedValues();
        this.currentLongSIDhasChanged = false;
        return true;
    }

    private void assureProfileIsExisting() {
        if (this.isProfileFileValid()) {
            return;
        }
        String profileFileName = AbstractAgentImpl.getInstallationInformation().getDialogInstanceProfileFileName(this.systemName, this.getInstanceNumber());
        this.setProfileName(profileFileName);
        Profile profile = ProfileCache.getProfileCache().getProfile(profileFileName);
        if (profile != null && profile.isValid()) {
            return;
        }
        try {
            PrintStream ps = new PrintStream(new FileOutputStream(profileFileName));
            ps.println("SAPSYSTEMNAME = " + this.systemName);
            ps.println("SAPSYSTEM = " + this.getInstanceNumber());
            ps.close();
        }
        catch (Exception e) {
            this.setProfileName(null);
        }
    }

    private void resetCachedValues() {
        this.longSIDfromIniFile = null;
        this.longSIDfromProfile = null;
        this.iniFileContents = null;
    }

    private String getDefaultLongSID() {
        String longSID = this.getLongSIDfromIniFile();
        if (longSID == null || longSID.length() == 0) {
            longSID = this.getLongSIDfromProfile();
        }
        return longSID == null ? "" : longSID;
    }

    private byte[] getIniFileContents() {
        if (this.iniFileContents == null) {
            this.iniFileContents = AbstractAgentImpl.getInstallationInformation().getJ2EEAgentIniFile(this.systemName, this.getInstanceNumber());
        }
        return this.iniFileContents;
    }

    private String getInstanceNumber() {
        return this.instanceNumber;
    }

    public String getDefaultConfigurationDirectory() {
        return AbstractAgentImpl.getInstallationInformation().getJ2EEAgentConfigurationDirectory(this.systemName, this.getInstanceNumber());
    }

    public String getDefaultAgentDirectory() {
        return AbstractAgentImpl.getInstallationInformation().getJ2EEAgentDirectory(this.systemName, this.getInstanceNumber());
    }

    protected void refreshFileNames() {
        this.setDefaultExecutableFileName(AbstractAgentImpl.getInstallationInformation().getJ2EEAgentFileName(this.systemName, this.getInstanceNumber()));
        this.setDefaultConfigFileName(AbstractAgentImpl.getInstallationInformation().getJ2EEAgentConfigurationFileName(this.systemName, this.getInstanceNumber()));
        this.setDefaultProfileFileName();
        if (!this.isConfigFileValid()) {
            this.setConfigFileName(null);
        }
        if (!this.isExecutableValid()) {
            this.setExecutableFileName(null);
        }
        if (!this.isProfileFileValid()) {
            this.setProfileName(null);
        }
    }

    public void enableCcmsCustomizing(boolean enable) {
        this.isCcmsCustomizingEnabled = enable;
    }

    public boolean isCcmsCustomizingEnabled() {
        return this.isCcmsCustomizingEnabled;
    }

    public void registerCcmsCustomizing() {
    }

    public void unregisterCcmsCustomizing() {
    }
}

