/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.agent.server;

import com.sap.engine.services.monitor.agent.InstallationInformation;
import com.sap.engine.services.monitor.agent.StringUtils;
import com.sap.engine.services.monitor.agent.server.ExternalExecutionWrapper;
import com.sap.engine.services.monitor.agent.server.InstallationDefaultsRequester;
import com.sap.engine.services.monitor.agent.server.InstallationInformationImpl;
import com.sap.engine.services.monitor.agent.server.ProfileCache;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class InstallationInformationImpl
implements InstallationInformation {
    private HashMap installedSystems = null;
    private HashSet systemNameFilter = null;
    private static final String separator = File.separator;
    private static String baseDirName = separator + "usr" + separator + "sap";
    private static boolean isWindowsPlatform = false;
    private static boolean baseDirNameIsValidated = false;
    private static final String SYS_DIR = "SYS";
    private static final String CCMS_DIR = "ccms";
    private static final String EXE_DIR = "exe";
    private static final String PROFILE_DIR = "profile";
    private static final String PROFILE_DEFAULT_FILE_NAME = "DEFAULT.PFL";
    private static final String RUN_DIR = "run";
    private static final String RUN_U_DIR = "runU";
    private static final String AGENT_NAME = "sapccmsr";
    private static final String CCMS_CONF_DIR = "sapccmsr";
    private static final String CCMS_AGENT_INI_FILE = "sapccmsr.ini";
    private static final String CCMS_AGENT_CONF_FILE = "csmconf";
    private static final String J2EE_ONLY_CENTRAL_PATTERN = "JC";
    private static final String J2EE_ONLY_DIALOG_PATTERN = "J";
    private static final String COMBINED_SYSTEM_CENTRAL_PATTERN = "DVEBMGS";
    private static final String COMBINED_SYSTEM_DIALOG_PATTERN = "D";
    private static final String REG_EXP_ALPHA_NUM = "[a-zA-Z0-9]";
    private static final String REG_EXP_NUM = "[0-9]";
    private static final String REG_EXP_SID = "[a-zA-Z0-9]{3}";
    private static final String REG_EXP_SYSTEM_PREFIX = "(?i:JC|DVEBMGS|J|D)";
    private static final String REG_EXP_SYSTEM_NUMBER = "[0-9]{2}";
    private static final String REG_EXP_HOST_NAME = "[a-zA-Z0-9]{1,}";
    private static final String REG_EXP_PROFILE_FILE_NAME = "[a-zA-Z0-9]{3}_(?i:JC|DVEBMGS|J|D)[0-9]{2}_[a-zA-Z0-9]{1,}";
    private static final String EXTENSION = ".exe";
    private static final String SAPLOC_PATH_PREFIX = "Path";
    private static final String hostName = System.getProperty("HOSTNAME");
    private static final String currentDirectory = System.getProperty("user.dir");
    private static String saplocDirectory = null;
    private static final boolean isDebugEnabled = new Boolean(System.getProperty("DEBUG_INSTALLATION"));
    private static InstallationInformationImpl singleton = null;
    private static ProfileCache profileCache = null;
    private final HashMap instances = new HashMap();
    static /* synthetic */ Class class$com$sap$engine$services$monitor$agent$server$InstallationInformationImpl;

    private InstallationInformationImpl() {
        String osName = System.getProperty("os.name");
        isWindowsPlatform = osName.startsWith("Windows");
        this.initializeBaseDirectory();
    }

    public static InstallationInformationImpl getInstallationInformation(InstallationDefaultsRequester requester) {
        if (singleton == null) {
            singleton = new InstallationInformationImpl();
            if (!baseDirNameIsValidated) {
                String newBaseDirName;
                if (requester != null && (newBaseDirName = requester.getInstallationBaseDirectory()) != null) {
                    baseDirName = newBaseDirName;
                }
                baseDirNameIsValidated = true;
            }
        }
        return singleton;
    }

    public static InstallationInformationImpl getInstallationInformation() {
        return InstallationInformationImpl.getInstallationInformation(null);
    }

    public void setSystemNameFilter(String[] systemNameFilter) {
        this.systemNameFilter = null;
        if (systemNameFilter == null || systemNameFilter.length == 0) {
            return;
        }
        this.systemNameFilter = new HashSet();
        int index = 0;
        while (index < systemNameFilter.length) {
            this.systemNameFilter.add(systemNameFilter[index]);
            ++index;
        }
    }

    private String getSaplocDirectory() {
        if (saplocDirectory == null) {
            ExternalExecutionWrapper wrapper = new ExternalExecutionWrapper();
            try {
                wrapper.execute(new String[]{"net", "share", "saploc"});
                ByteArrayOutputStream result = wrapper.getOutput();
                BufferedReader r = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(result.toByteArray())));
                String line = r.readLine();
                while (line != null) {
                    String directory;
                    if (line.startsWith(SAPLOC_PATH_PREFIX) && (directory = line.substring(SAPLOC_PATH_PREFIX.length()).trim()) != null && directory.length() > 0) {
                        saplocDirectory = directory;
                        break;
                    }
                    line = r.readLine();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return saplocDirectory;
    }

    private void initializeBaseDirectory() {
        if (baseDirNameIsValidated) {
            return;
        }
        if (this.isWindowsPlatform()) {
            String baseDir = this.getSaplocDirectory();
            if (baseDir != null) {
                baseDirName = baseDir;
                baseDirNameIsValidated = true;
            }
        } else {
            baseDirNameIsValidated = true;
        }
    }

    private HashMap initializeInstalledSystems() {
        HashMap<String, String[]> foundSystems = new HashMap<String, String[]>();
        File baseDir = new File(baseDirName);
        if (baseDir == null) {
            return foundSystems;
        }
        String[] list = baseDir.list();
        if (list == null) {
            return foundSystems;
        }
        int i = 0;
        while (i < list.length) {
            String[] instanceNumbers;
            File dir;
            if (this.isInSystemNameFilter(list[i]) && (dir = new File(baseDir, list[i])) != null && dir.isDirectory() && (instanceNumbers = this.getJ2EEInstancesByThread(dir)) != null) {
                String systemName = dir.getName();
                foundSystems.put(systemName, instanceNumbers);
            }
            ++i;
        }
        return foundSystems;
    }

    public Set getAllSystems() {
        return this.getInstalledSystems().keySet();
    }

    public String[] getInstanceNumbers(String systemName) {
        return (String[])this.getInstalledSystems().get(systemName);
    }

    public void addInstallledSystem(String systemName, String instanceNumber) {
        String[] instanceNumbers = null;
        if (!this.isSystemExisting(systemName) || (instanceNumbers = this.getInstanceNumbers(systemName)) == null) {
            this.getInstalledSystems().put(systemName, new String[]{instanceNumber});
            return;
        }
        int index = 0;
        while (index < instanceNumbers.length) {
            if (instanceNumber.equals(instanceNumbers[index])) {
                return;
            }
            ++index;
        }
        Object[] newInstanceNumbers = new String[instanceNumbers.length + 1];
        System.arraycopy(instanceNumbers, 0, newInstanceNumbers, 0, instanceNumbers.length);
        newInstanceNumbers[instanceNumbers.length] = instanceNumber;
        Arrays.sort(newInstanceNumbers);
        this.getInstalledSystems().put(systemName, newInstanceNumbers);
    }

    public String getJ2EEAgentDirectory(String systemName, String instanceNumber) {
        if (systemName == null || instanceNumber == null) {
            return currentDirectory;
        }
        String directory = baseDirName + separator + systemName + separator + J2EE_ONLY_CENTRAL_PATTERN + instanceNumber + separator + EXE_DIR;
        if ((directory = this.getFullFileName(directory)) != null) {
            return directory;
        }
        directory = baseDirName + separator + systemName + separator + J2EE_ONLY_DIALOG_PATTERN + instanceNumber + separator + EXE_DIR;
        if ((directory = this.getFullFileName(directory)) != null) {
            return directory;
        }
        directory = baseDirName + separator + systemName + separator + COMBINED_SYSTEM_CENTRAL_PATTERN + instanceNumber + separator + EXE_DIR;
        if ((directory = this.getFullFileName(directory)) != null) {
            return directory;
        }
        directory = baseDirName + separator + systemName + separator + COMBINED_SYSTEM_DIALOG_PATTERN + instanceNumber + separator + EXE_DIR;
        if ((directory = this.getFullFileName(directory)) != null) {
            return directory;
        }
        directory = baseDirName + separator + systemName + separator + SYS_DIR + separator + EXE_DIR + separator + RUN_DIR;
        if ((directory = this.getFullFileName(directory)) != null) {
            return directory;
        }
        directory = baseDirName + separator + systemName + separator + SYS_DIR + separator + EXE_DIR + separator + RUN_U_DIR;
        return (directory = this.getFullFileName(directory)) == null ? currentDirectory : directory;
    }

    public String getJ2EEAgentFileName(String systemName, String instanceNumber) {
        String fileName = null;
        if (this.isSystemExisting(systemName)) {
            fileName = this.getAgentFileName(this.getJ2EEAgentDirectory(systemName, instanceNumber));
        }
        if (fileName == null) {
            fileName = this.getAgentFileName(currentDirectory);
        }
        return this.getFullFileName(fileName);
    }

    public String getStandaloneAgentDirectory() {
        String directoryName = this.isWindowsPlatform() ? baseDirName + separator + "prfclog" : baseDirName + separator + CCMS_DIR + separator + "bin";
        File dir = new File(directoryName);
        if (dir != null && dir.exists()) {
            return directoryName;
        }
        return currentDirectory;
    }

    public String getStandaloneAgentFileName() {
        return this.getAgentFileName(this.getStandaloneAgentDirectory());
    }

    private String getAgentFileName(String directory) {
        if (directory == null) {
            directory = currentDirectory;
        }
        String agentFileName = directory + separator + this.getAgentBaseFileName();
        return this.getFullFileName(agentFileName);
    }

    public String getAgentBaseFileName() {
        String agentFileName = "sapccmsr";
        if (isWindowsPlatform) {
            agentFileName = agentFileName + EXTENSION;
        }
        return agentFileName;
    }

    private String getFullFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        File file = new File(fileName);
        if (file == null || !file.exists()) {
            return null;
        }
        return file.getAbsolutePath();
    }

    public String getProfileFileName(String systemName, String instanceNumber, String hostName) {
        if (!this.isInstanceExisting(systemName, instanceNumber)) {
            return null;
        }
        String profileFileName = this.getProfileDirectory(systemName) + separator + systemName + "_" + J2EE_ONLY_CENTRAL_PATTERN + instanceNumber + "_" + hostName;
        if ((profileFileName = this.getFullFileName(profileFileName)) != null) {
            return profileFileName;
        }
        profileFileName = this.getProfileDirectory(systemName) + separator + systemName + "_" + COMBINED_SYSTEM_CENTRAL_PATTERN + instanceNumber + "_" + hostName;
        if ((profileFileName = this.getFullFileName(profileFileName)) != null) {
            return profileFileName;
        }
        profileFileName = this.getProfileDirectory(systemName) + separator + systemName + "_" + J2EE_ONLY_DIALOG_PATTERN + instanceNumber + "_" + hostName;
        if ((profileFileName = this.getFullFileName(profileFileName)) != null) {
            return profileFileName;
        }
        profileFileName = this.getProfileDirectory(systemName) + separator + systemName + "_" + COMBINED_SYSTEM_DIALOG_PATTERN + instanceNumber + "_" + hostName;
        if ((profileFileName = this.getFullFileName(profileFileName)) != null) {
            return profileFileName;
        }
        profileFileName = this.getDialogInstanceProfileFileName(systemName, instanceNumber);
        return this.getFullFileName(profileFileName);
    }

    public String getDialogInstanceProfileFileName(String systemName, String instanceNumber) {
        return this.getJ2EEAgentConfigurationDirectory(systemName, instanceNumber) + File.separator + "SAPCCMSR_" + systemName + "_" + instanceNumber + ".PFL";
    }

    public String getProfileFileName(String systemName, String instanceNumber) {
        String[] hosts = this.getRegisteredHosts(systemName, instanceNumber);
        if (hosts == null || hosts.length == 0) {
            String profileFileName = this.getDialogInstanceProfileFileName(systemName, instanceNumber);
            return this.getFullFileName(profileFileName);
        }
        String selectedHost = hosts[0];
        if (hostName != null) {
            int index = 0;
            while (index < hosts.length) {
                if (hostName.equals(hosts[index])) {
                    selectedHost = hostName;
                    break;
                }
                ++index;
            }
        }
        return this.getProfileFileName(systemName, instanceNumber, selectedHost);
    }

    public String[] getRegisteredHosts(String systemName, String instanceNumber) {
        if (!this.isInstanceExisting(systemName, instanceNumber)) {
            return null;
        }
        String profileDirectory = this.getProfileDirectory(systemName);
        if (profileDirectory == null) {
            return null;
        }
        File profileDirectoryFile = new File(profileDirectory);
        if (profileDirectoryFile == null) {
            return null;
        }
        String[] list = profileDirectoryFile.list();
        if (list == null) {
            return null;
        }
        String j2eeCentralPattern = systemName + "_" + J2EE_ONLY_CENTRAL_PATTERN + instanceNumber + "_";
        String combinedCentralPattern = systemName + "_" + COMBINED_SYSTEM_CENTRAL_PATTERN + instanceNumber + "_";
        String j2eeDialogPattern = systemName + "_" + J2EE_ONLY_DIALOG_PATTERN + instanceNumber + "_";
        String combinedDialogPattern = systemName + "_" + COMBINED_SYSTEM_DIALOG_PATTERN + instanceNumber + "_";
        Vector<String> hosts = new Vector<String>();
        int i = 0;
        while (i < list.length) {
            File file = new File(profileDirectoryFile, list[i]);
            if (file != null) {
                String hostName = null;
                if (list[i].startsWith(j2eeCentralPattern)) {
                    hostName = list[i].substring(j2eeCentralPattern.length());
                } else if (list[i].startsWith(combinedCentralPattern)) {
                    hostName = list[i].substring(combinedCentralPattern.length());
                } else if (list[i].startsWith(j2eeDialogPattern)) {
                    hostName = list[i].substring(j2eeDialogPattern.length());
                } else if (list[i].startsWith(combinedDialogPattern)) {
                    hostName = list[i].substring(combinedDialogPattern.length());
                }
                if (hostName != null && hostName.length() != 0 && hostName.indexOf(46) == -1) {
                    hosts.add(hostName);
                }
            }
            ++i;
        }
        if (hosts.isEmpty()) {
            return null;
        }
        String[] result = new String[hosts.size()];
        return hosts.toArray(result);
    }

    public String getJ2EEAgentConfigurationDirectory(String systemName, String instanceNumber) {
        String directoryName = systemName == null || instanceNumber == null ? currentDirectory : baseDirName + separator + CCMS_DIR + separator + systemName + "_" + instanceNumber + separator + "sapccmsr";
        return this.getFullFileName(directoryName);
    }

    public String getJ2EEAgentConfigurationFileName(String systemName, String instanceNumber) {
        String fileName = null;
        if (this.isInstanceExisting(systemName, instanceNumber)) {
            fileName = this.getAgentConfigurationFileName(this.getJ2EEAgentConfigurationDirectory(systemName, instanceNumber));
        }
        if (fileName == null) {
            fileName = this.getAgentConfigurationFileName(currentDirectory);
        }
        return fileName;
    }

    public String getStandaloneAgentConfigurationDirectory() {
        String directoryName = this.isWindowsPlatform() ? baseDirName + separator + "prfclog" + separator + "sapccmsr" : baseDirName + separator + "tmp" + separator + "sapccmsr";
        File dir = new File(directoryName);
        if (dir != null && dir.exists()) {
            return directoryName;
        }
        return currentDirectory;
    }

    public String getStandaloneAgentConfigurationFileName() {
        String fileName = this.getAgentConfigurationFileName(this.getStandaloneAgentConfigurationDirectory());
        return fileName != null ? fileName : this.getAgentConfigurationFileName(currentDirectory);
    }

    private String getAgentConfigurationFileName(String directory) {
        if (directory == null) {
            directory = currentDirectory;
        }
        String agentConfigFileName = directory + separator + CCMS_AGENT_CONF_FILE;
        return this.getFullFileName(agentConfigFileName);
    }

    public String getAgentConfigurationBaseFileName() {
        return CCMS_AGENT_CONF_FILE;
    }

    public byte[] getJ2EEAgentIniFile(String systemName, String instanceNumber) {
        if (!this.isInstanceExisting(systemName, instanceNumber)) {
            return null;
        }
        String directory = this.getJ2EEAgentConfigurationDirectory(systemName, instanceNumber);
        String agentIniFileName = directory + separator + CCMS_AGENT_INI_FILE;
        InputStream iniSource = null;
        try {
            iniSource = new FileInputStream(agentIniFileName);
        }
        catch (FileNotFoundException e) {
            try {
                agentIniFileName = currentDirectory + separator + CCMS_AGENT_INI_FILE;
                iniSource = new FileInputStream(agentIniFileName);
            }
            catch (FileNotFoundException e1) {
                String filePath = (class$com$sap$engine$services$monitor$agent$server$InstallationInformationImpl == null ? (class$com$sap$engine$services$monitor$agent$server$InstallationInformationImpl = InstallationInformationImpl.class$("com.sap.engine.services.monitor.agent.server.InstallationInformationImpl")) : class$com$sap$engine$services$monitor$agent$server$InstallationInformationImpl).getPackage().getName();
                filePath = filePath.replace('.', '/');
                iniSource = this.getClass().getClassLoader().getResourceAsStream(filePath + "/" + CCMS_AGENT_INI_FILE);
            }
        }
        if (iniSource == null) {
            return null;
        }
        ByteArrayOutputStream contents = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[8192];
            int bytesRead = 0;
            while ((bytesRead = ((InputStream)iniSource).read(buffer)) > 0) {
                contents.write(buffer, 0, bytesRead);
            }
            ((InputStream)iniSource).close();
        }
        catch (IOException e) {
            return null;
        }
        return contents.toByteArray();
    }

    public String getJ2EEAgentIniFileName(String systemName, String instanceNumber) {
        if (!this.isInstanceExisting(systemName, instanceNumber)) {
            return null;
        }
        String directory = this.getJ2EEAgentConfigurationDirectory(systemName, instanceNumber);
        return directory + separator + CCMS_AGENT_INI_FILE;
    }

    public String getProfileDirectory(String systemName) {
        String directoryName = systemName == null ? currentDirectory : baseDirName + separator + systemName + separator + SYS_DIR + separator + PROFILE_DIR;
        return this.getFullFileName(directoryName);
    }

    public String getDefaultProfileFileName() {
        return PROFILE_DEFAULT_FILE_NAME;
    }

    public boolean isSystemExisting(String systemName) {
        return this.getInstalledSystems().containsKey(systemName);
    }

    public boolean isInstanceExisting(String systemName, String instanceNumber) {
        String[] instances = this.getInstanceNumbers(systemName);
        if (instances == null) {
            return false;
        }
        int index = 0;
        while (index < instances.length) {
            if (instances[index].equals(instanceNumber)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public boolean isWindowsPlatform() {
        return isWindowsPlatform;
    }

    public boolean matchesProfileFileNamePattern(String fileName) {
        if (fileName == null) {
            return false;
        }
        return StringUtils.matchesProfileFileNamePattern(fileName);
    }

    private String[] getJ2EEInstancesByThread(File dir) {
        final class J2EEInstanceCollector
        extends Thread {
            private final Integer key;
            private final /* synthetic */ File val$dir;
            private final /* synthetic */ InstallationInformationImpl this$0;

            J2EEInstanceCollector(InstallationInformationImpl this$0, File val$dir) {
                this.this$0 = this$0;
                this.val$dir = val$dir;
                this.key = new Integer(this.hashCode());
            }

            public void run() {
                String[] theInstances = InstallationInformationImpl.access$000(this.this$0, this.val$dir);
                HashMap hashMap = InstallationInformationImpl.access$100(this.this$0);
                synchronized (hashMap) {
                    InstallationInformationImpl.access$100(this.this$0).put(this.key, theInstances);
                }
            }

            public String[] getResult() {
                String[] result = null;
                HashMap hashMap = InstallationInformationImpl.access$100(this.this$0);
                synchronized (hashMap) {
                    result = (String[])InstallationInformationImpl.access$100(this.this$0).get(this.key);
                }
                return result;
            }
        }
        J2EEInstanceCollector collector = new J2EEInstanceCollector(this, dir);
        collector.start();
        try {
            collector.join(2000L);
        }
        catch (InterruptedException e) {
            return null;
        }
        if (collector.isAlive()) {
            collector.interrupt();
        }
        return collector.getResult();
    }

    private String[] getJ2EEInstances(File dir) {
        String[] list;
        if (dir == null) {
            return null;
        }
        File sysDir = null;
        Vector<File> centralServicesDirectories = new Vector<File>();
        Vector<File> instanceDirectories = new Vector<File>();
        if (isDebugEnabled) {
            System.out.println("is getJ2EEInstances :" + dir.getAbsolutePath());
        }
        if ((list = dir.list()) == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            File subDir;
            if (isDebugEnabled) {
                System.out.println("  checking :" + list[i]);
            }
            if ((subDir = new File(dir, list[i])) != null && subDir.isDirectory()) {
                String dirName = subDir.getName().toUpperCase();
                if (dirName.equals(SYS_DIR)) {
                    sysDir = subDir;
                } else if (dirName.startsWith(J2EE_ONLY_CENTRAL_PATTERN) || dirName.startsWith(COMBINED_SYSTEM_CENTRAL_PATTERN) || dirName.startsWith(J2EE_ONLY_DIALOG_PATTERN) || dirName.startsWith(COMBINED_SYSTEM_DIALOG_PATTERN)) {
                    instanceDirectories.add(subDir);
                } else if (dirName.startsWith("SCS")) {
                    centralServicesDirectories.add(subDir);
                }
            }
            ++i;
        }
        if (sysDir != null || !centralServicesDirectories.isEmpty()) {
            if (!this.isSystemDirectory(sysDir)) {
                return null;
            }
            boolean centralServicesDirFound = false;
            int index = 0;
            while (index < centralServicesDirectories.size()) {
                centralServicesDirFound = this.isCentralServicesDirectory((File)centralServicesDirectories.get(index));
                if (centralServicesDirFound) break;
                ++index;
            }
            if (!centralServicesDirFound) {
                return null;
            }
        }
        Vector<String> instances = new Vector<String>();
        int index = 0;
        while (index < instanceDirectories.size()) {
            File instDir = (File)instanceDirectories.get(index);
            if (this.isInstanceDirectory(instDir)) {
                String instDirName = instDir.getName();
                String instanceNumber = instDirName.substring(instDirName.length() - 2);
                try {
                    int instance = Integer.parseInt(instanceNumber);
                    if (instance >= 0 && instance <= 99) {
                        instances.add(instanceNumber);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ++index;
        }
        if (!instances.isEmpty()) {
            Object[] result = new String[instances.size()];
            instances.toArray(result);
            Arrays.sort(result);
            return result;
        }
        return null;
    }

    private boolean isSystemDirectory(File dir) {
        if (dir == null) {
            return false;
        }
        boolean exeDirFound = false;
        boolean globalDirFound = false;
        boolean profileDirFound = false;
        String[] list = dir.list();
        if (isDebugEnabled) {
            System.out.println("  is SystemDirectory :" + dir.getAbsolutePath());
        }
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                File subDir;
                if (isDebugEnabled) {
                    System.out.print("    checking :" + list[i]);
                }
                if ((subDir = new File(dir, list[i])) != null && subDir.isDirectory()) {
                    String dirName = subDir.getName().toLowerCase();
                    if (dirName.equals(EXE_DIR)) {
                        if (isDebugEnabled) {
                            System.out.println(" is EXE");
                        }
                        exeDirFound = true;
                    } else if (dirName.equals("global")) {
                        if (isDebugEnabled) {
                            System.out.println(" is global");
                        }
                        globalDirFound = true;
                    } else if (dirName.equals(PROFILE_DIR)) {
                        if (isDebugEnabled) {
                            System.out.println(" is profile");
                        }
                        profileDirFound = true;
                    } else if (isDebugEnabled) {
                        System.out.println();
                    }
                }
                ++i;
            }
        }
        if (isDebugEnabled) {
            System.out.println("  Result : " + (exeDirFound && globalDirFound && profileDirFound ? " true" : "false"));
        }
        return exeDirFound && globalDirFound && profileDirFound;
    }

    private boolean isInstanceDirectory(File dir) {
        if (dir == null) {
            return false;
        }
        boolean j2eeDirFound = false;
        boolean workDirFound = false;
        String[] list = dir.list();
        if (isDebugEnabled) {
            System.out.println("  is InstanceDirectory :" + dir.getAbsolutePath());
        }
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                File subDir;
                if (isDebugEnabled) {
                    System.out.print("    checking :" + list[i]);
                }
                if ((subDir = new File(dir, list[i])) != null && subDir.isDirectory()) {
                    String dirName = subDir.getName().toLowerCase();
                    if (dirName.equals("j2ee")) {
                        j2eeDirFound = true;
                        if (isDebugEnabled) {
                            System.out.println(" is j2ee");
                        }
                    } else if (dirName.equals("work")) {
                        workDirFound = true;
                        if (isDebugEnabled) {
                            System.out.println(" is work");
                        }
                    } else if (isDebugEnabled) {
                        System.out.println();
                    }
                }
                ++i;
            }
        }
        if (isDebugEnabled) {
            System.out.println("  Result : " + (workDirFound && j2eeDirFound ? " true" : "false"));
        }
        return workDirFound && j2eeDirFound;
    }

    private boolean isCentralServicesDirectory(File dir) {
        if (dir == null) {
            return false;
        }
        boolean workDirFound = false;
        String[] list = dir.list();
        if (isDebugEnabled) {
            System.out.println("  is CentralServices :" + dir.getAbsolutePath());
        }
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                File subDir;
                if (isDebugEnabled) {
                    System.out.print("    checking :" + list[i]);
                }
                if ((subDir = new File(dir, list[i])) != null && subDir.isDirectory()) {
                    String dirName = subDir.getName().toLowerCase();
                    if (dirName.equals("work")) {
                        workDirFound = true;
                        if (isDebugEnabled) {
                            System.out.println(" is work");
                        }
                    } else if (isDebugEnabled) {
                        System.out.println();
                    }
                }
                ++i;
            }
        }
        if (isDebugEnabled) {
            System.out.println("  Result : " + (workDirFound ? " true" : "false"));
        }
        return workDirFound;
    }

    private HashMap getInstalledSystems() {
        if (this.installedSystems == null) {
            this.installedSystems = this.initializeInstalledSystems();
        }
        return this.installedSystems;
    }

    private boolean isInSystemNameFilter(String systemName) {
        if (this.systemNameFilter == null) {
            return true;
        }
        if (systemName == null) {
            return false;
        }
        return this.systemNameFilter.contains(systemName);
    }

    private ProfileCache getProfileCache() {
        if (profileCache == null) {
            profileCache = ProfileCache.getProfileCache();
        }
        return profileCache;
    }

    public String[] allSystems() {
        Set allSystems = this.getAllSystems();
        if (allSystems == null) {
            return null;
        }
        String[] result = new String[allSystems.size()];
        allSystems.toArray(result);
        return result;
    }

    public String[] instanceNumbers(String systemName) {
        return this.getInstanceNumbers(systemName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ String[] access$000(InstallationInformationImpl x0, File x1) {
        return x0.getJ2EEInstances(x1);
    }

    static /* synthetic */ HashMap access$100(InstallationInformationImpl x0) {
        return x0.instances;
    }
}

