/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.agent.server;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class InputBlocker
extends JComponent
implements AWTEventListener {
    private Window theWindow;
    private Component activeComponent;
    private boolean beep;

    protected InputBlocker(Component activeComponent, boolean beep) {
        this.beep = beep;
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (InputBlocker.this.beep) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){});
        this.setActiveComponent(activeComponent);
    }

    public void eventDispatched(AWTEvent event) {
        Object source = event.getSource();
        boolean sourceIsComponent = event.getSource() instanceof Component;
        if (event instanceof KeyEvent && sourceIsComponent && SwingUtilities.windowForComponent((Component)source) == this.theWindow) {
            ((KeyEvent)event).consume();
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public static synchronized InputBlocker getBlocker(Component startComponent, boolean create, boolean beep) {
        RootPaneContainer aContainer = null;
        Component aComponent = startComponent;
        while (aComponent.getParent() != null && !(aComponent instanceof RootPaneContainer)) {
            aComponent = aComponent.getParent();
        }
        if (aComponent instanceof RootPaneContainer) {
            aContainer = (RootPaneContainer)((Object)aComponent);
        }
        if (aContainer != null) {
            if (aContainer.getGlassPane() != null && aContainer.getGlassPane() instanceof InputBlocker) {
                return (InputBlocker)aContainer.getGlassPane();
            }
            if (create) {
                InputBlocker aGlassPane = new InputBlocker(startComponent, beep);
                aContainer.setGlassPane(aGlassPane);
                return aGlassPane;
            }
            return null;
        }
        return null;
    }

    private void setActiveComponent(Component aComponent) {
        this.activeComponent = aComponent;
    }

    public void setVisible(boolean value) {
        if (value) {
            if (this.theWindow == null) {
                this.theWindow = SwingUtilities.windowForComponent(this.activeComponent);
                if (this.theWindow == null && this.activeComponent instanceof Window) {
                    this.theWindow = (Window)this.activeComponent;
                }
            }
            this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
            this.activeComponent = this.theWindow.getFocusOwner();
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
            this.requestFocus();
            super.setVisible(value);
        } else {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            super.setVisible(value);
            if (this.getTopLevelAncestor() != null) {
                this.getTopLevelAncestor().setCursor(null);
            }
        }
    }
}

