/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.agent.server;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class ExternalExecutionWrapper {
    private Process child = null;
    private StreamGobbler errorGobbler = null;
    private StreamGobbler outputGobbler = null;
    private ByteArrayOutputStream exceptionBuffer = null;
    private ByteArrayOutputStream executionResultBuffer = null;
    private String[] executionArguments = null;
    private int EXCEPTION_BUFFER_SIZE = 4096;
    private int EXECUTION_RESULT_BUFFER_SIZE = 4096;

    public int execute(String[] args) throws Exception {
        try {
            this.executionArguments = args;
            this.child = Runtime.getRuntime().exec(args);
        }
        catch (Exception ex) {
            try {
                this.exceptionBuffer = new ByteArrayOutputStream(this.EXCEPTION_BUFFER_SIZE);
                PrintStream ps = new PrintStream(this.exceptionBuffer);
                ex.printStackTrace(ps);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        this.errorGobbler = new StreamGobbler(this.child.getErrorStream());
        this.outputGobbler = new StreamGobbler(this.child.getInputStream());
        this.errorGobbler.start();
        this.outputGobbler.start();
        int retcode = this.child.waitFor();
        return retcode;
    }

    private void printHTMLArguments(String prefix, String color, ByteArrayOutputStream buffer) {
        PrintStream ps = new PrintStream(buffer);
        ps.print("<nobr><b><font color=" + color + ">");
        ps.print(prefix);
        ps.print(this.executionArguments == null || this.executionArguments[0] == null ? "<NULL>" : this.executionArguments[0]);
        if (this.executionArguments != null && this.executionArguments.length > 1) {
            ps.print("(");
            int index = 1;
            while (index < this.executionArguments.length) {
                if (index > 1) {
                    ps.print(",");
                }
                ps.print(this.executionArguments[index] == null ? "<NULL>" : this.executionArguments[index]);
                ++index;
            }
            ps.print(")");
        }
        ps.print("</font></b></nobr><br>");
    }

    private void printArguments(String prefix, String color, ByteArrayOutputStream buffer) {
        PrintStream ps = new PrintStream(buffer);
        ps.print(prefix);
        ps.print(this.executionArguments == null || this.executionArguments[0] == null ? "<NULL>" : this.executionArguments[0]);
        if (this.executionArguments != null && this.executionArguments.length > 1) {
            ps.print("(");
            int index = 1;
            while (index < this.executionArguments.length) {
                if (index > 1) {
                    ps.print(",");
                }
                ps.print(this.executionArguments[index] == null ? "<NULL>" : this.executionArguments[index]);
                ++index;
            }
            ps.print(")");
        }
        ps.println();
    }

    private void appendToResult(ByteArrayOutputStream buf) {
        BufferedReader r = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(buf.toByteArray())));
        if (this.executionResultBuffer == null) {
            this.executionResultBuffer = new ByteArrayOutputStream(this.EXECUTION_RESULT_BUFFER_SIZE);
            if (this.executionResultBuffer == null) {
                return;
            }
        }
        PrintStream ps = new PrintStream(this.executionResultBuffer);
        String line = null;
        try {
            line = r.readLine();
            while (line != null) {
                String trimmedLine = line.trim();
                if (trimmedLine.startsWith("ERROR")) {
                    line = "<font color=red>" + line + "</font>";
                } else if (trimmedLine.startsWith("WARNING")) {
                    line = "<font color=#d08030>" + line + "</font>";
                }
                ps.print("<nobr>" + line + "</nobr><br>");
                line = r.readLine();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public ByteArrayOutputStream getHTMLOutput() {
        if (this.executionResultBuffer == null) {
            this.executionResultBuffer = new ByteArrayOutputStream(this.EXECUTION_RESULT_BUFFER_SIZE);
        }
        if (this.exceptionBuffer != null) {
            this.printHTMLArguments("Exception for : ", "red", this.executionResultBuffer);
            this.appendToResult(this.exceptionBuffer);
            this.exceptionBuffer = null;
        }
        if (this.errorGobbler != null && this.errorGobbler.hasOutput()) {
            this.printHTMLArguments("Error for : ", "red", this.executionResultBuffer);
            this.appendToResult(this.errorGobbler.getOutput());
            this.errorGobbler = null;
        }
        if (this.outputGobbler != null && this.outputGobbler.hasOutput()) {
            this.printHTMLArguments("Output for : ", "blue", this.executionResultBuffer);
            this.appendToResult(this.outputGobbler.getOutput());
            this.outputGobbler = null;
        }
        return this.executionResultBuffer;
    }

    public ByteArrayOutputStream getOutput() {
        if (this.executionResultBuffer == null) {
            this.executionResultBuffer = new ByteArrayOutputStream(this.EXECUTION_RESULT_BUFFER_SIZE);
        }
        try {
            if (this.exceptionBuffer != null) {
                this.printArguments("Exception for : ", "red", this.executionResultBuffer);
                this.exceptionBuffer.writeTo(this.executionResultBuffer);
                this.exceptionBuffer = null;
            }
            if (this.errorGobbler != null && this.errorGobbler.hasOutput()) {
                this.printArguments("Error for : ", "red", this.executionResultBuffer);
                this.errorGobbler.getOutput().writeTo(this.executionResultBuffer);
                this.errorGobbler = null;
            }
            if (this.outputGobbler != null && this.outputGobbler.hasOutput()) {
                this.printArguments("Output for : ", "blue", this.executionResultBuffer);
                this.outputGobbler.getOutput().writeTo(this.executionResultBuffer);
                this.outputGobbler = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.executionResultBuffer;
    }

    private class StreamGobbler
    extends Thread {
        private InputStream is = null;
        private int OUTPUT_BUFFER_SIZE = 4096;
        private ByteArrayOutputStream outputBuffer = null;
        private boolean hasOutput = false;

        StreamGobbler(InputStream is) {
            this.is = is;
            this.outputBuffer = new ByteArrayOutputStream(this.OUTPUT_BUFFER_SIZE);
        }

        /*
         * WARNING - void declaration
         */
        public void run() {
            try {
                int got;
                byte[] buffer = new byte[this.OUTPUT_BUFFER_SIZE];
                while ((got = this.is.read(buffer, 0, buffer.length)) > 0) {
                    void var2_3;
                    this.outputBuffer.write(buffer, 0, (int)var2_3);
                    this.hasOutput = true;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        private ByteArrayOutputStream getOutput() {
            return this.outputBuffer;
        }

        public boolean hasOutput() {
            return this.hasOutput;
        }
    }
}

