/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.agent.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class ExecutableCache {
    private static HashMap cache = new HashMap();
    private static ExecutableCache singleton = null;
    private static final boolean isDebugEnabled = new Boolean(System.getProperty("DEBUG_CACHE"));
    private static final String SEARCH_PATTERN_IN_EXECUTABLE = "sapccmsr";

    private ExecutableCache() {
    }

    public static ExecutableCache getExecutableCache() {
        if (singleton == null) {
            singleton = new ExecutableCache();
        }
        return singleton;
    }

    public boolean isValid(String executableName) {
        if (executableName == null) {
            return false;
        }
        String fullExecutableName = this.getFullName(executableName);
        if (fullExecutableName == null) {
            return false;
        }
        ExecutableFileData data = (ExecutableFileData)cache.get(fullExecutableName);
        if (data == null) {
            try {
                if (isDebugEnabled) {
                    System.out.println("Executable add for : " + fullExecutableName);
                }
                data = new ExecutableFileData(fullExecutableName);
            }
            catch (IOException e) {
                return false;
            }
            if (data == null) {
                return false;
            }
            cache.put(fullExecutableName, data);
        }
        if (isDebugEnabled) {
            System.out.print("Executable get for : " + fullExecutableName + " : ");
            System.out.println(data == null ? false : data.isValid());
        }
        return data == null ? false : data.isValid();
    }

    public void setValid(String executableName) {
        if (executableName == null) {
            return;
        }
        String fullExecutableName = this.getFullName(executableName);
        if (fullExecutableName == null) {
            return;
        }
        ExecutableFileData data = (ExecutableFileData)cache.get(fullExecutableName);
        if (data == null) {
            try {
                data = new ExecutableFileData(fullExecutableName, true);
            }
            catch (IOException e) {
                return;
            }
            if (data == null) {
                return;
            }
        }
        data.setValid();
        cache.put(fullExecutableName, data);
        if (isDebugEnabled) {
            System.out.println("Executable setValid for : " + fullExecutableName);
        }
    }

    private String getFullName(String profileName) {
        if (profileName == null) {
            return null;
        }
        File file = new File(profileName);
        String fullName = file.getAbsolutePath();
        if (new File(fullName).isDirectory()) {
            return null;
        }
        return fullName;
    }

    private class ExecutableFileData {
        private String fileName = null;
        private boolean isValid = false;
        private long lastUpdate = 0L;
        private long fileLength = 0L;

        public ExecutableFileData(String executableName) throws IOException {
            this.init(executableName);
            this.isValid = this.containsPattern(executableName);
        }

        public ExecutableFileData(String executableName, boolean isValid) throws IOException {
            this.init(executableName);
            this.isValid = isValid;
        }

        public boolean isValid() {
            File file = new File(this.fileName);
            if (this.lastUpdate != file.lastModified() || this.fileLength != file.length()) {
                if (isDebugEnabled) {
                    System.out.println("Executable update for : " + this.fileName);
                }
                this.isValid = this.containsPattern(this.fileName);
                this.lastUpdate = file.lastModified();
            }
            return this.isValid;
        }

        public void setValid() {
            this.isValid = true;
        }

        private void init(String executableName) throws FileNotFoundException {
            File file = new File(executableName);
            if (file == null) {
                throw new FileNotFoundException();
            }
            this.lastUpdate = file.lastModified();
            this.fileLength = file.length();
            this.fileName = executableName;
        }

        private boolean containsPattern(String fileName) {
            int pos = -1;
            FileInputStream f = null;
            try {
                f = new FileInputStream(fileName);
                BoyerMooreByteSearch bs = new BoyerMooreByteSearch(f, ExecutableCache.SEARCH_PATTERN_IN_EXECUTABLE);
                pos = bs.search();
                f.close();
            }
            catch (IOException e) {
                pos = -1;
            }
            return pos != -1;
        }
    }

    public class BoyerMooreByteSearch {
        private byte[] pattern;
        private int patternLength;
        private int[] charJump;
        private int[] matchJump;
        private InputStream s;
        private int absolutePos = 0;
        private byte[] buffer = new byte[16384];
        private int remainingBytesInBuffer = 0;

        public BoyerMooreByteSearch(InputStream s, String pattern) {
            this.s = s;
            this.genPatternFromCharArray(pattern.toCharArray());
            this.computeJumps();
            this.computeMatchJumps();
        }

        private int reloadBuffer() throws IOException {
            int remainingBytes = this.remainingBytesInBuffer;
            int bytesRead = this.s.read(this.buffer, remainingBytes, this.buffer.length - remainingBytes);
            if (bytesRead < 0) {
                return -1;
            }
            this.remainingBytesInBuffer = remainingBytes + bytesRead;
            return this.remainingBytesInBuffer;
        }

        private void moveToStart(int pos) {
            int remainingBytes = this.remainingBytesInBuffer - pos;
            System.arraycopy(this.buffer, pos, this.buffer, 0, remainingBytes);
            this.absolutePos += pos;
            this.remainingBytesInBuffer = remainingBytes;
        }

        public int search() {
            int pos = -1;
            try {
                while (pos == -1) {
                    if (this.remainingBytesInBuffer < this.patternLength) {
                        this.reloadBuffer();
                    }
                    if (this.remainingBytesInBuffer < this.patternLength) {
                        return -1;
                    }
                    pos = this.search(this.buffer, 0, this.remainingBytesInBuffer);
                    if (pos >= 0) {
                        int foundPos = this.absolutePos + pos;
                        this.moveToStart(pos + this.patternLength);
                        return foundPos;
                    }
                    this.moveToStart(this.remainingBytesInBuffer - this.patternLength + 1);
                }
            }
            catch (IOException e) {
                return -1;
            }
            return -1;
        }

        private final int min(int i1, int i2) {
            return i1 < i2 ? i1 : i2;
        }

        private final int max(int i1, int i2) {
            return i1 > i2 ? i1 : i2;
        }

        private final void genPatternFromByteArray(byte[] bytes, int off, int length) {
            this.patternLength = length;
            this.pattern = new byte[length];
            int i = 1;
            int j = off;
            while (i <= length) {
                this.pattern[i] = bytes[j];
                ++i;
                ++j;
            }
        }

        private final void genPatternFromCharArray(char[] chars) {
            this.patternLength = chars.length;
            this.pattern = new byte[this.patternLength + 1];
            int i = 1;
            while (i <= this.patternLength) {
                this.pattern[i] = chars[i - 1] > '\u007f' ? (byte)(chars[i - 1] - 256 & 0xFF) : (byte)(chars[i - 1] & 0xFF);
                ++i;
            }
        }

        private final void computeJumps() {
            this.charJump = new int[256];
            int i = 0;
            while (i < 255) {
                this.charJump[i] = this.patternLength;
                ++i;
            }
            int k = 1;
            while (k <= this.patternLength) {
                this.charJump[this.pattern[k] + 128] = this.patternLength - k;
                ++k;
            }
        }

        /*
         * Unable to fully structure code
         */
        private void computeMatchJumps() {
            back = new int[this.patternLength + 2];
            this.matchJump = new int[this.patternLength + 2];
            mm = 2 * this.patternLength;
            k = 1;
            while (k <= this.patternLength) {
                this.matchJump[k] = mm - k;
                ++k;
            }
            k = this.patternLength;
            q = this.patternLength + 1;
            while (k > 0) {
                back[k] = q;
                while (q <= this.patternLength && this.pattern[k] != this.pattern[q]) {
                    this.matchJump[q] = this.min(this.matchJump[q], this.patternLength - k);
                    q = back[q];
                }
                --k;
                --q;
            }
            k = 1;
            while (k <= q) {
                this.matchJump[k] = this.min(this.matchJump[k], this.patternLength + q - k);
                ++k;
            }
            qq = back[q];
            ** GOTO lbl32
            {
                this.matchJump[q] = this.min(this.matchJump[q], qq - q + this.patternLength);
                ++q;
                do {
                    if (q <= qq) continue block4;
                    qq = back[qq];
lbl32:
                    // 2 sources

                } while (q <= this.patternLength);
            }
        }

        public int getPatternLength() {
            return this.patternLength;
        }

        private int search(byte[] byteString) {
            return this.search(byteString, 0, byteString.length);
        }

        private int search(byte[] byteString, int offset, int length) {
            int j = this.patternLength + offset;
            int k = this.patternLength;
            int len = this.min(byteString.length, offset + length);
            while (j <= len && k > 0) {
                if (byteString[j - 1] == this.pattern[k]) {
                    --j;
                    --k;
                    continue;
                }
                j += this.max(this.charJump[byteString[j - 1] + 128], this.matchJump[k]);
                k = this.patternLength;
            }
            if (k == 0) {
                return j;
            }
            return -1;
        }
    }
}

