/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.agent.server;

import com.sap.engine.services.monitor.agent.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class DataCopy {
    private String sourceFileName = null;
    private String sourceBackupFileName = null;
    private FileInputStream inputStream = null;
    private FileOutputStream outputStream = null;
    private BufferedReader source = null;
    private PrintStream dest = null;
    private String removePattern = null;
    private String replaceKeyPattern = null;
    private String replaceValue = null;
    private String addKeyPattern = null;
    private String addValue = null;
    private boolean appendValue = true;
    private boolean backupSucceeded = false;

    public void setDataSource(String fileName) throws FileNotFoundException {
        String backupFileName = fileName;
        this.backupSucceeded = false;
        File backupFile = null;
        this.sourceFileName = fileName;
        File sourceFile = new File(fileName);
        if (!sourceFile.exists()) {
            throw new FileNotFoundException(fileName);
        }
        int retry = 0;
        while (retry < 5) {
            backupFile = new File(backupFileName = backupFileName + "~");
            this.backupSucceeded = sourceFile.renameTo(backupFile);
            if (this.backupSucceeded) {
                this.sourceBackupFileName = backupFileName;
                break;
            }
            ++retry;
        }
        try {
            if (this.backupSucceeded) {
                this.inputStream = new FileInputStream(backupFile);
                this.source = new BufferedReader(new InputStreamReader(this.inputStream));
            } else {
                this.source = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.getFileContents(sourceFile))));
            }
        }
        catch (FileNotFoundException e) {
            if (this.backupSucceeded) {
                this.undoBackup();
            }
            throw e;
        }
    }

    public void setDataSource(byte[] source) {
        this.source = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(source)));
    }

    public void setDataDestination(String fileName) throws FileNotFoundException {
        try {
            this.outputStream = new FileOutputStream(fileName);
            this.dest = new PrintStream(this.outputStream);
        }
        catch (FileNotFoundException e) {
            if (this.backupSucceeded) {
                this.undoBackup();
            }
            throw e;
        }
    }

    public void setRemove(String pattern) {
        this.removePattern = pattern;
    }

    public void setAdd(String key, String value) {
        this.addKeyPattern = key;
        this.addValue = value;
        this.appendValue = true;
    }

    public void setAddAtEmptyLine(String key, String value) {
        this.addKeyPattern = key;
        this.addValue = value;
        this.appendValue = false;
    }

    public void setReplace(String key, String value) {
        this.replaceKeyPattern = key;
        this.replaceValue = value;
    }

    public void doCopy() {
        this.doCopy(false);
    }

    public void doCopy(boolean keepSourceFile) {
        block12: {
            String lineBuffer = null;
            boolean addHasBeenProcessed = false;
            boolean addLine = this.addKeyPattern != null;
            boolean addAtEmptyLine = this.addKeyPattern != null && !this.appendValue;
            boolean replaceLine = this.replaceKeyPattern != null;
            boolean deleteLine = this.removePattern != null;
            try {
                while ((lineBuffer = this.source.readLine()) != null) {
                    String[] elems;
                    if (addAtEmptyLine && !addHasBeenProcessed && lineBuffer.length() == 0) {
                        this.dest.println(this.addKeyPattern + " " + this.addValue);
                        addHasBeenProcessed = true;
                        continue;
                    }
                    if (!addLine && (elems = StringUtils.split(lineBuffer)) != null) {
                        if (replaceLine && elems[0].compareToIgnoreCase(this.replaceKeyPattern) == 0) {
                            this.dest.println(elems[0] + " " + this.replaceValue);
                            continue;
                        }
                        if (deleteLine && elems[0].compareToIgnoreCase(this.removePattern) == 0) continue;
                    }
                    this.dest.println(lineBuffer);
                }
                if (addLine && !addHasBeenProcessed) {
                    this.dest.println(this.addKeyPattern + " " + this.addValue);
                }
                this.dest.close();
                this.source.close();
                if (this.inputStream != null) {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                if (this.outputStream != null) {
                    this.outputStream.close();
                    this.outputStream = null;
                }
            }
            catch (Exception e) {
                if (!this.backupSucceeded) break block12;
                this.undoBackup();
                return;
            }
        }
        if (this.backupSucceeded && this.sourceBackupFileName != null) {
            if (keepSourceFile) {
                this.undoBackup();
            } else {
                File backupFile = new File(this.sourceBackupFileName);
                backupFile.delete();
            }
        }
    }

    private byte[] getFileContents(File file) {
        ByteArrayOutputStream contents = new ByteArrayOutputStream();
        try {
            FileInputStream source = new FileInputStream(file);
            byte[] buffer = new byte[8192];
            int bytesRead = 0;
            while ((bytesRead = source.read(buffer)) > 0) {
                contents.write(buffer, 0, bytesRead);
            }
            source.close();
        }
        catch (IOException e) {
            return null;
        }
        return contents.toByteArray();
    }

    private void undoBackup() {
        if (this.sourceFileName != null && this.sourceBackupFileName != null) {
            File backupFile = new File(this.sourceBackupFileName);
            File sourceFile = new File(this.sourceFileName);
            backupFile.renameTo(sourceFile);
        }
    }
}

