/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.agent.server;

import com.sap.engine.services.monitor.agent.server.Conf;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class ConfigFileCache {
    private static HashMap cache = new HashMap();
    private static ConfigFileCache singleton = null;
    private static final boolean isDebugEnabled = new Boolean(System.getProperty("DEBUG_CACHE"));

    private ConfigFileCache() {
    }

    public static ConfigFileCache getConfigFileCache() {
        if (singleton == null) {
            singleton = new ConfigFileCache();
        }
        return singleton;
    }

    public Conf getConf(String configFileName) {
        if (configFileName == null) {
            return null;
        }
        String fullConfigFileName = this.getFullName(configFileName);
        if (fullConfigFileName == null) {
            return null;
        }
        ConfigFileData data = (ConfigFileData)cache.get(fullConfigFileName);
        if (data == null) {
            try {
                if (isDebugEnabled) {
                    System.out.println("Config add for : " + fullConfigFileName);
                }
                data = new ConfigFileData(fullConfigFileName);
            }
            catch (IOException e) {
                return null;
            }
            if (data == null) {
                return null;
            }
            cache.put(fullConfigFileName, data);
        }
        Conf conf = null;
        try {
            conf = data.getConf();
        }
        catch (IOException e) {
            conf = null;
        }
        if (isDebugEnabled) {
            System.out.println("Config get for : " + fullConfigFileName);
        }
        return conf;
    }

    private String getFullName(String configFileName) {
        if (configFileName == null) {
            return null;
        }
        File file = new File(configFileName);
        String fullName = file.getAbsolutePath();
        if (new File(fullName).isDirectory()) {
            return null;
        }
        return fullName;
    }

    private class ConfigFileData {
        private String fileName = null;
        private Conf config = null;
        private long lastUpdate = 0L;
        private long fileLength = 0L;

        public ConfigFileData(String configFileName) throws IOException {
            this.config = new Conf(configFileName);
            this.fileName = configFileName;
            File file = new File(configFileName);
            this.lastUpdate = file.lastModified();
            this.fileLength = file.length();
        }

        public Conf getConf() throws IOException {
            File file = new File(this.fileName);
            if (this.lastUpdate != file.lastModified() || this.fileLength != file.length()) {
                if (isDebugEnabled) {
                    System.out.println("Config update for : " + this.fileName);
                }
                this.config = new Conf(this.fileName);
                this.lastUpdate = file.lastModified();
            }
            return this.config;
        }
    }
}

