/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.agent.server;

import com.sap.engine.services.monitor.agent.server.Password;
import com.sap.engine.services.monitor.agent.server.Properties;
import com.sap.engine.services.monitor.agent.server.Section;
import com.sap.engine.services.monitor.agent.server.Sections;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;

public class Conf
extends Sections {
    private static final String[] defaultSections = new String[]{"CEN_CONFIG", "CEN_ADMIN_USER", "CEN_GATEWAY", "CEN_CSMREG_USER"};
    private static final String[][] defaultKeys = new String[][]{{"CEN_SYSID"}, {"CEN_ADMIN_R3NAME", "CEN_ADMIN_MSHOST", "CEN_ADMIN_LOADBALANCING", "CEN_ADMIN_ASHOST", "CEN_ADMIN_SYSNR", "CEN_ADMIN_CLIENT", "CEN_ADMIN_USERID", "CEN_ADMIN_PASSWORD", "CEN_ADMIN_LANG", "CEN_ADMIN_TRACE"}, {"CEN_GATEWAY_HOST", "CEN_GATEWAY_SYSNR"}, {"CEN_CSMREG_R3NAME", "CEN_CSMREG_MSHOST", "CEN_CSMREG_LOADBALANCING", "CEN_CSMREG_ASHOST", "CEN_CSMREG_SYSNR", "CEN_CSMREG_CLIENT", "CEN_CSMREG_USERID", "CEN_CSMREG_PASSWORD", "CEN_CSMREG_LANG", "CEN_CSMREG_TRACE"}};
    private Boolean isValid = null;
    private boolean skipPasswordValues = true;

    public static String[] getDefaultSections() {
        return defaultSections;
    }

    public static String[] getDefaultSectionKeys(String section) {
        int i = 0;
        while (i < defaultSections.length) {
            if (defaultSections[i].equals(section)) {
                return defaultKeys[i];
            }
            ++i;
        }
        return null;
    }

    public Conf() {
    }

    public Conf(File configFile) throws IOException {
        this.load(configFile);
    }

    public Conf(String configFile) throws IOException {
        this.load(configFile);
    }

    public Conf(byte[] buf) throws IOException {
        this.load(new InputStreamReader(new ByteArrayInputStream(buf)));
    }

    private static String stripBlanks(String in) {
        int start = 0;
        int end = in.length();
        while (start < end && in.charAt(start) == ' ') {
            ++start;
        }
        while (start < end && in.charAt(end - 1) == ' ') {
            --end;
        }
        return in.substring(start, end);
    }

    public void load(String configFile) throws IOException {
        this.load(new File(configFile));
    }

    public void load(File configFile) throws IOException {
        FileInputStream inputStream = null;
        inputStream = new FileInputStream(configFile);
        this.load(inputStream);
        if (inputStream != null) {
            inputStream.close();
        }
    }

    public void load(FileInputStream r) throws IOException {
        this.load(new InputStreamReader(r));
    }

    public void load(InputStreamReader r) throws IOException {
        this.load(new BufferedReader(r));
    }

    public void load(BufferedReader r) throws IOException {
        Section section = null;
        Properties props = null;
        String line = r.readLine();
        while (line != null) {
            if (!line.startsWith("#")) {
                String name;
                int i = line.indexOf("=");
                if (i >= 0) {
                    if (props != null) {
                        name = line.substring(0, i);
                        String value = line.substring(i + 1);
                        if (name.endsWith("PASSWORD")) {
                            props.setProperty(Conf.stripBlanks(name), new Password(Conf.stripBlanks(value)));
                        } else {
                            props.setProperty(Conf.stripBlanks(name), Conf.stripBlanks(value));
                        }
                    }
                } else {
                    name = Conf.stripBlanks(line);
                    if (name.equals(".")) {
                        props = null;
                    } else if (!name.equals("")) {
                        section = this.getSection(name);
                        props = section.getProperties();
                    }
                }
            }
            line = r.readLine();
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        this.printAll(ps);
        return out.toByteArray();
    }

    public String getPropertyValue(String sectionName, String propertyKey) {
        if (sectionName == null || propertyKey == null) {
            return null;
        }
        Section section = this.getSection(sectionName);
        if (section == null) {
            return null;
        }
        Properties properties = section.getProperties();
        if (properties == null) {
            return null;
        }
        return properties.getPropertyString(propertyKey);
    }

    public void setProperty(String sectionName, String propertyKey, String propertyValue) {
        if (sectionName == null || propertyKey == null) {
            return;
        }
        Section section = this.getSection(sectionName);
        if (section == null) {
            return;
        }
        Properties properties = section.getProperties();
        if (properties == null) {
            return;
        }
        properties.setProperty(propertyKey, propertyValue);
    }

    void printProperties(PrintStream out, Properties props, String propName) {
        String[] keys = props.keys();
        String[] values = props.values();
        out.println(propName);
        int i = 0;
        while (i < keys.length) {
            out.println("  " + keys[i] + "=" + (this.skipPasswordValues && keys[i].endsWith("PASSWORD") ? "" : values[i]));
            ++i;
        }
        out.println(".");
        out.println();
    }

    void printAll(PrintStream out) {
        boolean oldSkip = this.skipPasswordValues;
        this.skipPasswordValues = false;
        this.print(out);
        this.skipPasswordValues = oldSkip;
    }

    void print(PrintStream out) {
        if (this.sections != null) {
            Iterator i = this.sections.iterator();
            while (i.hasNext()) {
                Section s = (Section)i.next();
                this.printProperties(out, s.getProperties(), s.getName());
            }
        }
    }

    public boolean isValid() {
        if (this.isValid == null) {
            boolean isValid = this.getPropertyValue("CEN_CONFIG", "CEN_SYSID") != null && this.getPropertyValue("CEN_ADMIN_USER", "CEN_ADMIN_SYSNR") != null && this.getPropertyValue("CEN_GATEWAY", "CEN_GATEWAY_SYSNR") != null && this.getPropertyValue("CEN_CSMREG_USER", "CEN_CSMREG_SYSNR") != null;
            this.isValid = new Boolean(isValid);
        }
        return this.isValid;
    }
}

