/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.agent.server;

import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.services.monitor.agent.J2EEAgent;
import com.sap.engine.services.monitor.agent.server.AgentPersistencyHandler;
import com.sap.engine.services.monitor.agent.server.Conf;
import com.sap.engine.services.monitor.agent.server.J2EEAgentProxy;
import com.sap.engine.services.monitor.agent.server.J2EEServerInformation;
import com.sap.engine.services.monitor.common.MonitorServiceRuntime;
import com.sap.engine.services.rfcengine.BundleConfiguration;
import com.sap.mw.jco.JCO;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class CcmsRegistration {
    private static Location location = Location.getLocation((Class)(class$com$sap$engine$services$monitor$agent$server$CcmsRegistration == null ? (class$com$sap$engine$services$monitor$agent$server$CcmsRegistration = CcmsRegistration.class$("com.sap.engine.services.monitor.agent.server.CcmsRegistration")) : class$com$sap$engine$services$monitor$agent$server$CcmsRegistration));
    private static final int NUMBER_OF_PROCESSES = 6;
    private static final boolean IS_LOCAL_BUNDLE = false;
    private static final boolean IS_UNICODE = false;
    static /* synthetic */ Class class$com$sap$engine$services$monitor$agent$server$CcmsRegistration;

    public void registerCcmsCustomizing(String systemID, String cenSystemPassword) {
        String me = "registerCcmsCustomizing(" + systemID + ", XXXXXX)";
        location.infoT(Category.SYS_SERVER, me);
        BundleConfiguration bundle = this.createBundle(systemID, cenSystemPassword);
        this.registerBundle(bundle);
        this.registerRemoteRFCDestination(bundle, systemID);
        AgentPersistencyHandler handler = new AgentPersistencyHandler(this.getSystemName());
        try {
            try {
                handler.open(1);
                handler.setBundle(this.getSystemName(), bundle);
            }
            catch (ConfigurationException e) {
                Category.SYS_SERVER.error(location, me, (Object)e);
                location.traceThrowableT(500, me, (Throwable)e);
                Object var8_7 = null;
                handler.close();
            }
            Object var8_6 = null;
            handler.close();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            handler.close();
            throw throwable;
        }
        location.infoT(Category.SYS_SERVER, me, "done");
    }

    public void unregisterCcmsCustomizing(String systemID) {
        String me = "unregisterCcmsCustomizing(" + systemID + ")";
        location.infoT(Category.SYS_SERVER, me);
        AgentPersistencyHandler handler = new AgentPersistencyHandler(this.getSystemName());
        try {
            try {
                handler.open(0);
                BundleConfiguration bundle = handler.getBundle(this.getSystemName());
                this.unregisterBundle(bundle);
                this.unregisterRemoteRFCDestination(bundle);
            }
            catch (ConfigurationException e) {
                Category.SYS_SERVER.error(location, me, (Object)e);
                location.traceThrowableT(500, me, (Throwable)e);
                Object var6_7 = null;
                handler.close();
            }
            Object var6_6 = null;
            handler.close();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            handler.close();
            throw throwable;
        }
        location.infoT(Category.SYS_SERVER, me, "done");
    }

    private BundleConfiguration createBundle(String systemID, String password) {
        BundleConfiguration bundle = null;
        try {
            J2EEAgent centralInstanceAgent = J2EEAgentProxy.create(this.getSystemName(), J2EEServerInformation.getCentralInstanceName());
            Conf centralConf = centralInstanceAgent.getConf();
            if (centralConf != null) {
                bundle = new BundleConfiguration();
                bundle.setProgramId("SAP.CCMS.J2EE." + systemID);
                bundle.setGatewayHost(centralConf.getPropertyValue("CEN_GATEWAY", "CEN_GATEWAY_HOST"));
                bundle.setGatewayServer("sapgw" + centralConf.getPropertyValue("CEN_GATEWAY", "CEN_GATEWAY_SYSNR"));
                bundle.setProcessesNumber(6);
                bundle.setLocal(false);
                bundle.setApplicationServerHost(centralConf.getPropertyValue("CEN_ADMIN_USER", "CEN_ADMIN_ASHOST"));
                bundle.setSystemNumber(centralConf.getPropertyValue("CEN_ADMIN_USER", "CEN_ADMIN_SYSNR"));
                bundle.setLogonLanguage(centralConf.getPropertyValue("CEN_ADMIN_USER", "CEN_ADMIN_LANG"));
                bundle.setLogonClient(centralConf.getPropertyValue("CEN_ADMIN_USER", "CEN_ADMIN_CLIENT"));
                bundle.setLogonUser(centralConf.getPropertyValue("CEN_ADMIN_USER", "CEN_ADMIN_USERID"));
                bundle.setLogonPassword(password);
                bundle.setUnicodeState(false);
            }
        }
        catch (Throwable t) {
            Category.SYS_SERVER.error(location, "getBundle()", (Object)t);
            location.traceThrowableT(500, "getBundle()", t);
            bundle = null;
        }
        return bundle;
    }

    private boolean registerBundle(BundleConfiguration bundle) {
        String me = "registerBundleOperation(" + bundle.getProgramId() + ")";
        location.infoT(Category.SYS_SERVER, me);
        ObjectName rfcRuntime = J2EEServerInformation.getRfcRuntimeObjectName();
        bundle.setRunningState(false);
        MBeanServer mBeanServer = MonitorServiceRuntime.getMBeanServer();
        Boolean result = new Boolean(false);
        try {
            String op = this.isBundleRegistered(bundle) ? "changeBundleConfiguration" : "addBundle";
            location.infoT(Category.SYS_SERVER, me, op);
            result = (Boolean)mBeanServer.invoke(rfcRuntime, op, new Object[]{bundle}, new String[]{bundle.getClass().getName()});
        }
        catch (Exception e) {
            Category.SYS_SERVER.error(location, me, (Object)e);
            location.traceThrowableT(500, me, (Throwable)e);
        }
        location.infoT(Category.SYS_SERVER, me, String.valueOf(result));
        return result;
    }

    private boolean unregisterBundle(BundleConfiguration bundle) {
        String me = "unregisterBundleOperation(" + bundle.getProgramId() + ")";
        location.infoT(Category.SYS_SERVER, me);
        ObjectName rfcRuntime = J2EEServerInformation.getRfcRuntimeObjectName();
        bundle.setRunningState(false);
        MBeanServer mBeanServer = MonitorServiceRuntime.getMBeanServer();
        Boolean result = new Boolean(true);
        try {
            if (this.isBundleRegistered(bundle)) {
                location.infoT(Category.SYS_SERVER, me, "is registered");
                result = (Boolean)mBeanServer.invoke(rfcRuntime, "removeBundle", new Object[]{bundle.getProgramId()}, new String[]{"java.lang.String"});
            }
        }
        catch (Exception e) {
            Category.SYS_SERVER.error(location, me, (Object)e);
            location.traceThrowableT(500, me, (Throwable)e);
            result = Boolean.FALSE;
        }
        location.infoT(Category.SYS_SERVER, me, String.valueOf(result));
        return result;
    }

    private boolean isBundleRegistered(BundleConfiguration bundle) {
        MBeanServer mBeanServer = MonitorServiceRuntime.getMBeanServer();
        ObjectName rfcRuntime = J2EEServerInformation.getRfcRuntimeObjectName();
        BundleConfiguration[] bundles = null;
        try {
            location.infoT(Category.SYS_SERVER, "isBundleRegistered()", rfcRuntime.getCanonicalName());
            bundles = (BundleConfiguration[])mBeanServer.invoke(rfcRuntime, "getConfigurations", null, null);
            location.infoT(Category.SYS_SERVER, "isBundleRegistered()", bundles != null ? String.valueOf(bundles.length) : "null");
        }
        catch (Exception e) {
            Category.SYS_SERVER.error(location, "isBundleRegistered()", (Object)e);
            location.traceThrowableT(500, "isBundleRegistered()", (Throwable)e);
            bundles = null;
        }
        if (bundles == null || bundles.length == 0) {
            return false;
        }
        int index = 0;
        while (index < bundles.length) {
            if (bundle.getProgramId().equals(bundles[index].getProgramId())) {
                location.infoT(Category.SYS_SERVER, "isBundleRegistered()", "true");
                return true;
            }
            ++index;
        }
        location.infoT(Category.SYS_SERVER, "isBundleRegistered()", "false");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void registerRemoteRFCDestination(BundleConfiguration bundle, String systemID) {
        JCO.Client jcoClient = null;
        JCO.Function remoteFunction = null;
        JCO.ParameterList input = null;
        JCO.Repository repository = null;
        try {
            try {
                location.infoT(Category.SYS_SERVER, "registerRemoteRFCDestination()");
                String rfcDestination = bundle.getProgramId();
                jcoClient = this.createClient(bundle);
                repository = new JCO.Repository("RFC", jcoClient);
                remoteFunction = repository.getFunctionTemplate("SALF_RFC_MODIFY_DESTINATION").getFunction();
                input = remoteFunction.getImportParameterList();
                input.setValue(rfcDestination, "DESTINATION");
                input.setValue("M", "ACTION");
                input.setValue("X", "AUTHORITY_CHECK");
                input.setValue("R", "METHOD");
                input.setValue(bundle.getProgramId(), "PROGRAM");
                input.setValue("", "SERVER");
                input.setValue(" ", "TRACE");
                input.setValue("Remote J2EE Customizing for " + systemID, "DESCRIPTION");
                input.setValue(bundle.getGatewayHost(), "GWHOST");
                input.setValue(bundle.getGatewayServer(), "GWSERVICE");
                input.setValue("2", "RFCUNICODE");
                jcoClient.execute(remoteFunction);
                remoteFunction = repository.getFunctionTemplate("SCSM_CSMSEGM_UPDATE").getFunction();
                input = remoteFunction.getImportParameterList();
                input.setValue("X", "UPDATE_J2EEDEST_ONLY");
                input.setValue("X", "DO_A_COMMIT");
                input.setValue(systemID, "J2EE_SYSID");
                input.setValue(rfcDestination, "J2EE_CUSTOMIZE_DESTINAT");
                jcoClient.execute(remoteFunction);
            }
            catch (Exception e) {
                Category.SYS_SERVER.error(location, "registerRemoteRFCDestination()", (Object)e);
                location.traceThrowableT(500, "registerRemoteRFCDestination()", (Throwable)e);
                Object var9_10 = null;
                if (jcoClient == null) return;
                jcoClient.disconnect();
                return;
            }
            Object var9_9 = null;
            if (jcoClient == null) return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (jcoClient == null) throw throwable;
            jcoClient.disconnect();
            throw throwable;
        }
        jcoClient.disconnect();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unregisterRemoteRFCDestination(BundleConfiguration bundle) {
        JCO.Client jcoClient = null;
        JCO.Function remoteFunction = null;
        JCO.ParameterList input = null;
        JCO.Repository repository = null;
        try {
            try {
                location.infoT(Category.SYS_SERVER, "unregisterRemoteRFCDestination()");
                String rfcDestination = bundle.getProgramId();
                jcoClient = this.createClient(bundle);
                repository = new JCO.Repository("RFC", jcoClient);
                remoteFunction = repository.getFunctionTemplate("SALF_RFC_MODIFY_DESTINATION").getFunction();
                input = remoteFunction.getImportParameterList();
                input.setValue(rfcDestination, "DESTINATION");
                input.setValue("D", "ACTION");
                input.setValue("X", "AUTHORITY_CHECK");
                input.setValue("R", "METHOD");
                input.setValue(bundle.getProgramId(), "PROGRAM");
                jcoClient.execute(remoteFunction);
            }
            catch (Exception e) {
                Category.SYS_SERVER.error(location, "registerRemoteRFCDestination()", (Object)e);
                location.traceThrowableT(500, "registerRemoteRFCDestination()", (Throwable)e);
                Object var8_9 = null;
                if (jcoClient == null) return;
                jcoClient.disconnect();
                return;
            }
            Object var8_8 = null;
            if (jcoClient == null) return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (jcoClient == null) throw throwable;
            jcoClient.disconnect();
            throw throwable;
        }
        jcoClient.disconnect();
    }

    private JCO.Client createClient(BundleConfiguration bundle) {
        location.infoT(Category.SYS_SERVER, "createClient()");
        JCO.Client jcoClient = null;
        String sClient = bundle.getLogonClient();
        String sUserid = bundle.getLogonUser();
        String sPassword = bundle.getLogonPassword();
        String sLanguage = bundle.getLogonLanguage();
        String sHost = bundle.getApplicationServerHost();
        String sSysnr = bundle.getSystemNumber();
        jcoClient = JCO.createClient((String)sClient, (String)sUserid, (String)sPassword, (String)sLanguage, (String)sHost, (String)sSysnr);
        jcoClient.connect();
        location.infoT(Category.SYS_SERVER, "createClient()", "done");
        return jcoClient;
    }

    private String getSystemName() {
        return System.getProperty("SAPSYSTEMNAME");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

