/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.agent.server;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.InvalidValueException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.NoWriteAccessException;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.engine.services.monitor.common.MonitorRuntimeControlImpl;
import com.sap.engine.services.rfcengine.BundleConfiguration;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;

public class AgentPersistencyHandler {
    private static final String CCMS_AGENT = "ccms.agent";
    private static final String CCMS_AGENT_REGISTRATION = "registration";
    private static final String REGISTERED = "registered";
    private static final String RETRIES = "retries";
    private static final String CCMS_AGENT_CCMS_CUSTOMIZING = "ccms.customizing";
    private static final String LONG_SID = "longSID";
    private static final String RFC_BUNDLE = "bundle";
    private static final String APPLICATION_SERVER_HOST = "application.server.host";
    private static final String GATEWAY_HOST = "gateway.host";
    private static final String GATEWAY_SERVICE = "gateway.service";
    private static final String LOCAL = "local";
    private static final String LOGON_CLIENT = "logon.client";
    private static final String LOGON_LANGUAGE = "logon.language";
    private static final String LOGON_PASSWORD = "logon.password";
    private static final String LOGON_USER = "logon.user";
    private static final String PROCESSES_NUMBER = "processes.number";
    private static final String PROGRAM_ID = "program.id";
    private static final String SYSTEM_NUMBER = "system.number";
    private static final String UNICODE = "unicode";
    private static final int MAX_RETRIES = 3;
    private static final String CCMS_AGENT_ADMIN_PASSWORD = "admin.password";
    private static final String CCMS_AGENT_CSMREG_PASSWORD = "csmreg.password";
    private Configuration configuration = null;
    private int accessMode;
    private boolean isRollbackRequired = false;
    private boolean configurationChanged = false;
    private ConfigurationHandler configurationHandler = null;
    private String systemName = null;
    private static Location location = Location.getLocation((Class)(class$com$sap$engine$services$monitor$agent$server$AgentPersistencyHandler == null ? (class$com$sap$engine$services$monitor$agent$server$AgentPersistencyHandler = AgentPersistencyHandler.class$("com.sap.engine.services.monitor.agent.server.AgentPersistencyHandler")) : class$com$sap$engine$services$monitor$agent$server$AgentPersistencyHandler));
    static /* synthetic */ Class class$com$sap$engine$services$monitor$agent$server$AgentPersistencyHandler;

    public AgentPersistencyHandler(String systemName) {
        this.systemName = systemName;
    }

    private String getSystemName() {
        return this.systemName;
    }

    public void open(int accessMode) throws ConfigurationException {
        String me = "open(" + accessMode + ")";
        location.infoT(Category.SYS_SERVER, me);
        if (this.getConfigurationHandler() == null) {
            ConfigurationException e = new ConfigurationException("Could not register configuration handler");
            Category.SYS_SERVER.error(location, me, (Object)e);
            location.traceThrowableT(500, me, (Throwable)e);
            throw e;
        }
        try {
            this.configuration = this.getConfigurationHandler().openConfiguration(CCMS_AGENT, accessMode);
        }
        catch (ConfigurationException e) {
            Category.SYS_SERVER.error(location, me, (Object)e);
            location.traceThrowableT(500, me, (Throwable)e);
            throw e;
        }
        this.accessMode = accessMode;
        this.isRollbackRequired = false;
        this.configurationChanged = false;
        location.infoT(Category.SYS_SERVER, me, "done");
    }

    public void commit() throws ConfigurationException {
        String me = "commit()";
        location.infoT(Category.SYS_SERVER, "commit()");
        try {
            this.checkForWrite();
            this.getConfigurationHandler().commit();
            this.configurationChanged = false;
            this.isRollbackRequired = false;
        }
        catch (ConfigurationException e) {
            Category.SYS_SERVER.error(location, "commit()", (Object)e);
            location.traceThrowableT(500, "commit()", (Throwable)e);
            throw e;
        }
        location.infoT(Category.SYS_SERVER, "commit()", "done");
    }

    public void rollback() throws ConfigurationException {
        String me = "rollback()";
        location.infoT(Category.SYS_SERVER, "rollback()");
        try {
            this.checkForWrite();
            this.getConfigurationHandler().rollback();
            this.configurationChanged = false;
            this.isRollbackRequired = false;
        }
        catch (ConfigurationException e) {
            Category.SYS_SERVER.error(location, "rollback()", (Object)e);
            location.traceThrowableT(500, "rollback()", (Throwable)e);
            throw e;
        }
        location.infoT(Category.SYS_SERVER, "rollback()", "done");
    }

    /*
     * Loose catch block
     */
    public void close() {
        block11: {
            block9: {
                String me = "close()";
                location.infoT(Category.SYS_SERVER, "close()");
                if (!this.configurationChanged) break block9;
                if (this.isRollbackRequired) {
                    this.getConfigurationHandler().rollback();
                    break block9;
                }
                this.getConfigurationHandler().commit();
            }
            Object var4_2 = null;
            try {
                this.getConfigurationHandler().closeAllConfigurations();
            }
            catch (ConfigurationException e2) {
                Category.SYS_SERVER.error(location, "close()", (Object)e2);
                location.traceThrowableT(500, "close()", (Throwable)e2);
            }
            this.configuration = null;
            this.configurationChanged = false;
            this.isRollbackRequired = false;
            {
                break block11;
                catch (ConfigurationException e) {
                    Category.SYS_SERVER.error(location, "close()", (Object)e);
                    location.traceThrowableT(500, "close()", (Throwable)e);
                    Object var4_3 = null;
                    try {
                        this.getConfigurationHandler().closeAllConfigurations();
                    }
                    catch (ConfigurationException e2) {
                        Category.SYS_SERVER.error(location, "close()", (Object)e2);
                        location.traceThrowableT(500, "close()", (Throwable)e2);
                    }
                    this.configuration = null;
                    this.configurationChanged = false;
                    this.isRollbackRequired = false;
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    this.getConfigurationHandler().closeAllConfigurations();
                }
                catch (ConfigurationException e2) {
                    Category.SYS_SERVER.error(location, "close()", (Object)e2);
                    location.traceThrowableT(500, "close()", (Throwable)e2);
                }
                this.configuration = null;
                this.configurationChanged = false;
                this.isRollbackRequired = false;
                throw throwable;
            }
        }
        location.infoT(Category.SYS_SERVER, "close()", "done");
    }

    private void checkForRead() throws ConfigurationException {
        if (this.configuration == null) {
            String me = "checkForRead()";
            ConfigurationException e = new ConfigurationException("Configuration not open for read");
            Category.SYS_SERVER.error(location, "checkForRead()", (Object)e);
            location.traceThrowableT(500, "checkForRead()", (Throwable)e);
            throw e;
        }
    }

    private void checkForWrite() throws ConfigurationException {
        String me = "checkForWrite()";
        if (this.configuration == null) {
            ConfigurationException e = new ConfigurationException("Configuration not open for write");
            Category.SYS_SERVER.error(location, "checkForWrite()", (Object)e);
            location.traceThrowableT(500, "checkForWrite()", (Throwable)e);
            throw e;
        }
        if (this.accessMode != 1) {
            ConfigurationException e = new ConfigurationException("Configuration open for read not write");
            Category.SYS_SERVER.error(location, "checkForWrite()", (Object)e);
            location.traceThrowableT(500, "checkForWrite()", (Throwable)e);
            throw e;
        }
    }

    public BundleConfiguration getBundle(String systemName) throws ConfigurationException {
        String me = "getBundle(" + systemName + ")";
        location.infoT(Category.SYS_SERVER, me);
        this.checkForRead();
        BundleConfiguration bundle = null;
        PropertySheet props = this.getBundleConfigurationPropertySheet(systemName);
        bundle = new BundleConfiguration();
        bundle.setProgramId((String)props.getPropertyEntry(PROGRAM_ID).getValue());
        bundle.setGatewayHost((String)props.getPropertyEntry(GATEWAY_HOST).getValue());
        bundle.setGatewayServer((String)props.getPropertyEntry(GATEWAY_SERVICE).getValue());
        bundle.setProcessesNumber(Integer.valueOf((String)props.getPropertyEntry(PROCESSES_NUMBER).getValue()).intValue());
        bundle.setLocal(Boolean.valueOf((String)props.getPropertyEntry(LOCAL).getValue()).booleanValue());
        bundle.setApplicationServerHost((String)props.getPropertyEntry(APPLICATION_SERVER_HOST).getValue());
        bundle.setSystemNumber((String)props.getPropertyEntry(SYSTEM_NUMBER).getValue());
        bundle.setLogonLanguage((String)props.getPropertyEntry(LOGON_LANGUAGE).getValue());
        bundle.setLogonClient((String)props.getPropertyEntry(LOGON_CLIENT).getValue());
        bundle.setLogonUser((String)props.getPropertyEntry(LOGON_USER).getValue());
        bundle.setLogonPassword((String)props.getPropertyEntry(LOGON_PASSWORD).getValue());
        bundle.setUnicodeState(Boolean.valueOf((String)props.getPropertyEntry(UNICODE).getValue()).booleanValue());
        location.infoT(Category.SYS_SERVER, me, "done");
        return bundle;
    }

    /*
     * Loose catch block
     */
    private ConfigurationHandler getConfigurationHandler() {
        block11: {
            block12: {
                if (this.configurationHandler != null) break block11;
                String me = "getConfigurationHandler()";
                location.infoT(Category.SYS_SERVER, "getConfigurationHandler()");
                ConfigurationHandler configurationHandler = MonitorRuntimeControlImpl.getConfigurationHandler();
                String[] rootNames = configurationHandler.getAllRootNames();
                boolean rootExists = false;
                int i = 0;
                while (i < rootNames.length) {
                    if (CCMS_AGENT.equals(rootNames[i])) {
                        rootExists = true;
                        break;
                    }
                    ++i;
                }
                if (!rootExists) {
                    location.infoT(Category.SYS_SERVER, "getConfigurationHandler()", "creating \"ccmsAgent\" configuration root....");
                    configurationHandler.createRootConfiguration(CCMS_AGENT);
                    configurationHandler.commit();
                    location.infoT(Category.SYS_SERVER, "getConfigurationHandler()", "creating of \"ccmsAgent\" configuration root finished succesfully.");
                }
                this.configurationHandler = configurationHandler;
                Object var7_7 = null;
                try {
                    configurationHandler.closeAllConfigurations();
                }
                catch (ConfigurationException e2) {
                    Category.SYS_SERVER.error(location, "getConfigurationHandler()", (Object)e2);
                    location.traceThrowableT(500, "getConfigurationHandler()", (Throwable)e2);
                }
                break block12;
                {
                    catch (ConfigurationException e) {
                        Category.SYS_SERVER.error(location, "getConfigurationHandler()", (Object)e);
                        location.traceThrowableT(500, "getConfigurationHandler()", (Throwable)e);
                        Object var7_8 = null;
                        try {
                            configurationHandler.closeAllConfigurations();
                        }
                        catch (ConfigurationException e2) {
                            Category.SYS_SERVER.error(location, "getConfigurationHandler()", (Object)e2);
                            location.traceThrowableT(500, "getConfigurationHandler()", (Throwable)e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    try {
                        configurationHandler.closeAllConfigurations();
                    }
                    catch (ConfigurationException e2) {
                        Category.SYS_SERVER.error(location, "getConfigurationHandler()", (Object)e2);
                        location.traceThrowableT(500, "getConfigurationHandler()", (Throwable)e2);
                    }
                    throw throwable;
                }
            }
            location.infoT(Category.SYS_SERVER, "getConfigurationHandler()", "done");
        }
        return this.configurationHandler;
    }

    private boolean isConfigured() throws ConfigurationException {
        this.checkForRead();
        return this.getCustomizingConfiguration() != null;
    }

    public void setRegistered(String instanceName, boolean isRegistered) throws ConfigurationException {
        String me;
        block6: {
            me = "setRegistered(" + instanceName + ", " + String.valueOf(isRegistered) + ")";
            location.infoT(Category.SYS_SERVER, me);
            this.checkForWrite();
            boolean rollback = false;
            try {
                PropertySheet props = this.getRegistrationPropertySheet(instanceName);
                this.setPropertySheetEntry(props, REGISTERED, isRegistered);
                if (isRegistered) {
                    this.setPropertySheetEntry(props, RETRIES, 3);
                    break block6;
                }
                int retries = 3;
                try {
                    retries = Integer.valueOf((String)props.getPropertyEntry(RETRIES).getValue());
                }
                catch (Exception e) {
                    Category.SYS_SERVER.error(location, me, (Object)e);
                    location.traceThrowableT(500, me, (Throwable)e);
                }
                if (retries > 0) {
                    --retries;
                }
                this.setPropertySheetEntry(props, RETRIES, retries);
            }
            catch (ConfigurationException e) {
                Category.SYS_SERVER.error(location, me, (Object)e);
                location.traceThrowableT(500, me, (Throwable)e);
                this.setRollbackRequired();
                throw e;
            }
        }
        location.infoT(Category.SYS_SERVER, me, "done");
    }

    public boolean isRegistered(String instanceName) throws ConfigurationException {
        String me = "isRegistered(" + instanceName + ")";
        location.infoT(Category.SYS_SERVER, me);
        this.checkForRead();
        PropertySheet props = this.getRegistrationPropertySheet(instanceName);
        boolean isRegistered = Boolean.valueOf((String)props.getPropertyEntry(REGISTERED).getValue());
        location.infoT(Category.SYS_SERVER, me, String.valueOf(isRegistered));
        return isRegistered;
    }

    /*
     * Loose catch block
     */
    public static void removeAll() {
        block13: {
            String me = "removeAll()";
            location.infoT(Category.SYS_SERVER, "removeAll()");
            ConfigurationHandler configurationHandler = MonitorRuntimeControlImpl.getConfigurationHandler();
            if (configurationHandler == null) {
                return;
            }
            Configuration agentConfiguration = configurationHandler.openConfiguration(CCMS_AGENT, 1);
            agentConfiguration.deleteConfiguration();
            configurationHandler.commit();
            Object var6_4 = null;
            try {
                configurationHandler.closeAllConfigurations();
            }
            catch (ConfigurationException e2) {
                Category.SYS_SERVER.error(location, "removeAll()", (Object)e2);
                location.traceThrowableT(500, "removeAll()", (Throwable)e2);
            }
            break block13;
            {
                catch (NameNotFoundException e) {
                    location.infoT(Category.SYS_SERVER, "removeAll()", e.getMessage());
                    Object var6_5 = null;
                    try {
                        configurationHandler.closeAllConfigurations();
                    }
                    catch (ConfigurationException e2) {
                        Category.SYS_SERVER.error(location, "removeAll()", (Object)e2);
                        location.traceThrowableT(500, "removeAll()", (Throwable)e2);
                    }
                    break block13;
                }
                catch (Exception e) {
                    Category.SYS_SERVER.error(location, "removeAll()", (Object)e);
                    location.traceThrowableT(500, "removeAll()", (Throwable)e);
                    try {
                        configurationHandler.rollback();
                    }
                    catch (ConfigurationException e1) {
                        Category.SYS_SERVER.error(location, "removeAll()", (Object)e1);
                        location.traceThrowableT(500, "removeAll()", (Throwable)e1);
                    }
                    Object var6_6 = null;
                    try {
                        configurationHandler.closeAllConfigurations();
                    }
                    catch (ConfigurationException e2) {
                        Category.SYS_SERVER.error(location, "removeAll()", (Object)e2);
                        location.traceThrowableT(500, "removeAll()", (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    configurationHandler.closeAllConfigurations();
                }
                catch (ConfigurationException e2) {
                    Category.SYS_SERVER.error(location, "removeAll()", (Object)e2);
                    location.traceThrowableT(500, "removeAll()", (Throwable)e2);
                }
                throw throwable;
            }
        }
        location.infoT(Category.SYS_SERVER, "removeAll()", "done");
    }

    public void setLongSID(String longSID) throws ConfigurationException {
        String me = "setLongSID(" + longSID + ")";
        location.infoT(Category.SYS_SERVER, me);
        this.checkForWrite();
        if (longSID != null) {
            this.setConfigurationProperty(LONG_SID, longSID);
        }
        location.infoT(Category.SYS_SERVER, me, "done");
    }

    public String getLongSID() throws ConfigurationException {
        String me = "getLongSID()";
        location.infoT(Category.SYS_SERVER, "getLongSID()");
        this.checkForRead();
        String longSID = null;
        try {
            longSID = this.getConfigurationProperty(LONG_SID);
        }
        catch (ConfigurationException e) {
            longSID = null;
        }
        location.infoT(Category.SYS_SERVER, "getLongSID()", longSID != null ? longSID : "null");
        return longSID;
    }

    public void setAdminPassword(String password) throws ConfigurationException {
        String me = "setAdminPassword()";
        location.infoT(Category.SYS_SERVER, "setAdminPassword()");
        this.checkForWrite();
        if (password != null) {
            this.setRegistrationSecureProperty(CCMS_AGENT_ADMIN_PASSWORD, password);
        }
        location.infoT(Category.SYS_SERVER, "setAdminPassword()", "done");
    }

    public String getAdminPassword() throws ConfigurationException {
        String me = "getAdminPassword()";
        location.infoT(Category.SYS_SERVER, "getAdminPassword()");
        this.checkForRead();
        String password = null;
        try {
            password = this.getRegistrationProperty(CCMS_AGENT_ADMIN_PASSWORD);
        }
        catch (ConfigurationException e) {
            password = null;
        }
        location.infoT(Category.SYS_SERVER, "getAdminPassword()", "done");
        return password;
    }

    public void setCsmregPassword(String password) throws ConfigurationException {
        String me = "setCsmregPassword()";
        location.infoT(Category.SYS_SERVER, "setCsmregPassword()");
        this.checkForWrite();
        if (password != null) {
            this.setRegistrationSecureProperty(CCMS_AGENT_CSMREG_PASSWORD, password);
        }
        location.infoT(Category.SYS_SERVER, "setCsmregPassword()", "done");
    }

    public String getCsmregPassword() throws ConfigurationException {
        String me = "getCsmregPassword()";
        location.infoT(Category.SYS_SERVER, "getCsmregPassword()");
        this.checkForRead();
        String password = null;
        try {
            password = this.getRegistrationProperty(CCMS_AGENT_CSMREG_PASSWORD);
        }
        catch (ConfigurationException e) {
            password = null;
        }
        location.infoT(Category.SYS_SERVER, "getCsmregPassword()", "done");
        return password;
    }

    private String getConfigurationProperty(String key) throws ConfigurationException {
        PropertySheet props = this.getConfigurationPropertySheet();
        return (String)props.getPropertyEntry(key).getValue();
    }

    private String getRegistrationProperty(String key) throws ConfigurationException {
        String[] values = this.getRegistrationProperties(new String[]{key});
        return values == null ? null : values[0];
    }

    private String[] getRegistrationProperties(String[] keys) throws ConfigurationException {
        if (keys == null) {
            return null;
        }
        int noOfKeys = keys.length;
        String[] values = new String[keys.length];
        PropertySheet props = this.getRegistrationPropertySheet();
        int index = 0;
        while (index < noOfKeys) {
            try {
                values[index] = (String)props.getPropertyEntry(keys[index]).getValue();
            }
            catch (NameNotFoundException e) {
                values[index] = null;
            }
            ++index;
        }
        return values;
    }

    private void setConfigurationProperty(String key, String value) throws ConfigurationException {
        boolean rollback = false;
        try {
            PropertySheet props = this.getConfigurationPropertySheet();
            this.setPropertySheetEntry(props, key, value);
        }
        catch (ConfigurationException e) {
            this.setRollbackRequired();
            String me = "setConfigurationProperty(" + key + ", " + value + ")";
            Category.SYS_SERVER.error(location, me, (Object)e);
            location.traceThrowableT(500, me, (Throwable)e);
            throw e;
        }
    }

    private void setRegistrationProperty(String key, String value) throws ConfigurationException {
        try {
            PropertySheet props = this.getRegistrationPropertySheet();
            this.setPropertySheetEntry(props, key, value);
        }
        catch (ConfigurationException e) {
            this.setRollbackRequired();
            String me = "setRegistrationProperty(" + key + ", " + value + ")";
            Category.SYS_SERVER.error(location, me, (Object)e);
            location.traceThrowableT(500, me, (Throwable)e);
            throw e;
        }
    }

    private void setRegistrationSecureProperty(String key, String value) throws ConfigurationException {
        try {
            PropertySheet props = this.getRegistrationPropertySheet();
            this.setPropertySheetSecureEntry(props, key, value);
        }
        catch (ConfigurationException e) {
            this.setRollbackRequired();
            String me = "setRegistrationSecureProperty(" + key + ", " + value + ")";
            Category.SYS_SERVER.error(location, me, (Object)e);
            location.traceThrowableT(500, me, (Throwable)e);
            throw e;
        }
    }

    public void setBundle(String systemName, BundleConfiguration bundle) throws ConfigurationException {
        String me = "setBundle(" + systemName + ", " + bundle.getProgramId() + ")";
        location.infoT(Category.SYS_SERVER, me);
        this.checkForWrite();
        try {
            PropertySheet props = this.getBundleConfigurationPropertySheet(systemName);
            this.setPropertySheetEntry(props, PROGRAM_ID, bundle.getProgramId());
            this.setPropertySheetEntry(props, GATEWAY_HOST, bundle.getGatewayHost());
            this.setPropertySheetEntry(props, GATEWAY_SERVICE, bundle.getGatewayServer());
            this.setPropertySheetEntry(props, PROCESSES_NUMBER, bundle.getProcessesNumber());
            this.setPropertySheetEntry(props, LOCAL, bundle.isLocal());
            this.setPropertySheetEntry(props, APPLICATION_SERVER_HOST, bundle.getApplicationServerHost());
            this.setPropertySheetEntry(props, SYSTEM_NUMBER, bundle.getSystemNumber());
            this.setPropertySheetEntry(props, LOGON_LANGUAGE, bundle.getLogonLanguage());
            this.setPropertySheetEntry(props, LOGON_CLIENT, bundle.getLogonClient());
            this.setPropertySheetEntry(props, LOGON_USER, bundle.getLogonUser());
            this.setPropertySheetSecureEntry(props, LOGON_PASSWORD, bundle.getLogonPassword());
            this.setPropertySheetEntry(props, UNICODE, bundle.isUnicode());
        }
        catch (ConfigurationException e) {
            this.setRollbackRequired();
            Category.SYS_SERVER.error(location, me, (Object)e);
            location.traceThrowableT(500, me, (Throwable)e);
            throw e;
        }
        location.infoT(Category.SYS_SERVER, me, "done");
    }

    private void setPropertySheetEntry(PropertySheet sheet, String entry, String value) throws InvalidValueException, NoWriteAccessException, NameNotFoundException, ConfigurationException {
        try {
            sheet.getPropertyEntry(entry).setValue((Object)value);
        }
        catch (NameNotFoundException e) {
            sheet.createPropertyEntry(entry, (Object)value, null);
        }
        this.configurationChanged = true;
    }

    private void setPropertySheetEntry(PropertySheet sheet, String entry, int value) throws InvalidValueException, NoWriteAccessException, NameNotFoundException, ConfigurationException {
        this.setPropertySheetEntry(sheet, entry, String.valueOf(value));
    }

    private void setPropertySheetEntry(PropertySheet sheet, String entry, boolean value) throws InvalidValueException, NoWriteAccessException, NameNotFoundException, ConfigurationException {
        this.setPropertySheetEntry(sheet, entry, String.valueOf(value));
    }

    private void setPropertySheetSecureEntry(PropertySheet sheet, String entry, String value) throws InvalidValueException, NoWriteAccessException, NameNotFoundException, ConfigurationException {
        try {
            sheet.getPropertyEntry(entry).setValue((Object)value);
        }
        catch (NameNotFoundException e) {
            sheet.createSecurePropertyEntry(entry, (Object)value, null);
        }
        this.configurationChanged = true;
    }

    private Configuration getRegistrationConfiguration() throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        Configuration registrationConfiguration = null;
        try {
            registrationConfiguration = this.configuration.getSubConfiguration(CCMS_AGENT_REGISTRATION);
        }
        catch (NameNotFoundException e) {
            if (this.accessMode == 0) {
                throw e;
            }
            registrationConfiguration = this.configuration.createSubConfiguration(CCMS_AGENT_REGISTRATION, 1);
            this.configurationChanged = true;
        }
        return registrationConfiguration;
    }

    private PropertySheet getRegistrationPropertySheet() throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        Configuration registrationConfiguration = this.getRegistrationConfiguration();
        return registrationConfiguration.getPropertySheetInterface();
    }

    private PropertySheet getRegistrationPropertySheet(String instanceName) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        Configuration registrationConfiguration = this.getRegistrationConfiguration();
        Configuration instanceConfiguration = null;
        try {
            instanceConfiguration = registrationConfiguration.getSubConfiguration(instanceName);
        }
        catch (NameNotFoundException e) {
            if (this.accessMode == 0) {
                throw e;
            }
            instanceConfiguration = registrationConfiguration.createSubConfiguration(instanceName, 1);
            this.configurationChanged = true;
        }
        return instanceConfiguration.getPropertySheetInterface();
    }

    private Configuration getCustomizingConfiguration() throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        Configuration customizingConfiguration = null;
        try {
            customizingConfiguration = this.configuration.getSubConfiguration(CCMS_AGENT_CCMS_CUSTOMIZING);
        }
        catch (NameNotFoundException e) {
            if (this.accessMode == 0) {
                throw e;
            }
            customizingConfiguration = this.configuration.createSubConfiguration(CCMS_AGENT_CCMS_CUSTOMIZING, 1);
            this.configurationChanged = true;
        }
        return customizingConfiguration;
    }

    private PropertySheet getConfigurationPropertySheet() throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        Configuration customizingConfiguration = this.getCustomizingConfiguration();
        return customizingConfiguration.getPropertySheetInterface();
    }

    private PropertySheet getBundleConfigurationPropertySheet(String systemName) throws NameNotFoundException, ConfigurationLockedException, ConfigurationException {
        Configuration customizingConfiguration = this.getCustomizingConfiguration();
        Configuration bundleConfiguration = null;
        try {
            bundleConfiguration = customizingConfiguration.getSubConfiguration(RFC_BUNDLE + systemName);
        }
        catch (NameNotFoundException e) {
            if (this.accessMode == 0) {
                throw e;
            }
            bundleConfiguration = customizingConfiguration.createSubConfiguration(RFC_BUNDLE + systemName, 1);
            this.configurationChanged = true;
        }
        return bundleConfiguration.getPropertySheetInterface();
    }

    public boolean isRegistrationRequired(String instanceName) throws ConfigurationException {
        String me = "isRegistrationRequired(" + instanceName + ")";
        location.infoT(Category.SYS_SERVER, me);
        this.checkForRead();
        boolean isRegistrationRequired = false;
        Configuration registrationConfiguration = null;
        try {
            registrationConfiguration = this.configuration.getSubConfiguration(CCMS_AGENT_REGISTRATION);
        }
        catch (NameNotFoundException e) {
            location.infoT(Category.SYS_SERVER, me, "false");
            return false;
        }
        try {
            Configuration instanceConfiguration = registrationConfiguration.getSubConfiguration(instanceName);
            PropertySheet props = instanceConfiguration.getPropertySheetInterface();
            boolean isRegistered = Boolean.valueOf((String)props.getPropertyEntry(REGISTERED).getValue());
            if (!isRegistered) {
                int retries = Integer.valueOf((String)props.getPropertyEntry(RETRIES).getValue());
                isRegistrationRequired = retries > 0;
            }
        }
        catch (NameNotFoundException e) {
            isRegistrationRequired = true;
        }
        location.infoT(Category.SYS_SERVER, me, String.valueOf(isRegistrationRequired));
        return isRegistrationRequired;
    }

    private void setRollbackRequired() {
        this.isRollbackRequired = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

