/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.agent.server;

import com.sap.engine.services.monitor.agent.AbstractAgent;
import com.sap.engine.services.monitor.agent.server.Conf;
import com.sap.engine.services.monitor.agent.server.ConfigFileCache;
import com.sap.engine.services.monitor.agent.server.DataCopy;
import com.sap.engine.services.monitor.agent.server.ExecutableCache;
import com.sap.engine.services.monitor.agent.server.ExternalExecutionWrapper;
import com.sap.engine.services.monitor.agent.server.InstallationInformationImpl;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.SequenceInputStream;
import java.io.Serializable;

public abstract class AbstractAgentImpl
implements Serializable,
AbstractAgent {
    private ExternalExecutionWrapper wrapper = null;
    private static String hostName = System.getProperty("HOSTNAME");
    private File installLogFile = null;
    private File deinstallLogFile = null;
    private Conf conf = null;
    private boolean confChanged = false;
    private static InstallationInformationImpl installationInfo = null;
    private String defaultExecutableFileName = null;
    private String defaultConfigFileName = null;
    private String currentExecutableFileName = null;
    private String currentConfigFileName = null;
    private static int LOG_BUFFER_SIZE = 8192;
    private String[] executionArguments = null;
    private InputStream agentLogFiles = null;
    private static final String BACKUP_EXTENSION = ".old";

    protected AbstractAgentImpl(String defaultExecutableFileName, String defaultConfigFileName) {
        this.setDefaultExecutableFileName(defaultExecutableFileName);
        this.setDefaultConfigFileName(defaultConfigFileName);
    }

    protected AbstractAgentImpl() {
    }

    public int register() throws Exception {
        File tempConfigFile = null;
        int rc = -1;
        try {
            tempConfigFile = this.createTempConfigFile();
            rc = this.register(tempConfigFile.getPath());
        }
        catch (Exception ex) {
            if (tempConfigFile != null) {
                tempConfigFile.delete();
            }
            throw ex;
        }
        if (tempConfigFile != null) {
            tempConfigFile.delete();
        }
        return rc;
    }

    public int unregister() throws Exception {
        File tempConfigFile = null;
        int rc = -1;
        try {
            tempConfigFile = this.createTempConfigFile();
            rc = this.unregister(tempConfigFile.getPath());
        }
        catch (Exception ex) {
            if (tempConfigFile != null) {
                tempConfigFile.delete();
            }
            throw ex;
        }
        if (tempConfigFile != null) {
            tempConfigFile.delete();
        }
        return rc;
    }

    public int version() throws Exception {
        this.clearAgentLogFiles();
        this.wrapper = new ExternalExecutionWrapper();
        int retcode = this.wrapper.execute(this.createExecArguments("-v"));
        this.addAgentLogFile(this.wrapper.getHTMLOutput());
        return retcode;
    }

    private int register(String configFile) throws Exception {
        this.clearAgentLogFiles();
        this.deleteLogFile(this.getInstallLogFile());
        this.wrapper = new ExternalExecutionWrapper();
        this.executionArguments = this.createExecArguments(new String[]{"-R", "-f", configFile});
        int retcode = this.wrapper.execute(this.executionArguments);
        this.addAgentLogFile(this.getLog(this.getInstallLogFile()));
        if (!AbstractAgentImpl.getInstallationInformation().isWindowsPlatform() && retcode == 0) {
            retcode = this.wrapper.execute(this.createExecArguments("-DCCMS"));
            this.addAgentLogFile(this.wrapper.getHTMLOutput());
        }
        return retcode;
    }

    private int unregister(String configFile) throws Exception {
        this.clearAgentLogFiles();
        this.deleteLogFile(this.getDeinstallLogFile());
        this.backupConfigFile();
        this.wrapper = new ExternalExecutionWrapper();
        this.executionArguments = this.createExecArguments(new String[]{"-U", "-f", configFile});
        int retcode = this.wrapper.execute(this.executionArguments);
        this.addAgentLogFile(this.getLog(this.getDeinstallLogFile()));
        return retcode;
    }

    private void backupConfigFile() {
        String configFileName = this.getConfigFileName();
        if (configFileName == null) {
            return;
        }
        String backupConfigFileName = configFileName + BACKUP_EXTENSION;
        File backupFile = new File(backupConfigFileName);
        if (backupFile == null || backupFile.exists()) {
            return;
        }
        DataCopy copy = new DataCopy();
        try {
            copy.setDataSource(configFileName);
            copy.setDataDestination(backupConfigFileName);
            copy.doCopy(true);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
    }

    public void refresh() {
        this.refreshFileNames();
    }

    protected abstract void refreshFileNames();

    protected void setDefaultExecutableFileName(String executableFileName) {
        this.defaultExecutableFileName = ExecutableCache.getExecutableCache().isValid(executableFileName) ? executableFileName : null;
    }

    protected void setDefaultConfigFileName(String configFileName) {
        Conf conf = ConfigFileCache.getConfigFileCache().getConf(configFileName);
        this.defaultConfigFileName = conf != null && conf.isValid() ? configFileName : null;
    }

    private File createTempConfigFile() throws IOException {
        File tempConfigFile = null;
        tempConfigFile = File.createTempFile("csm", ".conf");
        PrintStream out = new PrintStream(new FileOutputStream(tempConfigFile));
        Conf conf = this.getConf();
        conf.printAll(out);
        out.close();
        return tempConfigFile;
    }

    private ByteArrayOutputStream getLog(File logFile) {
        ByteArrayOutputStream logBuffer = new ByteArrayOutputStream(LOG_BUFFER_SIZE);
        if (logFile != null && logFile.exists()) {
            try {
                String line = null;
                FileInputStream inputStream = null;
                inputStream = new FileInputStream(logFile);
                BufferedReader r = new BufferedReader(new InputStreamReader(inputStream));
                PrintStream ps = new PrintStream(logBuffer);
                this.printExecutionArguments("Logfile for : ", "blue", ps);
                line = r.readLine();
                while (line != null) {
                    ps.print(this.getDecoratedLine(line));
                    line = r.readLine();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                logBuffer = null;
            }
            return logBuffer;
        }
        return this.wrapper.getHTMLOutput();
    }

    private String getDecoratedLine(String line) {
        if (line == null) {
            return "";
        }
        String trimmedLine = line.trim();
        if (trimmedLine.startsWith("ERROR")) {
            line = "<font color=red>" + line + "</font>";
        } else if (trimmedLine.startsWith("WARNING")) {
            line = "<font color=#d08030>" + line + "</font>";
        }
        return "<nobr>" + line + "</nobr><br>";
    }

    private File getInstallLogFile() {
        if (this.installLogFile == null) {
            try {
                String startingDirectory = System.getProperty("user.dir");
                this.installLogFile = new File(startingDirectory + File.separator + "sapccmsr.install.log");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.installLogFile;
    }

    private File getDeinstallLogFile() {
        if (this.deinstallLogFile == null) {
            try {
                String startingDirectory = System.getProperty("user.dir");
                this.deinstallLogFile = new File(startingDirectory + File.separator + "sapccmsr.deinstall.log");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.deinstallLogFile;
    }

    private void deleteLogFile(File logFile) {
        if (logFile != null && logFile.exists()) {
            logFile.delete();
        }
    }

    public boolean isConfigFileValid() {
        String configFileName = this.getConfigFileName();
        if (configFileName == null) {
            return false;
        }
        Conf config = ConfigFileCache.getConfigFileCache().getConf(configFileName);
        return config == null ? false : config.isValid();
    }

    public boolean isExecutableValid() {
        String executableFileName = this.getExecutableFileName();
        if (executableFileName == null) {
            return false;
        }
        return ExecutableCache.getExecutableCache().isValid(executableFileName);
    }

    public boolean isValid() {
        return this.isConfigFileValid() && this.isExecutableValid();
    }

    public InputStream getOutput() {
        return this.agentLogFiles;
    }

    public int start() throws Exception {
        this.wrapper = new ExternalExecutionWrapper();
        int retcode = this.wrapper.execute(this.createExecArguments("-DCCMS"));
        return retcode;
    }

    public int stop() throws Exception {
        this.wrapper = new ExternalExecutionWrapper();
        int retcode = this.wrapper.execute(this.createExecArguments("-stop"));
        return retcode;
    }

    public abstract String getDefaultConfigurationDirectory();

    public abstract String getDefaultAgentDirectory();

    public String getAgentConfigurationBaseFileName() {
        return AbstractAgentImpl.getInstallationInformation().getAgentConfigurationBaseFileName();
    }

    public String getAgentBaseFileName() {
        return AbstractAgentImpl.getInstallationInformation().getAgentBaseFileName();
    }

    protected static InstallationInformationImpl getInstallationInformation() {
        if (installationInfo == null) {
            installationInfo = InstallationInformationImpl.getInstallationInformation();
        }
        return installationInfo;
    }

    protected abstract String[] createExecArguments(String[] var1);

    private String[] createExecArguments(String arg) {
        return this.createExecArguments(new String[]{arg});
    }

    public int status() throws Exception {
        this.wrapper = new ExternalExecutionWrapper();
        int retcode = this.wrapper.execute(this.createExecArguments("-status"));
        return retcode;
    }

    public void printLog() {
        File logFile = this.getInstallLogFile();
        if (logFile == null || !logFile.exists()) {
            return;
        }
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(logFile)));
            String line = r.readLine();
            while (line != null) {
                System.out.println(line);
                line = r.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean makePersistent(Component parent) {
        boolean result = true;
        if (this.confChanged) {
            String configFileName = this.getConfigFileName();
            if (configFileName == null) {
                configFileName = this.getDefaultConfigurationDirectory() + File.separator + AbstractAgentImpl.getInstallationInformation().getAgentConfigurationBaseFileName() + ".install";
            }
            result = this.saveConf(configFileName);
        }
        return result;
    }

    private boolean saveConf(String configFileName) {
        try {
            File configFile = new File(configFileName);
            PrintStream out = new PrintStream(new FileOutputStream(configFile));
            Conf conf = this.getConf();
            conf.print(out);
            out.close();
            this.setConfigFileNameOnly(configFileName);
            this.confChanged = false;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean makePersistent() {
        return this.makePersistent(null);
    }

    public String getConfigFileName() {
        return this.currentConfigFileName != null ? this.currentConfigFileName : this.defaultConfigFileName;
    }

    public void setConfigFileName(String configFileName) {
        this.currentConfigFileName = configFileName;
        this.conf = null;
    }

    private void setConfigFileNameOnly(String configFileName) {
        this.currentConfigFileName = configFileName;
    }

    public String getExecutableFileName() {
        return this.currentExecutableFileName != null ? this.currentExecutableFileName : this.defaultExecutableFileName;
    }

    public void setExecutableFileName(String executableFileName) {
        this.currentExecutableFileName = executableFileName;
    }

    public String getAdminSystem() {
        return this.getConfigurationProperty("CEN_CONFIG", "CEN_SYSID");
    }

    public String getAdminUser() {
        return this.getConfigurationProperty("CEN_ADMIN_USER", "CEN_ADMIN_USERID");
    }

    public String getAdminClient() {
        return this.getConfigurationProperty("CEN_ADMIN_USER", "CEN_ADMIN_CLIENT");
    }

    public String getCsmregSystem() {
        return this.getConfigurationProperty("CEN_CONFIG", "CEN_SYSID");
    }

    public String getCsmregUser() {
        return this.getConfigurationProperty("CEN_CSMREG_USER", "CEN_CSMREG_USERID");
    }

    public String getCsmregClient() {
        return this.getConfigurationProperty("CEN_CSMREG_USER", "CEN_CSMREG_CLIENT");
    }

    public void setAdminPassword(String password) {
        this.setConfigurationProperty("CEN_ADMIN_USER", "CEN_ADMIN_PASSWORD", password);
    }

    public String getAdminPassword() {
        return this.getConfigurationProperty("CEN_ADMIN_USER", "CEN_ADMIN_PASSWORD");
    }

    public void setCsmregPassword(String password) {
        this.setConfigurationProperty("CEN_CSMREG_USER", "CEN_CSMREG_PASSWORD", password);
    }

    public String getCsmregPassword() {
        return this.getConfigurationProperty("CEN_CSMREG_USER", "CEN_CSMREG_PASSWORD");
    }

    private String getConfigurationProperty(String sectionName, String propertyName) {
        Conf data = this.getConf();
        if (data == null) {
            return null;
        }
        return data.getPropertyValue(sectionName, propertyName);
    }

    private void setConfigurationProperty(String sectionName, String propertyName, String propertyValue) {
        Conf data = this.getConf();
        if (data == null) {
            return;
        }
        data.setProperty(sectionName, propertyName, propertyValue);
    }

    public Conf getConf() {
        if (this.conf == null) {
            String configFileName = this.getConfigFileName();
            if (configFileName == null) {
                return null;
            }
            this.conf = ConfigFileCache.getConfigFileCache().getConf(configFileName);
        }
        return this.conf;
    }

    public void setConf(Conf conf) {
        this.conf = conf;
        this.confChanged = true;
    }

    public void setConfigFile(String configFileName, Conf conf) {
        if (configFileName == null) {
            configFileName = this.getDefaultConfigurationDirectory() + File.separator + AbstractAgentImpl.getInstallationInformation().getAgentConfigurationBaseFileName() + ".install";
        } else {
            File configFile = new File(configFileName);
            if (configFile.getParent() == null) {
                configFileName = this.getDefaultConfigurationDirectory() + File.separator + configFileName;
            }
        }
        this.setConf(conf);
        this.saveConf(configFileName);
    }

    private void printExecutionArguments(String prefix, String color, PrintStream ps) {
        ps.print("<nobr><b><font color=" + color + ">");
        ps.print(prefix);
        ps.print(this.executionArguments == null || this.executionArguments[0] == null ? "<NULL>" : this.executionArguments[0]);
        if (this.executionArguments != null && this.executionArguments.length > 1) {
            ps.print("(");
            int index = 1;
            while (index < this.executionArguments.length) {
                if (index > 1) {
                    ps.print(",");
                }
                ps.print(this.executionArguments[index] == null ? "<NULL>" : this.executionArguments[index]);
                ++index;
            }
            ps.print(")");
        }
        ps.print("</font></b></nobr><br>");
    }

    private void clearAgentLogFiles() {
        this.agentLogFiles = null;
    }

    private void addAgentLogFile(ByteArrayOutputStream log) {
        this.agentLogFiles = this.agentLogFiles == null ? new ByteArrayInputStream(log.toByteArray()) : new SequenceInputStream(this.agentLogFiles, new ByteArrayInputStream(log.toByteArray()));
    }
}

