/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.agent.client;

import com.sap.engine.services.monitor.agent.server.InputBlocker;
import java.awt.Component;
import javax.swing.SwingUtilities;

public abstract class SwingWorker {
    private Thread thread;
    private ThreadVar threadVar;
    private InputBlocker glassPane;
    private String message;
    private String title;
    private boolean beep;
    private Component parent;

    public SwingWorker(Component parent) {
        this(parent, null, null, false);
    }

    public SwingWorker(Component parent, String title, String message, boolean beep) {
        this.setParent(parent);
        this.message = message;
        this.title = title;
        this.beep = beep;
        final Runnable doFinished = new Runnable(){

            public void run() {
                SwingWorker.this.finished();
            }
        };
        Runnable doConstruct = new Runnable(){

            public void run() {
                try {
                    SwingWorker.this.construct();
                    Object var2_1 = null;
                    SwingWorker.this.threadVar.clear();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    SwingWorker.this.threadVar.clear();
                    throw throwable;
                }
                SwingUtilities.invokeLater(doFinished);
            }
        };
        Thread t = new Thread(Thread.currentThread().getThreadGroup(), doConstruct);
        this.threadVar = new ThreadVar(t);
    }

    private void activateInputBlocker() {
        InputBlocker aBlocker = InputBlocker.getBlocker(this.getParent(), true, this.beep);
        this.setInputBlocker(aBlocker);
        if (this.getInputBlocker() != null) {
            this.getInputBlocker().setVisible(true);
        }
    }

    private void construct() {
        this.activateInputBlocker();
        try {
            this.doNonUILogic();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void deactivateInputBlocker() {
        if (this.getInputBlocker() != null) {
            this.getInputBlocker().setVisible(false);
        }
    }

    protected abstract void doNonUILogic() throws RuntimeException;

    protected void doUIUpdateLogic() throws RuntimeException {
    }

    protected void finished() {
        try {
            try {
                this.deactivateInputBlocker();
                this.doUIUpdateLogic();
            }
            catch (RuntimeException e) {
                System.out.println("SwingWorker error" + e);
                Object var3_2 = null;
                if (this.getParent() != null) {
                    this.getParent().requestFocus();
                }
            }
            Object var3_1 = null;
            if (this.getParent() != null) {
                this.getParent().requestFocus();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.getParent() != null) {
                this.getParent().requestFocus();
            }
            throw throwable;
        }
    }

    protected Component getParent() {
        return this.parent;
    }

    protected InputBlocker getInputBlocker() {
        return this.glassPane;
    }

    public void interrupt() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.interrupt();
        }
        this.threadVar.clear();
    }

    protected void setParent(Component parent) {
        this.parent = parent;
    }

    protected void setInputBlocker(InputBlocker newGlassPane) {
        this.glassPane = newGlassPane;
    }

    public void start() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.start();
        }
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread t) {
            this.thread = t;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

