/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.agent.client;

import java.awt.Component;
import java.awt.Container;
import javax.swing.Spring;
import javax.swing.SpringLayout;

public class SpringUtilities {
    public static void printSizes(Component c) {
        System.out.println("minimumSize = " + c.getMinimumSize());
        System.out.println("preferredSize = " + c.getPreferredSize());
        System.out.println("maximumSize = " + c.getMaximumSize());
    }

    public static void makeGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException exc) {
            System.err.println("The first argument to makeGrid must use SpringLayout.");
            return;
        }
        Spring xPadSpring = Spring.constant(xPad);
        Spring yPadSpring = Spring.constant(yPad);
        Spring initialXSpring = Spring.constant(initialX);
        Spring initialYSpring = Spring.constant(initialY);
        int max = rows * cols;
        Spring maxWidthSpring = layout.getConstraints(parent.getComponent(0)).getWidth();
        Spring maxHeightSpring = layout.getConstraints(parent.getComponent(0)).getHeight();
        int i = 1;
        while (i < max) {
            SpringLayout.Constraints cons = layout.getConstraints(parent.getComponent(i));
            maxWidthSpring = Spring.max(maxWidthSpring, cons.getWidth());
            maxHeightSpring = Spring.max(maxHeightSpring, cons.getHeight());
            ++i;
        }
        int i2 = 0;
        while (i2 < max) {
            SpringLayout.Constraints cons = layout.getConstraints(parent.getComponent(i2));
            cons.setWidth(maxWidthSpring);
            cons.setHeight(maxHeightSpring);
            ++i2;
        }
        SpringLayout.Constraints lastCons = null;
        SpringLayout.Constraints lastRowCons = null;
        int i3 = 0;
        while (i3 < max) {
            SpringLayout.Constraints cons = layout.getConstraints(parent.getComponent(i3));
            if (i3 % cols == 0) {
                lastRowCons = lastCons;
                cons.setX(initialXSpring);
            } else {
                cons.setX(Spring.sum(lastCons.getConstraint("East"), xPadSpring));
            }
            if (i3 / cols == 0) {
                cons.setY(initialYSpring);
            } else {
                cons.setY(Spring.sum(lastRowCons.getConstraint("South"), yPadSpring));
            }
            lastCons = cons;
            ++i3;
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", Spring.sum(Spring.constant(yPad), lastCons.getConstraint("South")));
        pCons.setConstraint("East", Spring.sum(Spring.constant(xPad), lastCons.getConstraint("East")));
    }

    public static void align(Container parent, int xPad, int yPad) {
        SpringLayout layout;
        Component[] components = parent.getComponents();
        if (components == null || components.length == 0) {
            return;
        }
        int lastComponentIndex = components.length - 1;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException exc) {
            System.err.println("The first argument to makeGrid must use SpringLayout.");
            return;
        }
        layout.putConstraint("North", components[0], yPad, "North", (Component)parent);
        layout.putConstraint("West", components[0], xPad, "West", (Component)parent);
        Spring maxWidth = layout.getConstraints(components[0]).getWidth();
        int index = 1;
        while (index <= lastComponentIndex) {
            maxWidth = Spring.max(maxWidth, layout.getConstraints(components[index]).getWidth());
            ++index;
        }
        layout.getConstraints(components[0]).setWidth(maxWidth);
        int index2 = 1;
        while (index2 <= lastComponentIndex) {
            layout.getConstraints(components[index2]).setWidth(maxWidth);
            layout.putConstraint("North", components[index2], yPad, "South", components[index2 - 1]);
            layout.putConstraint("West", components[index2], 0, "West", components[index2 - 1]);
            ++index2;
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", Spring.sum(Spring.constant(yPad), layout.getConstraints(components[lastComponentIndex]).getConstraint("South")));
        pCons.setConstraint("East", Spring.sum(Spring.constant(2 * xPad), maxWidth));
    }

    private static SpringLayout.Constraints getConstraintsForCell(int row, int col, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component c = parent.getComponent(row * cols + col);
        return layout.getConstraints(c);
    }

    public static void makeCompactGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        int r;
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException exc) {
            System.err.println("The first argument to makeCompactGrid must use SpringLayout.");
            return;
        }
        Spring x = Spring.constant(initialX);
        int c = 0;
        while (c < cols) {
            Spring width = Spring.constant(0);
            r = 0;
            while (r < rows) {
                width = Spring.max(width, SpringUtilities.getConstraintsForCell(r, c, parent, cols).getWidth());
                ++r;
            }
            int r2 = 0;
            while (r2 < rows) {
                SpringLayout.Constraints constraints = SpringUtilities.getConstraintsForCell(r2, c, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
                ++r2;
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(xPad)));
            ++c;
        }
        Spring y = Spring.constant(initialY);
        r = 0;
        while (r < rows) {
            Spring height = Spring.constant(0);
            int c2 = 0;
            while (c2 < cols) {
                height = Spring.max(height, SpringUtilities.getConstraintsForCell(r, c2, parent, cols).getHeight());
                ++c2;
            }
            int c3 = 0;
            while (c3 < cols) {
                SpringLayout.Constraints constraints = SpringUtilities.getConstraintsForCell(r, c3, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
                ++c3;
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(yPad)));
            ++r;
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", y);
        pCons.setConstraint("East", x);
    }
}

