/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.agent.client;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JTextField;

public class OpenFileAction
extends AbstractAction {
    protected Component parent;
    protected JFileChooser chooser;
    JTextField textField;
    private String propertyChange = null;

    public OpenFileAction(Component parent, JTextField textField, String labelText) {
        super(labelText);
        this.textField = textField;
        this.chooser = new JFileChooser(new File(textField.getText()));
        this.parent = parent;
    }

    public void setPropertyChangeEvent(String propertyChange) {
        this.propertyChange = propertyChange;
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.chooser.showOpenDialog(this.parent) == 0) {
            String oldFileName = this.textField.getText();
            File file = this.chooser.getSelectedFile();
            if (file != null) {
                String newFileName = file.getAbsolutePath();
                if (this.textField != null) {
                    this.textField.setText(newFileName);
                }
                if (this.openFile(file)) {
                    if (this.propertyChange != null) {
                        this.firePropertyChange(this.propertyChange, oldFileName, newFileName);
                    }
                } else if (this.textField != null) {
                    this.textField.setText(oldFileName);
                }
            }
        }
    }

    public boolean openFile(File file) {
        return true;
    }
}

