/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor.agent.client;

import com.sap.engine.services.monitor.MonitorRuntimeControlInterface;
import com.sap.engine.services.monitor.agent.AbstractAgent;
import com.sap.engine.services.monitor.agent.AgentConfigurationRuntimeInterface;
import com.sap.engine.services.monitor.agent.J2EEAgent;
import com.sap.engine.services.monitor.agent.StandaloneAgent;
import com.sap.engine.services.monitor.agent.client.J2EEAgentProxy;
import com.sap.engine.services.monitor.agent.client.OpenFileAction;
import com.sap.engine.services.monitor.agent.client.SpringUtilities;
import com.sap.engine.services.monitor.agent.client.StandaloneAgentProxy;
import com.sap.engine.services.monitor.agent.client.SwingWorker;
import com.sap.engine.services.monitor.agent.server.Conf;
import com.sap.engine.services.monitor.agent.server.InstallationDefaultsRequester;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLEditorKit;

public class CcmsAgentConfigurationPanel
extends JScrollPane
implements PropertyChangeListener,
InstallationDefaultsRequester {
    private static ResourceBundle rb = ResourceBundle.getBundle((class$com$sap$engine$services$monitor$agent$client$CcmsAgentConfigurationPanel == null ? (class$com$sap$engine$services$monitor$agent$client$CcmsAgentConfigurationPanel = CcmsAgentConfigurationPanel.class$("com.sap.engine.services.monitor.agent.client.CcmsAgentConfigurationPanel")) : class$com$sap$engine$services$monitor$agent$client$CcmsAgentConfigurationPanel).getPackage().getName() + ".agent");
    private static String initialSystemName = null;
    private static String initialInstance = null;
    private static String currentInstance = null;
    private static String currentSystem = null;
    private static AbstractAgent currentAgent = null;
    private static HashMap agentCache = new HashMap();
    private static boolean agentCacheIsEmpty = true;
    private static StandaloneAgent standaloneAgent = null;
    private ModeSelectionPanel modePanel = null;
    private AgentDataPanel agentPanel = null;
    private PasswordPanel passwordPanel = null;
    private LogMessagePanel logMessagePanel = null;
    private ButtonPanel buttonPanel = null;
    private Color normalTextColor = null;
    private Color hiliteTextColor = null;
    private Conf conf = null;
    private MonitorRuntimeControlInterface managementInterface = null;
    private Frame mainFrame = null;
    static /* synthetic */ Class class$com$sap$engine$services$monitor$agent$client$CcmsAgentConfigurationPanel;

    private void addActionButtons(Container cp) {
        SpringLayout layoutActions = new SpringLayout();
        JPanel panelActions = new JPanel(layoutActions);
        RegisterButtonAction actionButtonRegister = new RegisterButtonAction(rb.getString("register.label"));
        StartButtonAction actionButtonStart = new StartButtonAction(rb.getString("start.label"));
        StatusButtonAction actionButtonStatus = new StatusButtonAction(rb.getString("status.label"));
        ExitButtonAction actionButtonExit = new ExitButtonAction(rb.getString("exit.label"));
        panelActions.add(new JButton(actionButtonRegister));
        panelActions.add(new JButton(actionButtonStart));
        panelActions.add(new JButton(actionButtonStatus));
        panelActions.add(new JButton(actionButtonExit));
        SpringUtilities.makeCompactGrid(panelActions, 1, 4, 3, 3, 3, 3);
        cp.add(panelActions);
    }

    private Frame getMainFrame() {
        return this.mainFrame;
    }

    public CcmsAgentConfigurationPanel(MonitorRuntimeControlInterface managementInterface, Frame mainFrame) {
        this.managementInterface = managementInterface;
        this.mainFrame = mainFrame;
        initialSystemName = managementInterface.getSystemName();
        this.init();
        this.buildSimplePane(mainFrame);
        this.setPreferredSize(new Dimension(600, 500));
        this.setVisible(true);
    }

    private void init() {
        String[] allSystems = this.getAgentRuntime().allSystems();
        if (allSystems != null) {
            boolean isWithinJ2EE = this.getAgentRuntime().isRunningInJ2eeEngine();
            int sysIndex = 0;
            while (sysIndex < allSystems.length) {
                String[] instances;
                String systemName = allSystems[sysIndex];
                if (systemName != null && (instances = this.getAgentRuntime().instanceNumbers(systemName)) != null) {
                    int index = 0;
                    while (index < instances.length) {
                        J2EEAgent newAgent = J2EEAgentProxy.create(systemName, isWithinJ2EE ? null : instances[index], this.getAgentRuntime());
                        if (newAgent != null) {
                            this.putAgent(systemName, instances[index], newAgent);
                        }
                        ++index;
                    }
                }
                ++sysIndex;
            }
        }
        if (agentCacheIsEmpty = agentCache.isEmpty()) {
            this.putAgent(null, null, J2EEAgentProxy.create(null, null, this.getAgentRuntime()));
        }
        if (this.getAgentRuntime().isSystemExisting(initialSystemName)) {
            String[] instances = this.getAgentRuntime().instanceNumbers(initialSystemName);
            if (instances == null) {
                initialSystemName = null;
            } else {
                initialInstance = instances[0];
            }
        } else {
            initialSystemName = null;
        }
    }

    private String getAgentKey(String systemName, String instanceNumber) {
        return systemName == null ? instanceNumber : (instanceNumber == null ? systemName : systemName + instanceNumber);
    }

    private J2EEAgent getAgent(String systemName, String instanceNumber) {
        String agentKey = this.getAgentKey(systemName, instanceNumber);
        return (J2EEAgent)agentCache.get(agentKey);
    }

    private J2EEAgent putAgent(String systemName, String instanceNumber, J2EEAgent agent) {
        String agentKey = this.getAgentKey(systemName, instanceNumber);
        agentCache.put(agentKey, agent);
        if (systemName == null && instanceNumber == null) {
            return agent;
        }
        if (agentCacheIsEmpty) {
            agentCache.remove(this.getAgentKey(null, null));
            agentCacheIsEmpty = false;
        }
        return agent;
    }

    private StandaloneAgent getStandaloneAgent() {
        if (standaloneAgent == null) {
            standaloneAgent = StandaloneAgentProxy.create(this.getAgentRuntime());
        }
        return standaloneAgent;
    }

    private String getExecFileName(AbstractAgent agent) {
        return agent == null ? null : agent.getExecutableFileName();
    }

    private String getConfigFileName(AbstractAgent agent) {
        return agent == null ? null : agent.getConfigFileName();
    }

    private String getProfileFileName(J2EEAgent agent) {
        return agent == null ? null : agent.getProfileName();
    }

    private void updatePane() {
        if (currentAgent == null) {
            return;
        }
        this.getAgentPanel().setExecFile(this.getExecFileName(currentAgent), !currentAgent.isExecutableValid());
        this.getAgentPanel().setConfigFile(this.getConfigFileName(currentAgent), !currentAgent.isConfigFileValid());
        this.getPasswordPanel().setAdminUserInformation(currentAgent.getAdminUser(), currentAgent.getAdminClient(), currentAgent.getAdminSystem());
        this.getPasswordPanel().setCsmregUserInformation(currentAgent.getCsmregUser(), currentAgent.getCsmregClient(), currentAgent.getCsmregSystem());
        if (currentAgent instanceof J2EEAgent) {
            J2EEAgent agent = (J2EEAgent)currentAgent;
            this.getModePanel().setProfileFileName(this.getProfileFileName(agent), !agent.isProfileFileValid());
            this.getModePanel().setLongSID(agent.getLongSID());
            this.getModePanel().setCcmsCustomizingEnabled(agent.isCcmsCustomizingEnabled());
        }
        this.getPasswordPanel().clearPasswords();
        if (currentAgent != null && currentAgent.isValid()) {
            this.getButtonPanel().enableRegister();
        } else {
            this.getButtonPanel().disableRegister();
        }
    }

    private void buildSimplePane(Frame mainFrame) {
        ModeSelectionPanel modePanel = this.getModePanel();
        AgentDataPanel agentPanel = this.getAgentPanel();
        PasswordPanel passwordPanel = this.getPasswordPanel();
        LogMessagePanel logMessagePanel = this.getMessagePanel();
        ButtonPanel buttonPanel = this.getButtonPanel();
        JPanel cp = new JPanel();
        SpringLayout contentLayout = new SpringLayout();
        cp.setLayout(contentLayout);
        this.getModePanel().addPropertyChangeListener(new PropertyChangeListener(){

            private void handleSystemChange(String newSystem) {
                currentSystem = newSystem;
                currentInstance = CcmsAgentConfigurationPanel.this.getModePanel().getSelectedInstance();
                J2EEAgent newAgent = CcmsAgentConfigurationPanel.this.getAgent(currentSystem, currentInstance);
                if (newAgent != null) {
                    currentAgent = newAgent;
                }
                CcmsAgentConfigurationPanel.this.updatePane();
                if (!CcmsAgentConfigurationPanel.this.getAgentRuntime().isRunningInJ2eeEngine()) {
                    // empty if block
                }
            }

            private void handleInstanceChange(String newInstance) {
                currentInstance = newInstance;
                J2EEAgent newAgent = CcmsAgentConfigurationPanel.this.getAgent(currentSystem, currentInstance);
                if (newAgent != null) {
                    currentAgent = newAgent;
                }
                CcmsAgentConfigurationPanel.this.updatePane();
            }

            private void handleProfileChange(String newProfileName) {
                if (currentAgent != null) {
                    String fileName = "";
                    if (currentAgent != null) {
                        fileName = ((J2EEAgent)currentAgent).getProfileName();
                        if (!CcmsAgentConfigurationPanel.this.getAgentRuntime().isProfileValid(fileName)) {
                            fileName = "";
                        }
                    }
                    ((J2EEAgent)currentAgent).setProfileName(newProfileName);
                }
            }

            private void handleLongSIDChange(String newLongSID) {
                this.saveLongSID();
            }

            private void handleCcmsCustomizingChange(Boolean enable) {
                if (currentAgent == null || !(currentAgent instanceof J2EEAgent)) {
                    return;
                }
                ((J2EEAgent)currentAgent).enableCcmsCustomizing(enable);
            }

            private void handleModeChange(String newMode) {
                if (newMode.equals("SAP J2EE Engine")) {
                    currentAgent = CcmsAgentConfigurationPanel.this.getAgent(currentSystem, currentInstance);
                } else if (newMode.equals("Standalone")) {
                    currentAgent = CcmsAgentConfigurationPanel.this.getStandaloneAgent();
                }
                CcmsAgentConfigurationPanel.this.updatePane();
            }

            private void saveLongSID() {
                if (currentAgent == null || !(currentAgent instanceof J2EEAgent)) {
                    return;
                }
                ((J2EEAgent)currentAgent).setLongSID(CcmsAgentConfigurationPanel.this.getModePanel().getLongSID());
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("SystemChangedProperty")) {
                    this.handleSystemChange((String)evt.getNewValue());
                } else if (evt.getPropertyName().equals("InstanceChangedProperty")) {
                    this.handleInstanceChange((String)evt.getNewValue());
                } else if (evt.getPropertyName().equals("ProfileChangedProperty")) {
                    this.handleProfileChange((String)evt.getNewValue());
                } else if (evt.getPropertyName().equals("LongSIDChangedProperty")) {
                    this.handleLongSIDChange((String)evt.getNewValue());
                } else if (evt.getPropertyName().equals("ModeChangedProperty")) {
                    this.handleModeChange((String)evt.getNewValue());
                } else if (evt.getPropertyName().equals("CcmsCustomizingChangedProperty")) {
                    this.handleCcmsCustomizingChange((Boolean)evt.getNewValue());
                }
                if (currentAgent != null && currentAgent.isValid()) {
                    CcmsAgentConfigurationPanel.this.getButtonPanel().enableRegister();
                } else {
                    CcmsAgentConfigurationPanel.this.getButtonPanel().disableRegister();
                }
            }
        });
        agentPanel.addPropertyChangeListener(new PropertyChangeListener(){

            private void handleConfigFileChange(String newConfigFile) {
                if (currentAgent != null) {
                    String oldConfigFile = currentAgent.getConfigFileName();
                    if (oldConfigFile != null && newConfigFile != null && oldConfigFile.equals(newConfigFile)) {
                        return;
                    }
                    if (CcmsAgentConfigurationPanel.this.getAgentRuntime().isRunningInJ2eeEngine()) {
                        currentAgent.setConfigFile(new File(newConfigFile).getName(), CcmsAgentConfigurationPanel.this.getConf());
                    } else {
                        currentAgent.setConfigFileName(newConfigFile);
                    }
                    CcmsAgentConfigurationPanel.this.getPasswordPanel().setAdminUserInformation(currentAgent.getAdminUser(), currentAgent.getAdminClient(), currentAgent.getAdminSystem());
                    CcmsAgentConfigurationPanel.this.getPasswordPanel().setCsmregUserInformation(currentAgent.getCsmregUser(), currentAgent.getCsmregClient(), currentAgent.getCsmregSystem());
                }
            }

            private void handleExecFileChange(String newExecFile) {
                if (currentAgent != null) {
                    String oldExecFile = currentAgent.getExecutableFileName();
                    boolean isExecFileValid = currentAgent.isExecutableValid();
                    if (oldExecFile != null && newExecFile != null && oldExecFile.equals(newExecFile) && isExecFileValid) {
                        return;
                    }
                    currentAgent.setExecutableFileName(CcmsAgentConfigurationPanel.this.getAgentRuntime().isExecutableValid(newExecFile) ? newExecFile : "");
                }
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("AgentConfigFileChangedProperty")) {
                    this.handleConfigFileChange((String)evt.getNewValue());
                } else if (evt.getPropertyName().equals("AgentExecutableChangedProperty")) {
                    this.handleExecFileChange((String)evt.getNewValue());
                }
                if (currentAgent != null && currentAgent.isValid()) {
                    CcmsAgentConfigurationPanel.this.getButtonPanel().enableRegister();
                } else {
                    CcmsAgentConfigurationPanel.this.getButtonPanel().disableRegister();
                }
            }
        });
        if (initialSystemName != null || this.getAgentRuntime().isRunningInJ2eeEngine()) {
            modePanel.setStandaloneMode(false);
            modePanel.setSelectedSystem(initialSystemName);
        } else {
            modePanel.setStandaloneMode(true);
        }
        cp.add(modePanel);
        cp.add(agentPanel);
        cp.add(passwordPanel);
        cp.add(logMessagePanel);
        cp.add(buttonPanel);
        passwordPanel.addPropertyChangeListener(this);
        SpringUtilities.align(cp, 3, 3);
        this.setViewportView(cp);
        buttonPanel.setDefaultButton(0);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("CsmregPasswordChangedProperty")) {
            if (currentAgent == null) {
                return;
            }
            currentAgent.setAdminPassword((String)evt.getNewValue());
        } else if (evt.getPropertyName().equals("AdminPasswordChangedProperty")) {
            if (currentAgent == null) {
                return;
            }
            currentAgent.setCsmregPassword((String)evt.getNewValue());
        }
    }

    private Color getTextColor() {
        if (this.normalTextColor == null) {
            this.normalTextColor = UIManager.getColor("TextField.foreground");
        }
        return this.normalTextColor;
    }

    private Color getHiliteTextColor() {
        if (this.hiliteTextColor == null) {
            Color[] colorChoices = new Color[]{Color.red, Color.blue, Color.green, Color.cyan, Color.magenta};
            Color textColor = this.getTextColor();
            Color backgroundColor = UIManager.getColor("TextField.background");
            Color inactiveBackgroundColor = UIManager.getColor("TextField.inactiveBackground");
            int index = 0;
            while (index < colorChoices.length) {
                Color selectedColor = colorChoices[index];
                if (!(selectedColor.equals(textColor) || selectedColor.equals(backgroundColor) || selectedColor.equals(backgroundColor))) {
                    this.hiliteTextColor = selectedColor;
                    break;
                }
                ++index;
            }
            if (this.hiliteTextColor == null) {
                this.hiliteTextColor = textColor;
            }
        }
        return this.hiliteTextColor;
    }

    private ModeSelectionPanel getModePanel() {
        if (this.modePanel == null) {
            this.modePanel = new ModeSelectionPanel();
        }
        return this.modePanel;
    }

    private AgentDataPanel getAgentPanel() {
        if (this.agentPanel == null) {
            this.agentPanel = new AgentDataPanel();
        }
        return this.agentPanel;
    }

    private PasswordPanel getPasswordPanel() {
        if (this.passwordPanel == null) {
            this.passwordPanel = new PasswordPanel();
        }
        return this.passwordPanel;
    }

    private LogMessagePanel getMessagePanel() {
        if (this.logMessagePanel == null) {
            this.logMessagePanel = new LogMessagePanel();
        }
        return this.logMessagePanel;
    }

    private ButtonPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new ButtonPanel();
        }
        return this.buttonPanel;
    }

    public String getInstallationBaseDirectory() {
        File dir;
        JTextField directoryName = new JTextField();
        SelectInstallationDirectoryAction action = new SelectInstallationDirectoryAction(null, directoryName, "SAPXXX");
        ((OpenFileAction)action).actionPerformed(null);
        String directory = directoryName.getText();
        if (directory != null && directory.length() > 0 && (dir = new File(directory)) != null && dir.exists() && dir.isDirectory()) {
            return dir.getAbsolutePath();
        }
        return null;
    }

    private AgentConfigurationRuntimeInterface getAgentRuntime() {
        return this.managementInterface;
    }

    public Conf getConf() {
        return this.conf;
    }

    public void setConf(Conf conf) {
        this.conf = conf;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LogMessagePanel
    extends JPanel {
        private JEditorPane logPane = null;

        public LogMessagePanel() {
            this.init();
        }

        public void append(InputStream s) {
            if (s == null) {
                return;
            }
            HTMLEditorKit kit = (HTMLEditorKit)this.logPane.getEditorKit();
            Document doc = this.logPane.getDocument();
            try {
                kit.read(s, doc, doc.getLength());
            }
            catch (Exception e) {
                // empty catch block
            }
            this.setFont();
        }

        public void show(InputStream s) {
            String buffer = new String("<html>");
            if (s == null || buffer == null) {
                return;
            }
            try {
                boolean size = false;
                byte[] buf = new byte[8192];
                int got = s.read(buf);
                while (got >= 0) {
                    buffer = buffer + new String(buf, 0, got);
                    got = s.read(buf);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            buffer = buffer + "</html>";
            this.logPane.setText(buffer);
            this.setFont();
        }

        private void init() {
            SpringLayout layout = new SpringLayout();
            this.setLayout(layout);
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            this.logPane = new JEditorPane();
            this.logPane.setContentType("text/html");
            this.logPane.setEditable(false);
            this.logPane.setBackground(UIManager.getColor("TextField.inactiveBackground"));
            JScrollPane scrollPane = new JScrollPane(this.logPane);
            this.add(scrollPane);
            layout.putConstraint("North", (Component)scrollPane, 6, "North", (Component)this);
            layout.putConstraint("West", (Component)scrollPane, 5, "West", (Component)this);
            layout.putConstraint("East", (Component)scrollPane, -5, "East", (Component)this);
            layout.putConstraint("South", (Component)scrollPane, -6, "South", (Component)this);
            SpringLayout.Constraints panelCons = layout.getConstraints(scrollPane);
            panelCons.setConstraint("North", Spring.sum(Spring.constant(5), layout.getConstraints(this).getConstraint("North")));
            panelCons.setConstraint("West", Spring.sum(Spring.constant(5), layout.getConstraints(this).getConstraint("West")));
            this.setPreferredSize(new Dimension(1, 100));
        }

        private void setFont() {
            HTMLEditorKit kit = (HTMLEditorKit)this.logPane.getEditorKit();
            StyledDocument doc = (StyledDocument)this.logPane.getDocument();
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            StyleConstants.setFontFamily(attrs, "Monospaced");
            doc.setParagraphAttributes(0, doc.getLength(), attrs, false);
        }
    }

    private class FileRequestPanel
    extends JPanel {
        private JTextField fileName = null;
        private String currentFileName = null;
        private JButton pushButton = null;
        private String propertyChangeEvent = null;
        private boolean hideButton = false;

        FileRequestPanel(String labelText, String propertyChangeEvent) {
            this(labelText, propertyChangeEvent, false);
        }

        FileRequestPanel(String labelText, String propertyChangeEvent, boolean hideButton) {
            this.propertyChangeEvent = propertyChangeEvent;
            this.hideButton = hideButton;
            this.init(labelText);
        }

        public void setOpenFileAction(OpenFileAction action) {
            action.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ FileRequestPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void propertyChange(PropertyChangeEvent evt) {
                    PropertyChangeEvent e = evt;
                    if (e != null) {
                        FileRequestPanel.access$4001(this.this$1, this.this$1.getChangeEvent(), e.getOldValue(), e.getNewValue());
                    }
                }
            });
            this.pushButton.setAction(action);
        }

        public void setFileName(String fileName, boolean hiliteText) {
            JTextField field = this.getFileNameField();
            if (hiliteText) {
                field.setForeground(CcmsAgentConfigurationPanel.this.getHiliteTextColor());
            } else {
                field.setForeground(CcmsAgentConfigurationPanel.this.getTextColor());
            }
            field.setText(fileName);
            this.currentFileName = fileName;
        }

        public String getFileName() {
            return this.currentFileName;
        }

        protected void setAction(Action action) {
            this.pushButton.setAction(action);
        }

        protected JTextField getFileNameField() {
            return this.fileName;
        }

        protected String getChangeEvent() {
            return this.propertyChangeEvent;
        }

        private void init(String labelText) {
            SpringLayout layout = new SpringLayout();
            this.setLayout(layout);
            JLabel label = new JLabel(labelText);
            this.add(label);
            SpringLayout.Constraints labelConstraints = layout.getConstraints(label);
            labelConstraints.setX(Spring.constant(5));
            labelConstraints.setConstraint("North", Spring.sum(Spring.constant(8), layout.getConstraints(this).getConstraint("North")));
            this.fileName = new JTextField();
            this.fileName.setEditable(false);
            Dimension dim = this.fileName.getPreferredSize();
            this.add(this.fileName);
            layout.getConstraints(this.fileName).setHeight(Spring.constant(dim.height + 1));
            SpringLayout.Constraints fileNameCons = layout.getConstraints(this.fileName);
            layout.putConstraint("North", (Component)this.fileName, -2, "North", (Component)label);
            layout.putConstraint("West", (Component)this.fileName, 25, "East", (Component)label);
            fileNameCons.setHeight(Spring.constant(dim.height + 1));
            this.pushButton = new JButton();
            this.pushButton.setPreferredSize(new Dimension(90, 26));
            if (!this.hideButton) {
                this.add(this.pushButton);
            }
            layout.putConstraint("North", (Component)this.pushButton, -3, "North", (Component)this.fileName);
            layout.putConstraint("East", (Component)this.pushButton, 0, "East", (Component)this);
            SpringLayout.Constraints panelCons = layout.getConstraints(this);
            panelCons.setConstraint("South", Spring.sum(Spring.constant(5), layout.getConstraints(this.pushButton).getConstraint("South")));
            panelCons.setConstraint("East", Spring.sum(Spring.constant(100), layout.getConstraints(this.fileName).getConstraint("East")));
        }

        static /* synthetic */ void access$4001(FileRequestPanel x0, String x1, Object x2, Object x3) {
            super.firePropertyChange(x1, x2, x3);
        }
    }

    private class AgentConfigFilePanel
    extends FileRequestPanel {
        AgentConfigFilePanel(String propertyChangeEvent) {
            super("Agent Configuration File", propertyChangeEvent);
            this.setOpenFileAction(new OpenConfigFileAction(this, this.getFileNameField(), rb.getString("change.label")));
        }
    }

    private class AgentExecutablePanel
    extends FileRequestPanel {
        AgentExecutablePanel(String propertyChangeEvent) {
            super("Agent Executable", propertyChangeEvent, CcmsAgentConfigurationPanel.this.getAgentRuntime().isRunningInJ2eeEngine());
            this.setOpenFileAction(new OpenExecutableFileAction(this, this.getFileNameField(), rb.getString("change.label")));
        }
    }

    private class ButtonPanel
    extends JPanel {
        public static final int REGISTER_BUTTON = 0;
        public static final int UNREGISTER_BUTTON = 1;
        public static final int EXIT_BUTTON = 2;
        private JButton registerButton = null;
        private JButton exitButton = null;
        private JButton advancedButton = null;
        private JButton unregisterButton = null;

        ButtonPanel() {
            this.init();
        }

        public void enableRegister() {
            if (this.registerButton != null) {
                this.registerButton.setEnabled(true);
            }
            if (this.unregisterButton != null) {
                this.unregisterButton.setEnabled(true);
            }
        }

        public void disableRegister() {
            if (this.registerButton != null) {
                this.registerButton.setEnabled(false);
            }
            if (this.unregisterButton != null) {
                this.unregisterButton.setEnabled(false);
            }
        }

        public boolean isRegisterEnabled() {
            return this.registerButton != null ? this.registerButton.isEnabled() : false;
        }

        public void setDefaultButton(int buttonID) {
            if (buttonID != 0 && buttonID != 1 && buttonID != 2) {
                return;
            }
            RootPaneContainer aContainer = null;
            Container aComponent = CcmsAgentConfigurationPanel.this.getMainFrame();
            while (aComponent.getParent() != null && !(aComponent instanceof RootPaneContainer)) {
                aComponent = aComponent.getParent();
            }
            if (aComponent instanceof RootPaneContainer) {
                aContainer = (RootPaneContainer)((Object)aComponent);
            }
            if (aContainer != null) {
                JButton newDefaultButton = buttonID == 0 ? this.registerButton : (buttonID == 1 ? this.unregisterButton : this.exitButton);
                aContainer.getRootPane().setDefaultButton(newDefaultButton);
            }
        }

        private void init() {
            SpringLayout layout = new SpringLayout();
            this.setLayout(layout);
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            RegisterButtonAction actionButtonRegister = new RegisterButtonAction(rb.getString("register.label"));
            UnregisterButtonAction actionButtonUnregister = new UnregisterButtonAction("Unregister");
            ExitButtonAction actionButtonExit = new ExitButtonAction(rb.getString("exit.label"));
            AdvancedButtonAction actionButtonAdvanced = new AdvancedButtonAction("Advanced");
            this.registerButton = new JButton(actionButtonRegister);
            this.registerButton.setPreferredSize(new Dimension(100, 26));
            this.add(this.registerButton);
            layout.putConstraint("North", (Component)this.registerButton, 5, "North", (Component)this);
            layout.putConstraint("West", (Component)this.registerButton, 5, "West", (Component)this);
            this.unregisterButton = new JButton(actionButtonUnregister);
            this.unregisterButton.setPreferredSize(new Dimension(100, 26));
            this.add(this.unregisterButton);
            layout.putConstraint("North", (Component)this.unregisterButton, 0, "North", (Component)this.registerButton);
            layout.putConstraint("West", (Component)this.unregisterButton, 5, "East", (Component)this.registerButton);
            this.exitButton = new JButton(actionButtonExit);
            this.exitButton.setPreferredSize(new Dimension(100, 26));
            this.add(this.exitButton);
            layout.putConstraint("North", (Component)this.exitButton, 0, "North", (Component)this.registerButton);
            layout.putConstraint("East", (Component)this.exitButton, -5, "East", (Component)this);
            if (CcmsAgentConfigurationPanel.this.getAgentRuntime().isRunningInJ2eeEngine()) {
                this.exitButton.setVisible(false);
            }
            this.advancedButton = new JButton(actionButtonAdvanced);
            this.advancedButton.setPreferredSize(new Dimension(100, 26));
            this.advancedButton.setEnabled(false);
            this.add(this.advancedButton);
            layout.putConstraint("North", (Component)this.advancedButton, 0, "North", (Component)this.exitButton);
            layout.putConstraint("East", (Component)this.advancedButton, -10, "West", (Component)this.exitButton);
            SpringLayout.Constraints panelCons = layout.getConstraints(this);
            panelCons.setConstraint("South", Spring.sum(Spring.constant(5), layout.getConstraints(this.exitButton).getConstraint("South")));
        }
    }

    private class ModeSelectionPanel
    extends JPanel {
        public static final String SYSTEM_CHANGED_PROPERTY = "SystemChangedProperty";
        public static final String INSTANCE_CHANGED_PROPERTY = "InstanceChangedProperty";
        public static final String PROFILE_CHANGED_PROPERTY = "ProfileChangedProperty";
        public static final String LONG_SID_CHANGED_PROPERTY = "LongSIDChangedProperty";
        public static final String CCMS_CUSTOMIZING_CHANGED_PROPERTY = "CcmsCustomizingChangedProperty";
        public static final String MODE_CHANGED_PROPERTY = "ModeChangedProperty";
        public static final String J2EE_MODE_SELECTED = "SAP J2EE Engine";
        public static final String STANDALONE_MODE_SELECTED = "Standalone";
        private final JRadioButton j2eeMode = new JRadioButton("SAP Netweaver J2EE Engine");
        private final JLabel systemLabel = new JLabel("System ID");
        private final JComboBox systemChoices = new JComboBox();
        private final JComboBox instanceChoices = new JComboBox();
        private final JLabel instanceLabel = new JLabel("Instance");
        private final JLabel profileLabel = new JLabel("Profile");
        private final JTextField textFieldProfile = new JTextField();
        private final LongSIDTextField textFieldLongSID = new LongSIDTextField("LongSIDChangedProperty");
        private final JCheckBox checkLongSID = new JCheckBox("Long SID");
        private final JCheckBox enableCCMScustomizing = new JCheckBox("Enable CCMS Customizing");
        private final JButton pushButton = new JButton();
        private final JRadioButton standaloneMode = new JRadioButton("J2EE Engine 6.20 / TREX / OS Only");
        private String selectedSystem = null;
        private String selectedInstance = null;
        private boolean systemSelectionInProgress = false;

        ModeSelectionPanel() {
            this.init();
        }

        public String getSelectedSystem() {
            return this.selectedSystem;
        }

        public String getSelectedInstance() {
            return this.selectedInstance;
        }

        public String getLongSID() {
            return this.checkLongSID.isSelected() ? this.textFieldLongSID.getText() : "";
        }

        public void setLongSID(String longSID) {
            boolean isLongSID = longSID != null && longSID.length() > 0;
            this.textFieldLongSID.setVerifiedText(isLongSID ? longSID : "");
            this.checkLongSID.setSelected(isLongSID);
        }

        public boolean isCcmsCustomizingEnabled() {
            return this.enableCCMScustomizing.isSelected();
        }

        public void setCcmsCustomizingEnabled(boolean enable) {
            this.enableCCMScustomizing.setSelected(enable);
        }

        public void setProfileFileName(String fileName, boolean hiliteText) {
            if (hiliteText) {
                this.textFieldProfile.setForeground(CcmsAgentConfigurationPanel.this.getHiliteTextColor());
            } else {
                this.textFieldProfile.setForeground(CcmsAgentConfigurationPanel.this.getTextColor());
            }
            this.textFieldProfile.setText(fileName);
        }

        public void setSelectedSystem(String systemName) {
            this.systemChoices.setSelectedItem(systemName);
        }

        public boolean isStandaloneMode() {
            return this.standaloneMode.isSelected();
        }

        private void setStandaloneMode(boolean isStandalone) {
            if (isStandalone) {
                ComboBoxModel model;
                String initialSystemSelection;
                if (this.selectedSystem == null && (initialSystemSelection = (String)(model = this.systemChoices.getModel()).getElementAt(0)) != null) {
                    this.setSelectedSystem(initialSystemSelection);
                }
                this.standaloneMode.doClick();
            } else {
                this.j2eeMode.doClick();
            }
        }

        private void enableJ2EEModeEntries(boolean enable) {
            this.systemChoices.setEnabled(enable);
            this.instanceChoices.setEnabled(enable);
            this.textFieldProfile.setEnabled(enable);
            this.pushButton.setEnabled(enable);
            String systemName = (String)this.systemChoices.getSelectedItem();
            this.checkLongSID.setEnabled(enable && systemName != null);
            this.enableLongSIDtextField(enable);
        }

        private void enableLongSIDtextField(boolean enable) {
            boolean enableTextField = false;
            if (enable && this.checkLongSID.isSelected()) {
                enableTextField = true;
            }
            this.textFieldLongSID.setEnabled(enableTextField);
        }

        private void assureAgentIsExisting(String systemName, String instanceNumber, String profileFileName) {
            J2EEAgent agent = CcmsAgentConfigurationPanel.this.getAgent(systemName, instanceNumber);
            if (agent != null) {
                return;
            }
            CcmsAgentConfigurationPanel.this.getAgentRuntime().addInstallledSystem(systemName, instanceNumber);
            boolean isWithinJ2EE = CcmsAgentConfigurationPanel.this.getAgentRuntime().isRunningInJ2eeEngine();
            agent = J2EEAgentProxy.create(systemName, isWithinJ2EE ? null : instanceNumber, CcmsAgentConfigurationPanel.this.getAgentRuntime());
            agent.setProfileName(profileFileName);
            J2EEAgent dummyAgent = CcmsAgentConfigurationPanel.this.getAgent(null, null);
            if (dummyAgent != null) {
                agent.setConfigFileName(dummyAgent.getConfigFileName());
                agent.setExecutableFileName(dummyAgent.getExecutableFileName());
            }
            CcmsAgentConfigurationPanel.this.putAgent(systemName, instanceNumber, agent);
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.systemChoices.getModel();
            int index = model.getIndexOf(systemName);
            if (index == -1) {
                model.addElement(systemName);
            }
            this.enableJ2EEModeEntries(true);
        }

        private void init() {
            SpringLayout layout = new SpringLayout();
            this.setLayout(layout);
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            boolean isWithinJ2EE = CcmsAgentConfigurationPanel.this.getAgentRuntime().isRunningInJ2eeEngine();
            SpringLayout.Constraints panelConstraints = layout.getConstraints(this);
            Spring rowPos = Spring.sum(panelConstraints.getY(), Spring.constant(5));
            SpringLayout.Constraints cons = null;
            ButtonGroup buttonGroup = new ButtonGroup();
            if (!isWithinJ2EE) {
                buttonGroup.add(this.j2eeMode);
                this.add(this.j2eeMode);
                cons = layout.getConstraints(this.j2eeMode);
                cons.setY(rowPos);
                layout.putConstraint("West", (Component)this.j2eeMode, 5, "West", (Component)this);
                rowPos = Spring.sum(panelConstraints.getY(), cons.getHeight());
            }
            this.add(this.systemLabel);
            cons = layout.getConstraints(this.systemLabel);
            rowPos = Spring.sum(rowPos, Spring.constant(10));
            cons.setY(rowPos);
            layout.putConstraint("West", (Component)this.systemLabel, isWithinJ2EE ? 5 : 35, "West", (Component)this);
            rowPos = Spring.sum(cons.getY(), cons.getHeight());
            Object[] allSystems = CcmsAgentConfigurationPanel.this.getAgentRuntime().allSystems();
            Arrays.sort(allSystems);
            DefaultComboBoxModel<Object> allSystemNamesModel = new DefaultComboBoxModel<Object>(allSystems);
            DefaultComboBoxModel instanceModel = new DefaultComboBoxModel();
            this.systemChoices.setModel(allSystemNamesModel);
            this.systemChoices.setPreferredSize(new Dimension(80, 26));
            this.systemChoices.addActionListener(new ActionListener(this, instanceModel){
                private final /* synthetic */ DefaultComboBoxModel val$instanceModel;
                private final /* synthetic */ ModeSelectionPanel this$1;
                {
                    this.this$1 = this$1;
                    this.val$instanceModel = val$instanceModel;
                }

                private void handleSystemChoiceSelection(ActionEvent e) {
                    JComboBox box = (JComboBox)e.getSource();
                    if (box == null) {
                        return;
                    }
                    String newSelectedSystem = (String)box.getSelectedItem();
                    if (newSelectedSystem == null || newSelectedSystem == CcmsAgentConfigurationPanel.access$800()) {
                        return;
                    }
                    String[] instanceNumbers = CcmsAgentConfigurationPanel.access$100(ModeSelectionPanel.access$2100(this.this$1)).instanceNumbers(newSelectedSystem);
                    this.val$instanceModel.removeAllElements();
                    if (instanceNumbers == null) {
                        return;
                    }
                    int i = 0;
                    while (i < instanceNumbers.length) {
                        this.val$instanceModel.addElement(instanceNumbers[i]);
                        ++i;
                    }
                    String lastSelectedSystem = ModeSelectionPanel.access$2200(this.this$1);
                    ModeSelectionPanel.access$2202(this.this$1, newSelectedSystem);
                    ModeSelectionPanel.access$2300(this.this$1).setSelectedIndex(0);
                    ModeSelectionPanel.access$2401(this.this$1, "SystemChangedProperty", lastSelectedSystem, ModeSelectionPanel.access$2200(this.this$1));
                }

                public void actionPerformed(ActionEvent e) {
                    if (ModeSelectionPanel.access$2500(this.this$1).getActionCommand().equals(e.getActionCommand())) {
                        ModeSelectionPanel.access$2602(this.this$1, true);
                        this.handleSystemChoiceSelection(e);
                        ModeSelectionPanel.access$2602(this.this$1, false);
                    }
                }
            });
            this.instanceChoices.setModel(instanceModel);
            this.instanceChoices.setPreferredSize(new Dimension(80, 26));
            this.instanceChoices.addActionListener(new ActionListener(this){
                private final /* synthetic */ ModeSelectionPanel this$1;
                {
                    this.this$1 = this$1;
                }

                private void handleInstanceChoiceSelection(ActionEvent e) {
                    JComboBox box = (JComboBox)e.getSource();
                    if (box == null) {
                        return;
                    }
                    String newSelectedInstance = (String)box.getSelectedItem();
                    if (newSelectedInstance == null) {
                        return;
                    }
                    String lastSelectedInstance = ModeSelectionPanel.access$2700(this.this$1);
                    ModeSelectionPanel.access$2702(this.this$1, newSelectedInstance);
                    if (!ModeSelectionPanel.access$2600(this.this$1)) {
                        ModeSelectionPanel.access$2801(this.this$1, "InstanceChangedProperty", lastSelectedInstance, ModeSelectionPanel.access$2700(this.this$1));
                    }
                }

                public void actionPerformed(ActionEvent e) {
                    if (ModeSelectionPanel.access$2300(this.this$1).getActionCommand().equals(e.getActionCommand())) {
                        this.handleInstanceChoiceSelection(e);
                    }
                }
            });
            this.add(this.systemChoices);
            layout.putConstraint("North", (Component)this.systemChoices, -4, "North", (Component)this.systemLabel);
            layout.putConstraint("West", (Component)this.systemChoices, 25, "East", (Component)this.systemLabel);
            layout.getConstraints(this.systemChoices).setHeight(Spring.constant(this.systemChoices.getPreferredSize().height + 1));
            if (!isWithinJ2EE) {
                this.add(this.instanceLabel);
                layout.putConstraint("North", (Component)this.instanceLabel, 0, "North", (Component)this.systemLabel);
                layout.putConstraint("West", (Component)this.instanceLabel, 25, "East", (Component)this.systemChoices);
                this.add(this.instanceChoices);
                layout.putConstraint("North", (Component)this.instanceChoices, 0, "North", (Component)this.systemChoices);
                layout.putConstraint("West", (Component)this.instanceChoices, 25, "East", (Component)this.instanceLabel);
                layout.getConstraints(this.instanceChoices).setHeight(Spring.constant(this.instanceChoices.getPreferredSize().height + 1));
            }
            this.add(this.profileLabel);
            cons = layout.getConstraints(this.profileLabel);
            rowPos = Spring.sum(rowPos, Spring.constant(15));
            cons.setY(rowPos);
            layout.putConstraint("West", (Component)this.profileLabel, 0, "West", (Component)this.systemLabel);
            rowPos = Spring.sum(cons.getY(), cons.getHeight());
            this.textFieldProfile.setEditable(false);
            this.add(this.textFieldProfile);
            layout.putConstraint("North", (Component)this.textFieldProfile, -2, "North", (Component)this.profileLabel);
            layout.putConstraint("West", (Component)this.textFieldProfile, 0, "West", (Component)this.systemChoices);
            layout.getConstraints(this.textFieldProfile).setHeight(Spring.constant(this.textFieldProfile.getPreferredSize().height + 2));
            OpenProfileAction actionButtonProfile = new OpenProfileAction(this, this.textFieldProfile, rb.getString("change.label"));
            actionButtonProfile.addPropertyChangeListener(new PropertyChangeListener(this, instanceModel){
                private final /* synthetic */ DefaultComboBoxModel val$instanceModel;
                private final /* synthetic */ ModeSelectionPanel this$1;
                {
                    this.this$1 = this$1;
                    this.val$instanceModel = val$instanceModel;
                }

                public void propertyChange(PropertyChangeEvent evt) {
                    String selectedProfileFileName = (String)evt.getNewValue();
                    if (CcmsAgentConfigurationPanel.access$100(ModeSelectionPanel.access$2100(this.this$1)).isProfileValid(selectedProfileFileName)) {
                        String selectedSystemName = CcmsAgentConfigurationPanel.access$100(ModeSelectionPanel.access$2100(this.this$1)).getSystemNameFromProfile(selectedProfileFileName);
                        String selectedInstanceNumber = CcmsAgentConfigurationPanel.access$100(ModeSelectionPanel.access$2100(this.this$1)).getInstanceNumberFromProfile(selectedProfileFileName);
                        ModeSelectionPanel.access$3000(this.this$1, selectedSystemName, selectedInstanceNumber, selectedProfileFileName);
                        boolean systemHasNotChanged = selectedSystemName.equals(CcmsAgentConfigurationPanel.access$800());
                        ModeSelectionPanel.access$2500(this.this$1).setSelectedItem(selectedSystemName);
                        if (systemHasNotChanged && this.val$instanceModel.getIndexOf(selectedInstanceNumber) == -1) {
                            String[] instanceNumbers = CcmsAgentConfigurationPanel.access$100(ModeSelectionPanel.access$2100(this.this$1)).instanceNumbers(selectedSystemName);
                            this.val$instanceModel.removeAllElements();
                            if (instanceNumbers == null) {
                                return;
                            }
                            int i = 0;
                            while (i < instanceNumbers.length) {
                                this.val$instanceModel.addElement(instanceNumbers[i]);
                                ++i;
                            }
                        }
                        ModeSelectionPanel.access$2300(this.this$1).setSelectedItem(selectedInstanceNumber);
                    }
                }
            });
            this.pushButton.setAction(actionButtonProfile);
            this.pushButton.setPreferredSize(new Dimension(90, 26));
            if (!isWithinJ2EE) {
                this.add(this.pushButton);
                layout.putConstraint("North", (Component)this.pushButton, -3, "North", (Component)this.textFieldProfile);
                layout.putConstraint("East", (Component)this.pushButton, -5, "East", (Component)this);
            }
            this.checkLongSID.addItemListener(new ItemListener(this){
                private final /* synthetic */ ModeSelectionPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void itemStateChanged(ItemEvent e) {
                    boolean enable = e.getStateChange() == 1;
                    String newLongSID = null;
                    String oldLongSID = ModeSelectionPanel.access$3100(this.this$1).getText();
                    if (enable) {
                        newLongSID = ModeSelectionPanel.access$3100(this.this$1).getText();
                        if (newLongSID == null || newLongSID.length() == 0) {
                            newLongSID = CcmsAgentConfigurationPanel.access$800();
                        }
                    } else {
                        newLongSID = "";
                    }
                    ModeSelectionPanel.access$3200(this.this$1, enable);
                    ModeSelectionPanel.access$3100(this.this$1).setVerifiedText(newLongSID);
                    if (newLongSID.compareTo(oldLongSID) != 0) {
                        ModeSelectionPanel.access$3301(this.this$1, "LongSIDChangedProperty", oldLongSID, newLongSID);
                    }
                }
            });
            this.checkLongSID.setToolTipText(rb.getString("tooltip.longSIDcheckBox"));
            this.add(this.checkLongSID);
            cons = layout.getConstraints(this.checkLongSID);
            rowPos = Spring.sum(rowPos, Spring.constant(15));
            cons.setY(rowPos);
            layout.putConstraint("West", (Component)this.checkLongSID, -5, "West", (Component)this.profileLabel);
            rowPos = Spring.sum(cons.getY(), cons.getHeight());
            this.textFieldLongSID.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ ModeSelectionPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void propertyChange(PropertyChangeEvent evt) {
                    ModeSelectionPanel.access$3401(this.this$1, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
                }
            });
            this.textFieldLongSID.setToolTipText(rb.getString("tooltip.longSIDtextBox"));
            this.add(this.textFieldLongSID);
            layout.putConstraint("North", (Component)this.textFieldLongSID, 0, "North", (Component)this.checkLongSID);
            layout.putConstraint("West", (Component)this.textFieldLongSID, 0, "West", (Component)this.textFieldProfile);
            if (isWithinJ2EE) {
                this.enableCCMScustomizing.addItemListener(new ItemListener(this){
                    private final /* synthetic */ ModeSelectionPanel this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void itemStateChanged(ItemEvent e) {
                        boolean enable = e.getStateChange() == 1;
                        this.this$1.firePropertyChange("CcmsCustomizingChangedProperty", !enable, enable);
                    }
                });
                this.add(this.enableCCMScustomizing);
                cons = layout.getConstraints(this.enableCCMScustomizing);
                rowPos = Spring.sum(rowPos, Spring.constant(15));
                cons.setY(rowPos);
                layout.putConstraint("West", (Component)this.enableCCMScustomizing, -5, "West", (Component)this.profileLabel);
                rowPos = Spring.sum(cons.getY(), cons.getHeight());
            }
            if (!isWithinJ2EE) {
                this.add(this.standaloneMode);
                buttonGroup.add(this.standaloneMode);
                cons = layout.getConstraints(this.standaloneMode);
                rowPos = Spring.sum(rowPos, Spring.constant(15));
                cons.setY(rowPos);
                layout.putConstraint("West", (Component)this.standaloneMode, 0, "West", (Component)this.j2eeMode);
                rowPos = Spring.sum(cons.getY(), cons.getHeight());
            }
            SpringLayout.Constraints panelCons = layout.getConstraints(this);
            panelCons.setConstraint("South", Spring.sum(Spring.constant(5), rowPos));
            panelCons.setConstraint("East", Spring.sum(Spring.constant(100), layout.getConstraints(this.textFieldProfile).getConstraint("East")));
            ActionListener selectModeActionListener = new ActionListener(this){
                private final /* synthetic */ ModeSelectionPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    boolean enable = false;
                    if (ModeSelectionPanel.access$3500(this.this$1).getActionCommand().equals(e.getActionCommand())) {
                        enable = true;
                    } else if (ModeSelectionPanel.access$3600(this.this$1).getActionCommand().equals(e.getActionCommand())) {
                        enable = false;
                    } else {
                        return;
                    }
                    ModeSelectionPanel.access$3701(this.this$1, "ModeChangedProperty", enable ? "Standalone" : "SAP J2EE Engine", enable ? "SAP J2EE Engine" : "Standalone");
                    ModeSelectionPanel.access$3800(this.this$1, enable);
                }
            };
            this.j2eeMode.addActionListener(selectModeActionListener);
            this.standaloneMode.addActionListener(selectModeActionListener);
        }

        static /* synthetic */ CcmsAgentConfigurationPanel access$2100(ModeSelectionPanel x0) {
            return x0.CcmsAgentConfigurationPanel.this;
        }

        static /* synthetic */ String access$2200(ModeSelectionPanel x0) {
            return x0.selectedSystem;
        }

        static /* synthetic */ String access$2202(ModeSelectionPanel x0, String x1) {
            x0.selectedSystem = x1;
            return x0.selectedSystem;
        }

        static /* synthetic */ JComboBox access$2300(ModeSelectionPanel x0) {
            return x0.instanceChoices;
        }

        static /* synthetic */ void access$2401(ModeSelectionPanel x0, String x1, Object x2, Object x3) {
            super.firePropertyChange(x1, x2, x3);
        }

        static /* synthetic */ JComboBox access$2500(ModeSelectionPanel x0) {
            return x0.systemChoices;
        }

        static /* synthetic */ boolean access$2602(ModeSelectionPanel x0, boolean x1) {
            x0.systemSelectionInProgress = x1;
            return x0.systemSelectionInProgress;
        }

        static /* synthetic */ String access$2700(ModeSelectionPanel x0) {
            return x0.selectedInstance;
        }

        static /* synthetic */ String access$2702(ModeSelectionPanel x0, String x1) {
            x0.selectedInstance = x1;
            return x0.selectedInstance;
        }

        static /* synthetic */ boolean access$2600(ModeSelectionPanel x0) {
            return x0.systemSelectionInProgress;
        }

        static /* synthetic */ void access$2801(ModeSelectionPanel x0, String x1, Object x2, Object x3) {
            super.firePropertyChange(x1, x2, x3);
        }

        static /* synthetic */ void access$3000(ModeSelectionPanel x0, String x1, String x2, String x3) {
            x0.assureAgentIsExisting(x1, x2, x3);
        }

        static /* synthetic */ LongSIDTextField access$3100(ModeSelectionPanel x0) {
            return x0.textFieldLongSID;
        }

        static /* synthetic */ void access$3200(ModeSelectionPanel x0, boolean x1) {
            x0.enableLongSIDtextField(x1);
        }

        static /* synthetic */ void access$3301(ModeSelectionPanel x0, String x1, Object x2, Object x3) {
            super.firePropertyChange(x1, x2, x3);
        }

        static /* synthetic */ void access$3401(ModeSelectionPanel x0, String x1, Object x2, Object x3) {
            super.firePropertyChange(x1, x2, x3);
        }

        static /* synthetic */ JRadioButton access$3500(ModeSelectionPanel x0) {
            return x0.j2eeMode;
        }

        static /* synthetic */ JRadioButton access$3600(ModeSelectionPanel x0) {
            return x0.standaloneMode;
        }

        static /* synthetic */ void access$3701(ModeSelectionPanel x0, String x1, Object x2, Object x3) {
            super.firePropertyChange(x1, x2, x3);
        }

        static /* synthetic */ void access$3800(ModeSelectionPanel x0, boolean x1) {
            x0.enableJ2EEModeEntries(x1);
        }
    }

    private class LongSIDTextField
    extends JTextField {
        private static final int LONG_SID_LENGTH = 8;
        private String changeEvent = null;
        private boolean verifyInput = true;

        public LongSIDTextField() {
            this.init();
        }

        public LongSIDTextField(String changeEvent) {
            this.setChangeEvent(changeEvent);
            this.init();
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            Color fieldColor = enabled ? UIManager.getColor("TextField.background") : UIManager.getColor("TextField.inactiveBackground");
            this.setBackground(fieldColor);
        }

        public void setVerifiedText(String text) {
            this.setInputVerification(false);
            this.setText(text);
            this.setInputVerification(true);
        }

        private final void setInputVerification(boolean verifyInput) {
            this.verifyInput = verifyInput;
        }

        private final boolean inputVerificationRequired() {
            return this.verifyInput;
        }

        private final void setChangeEvent(String changeEvent) {
            this.changeEvent = changeEvent;
        }

        private final String getChangeEvent() {
            return this.changeEvent;
        }

        private void init() {
            FontMetrics fm = ((Component)this).getFontMetrics(this.getFont());
            this.setPreferredSize(new Dimension(fm.charWidth('W') * 8 + 10, fm.getHeight() + 5));
            ((JTextComponent)this).setDocument(new PlainDocument(this){
                private int maxLen;
                private final /* synthetic */ LongSIDTextField this$1;
                {
                    this.this$1 = this$1;
                    this.maxLen = 8;
                }

                public void insertString(int param, String str, AttributeSet attributeSet) throws BadLocationException {
                    boolean insertIsValid = false;
                    if (str != null && param > 2) {
                        boolean bl = insertIsValid = this.getLength() + str.length() <= this.maxLen;
                        if (insertIsValid) {
                            char[] input = str.toCharArray();
                            int i = 0;
                            while (i < input.length) {
                                if (!Character.isLetterOrDigit(input[i])) {
                                    insertIsValid = false;
                                    break;
                                }
                                ++i;
                            }
                        }
                    }
                    if (!insertIsValid && LongSIDTextField.access$1500(this.this$1)) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    super.insertString(param, str, attributeSet);
                }

                public void remove(int offs, int len) throws BadLocationException {
                    boolean removeIsValid = true;
                    boolean bl = removeIsValid = offs > 2;
                    if (!removeIsValid && LongSIDTextField.access$1500(this.this$1)) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    super.remove(offs, len);
                }
            });
            this.addFocusListener(new FocusListener(this){
                private String initialLongSID;
                private final /* synthetic */ LongSIDTextField this$1;
                {
                    this.this$1 = this$1;
                    this.initialLongSID = "";
                }

                public void focusGained(FocusEvent e) {
                    this.initialLongSID = this.this$1.getText();
                }

                public void focusLost(FocusEvent e) {
                    String newLongSID = this.this$1.getText();
                    String changeEvent = LongSIDTextField.access$1600(this.this$1);
                    if (changeEvent != null && this.initialLongSID.compareTo(newLongSID) != 0) {
                        LongSIDTextField.access$1701(this.this$1, changeEvent, this.initialLongSID, newLongSID);
                    }
                }
            });
        }

        static /* synthetic */ boolean access$1500(LongSIDTextField x0) {
            return x0.inputVerificationRequired();
        }

        static /* synthetic */ String access$1600(LongSIDTextField x0) {
            return x0.getChangeEvent();
        }

        static /* synthetic */ void access$1701(LongSIDTextField x0, String x1, Object x2, Object x3) {
            super.firePropertyChange(x1, x2, x3);
        }
    }

    private class PasswordPanel
    extends JPanel
    implements PropertyChangeListener {
        public static final String ADMIN_PASSWORD_CHANGED_PROPERTY = "CsmregPasswordChangedProperty";
        public static final String CSMREG_PASSWORD_CHANGED_PROPERTY = "AdminPasswordChangedProperty";
        private SimplePasswordPanel adminPassword;
        private SimplePasswordPanel csmregPassword;

        PasswordPanel() {
            this.adminPassword = new SimplePasswordPanel("Password for Administration User");
            this.csmregPassword = new SimplePasswordPanel("Password for CSMREG User");
            this.init();
        }

        public void clearPasswords() {
            this.adminPassword.clearPassword();
            this.csmregPassword.clearPassword();
        }

        public void setAdminUserInformation(String user, String mandant, String systemID) {
            this.adminPassword.setUserInformation(user, mandant, systemID);
        }

        public void setCsmregUserInformation(String user, String mandant, String systemID) {
            this.csmregPassword.setUserInformation(user, mandant, systemID);
        }

        public String getAdminPassword() {
            return this.adminPassword.getPassword();
        }

        public String getCsmregPassword() {
            return this.csmregPassword.getPassword();
        }

        private void init() {
            SpringLayout layout = new SpringLayout();
            this.setLayout(layout);
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            this.add(this.adminPassword);
            this.add(this.csmregPassword);
            this.adminPassword.addPropertyChangeListener(this);
            this.csmregPassword.addPropertyChangeListener(this);
            SpringUtilities.align(this, 5, 0);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("PasswordChangedProperty")) {
                try {
                    String forwardedEvent = null;
                    SimplePasswordPanel source = (SimplePasswordPanel)evt.getSource();
                    if (source == this.csmregPassword) {
                        forwardedEvent = CSMREG_PASSWORD_CHANGED_PROPERTY;
                    } else if (source == this.adminPassword) {
                        forwardedEvent = ADMIN_PASSWORD_CHANGED_PROPERTY;
                    }
                    if (forwardedEvent != null) {
                        this.firePropertyChange(forwardedEvent, evt.getOldValue(), evt.getNewValue());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class SimplePasswordPanel
    extends JPanel
    implements FocusListener {
        public static final String PASSWORD_CHANGED_PROPERTY = "PasswordChangedProperty";
        private JLabel label = null;
        private JPasswordField password = null;
        private String prefix = null;
        private String user = null;
        private String mandant = null;
        private String systemID = null;
        private String initialPassword = null;

        SimplePasswordPanel(String prefix) {
            this.init(prefix);
        }

        public void setUserInformation(String user, String mandant, String systemID) {
            this.user = user;
            this.mandant = mandant;
            this.systemID = systemID;
            this.updateLabel();
        }

        public void setUser(String user) {
            this.user = user;
            this.updateLabel();
        }

        public void setMandant(String mandant) {
            this.mandant = mandant;
            this.updateLabel();
        }

        public void setSystemID(String systemID) {
            this.systemID = systemID;
            this.updateLabel();
        }

        public String getPassword() {
            char[] pwd = this.password.getPassword();
            return pwd == null ? null : new String(pwd);
        }

        private void init(String prefix) {
            this.prefix = prefix;
            SpringLayout layout = new SpringLayout();
            this.setLayout(layout);
            this.label = new JLabel(this.prefix);
            this.add(this.label);
            layout.putConstraint("North", (Component)this.label, 6, "North", (Component)this);
            layout.putConstraint("West", (Component)this.label, 5, "West", (Component)this);
            this.password = new JPasswordField();
            FontMetrics fm = ((Component)this.password).getFontMetrics(this.password.getFont());
            Dimension dim = this.password.getPreferredSize();
            this.add(this.password);
            this.password.addFocusListener(this);
            SpringLayout.Constraints passwordCons = layout.getConstraints(this.password);
            passwordCons.setConstraint("North", layout.getConstraints(this.label).getConstraint("North"));
            passwordCons.setConstraint("West", Spring.constant(450));
            passwordCons.setHeight(Spring.constant(fm.getHeight() + 5));
            SpringLayout.Constraints panelCons = layout.getConstraints(this);
            panelCons.setConstraint("South", Spring.sum(Spring.constant(5), layout.getConstraints(this.password).getConstraint("South")));
            panelCons.setConstraint("East", Spring.sum(Spring.constant(0), layout.getConstraints(this.password).getConstraint("East")));
            this.setPreferredSize(new Dimension(450 + fm.charWidth('*') * 12 + 10, fm.getHeight() + 15));
        }

        private void updateLabel() {
            String labelText = this.prefix + " [";
            labelText = labelText + (this.systemID == null ? "<SID>" : this.systemID);
            labelText = labelText + ":";
            labelText = labelText + (this.mandant == null ? "<MANDANT>" : this.mandant);
            labelText = labelText + ":";
            labelText = labelText + (this.user == null ? "<USER>" : this.user);
            labelText = labelText + "]";
            this.label.setText(labelText);
        }

        public void focusGained(FocusEvent e) {
            this.initialPassword = this.getPassword();
        }

        public void focusLost(FocusEvent e) {
            String newPassword = this.getPassword();
            if (this.initialPassword == null && newPassword == null) {
                return;
            }
            if (this.initialPassword != null && this.initialPassword.equals(newPassword)) {
                return;
            }
            this.firePropertyChange(PASSWORD_CHANGED_PROPERTY, this.initialPassword, newPassword);
        }

        public void clearPassword() {
            String oldPassword = this.getPassword();
            String newPassword = "";
            ((JTextComponent)this.password).setText(newPassword);
            this.firePropertyChange(PASSWORD_CHANGED_PROPERTY, oldPassword, newPassword);
        }
    }

    private class AgentDataPanel
    extends JPanel {
        public static final String AGENT_EXECUTABLE_CHANGED_PROPERTY = "AgentExecutableChangedProperty";
        public static final String AGENT_CONFIG_FILE_CHANGED_PROPERTY = "AgentConfigFileChangedProperty";
        private AgentConfigFilePanel config = null;
        private AgentExecutablePanel exec = null;

        AgentDataPanel() {
            this.init();
        }

        public void setConfigFile(String fileName, boolean hilite) {
            String oldFileName = this.config.getFileName();
            this.config.setFileName(fileName, hilite);
            if (fileName != null && !fileName.equals(oldFileName) || fileName != oldFileName) {
                this.firePropertyChange(AGENT_CONFIG_FILE_CHANGED_PROPERTY, oldFileName, fileName);
            }
        }

        public void setExecFile(String fileName, boolean hilite) {
            String oldFileName = this.exec.getFileName();
            this.exec.setFileName(fileName, hilite);
            if (fileName != null && !fileName.equals(oldFileName) || fileName != oldFileName) {
                this.firePropertyChange(AGENT_EXECUTABLE_CHANGED_PROPERTY, oldFileName, fileName);
            }
        }

        private void init() {
            SpringLayout layout = new SpringLayout();
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            this.setLayout(layout);
            this.config = new AgentConfigFilePanel(AGENT_CONFIG_FILE_CHANGED_PROPERTY);
            this.exec = new AgentExecutablePanel(AGENT_EXECUTABLE_CHANGED_PROPERTY);
            this.add(this.config);
            this.add(this.exec);
            PropertyChangeListener listener = new PropertyChangeListener(this){
                private final /* synthetic */ AgentDataPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("AgentConfigFileChangedProperty")) {
                        this.this$1.setConfigFile((String)evt.getNewValue(), false);
                    } else if (evt.getPropertyName().equals("AgentExecutableChangedProperty")) {
                        this.this$1.setExecFile((String)evt.getNewValue(), false);
                    }
                }
            };
            this.config.addPropertyChangeListener(listener);
            this.exec.addPropertyChangeListener(listener);
            SpringUtilities.align(this, 5, 0);
        }
    }

    public class AdvancedButtonAction
    extends AbstractAction {
        AdvancedButtonAction(String labelText) {
            super(labelText);
        }

        public void actionPerformed(ActionEvent evt) {
        }
    }

    public class ExitButtonAction
    extends AbstractAction {
        ExitButtonAction(String labelText) {
            super(labelText);
        }

        public void actionPerformed(ActionEvent evt) {
            System.exit(0);
        }
    }

    public class StatusButtonAction
    extends AbstractAction {
        StatusButtonAction(String labelText) {
            super(labelText);
        }

        public void actionPerformed(ActionEvent evt) {
            if (currentAgent == null) {
                return;
            }
            try {
                currentAgent.status();
            }
            catch (Exception ex) {
                // empty catch block
            }
            InputStream log = currentAgent.getOutput();
            CcmsAgentConfigurationPanel.this.getMessagePanel().show(log);
        }
    }

    public class StartButtonAction
    extends AbstractAction {
        StartButtonAction(String labelText) {
            super(labelText);
        }

        public void actionPerformed(ActionEvent evt) {
            if (currentAgent == null) {
                return;
            }
            try {
                currentAgent.start();
                InputStream log = currentAgent.getOutput();
                CcmsAgentConfigurationPanel.this.getMessagePanel().show(log);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class UnregisterButtonAction
    extends AbstractAction {
        UnregisterButtonAction(String labelText) {
            super(labelText);
        }

        public void actionPerformed(ActionEvent evt) {
            JButton button = (JButton)evt.getSource();
            if (currentAgent == null) {
                return;
            }
            SwingWorker worker = new SwingWorker(this, button){
                private int rc;
                private final /* synthetic */ UnregisterButtonAction this$1;
                {
                    this.this$1 = this$1;
                    this.rc = -1;
                }

                protected void doNonUILogic() throws RuntimeException {
                    if (CcmsAgentConfigurationPanel.access$000() == null) {
                        return;
                    }
                    InputStream log = null;
                    try {
                        ((J2EEAgent)CcmsAgentConfigurationPanel.access$000()).unregisterCcmsCustomizing();
                        this.rc = CcmsAgentConfigurationPanel.access$000().unregister();
                        log = CcmsAgentConfigurationPanel.access$000().getOutput();
                        CcmsAgentConfigurationPanel.access$400(UnregisterButtonAction.access$700(this.this$1)).show(log);
                    }
                    catch (Exception e) {
                        try {
                            log = CcmsAgentConfigurationPanel.access$000().getOutput();
                            CcmsAgentConfigurationPanel.access$400(UnregisterButtonAction.access$700(this.this$1)).show(log);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }

                protected void doUIUpdateLogic() throws RuntimeException {
                    if (CcmsAgentConfigurationPanel.access$000() != null) {
                        CcmsAgentConfigurationPanel.access$000().refresh();
                    }
                    CcmsAgentConfigurationPanel.access$600(UnregisterButtonAction.access$700(this.this$1)).clearPasswords();
                    CcmsAgentConfigurationPanel.access$500(UnregisterButtonAction.access$700(this.this$1));
                }
            };
            worker.start();
        }

        static /* synthetic */ CcmsAgentConfigurationPanel access$700(UnregisterButtonAction x0) {
            return x0.CcmsAgentConfigurationPanel.this;
        }
    }

    public class RegisterButtonAction
    extends AbstractAction {
        RegisterButtonAction(String labelText) {
            super(labelText);
        }

        public void actionPerformed(ActionEvent evt) {
            JButton button = (JButton)evt.getSource();
            if (currentAgent == null) {
                return;
            }
            if (!currentAgent.makePersistent(button.getRootPane())) {
                return;
            }
            SwingWorker worker = new SwingWorker(this, button, button){
                private int rc;
                private final /* synthetic */ JButton val$button;
                private final /* synthetic */ RegisterButtonAction this$1;
                {
                    this.this$1 = this$1;
                    this.val$button = val$button;
                    this.rc = -1;
                }

                protected void doNonUILogic() throws RuntimeException {
                    if (CcmsAgentConfigurationPanel.access$000() == null) {
                        return;
                    }
                    InputStream log = null;
                    try {
                        this.rc = CcmsAgentConfigurationPanel.access$000().version();
                        log = CcmsAgentConfigurationPanel.access$000().getOutput();
                        CcmsAgentConfigurationPanel.access$400(RegisterButtonAction.access$300(this.this$1)).show(log);
                        this.rc = CcmsAgentConfigurationPanel.access$000().register();
                        log = CcmsAgentConfigurationPanel.access$000().getOutput();
                        CcmsAgentConfigurationPanel.access$400(RegisterButtonAction.access$300(this.this$1)).append(log);
                        if (CcmsAgentConfigurationPanel.access$000() instanceof J2EEAgent && ((J2EEAgent)CcmsAgentConfigurationPanel.access$000()).isCcmsCustomizingEnabled()) {
                            ((J2EEAgent)CcmsAgentConfigurationPanel.access$000()).registerCcmsCustomizing();
                        }
                    }
                    catch (Exception e) {
                        try {
                            log = CcmsAgentConfigurationPanel.access$000().getOutput();
                            CcmsAgentConfigurationPanel.access$400(RegisterButtonAction.access$300(this.this$1)).show(log);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    CcmsAgentConfigurationPanel.access$500(RegisterButtonAction.access$300(this.this$1));
                }

                protected void doUIUpdateLogic() throws RuntimeException {
                    if (CcmsAgentConfigurationPanel.access$000() != null) {
                        CcmsAgentConfigurationPanel.access$000().refresh();
                    }
                    CcmsAgentConfigurationPanel.access$600(RegisterButtonAction.access$300(this.this$1)).clearPasswords();
                    CcmsAgentConfigurationPanel.access$500(RegisterButtonAction.access$300(this.this$1));
                    if (!CcmsAgentConfigurationPanel.access$100(RegisterButtonAction.access$300(this.this$1)).isWindowsPlatform() && this.rc == 0 && CcmsAgentConfigurationPanel.access$000() instanceof StandaloneAgent) {
                        JOptionPane.showMessageDialog(this.val$button.getRootPane(), "Please make sure, that the agent will be automatically started during system start");
                    }
                }
            };
            worker.start();
        }

        static /* synthetic */ CcmsAgentConfigurationPanel access$300(RegisterButtonAction x0) {
            return x0.CcmsAgentConfigurationPanel.this;
        }
    }

    public class SelectInstallationDirectoryAction
    extends OpenFileAction {
        public SelectInstallationDirectoryAction(Component parent, JTextField textField, String labelText) {
            super(parent, textField, labelText);
            this.chooser.setDialogTitle("Select SAP Installation Directory");
            this.chooser.setFileSelectionMode(1);
            this.chooser.setFileFilter(this.getFilter("SAP Installation Directory"));
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                String dirName = File.separator;
                File dir = new File(dirName);
                if (dir != null) {
                    this.chooser.setCurrentDirectory(dir);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.actionPerformed(evt);
        }

        private FileFilter getFilter(String description) {
            String filterDescription = description;
            return new FileFilter(this, filterDescription){
                private final /* synthetic */ String val$filterDescription;
                private final /* synthetic */ SelectInstallationDirectoryAction this$1;
                {
                    this.this$1 = this$1;
                    this.val$filterDescription = val$filterDescription;
                }

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String absoluteFileName = file.getAbsolutePath();
                    if (absoluteFileName == null) {
                        return false;
                    }
                    return absoluteFileName.endsWith("sap");
                }

                public String getDescription() {
                    return this.val$filterDescription;
                }
            };
        }
    }

    public class OpenExecutableFileAction
    extends OpenFileAction {
        public OpenExecutableFileAction(Component parent, JTextField textField, String labelText) {
            super(parent, textField, labelText);
            this.chooser.setFileFilter(this.getFilter("Agent Executable Files"));
            this.setPropertyChangeEvent("AgentExecutableChangedProperty");
        }

        public void actionPerformed(ActionEvent evt) {
            String dirName = currentAgent.getDefaultAgentDirectory();
            File dir = new File(dirName);
            if (dir != null) {
                this.chooser.setCurrentDirectory(dir);
            }
            super.actionPerformed(evt);
        }

        public boolean openFile(File file) {
            if (file == null) {
                return false;
            }
            String executableName = file.getAbsolutePath();
            if (!CcmsAgentConfigurationPanel.this.getAgentRuntime().isExecutableValid(executableName)) {
                Object[] options = new Object[]{"YES", "NO"};
                int selectedOption = JOptionPane.showOptionDialog(this.parent, executableName + " may not be a valid agent executable file, use anyway ?", "Invalid Agent Executable File", 0, 2, null, options, options[1]);
                if (selectedOption == 0) {
                    CcmsAgentConfigurationPanel.this.getAgentRuntime().setExecutableValid(executableName);
                }
                return selectedOption == 0;
            }
            return true;
        }

        private FileFilter getFilter(String description) {
            String filterDescription = description;
            return new FileFilter(this, filterDescription){
                private final /* synthetic */ String val$filterDescription;
                private final /* synthetic */ OpenExecutableFileAction this$1;
                {
                    this.this$1 = this$1;
                    this.val$filterDescription = val$filterDescription;
                }

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    if (CcmsAgentConfigurationPanel.access$000() == null) {
                        return false;
                    }
                    String agentFileName = CcmsAgentConfigurationPanel.access$000().getAgentBaseFileName();
                    if (agentFileName == null) {
                        return false;
                    }
                    String absoluteFileName = file.getAbsolutePath();
                    if (absoluteFileName == null) {
                        return false;
                    }
                    return absoluteFileName.endsWith(agentFileName);
                }

                public String getDescription() {
                    return this.val$filterDescription;
                }
            };
        }
    }

    public class OpenConfigFileAction
    extends OpenFileAction {
        public OpenConfigFileAction(Component parent, JTextField textField, String labelText) {
            super(parent, textField, labelText);
            this.chooser.setFileFilter(this.getFilter("Configuration Files"));
            this.setPropertyChangeEvent("AgentConfigFileChangedProperty");
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                String dirName = currentAgent.getDefaultConfigurationDirectory();
                File dir = new File(dirName);
                if (dir != null) {
                    this.chooser.setCurrentDirectory(dir);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.actionPerformed(evt);
        }

        public boolean openFile(File file) {
            return CcmsAgentConfigurationPanel.this.getAgentRuntime().isRunningInJ2eeEngine() ? this.openFileJ2EE(file) : this.openFileStandalone(file);
        }

        public boolean openFileStandalone(File file) {
            if (file == null) {
                return false;
            }
            String configFileName = file.getAbsolutePath();
            if (!CcmsAgentConfigurationPanel.this.getAgentRuntime().isConfigFileValid(configFileName)) {
                JOptionPane.showMessageDialog(this.parent, configFileName + " is not a valid agent configuration file", "Invalid Configuration File", 0);
                return false;
            }
            return true;
        }

        public boolean openFileJ2EE(File file) {
            if (file == null) {
                return false;
            }
            String configFileName = file.getAbsolutePath();
            Conf conf = null;
            try {
                conf = new Conf(configFileName);
            }
            catch (IOException e) {
                conf = null;
            }
            if (conf == null || !conf.isValid()) {
                CcmsAgentConfigurationPanel.this.setConf(null);
                JOptionPane.showMessageDialog(this.parent, configFileName + " is not a valid agent configuration file", "Invalid Configuration File", 0);
                return false;
            }
            CcmsAgentConfigurationPanel.this.setConf(conf);
            return true;
        }

        private FileFilter getFilter(String description) {
            String filterDescription = description;
            return new FileFilter(this, filterDescription){
                private final /* synthetic */ String val$filterDescription;
                private final /* synthetic */ OpenConfigFileAction this$1;
                {
                    this.this$1 = this$1;
                    this.val$filterDescription = val$filterDescription;
                }

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    if (CcmsAgentConfigurationPanel.access$000() == null) {
                        return false;
                    }
                    String configFileName = CcmsAgentConfigurationPanel.access$000().getAgentConfigurationBaseFileName();
                    if (configFileName == null) {
                        return false;
                    }
                    String absoluteFileName = file.getAbsolutePath();
                    if (absoluteFileName == null) {
                        return false;
                    }
                    return absoluteFileName.endsWith(configFileName);
                }

                public String getDescription() {
                    return this.val$filterDescription;
                }
            };
        }
    }

    public class OpenProfileAction
    extends OpenFileAction {
        OpenProfileAction(Component parent, JTextField textField, String labelText) {
            super(parent, textField, labelText);
            this.chooser.setFileFilter(this.getFilter("Profiles"));
            this.setPropertyChangeEvent("ProfileChangedProperty");
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                String dirName = ((J2EEAgent)currentAgent).getDefaultProfileDirectory();
                File dir = new File(dirName);
                if (dir != null && dir.exists() && dir.isDirectory()) {
                    this.chooser.setCurrentDirectory(dir);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.actionPerformed(evt);
        }

        public boolean openFile(File file) {
            if (file == null) {
                return false;
            }
            String profileName = file.getAbsolutePath();
            if (!CcmsAgentConfigurationPanel.this.getAgentRuntime().isProfileValid(profileName)) {
                JOptionPane.showMessageDialog(this.parent, profileName + " is not a valid profile", "Invalid Profile", 0);
                return false;
            }
            return true;
        }

        private FileFilter getFilter(String description) {
            String filterDescription = description;
            return new FileFilter(this, filterDescription){
                private final /* synthetic */ String val$filterDescription;
                private final /* synthetic */ OpenProfileAction this$1;
                {
                    this.this$1 = this$1;
                    this.val$filterDescription = val$filterDescription;
                }

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    if (CcmsAgentConfigurationPanel.access$000() == null) {
                        return false;
                    }
                    String fileName = file.getName();
                    if (fileName == null) {
                        return false;
                    }
                    return CcmsAgentConfigurationPanel.access$100(OpenProfileAction.access$200(this.this$1)).matchesProfileFileNamePattern(fileName);
                }

                public String getDescription() {
                    return this.val$filterDescription;
                }
            };
        }

        static /* synthetic */ CcmsAgentConfigurationPanel access$200(OpenProfileAction x0) {
            return x0.CcmsAgentConfigurationPanel.this;
        }
    }
}

