/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.monitor;

import com.sap.engine.services.monitor.ArrayComparator;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.TreeSet;

public class Util {
    private static final int MILLIS_IN_SECOND = 1000;
    private static final int MILLIS_IN_MINUTE = 60000;
    private static final int MILLIS_IN_HOUR = 3600000;
    private static final int MILLIS_IN_DAY = 86400000;
    public static DecimalFormat s_decimalFormat = new DecimalFormat("##0.00");

    public static String[] objectArray2StringArray(Object[] objArray) {
        String[] strArray = new String[objArray.length];
        int i = 0;
        while (i < objArray.length) {
            strArray[i] = (String)objArray[i];
            ++i;
        }
        return strArray;
    }

    public static String getStackTraceAsString(Exception e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        StringBuffer error = stringWriter.getBuffer();
        return error.toString();
    }

    public static String[][] sortTwoDimArray(String[][] array) {
        TreeSet<String[]> set = new TreeSet<String[]>(new ArrayComparator());
        int p = 0;
        int rows = array.length;
        int columns = 0;
        if (rows > 0) {
            columns = array[0].length;
        }
        String[][] resultArray = new String[rows][columns];
        int i = 0;
        while (i < rows) {
            set.add(array[i]);
            ++i;
        }
        Iterator setIter = set.iterator();
        while (setIter.hasNext()) {
            String[] temp = (String[])setIter.next();
            resultArray[p] = temp;
            ++p;
        }
        return resultArray;
    }

    public static long getGranularityPeriod(int unit, int value) {
        long granularityPeriod = 0L;
        switch (unit) {
            case 0: {
                granularityPeriod = value * 60000;
                break;
            }
            case 1: {
                granularityPeriod = value * 3600000;
                break;
            }
            case 2: {
                granularityPeriod = value * 86400000;
            }
        }
        return granularityPeriod;
    }

    public static String[][] arrayToString(Serializable[][] serArray) {
        int rows = serArray.length;
        int columns = 0;
        if (rows > 0) {
            columns = serArray[0].length;
        }
        String[][] strArray = new String[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                strArray[i][j] = serArray[i][j] != null ? serArray[i][j].toString() : "";
                ++j;
            }
            ++i;
        }
        return strArray;
    }

    public static final String formatDouble(double value) {
        return s_decimalFormat.format(value);
    }

    public static double round(double h) {
        double coef = 1.0;
        int sign = 1;
        if (h < 0.0) {
            sign = -1;
            h *= -1.0;
        }
        if (h > 1.0) {
            h *= 100.0;
            h = Math.round(h);
            h /= 100.0;
        } else if (h != 0.0) {
            while (h < 1.0) {
                h *= 100.0;
                coef *= 100.0;
            }
            h *= 100.0;
            h = Math.round(h);
            h /= coef * 100.0;
        }
        if (sign == -1) {
            h *= (double)sign;
        }
        return h;
    }
}

