/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.rdebug.views;

import com.sap.ide.eclipse.rdebug.CustomerConnectionEntry;
import com.sap.ide.eclipse.rdebug.ICustomerConnectionManager;
import com.sap.ide.eclipse.rdebug.JrdebugecPlugin;
import com.sap.ide.eclipse.rdebug.trace.Tracer;
import com.sap.ide.eclipse.rdebug.views.ConnectionDialog;
import com.sap.ide.eclipse.rdebug.views.LaunchConfigurationTabView;
import com.sap.ide.eclipse.rdebug.views.RemoteDebugViewMessages;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

class RemoteDebugTabView
extends Composite {
    private Text csnConnectionIdString = null;
    private Text projectName = null;
    private Text sourceRetrievalUrl = null;
    private ICustomerConnectionManager connectionManager = null;
    private CustomerConnectionEntry.CustomerConnectionIdentifier connectionIdentifier = null;

    RemoteDebugTabView(Composite parent, LaunchConfigurationTabView.RemoteDebugTab remoteDebugTab) {
        super(parent, 0);
        WorkbenchHelp.setHelp((Control)parent, (String)"com.sap.ide.eclipse.rdebug.cssRemotedebugLaunchConfig");
        this.connectionManager = JrdebugecPlugin.getDefault().getConnectionManager();
        Font font = parent.getFont();
        GridLayout topLayout = new GridLayout();
        topLayout.marginHeight = 0;
        this.setLayout((Layout)topLayout);
        Label label = new Label((Composite)this, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        Composite projComp = new Composite((Composite)this, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 2;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        projComp.setLayout((Layout)projLayout);
        gd = new GridData(768);
        projComp.setLayoutData((Object)gd);
        projComp.setFont(font);
        Label projectLabel = new Label(projComp, 0);
        projectLabel.setText(RemoteDebugViewMessages.THIS.getString("RemoteDebugTabView.Project_name_label"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        projectLabel.setLayoutData((Object)gd);
        projectLabel.setFont(font);
        this.projectName = new Text(projComp, 2052);
        gd = new GridData(768);
        this.projectName.setLayoutData((Object)gd);
        this.projectName.setFont(font);
        LaunchConfigurationTabView.RemoteDebugTab.TextListener projectNameListener = remoteDebugTab.new LaunchConfigurationTabView.RemoteDebugTab.TextListener();
        this.projectName.addModifyListener((ModifyListener)projectNameListener);
        Button browseProjects = new Button(projComp, 0);
        browseProjects.setText(RemoteDebugViewMessages.THIS.getString("RemoteDebugTabView.Project_Browse_Button"));
        gd = new GridData();
        browseProjects.setLayoutData((Object)gd);
        browseProjects.addSelectionListener((SelectionListener)new ProjectBrowseListener());
        label = new Label((Composite)this, 0);
        gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        Composite csnConnComp = new Composite((Composite)this, 0x800000);
        GridLayout csnConnLayout = new GridLayout();
        csnConnLayout.marginHeight = 0;
        csnConnLayout.marginWidth = 0;
        csnConnLayout.numColumns = 2;
        csnConnComp.setLayout((Layout)csnConnLayout);
        gd = new GridData(768);
        csnConnComp.setLayoutData((Object)gd);
        csnConnComp.setFont(font);
        Label csnConnLabel = new Label(csnConnComp, 0);
        csnConnLabel.setText(RemoteDebugViewMessages.THIS.getString("RemoteDebugTabView.CSS_Connection_Label"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        csnConnLabel.setLayoutData((Object)gd);
        csnConnLabel.setFont(font);
        this.csnConnectionIdString = new Text(csnConnComp, 2052);
        gd = new GridData(768);
        this.csnConnectionIdString.setLayoutData((Object)gd);
        this.csnConnectionIdString.setFont(font);
        this.csnConnectionIdString.setEditable(false);
        LaunchConfigurationTabView.RemoteDebugTab.TextListener csnConnectionListener = remoteDebugTab.new LaunchConfigurationTabView.RemoteDebugTab.TextListener();
        this.csnConnectionIdString.addModifyListener((ModifyListener)csnConnectionListener);
        Button csnConnection = new Button(csnConnComp, 0);
        csnConnection.setText(RemoteDebugViewMessages.THIS.getString("RemoteDebugTabView.Connection_Choose_Button"));
        gd = new GridData();
        csnConnection.setLayoutData((Object)gd);
        csnConnection.addSelectionListener((SelectionListener)new ChooseConnectionListener());
        label = new Label((Composite)this, 0);
        gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        Composite sourceRetComp = new Composite((Composite)this, 0x800000);
        GridLayout sourceRetLayout = new GridLayout();
        sourceRetLayout.marginHeight = 0;
        sourceRetLayout.marginWidth = 0;
        sourceRetLayout.numColumns = 2;
        sourceRetComp.setLayout((Layout)sourceRetLayout);
        gd = new GridData(768);
        sourceRetComp.setLayoutData((Object)gd);
        sourceRetComp.setFont(font);
        label = new Label((Composite)this, 0);
        gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
    }

    String getProjectName() {
        return this.projectName.getText();
    }

    String getConnectionIdString() {
        if (this.connectionIdentifier != null) {
            return this.connectionIdentifier.getIdString();
        }
        return "";
    }

    private void setCsnConnectionIdDescription(String connDescription) {
        if (connDescription == null) {
            this.csnConnectionIdString.setText("");
        } else {
            this.csnConnectionIdString.setText(connDescription);
        }
    }

    void setProjectName(String projectName) {
        if (projectName == null) {
            this.projectName.setText("");
        } else {
            this.projectName.setText(projectName);
        }
    }

    void setConnectionIdentifier(CustomerConnectionEntry.CustomerConnectionIdentifier pIdentifier) {
        this.connectionIdentifier = pIdentifier;
        if (this.connectionIdentifier != null) {
            this.setCsnConnectionIdDescription(this.connectionIdentifier.getDescription());
        } else {
            this.setCsnConnectionIdDescription("");
        }
    }

    private class ProjectBrowseListener
    implements SelectionListener {
        private ProjectBrowseListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            ArrayList<IProject> javaProjectsList = new ArrayList<IProject>();
            int i = 0;
            while (i < projects.length) {
                try {
                    if (projects[i].isOpen() && projects[i].hasNature("org.eclipse.jdt.core.javanature")) {
                        javaProjectsList.add(projects[i]);
                    }
                }
                catch (CoreException ex) {
                    Tracer.dtTracer.userOut("JavaRemoteDebug", 2, ex.getMessage());
                    return;
                }
                ++i;
            }
            Object[] javaProjects = new IProject[javaProjectsList.size()];
            javaProjectsList.toArray(javaProjects);
            JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(RemoteDebugTabView.this.getShell(), (ILabelProvider)labelProvider);
            dialog.setTitle(RemoteDebugViewMessages.THIS.getString("RemoteDebugTabView.Project_selection_dialog_title"));
            dialog.setMessage(RemoteDebugViewMessages.THIS.getString("RemoteDebugTabView.Choose_a_project_message"));
            dialog.setElements(javaProjects);
            if (dialog.open() == 0) {
                String projectName = ((IProject)dialog.getFirstResult()).getName();
                RemoteDebugTabView.this.setProjectName(projectName);
            }
        }
    }

    private class ChooseConnectionListener
    implements SelectionListener {
        private ChooseConnectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            RemoteDebugTabView.this.connectionManager.load();
            ConnectionDialog connDialog = new ConnectionDialog(RemoteDebugTabView.this.getShell(), RemoteDebugTabView.this.connectionManager);
            connDialog.open();
            if (connDialog.getReturnCode() == 0) {
                CustomerConnectionEntry.CustomerConnectionIdentifier connIdentifier = connDialog.getConnectionIdentifier();
                RemoteDebugTabView.this.setConnectionIdentifier(connIdentifier);
            }
        }
    }
}

