/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.rdebug.views;

import com.sap.ide.eclipse.rdebug.JrdebugecPlugin;
import com.sap.ide.eclipse.rdebug.views.RemoteDebugViewMessages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class RDebugPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IWorkbench workbench = null;
    private Button confirmDisconnectAll = null;
    private Text cssSystem = null;
    private Text cssSystemNo = null;
    private Text cssGroup = null;
    private Text cssMshost = null;
    private Text cssClient = null;
    private Text cssLangu = null;
    private Text cssUser = null;
    private Text cssPassword = null;

    public void init(IWorkbench pWorkbench) {
        this.workbench = pWorkbench;
    }

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        Composite mainArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 8;
        layout.horizontalSpacing = 0;
        mainArea.setLayout((Layout)layout);
        mainArea.setLayoutData((Object)new GridData(1808));
        mainArea.setFont(font);
        WorkbenchHelp.setHelp((Control)parent, (String)"com.sap.ide.eclipse.rdebug.cssRemotedebugLaunchPreferences");
        Label folderLabel = new Label(mainArea, 0);
        folderLabel.setText(RemoteDebugViewMessages.THIS.getString("RDebugPreferencePage.Options_for_CSS_Remote_Debugging"));
        TabFolder mainFolder = new TabFolder(mainArea, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        mainFolder.setLayout((Layout)layout);
        mainFolder.setLayoutData((Object)new GridData(1808));
        mainFolder.setFont(font);
        this.createGeneralTab(mainFolder);
        this.createCSSConnectionTab(mainFolder);
        this.initializeValues();
        return mainArea;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return JrdebugecPlugin.getDefault().getPreferenceStore();
    }

    protected void performApply() {
        super.performApply();
    }

    protected void performDefaults() {
        IPreferenceStore store = this.doGetPreferenceStore();
        this.confirmDisconnectAll.setSelection(store.getDefaultBoolean("com.sap.ide.eclipse.rdebug.ask_disconnect_all"));
        this.cssSystem.setText(store.getDefaultString("com.sap.ide.eclipse.rdebug.css_r3name"));
        this.cssGroup.setText(store.getDefaultString("com.sap.ide.eclipse.rdebug.css_group"));
        this.cssMshost.setText(store.getDefaultString("com.sap.ide.eclipse.rdebug.css_mshost"));
        this.cssSystemNo.setText(store.getDefaultString("com.sap.ide.eclipse.rdebug.css_sysno"));
        this.cssClient.setText(store.getDefaultString("com.sap.ide.eclipse.rdebug.css_client"));
        this.cssLangu.setText(store.getDefaultString("com.sap.ide.eclipse.rdebug.css_lang"));
        this.cssUser.setText(store.getDefaultString("com.sap.ide.eclipse.rdebug.css_user"));
    }

    public boolean performOk() {
        IPreferenceStore store = this.doGetPreferenceStore();
        store.setValue("com.sap.ide.eclipse.rdebug.ask_disconnect_all", this.confirmDisconnectAll.getSelection());
        store.setValue("com.sap.ide.eclipse.rdebug.css_r3name", this.cssSystem.getText());
        store.setValue("com.sap.ide.eclipse.rdebug.css_group", this.cssGroup.getText());
        store.setValue("com.sap.ide.eclipse.rdebug.css_mshost", this.cssMshost.getText());
        store.setValue("com.sap.ide.eclipse.rdebug.css_sysno", this.cssSystemNo.getText());
        store.setValue("com.sap.ide.eclipse.rdebug.css_client", this.cssClient.getText());
        store.setValue("com.sap.ide.eclipse.rdebug.css_lang", this.cssLangu.getText());
        store.setValue("com.sap.ide.eclipse.rdebug.css_user", this.cssUser.getText());
        return true;
    }

    private void initializeValues() {
        IPreferenceStore store = this.doGetPreferenceStore();
        this.confirmDisconnectAll.setSelection(store.getBoolean("com.sap.ide.eclipse.rdebug.ask_disconnect_all"));
        this.cssSystem.setText(store.getString("com.sap.ide.eclipse.rdebug.css_r3name"));
        this.cssGroup.setText(store.getString("com.sap.ide.eclipse.rdebug.css_group"));
        this.cssMshost.setText(store.getString("com.sap.ide.eclipse.rdebug.css_mshost"));
        this.cssSystemNo.setText(store.getString("com.sap.ide.eclipse.rdebug.css_sysno"));
        this.cssClient.setText(store.getString("com.sap.ide.eclipse.rdebug.css_client"));
        this.cssLangu.setText(store.getString("com.sap.ide.eclipse.rdebug.css_lang"));
        this.cssUser.setText(store.getString("com.sap.ide.eclipse.rdebug.css_user"));
    }

    private void createGeneralTab(TabFolder pMainFolder) {
        Font font = pMainFolder.getFont();
        TabItem generalTab = new TabItem(pMainFolder, 0, 0);
        generalTab.setText(RemoteDebugViewMessages.THIS.getString("RDebugPreferencePage.General_Tab_Name"));
        Composite generalMain = new Composite((Composite)pMainFolder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 8;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 8;
        generalMain.setLayout((Layout)layout);
        generalMain.setLayoutData((Object)new GridData(1808));
        generalMain.setFont(font);
        generalTab.setControl((Control)generalMain);
        this.confirmDisconnectAll = new Button(generalMain, 32);
        this.confirmDisconnectAll.setFont(font);
        Label confirmDisconnectAllText = new Label(generalMain, 0);
        confirmDisconnectAllText.setText(RemoteDebugViewMessages.THIS.getString("RDebugPreferencePage.Show_disconnect_confirmation_dialog"));
        confirmDisconnectAllText.setLayoutData((Object)new GridData());
        confirmDisconnectAllText.setFont(font);
    }

    private void createCSSConnectionTab(TabFolder pMainFolder) {
        Font font = pMainFolder.getFont();
        TabItem cssConnectionTab = new TabItem(pMainFolder, 0, 1);
        cssConnectionTab.setText(RemoteDebugViewMessages.THIS.getString("RDebugPreferencePage.CSS_Connection_Tab_Name"));
        Composite cssConnMain = new Composite((Composite)pMainFolder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 10;
        layout.marginWidth = 0;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 8;
        cssConnMain.setLayout((Layout)layout);
        cssConnMain.setLayoutData((Object)new GridData(1808));
        cssConnMain.setFont(font);
        cssConnectionTab.setControl((Control)cssConnMain);
        this.cssSystem = this.createTextField(cssConnMain, RemoteDebugViewMessages.THIS.getString("RDebugPreferencePage.System"));
        this.cssGroup = this.createTextField(cssConnMain, RemoteDebugViewMessages.THIS.getString("RDebugPreferencePage.Logon_Group"));
        this.cssMshost = this.createTextField(cssConnMain, RemoteDebugViewMessages.THIS.getString("RDebugPreferencePage.Message_Server"));
        this.cssClient = this.createTextField(cssConnMain, RemoteDebugViewMessages.THIS.getString("RDebugPreferencePage.Client"));
        this.cssSystemNo = this.createTextField(cssConnMain, RemoteDebugViewMessages.THIS.getString("RDebugPreferencePage.System_Number"));
        this.cssLangu = this.createTextField(cssConnMain, RemoteDebugViewMessages.THIS.getString("RDebugPreferencePage.Language_Shortcut"));
        this.addEmptyContainer(cssConnMain);
        this.addEmptyContainer(cssConnMain);
        this.cssUser = this.createTextField(cssConnMain, RemoteDebugViewMessages.THIS.getString("RDebugPreferencePage.User"));
    }

    private Text createTextField(Composite parent, String labelText) {
        Font font = parent.getFont();
        Label textLabel = new Label(parent, 0);
        textLabel.setText(labelText);
        GridData gd = new GridData();
        textLabel.setLayoutData((Object)gd);
        textLabel.setFont(font);
        Text textField = new Text(parent, 2052);
        gd = new GridData(768);
        textField.setLayoutData((Object)gd);
        textField.setFont(font);
        textField.setEditable(true);
        return textField;
    }

    private void addEmptyContainer(Composite parent) {
        Label dummy = new Label(parent, 0);
        dummy.setLayoutData((Object)new GridData());
    }
}

