/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.rdebug.views;

import com.sap.ide.eclipse.rdebug.CustomerConnectionEntry;
import com.sap.ide.eclipse.rdebug.ICustomerConnectionManager;
import com.sap.ide.eclipse.rdebug.JrdebugecPlugin;
import com.sap.ide.eclipse.rdebug.trace.Tracer;
import com.sap.ide.eclipse.rdebug.views.RemoteDebugTabView;
import com.sap.ide.eclipse.rdebug.views.RemoteDebugViewMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaSourceLookupTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class LaunchConfigurationTabView
extends AbstractLaunchConfigurationTabGroup {
    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        CommonTab commonTab = new CommonTab();
        commonTab.setLaunchConfigurationDialog(dialog);
        RemoteDebugTab remoteDebugTab = new RemoteDebugTab();
        remoteDebugTab.setLaunchConfigurationDialog(dialog);
        JavaSourceLookupTab javaSourceLookupTab = new JavaSourceLookupTab();
        javaSourceLookupTab.setLaunchConfigurationDialog(dialog);
        ILaunchConfigurationTab[] tabs = new ILaunchConfigurationTab[]{remoteDebugTab, javaSourceLookupTab, commonTab};
        this.setTabs(tabs);
    }

    static final class RemoteDebugTab
    extends AbstractLaunchConfigurationTab {
        private RemoteDebugTabView tabView = null;
        private ICustomerConnectionManager connectionManager = JrdebugecPlugin.getDefault().getConnectionManager();

        private RemoteDebugTab() {
        }

        public void createControl(Composite parent) {
            this.tabView = new RemoteDebugTabView(parent, this);
            this.setControl((Control)this.tabView);
        }

        public String getName() {
            return RemoteDebugViewMessages.THIS.getString("LaunchConfigurationTabView.Remote_Debug_Tab_Name");
        }

        public void initializeFrom(ILaunchConfiguration launchConfig) {
            try {
                String projName = launchConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
                this.tabView.setProjectName(projName);
                String connId = launchConfig.getAttribute("com.sap.ide.rdebug.connectionIdentifier", "");
                CustomerConnectionEntry.CustomerConnectionIdentifier connIdentifier = this.connectionManager.getIdentifier(connId);
                this.tabView.setConnectionIdentifier(connIdentifier);
            }
            catch (CoreException cEx) {
                Tracer.dtTracer.userOut("JavaRemoteDebug", 2, cEx.getMessage());
            }
        }

        public void performApply(ILaunchConfigurationWorkingCopy launchConfigCopy) {
            launchConfigCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.tabView.getProjectName());
            launchConfigCopy.setAttribute("com.sap.ide.rdebug.connectionIdentifier", this.tabView.getConnectionIdString());
        }

        public void setDefaults(ILaunchConfigurationWorkingCopy launchConfigCopy) {
            launchConfigCopy.setAttribute(IJavaLaunchConfigurationConstants.ID_REMOTE_JAVA_APPLICATION, true);
        }

        public boolean canSave() {
            return true;
        }

        public boolean isValid(ILaunchConfiguration launchConfig) {
            String name = this.tabView.getProjectName();
            String connIdentifier = this.tabView.getConnectionIdString();
            if (name.equals("") || !JrdebugecPlugin.getWorkspace().getRoot().getProject(name).exists()) {
                this.setErrorMessage(RemoteDebugViewMessages.THIS.getString("LaunchConfigurationTabView.Error.Please_specify_valid_project_name"));
                return false;
            }
            if (connIdentifier.equals("")) {
                this.setErrorMessage(RemoteDebugViewMessages.THIS.getString("LaunchConfigurationTabView.Error.Please_specify_a_CSN/CSR_connection"));
                return false;
            }
            this.setErrorMessage(null);
            return true;
        }

        public Image getImage() {
            return DebugUITools.getImage((String)"IMG_LCL_DISCONNECT");
        }

        class TextListener
        implements ModifyListener {
            TextListener() {
            }

            public void modifyText(ModifyEvent e) {
                RemoteDebugTab.super.updateLaunchConfigurationDialog();
            }
        }
    }
}

