/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.rdebug.views;

import com.sap.ide.eclipse.rdebug.BuildTModel;
import com.sap.ide.eclipse.rdebug.ConnectToCustomer;
import com.sap.ide.eclipse.rdebug.CreateConfigurations;
import com.sap.ide.eclipse.rdebug.CustomerConnection;
import com.sap.ide.eclipse.rdebug.IConstants;
import com.sap.ide.eclipse.rdebug.JcoInfo;
import com.sap.ide.eclipse.rdebug.JrdebugecPlugin;
import com.sap.ide.eclipse.rdebug.ReadAndStoreInput;
import com.sap.ide.eclipse.rdebug.TabsAndFields;
import com.sap.ide.eclipse.rdebug.trace.Tracer;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.tssap.util.trace.TracerI;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.image.SapImage;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISimplePane;
import com.tssap.util.ui.pane.ITabbedPane;
import com.tssap.util.ui.pane.PaneFactory;
import com.tssap.util.ui.viewer.table.ISapTableViewer;
import com.tssap.util.ui.viewer.table.SapTableRow;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.table.TableModel;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdi.Bootstrap;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.part.ViewPart;

public class ConnectionView
extends ViewPart
implements IConstants {
    private TableViewer viewer;
    private Action action1;
    private Action action2;
    private Action doubleClickAction;
    private TabsAndFields fields;
    private Hashtable systems;
    private ConnectToCustomer cusConn;
    private ILaunch remoteLaunch;
    private ReadAndStoreInput data = null;
    private ISimplePane connectTabPane;
    private IGridLayoutPane parentPane;
    private Text project;
    private IGridLayoutPane errorPane;
    private Label l;
    private Composite parent;
    private IGridLayoutPane gridPane;
    private ITabbedPane mainTabPane;
    private IGridLayoutPane projectPane;
    private Button refreshButton;
    private Composite dispComposite;
    private String sourcePathSelected;
    private String compare = new String();
    private TracerI dtTracer;
    private IDialogSettings viewDialogSettings = null;
    private static final String CONNECTION_SETTINGS = "connectionView";
    private static final String LAST_SAVED_PROJECT = "lastSavedProject";

    public ConnectionView() {
        JrdebugecPlugin remoteDebugPlugin = JrdebugecPlugin.getDefault();
        this.viewDialogSettings = remoteDebugPlugin.getDialogSettings().getSection(CONNECTION_SETTINGS);
        if (this.viewDialogSettings == null) {
            this.viewDialogSettings = remoteDebugPlugin.getDialogSettings().addNewSection(CONNECTION_SETTINGS);
        }
    }

    public void createPartControl(Composite p) {
        this.parent = p;
        int e = this.createDataStream();
        this.systems = this.data.getTableData();
        this.createView(this.parent, e);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ConnectionView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.action2);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IAction)this.action2);
        manager.add((IContributionItem)new Separator("Additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IAction)this.action2);
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"ConnectionView", (String)message);
    }

    private void createView(Composite parent, int e) {
        this.fields = null;
        this.dispComposite = new Composite(parent, parent.getStyle());
        this.dispComposite.setLayout((Layout)new FillLayout());
        this.parentPane = PaneFactory.createGridLayoutPane((Composite)this.dispComposite, (int)1);
        this.refreshButton = this.parentPane.addPushButton("Refresh data");
        this.refreshButton.addSelectionListener((SelectionListener)new RefreshButtonListener());
        this.projectPane = this.parentPane.addGridLayoutPane(3, this.parentPane.createGridLayoutData(4, 4, 1, 1));
        this.fillProjectPane(this.projectPane);
        this.mainTabPane = this.parentPane.addTabbedPane(this.parentPane.createGridLayoutData(4, 4, true, true));
        this.fields = new TabsAndFields(this.data.getNumberOfSystems());
        this.createTabbedPane(this.fields, e);
    }

    private void createTabbedPane(TabsAndFields fields, int e) {
        Enumeration keys = this.systems.keys();
        int i = 0;
        while (i < this.data.getNumberOfSystems()) {
            String key;
            try {
                key = (String)keys.nextElement();
            }
            catch (Exception exep) {
                Tracer.dtTracer.userOut("JavaRemoteDebug", 2, exep.getMessage());
                key = "No System";
            }
            fields.setTab(this.mainTabPane.addGridLayoutPaneAsTab(key, 1), i);
            IGridLayoutPane bPane = fields.getTab(i).addGridLayoutPane(2);
            IGridLayoutPane buttonPane = bPane.addGridLayoutPane(3, false);
            fields.setButton(buttonPane.addPushButton("Connect "), i, 1);
            fields.getButton(i, 1).setEnabled(false);
            fields.setButton(buttonPane.addPushButton("Disconnect "), i, 2);
            fields.getButton(i, 2).setEnabled(false);
            fields.setButton(buttonPane.addPushButton("Delete Line "), i, 3);
            fields.getButton(i, 3).setEnabled(false);
            IGridLayoutPane buttonTablePane = bPane.addGridLayoutPane(2, false);
            fields.setButton(buttonTablePane.addPushButton("Check Connections"), i, 0);
            fields.setButton(buttonTablePane.addPushButton("Disconnect all"), i, 4);
            fields.getButton(i, 4).addSelectionListener((SelectionListener)new DisconnectAllListener());
            IGridLayoutPane tablePane = fields.getTab(i).addGridLayoutPane(1);
            this.gridPane = fields.getTab(i).addGridLayoutPane(2, fields.getTab(i).createGridLayoutData(4, 4, true, true));
            try {
                BuildTModel dataPerSystem = new BuildTModel(key, (Vector)this.systems.get(key));
                fields.setTableView(this.gridPane.addSapTableViewer((TableModel)dataPerSystem, fields.getTab(i).createGridLayoutData(4, 4, true, true)), i);
            }
            catch (Exception exep) {
                Tracer.dtTracer.userOut("JavaRemoteDebug", 2, exep.getMessage());
            }
            fields.getTableView(i).getTableViewer().addSelectionChangedListener((ISelectionChangedListener)new SListener(fields.getTableView(i), key, i));
            IGridLayoutPane userPw = fields.getTab(i).addGridLayoutPane("User in " + key + "  System ", 3, false);
            userPw.addTextLabel("User ", userPw.createGridLayoutData(1, 2, 1, 1));
            fields.setTextField(userPw.addTextField("", false, userPw.createGridLayoutData(4, 2, true, false, 2, 1)), i, 0);
            userPw.addTextLabel("Password", userPw.createGridLayoutData(1, 2, 1, 1));
            fields.setTextField(userPw.addTextField("", false, userPw.createGridLayoutData(4, 2, true, false, 2, 1)), i, 1);
            this.errorPane = fields.getTab(i).addGridLayoutPane(2, this.parentPane.createGridLayoutData(4, 4, 1, 1));
            fields.setIconField(SapIdeUtilImages.getSapImage((ISapImage)SapImage.ICON_INFORMATION), i);
            this.l = this.errorPane.addImage(fields.getIconField(i), false);
            fields.setIconLabels(this.l, i);
            fields.setMessageLabel(this.errorPane.addTextLabel("", userPw.createGridLayoutData(4, 4, true, false)), i);
            fields.setPasswordField(i);
            fields.setLength(i);
            fields.getButton(i, 0).addSelectionListener((SelectionListener)new CheckButtonListener(key, i));
            fields.getButton(i, 1).addSelectionListener((SelectionListener)new ConnectButtonListener(fields.getButton(i, 1), fields.getTableView(i), i, key, this.parent));
            fields.getButton(i, 2).addSelectionListener((SelectionListener)new CancelButtonListener(i));
            fields.getButton(i, 3).addSelectionListener((SelectionListener)new DeleteButtonListener(fields.getTableView(i), i, key));
            if (e != 0) {
                this.createError(e, i);
            }
            ++i;
        }
    }

    private void createError(int e, int i) {
        if (e == 2) {
            this.fields.getMessageLabel(i).setText("Error:" + System.getProperty("java.io.tmpdir") + "sapdebugdata.txt" + "File is empty");
            this.fields.setIconField(IConstants.IMAGE_WARNING, i);
            this.setButtonDisabled();
        } else if (e == 3) {
            this.fields.getMessageLabel(i).setText("Error:" + System.getProperty("java.io.tmpdir") + "sapdebugdata.txt" + "File not available");
            this.fields.setIconField(IConstants.IMAGE_ERROR, i);
            this.setButtonDisabled();
        }
    }

    private void fillProjectPane(IGridLayoutPane pane) {
        pane.addTextLabel("Project:", pane.createGridLayoutData(4, 4, 1, 1));
        this.project = pane.addTextField("                                                                                ", true, pane.createGridLayoutData(4, 4, true, false, 1, 1));
        String lastProject = this.viewDialogSettings.get(LAST_SAVED_PROJECT);
        if (lastProject != null) {
            this.project.setText(lastProject);
        }
        Button button = pane.addPushButton("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionView.this.handleBrowse();
            }
        });
    }

    private int createDataStream() {
        this.data = null;
        this.data = new ReadAndStoreInput();
        int error = this.data.readFile();
        return error;
    }

    public void setFocus() {
        if (this.data == null) {
            int j = this.createDataStream();
            this.systems = this.data.getTableData();
            this.createView(this.dispComposite, j);
        }
    }

    public void setInitializationData() {
    }

    public void init() {
    }

    public void dispose() {
    }

    public void getAdapter() {
    }

    public void setButtonDisabled() {
        int i = 0;
        while (i <= this.fields.getNumberOfTabs()) {
            int j = 0;
            while (j < this.fields.getNumberOfButtons()) {
                this.fields.getButton(i, j).setEnabled(false);
                ++j;
            }
            ++i;
        }
    }

    private void handleBrowse() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> javaProjectsList = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.length) {
            try {
                if (projects[i].isOpen() && projects[i].hasNature("org.eclipse.jdt.core.javanature")) {
                    javaProjectsList.add(projects[i]);
                }
            }
            catch (CoreException ex) {
                Tracer.dtTracer.userOut("JavaRemoteDebug", 2, ex.getMessage());
            }
            ++i;
        }
        Object[] javaProjects = new IProject[javaProjectsList.size()];
        javaProjectsList.toArray(javaProjects);
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.parent.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Project selection");
        dialog.setMessage("Choose a project for remote debugging sources");
        dialog.setElements(javaProjects);
        if (dialog.open() == 0) {
            String projectName = ((IProject)dialog.getFirstResult()).getName();
            this.project.setText(projectName);
            this.viewDialogSettings.put(LAST_SAVED_PROJECT, projectName);
        }
    }

    static /* synthetic */ ConnectToCustomer access$1902(ConnectionView x0, ConnectToCustomer x1) {
        x0.cusConn = x1;
        return x0.cusConn;
    }

    static /* synthetic */ String access$2200(ConnectionView x0) {
        return x0.sourcePathSelected;
    }

    static /* synthetic */ ILaunch access$2402(ConnectionView x0, ILaunch x1) {
        x0.remoteLaunch = x1;
        return x0.remoteLaunch;
    }

    class DisconnectAllListener
    extends SelectionAdapter {
        DisconnectAllListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            try {
                VirtualMachineManager vmManager = Bootstrap.virtualMachineManager();
                Tracer.dtTracer.userOut("JavaRemoteDebug", 4, "Disconnect All");
                if (vmManager != null) {
                    Tracer.dtTracer.userOut("JavaRemoteDebug", 4, "VM Manager found");
                    List<VirtualMachine> connectedVMs = vmManager.connectedVirtualMachines();
                    VirtualMachine[] virtualMachines = new VirtualMachine[connectedVMs.size()];
                    connectedVMs.toArray(virtualMachines);
                    int i = 0;
                    while (i < virtualMachines.length) {
                        Tracer.dtTracer.userOut("JavaRemoteDebug", 4, "Connected VM found" + virtualMachines[i].description());
                        virtualMachines[i].dispose();
                        ++i;
                    }
                }
                if (ConnectionView.this.cusConn != null) {
                    ConnectionView.this.cusConn.cancelConnection();
                }
            }
            catch (Exception ex) {
                Tracer.dtTracer.userOut("JavaRemoteDebug", 2, ex.getMessage());
            }
        }
    }

    protected class RefreshButtonListener
    extends SelectionAdapter {
        String key;

        public void widgetSelected(SelectionEvent e) {
            ConnectionView.this.data = null;
            ConnectionView.this.fields = null;
            int error = ConnectionView.this.createDataStream();
            if (error != 0 && error == 3) {
                Tracer.dtTracer.userOut("JavaRemoteDebug", 2, "File not available");
            }
            if (ConnectionView.this.systems != null) {
                ConnectionView.this.systems.clear();
            }
            ConnectionView.this.systems = ConnectionView.this.data.getTableData();
            ConnectionView.this.dispComposite.dispose();
            ConnectionView.this.dispComposite = null;
            ConnectionView.this.dispComposite = new Composite(ConnectionView.this.parent, ConnectionView.this.parent.getStyle());
            ConnectionView.this.dispComposite.setLayout((Layout)new FillLayout());
            ConnectionView.this.parentPane = PaneFactory.createGridLayoutPane((Composite)ConnectionView.this.dispComposite, (int)1);
            ConnectionView.this.refreshButton = ConnectionView.this.parentPane.addPushButton("Refresh data");
            ConnectionView.this.refreshButton.addSelectionListener((SelectionListener)new RefreshButtonListener());
            ConnectionView.this.projectPane = ConnectionView.this.parentPane.addGridLayoutPane(3, ConnectionView.this.parentPane.createGridLayoutData(4, 4, 1, 1));
            ConnectionView.this.fillProjectPane(ConnectionView.this.projectPane);
            ConnectionView.this.mainTabPane = ConnectionView.this.parentPane.addTabbedPane(ConnectionView.this.parentPane.createGridLayoutData(4, 4, true, true));
            ConnectionView.this.fields = new TabsAndFields(ConnectionView.this.data.getNumberOfSystems());
            ConnectionView.this.createTabbedPane(ConnectionView.this.fields, error);
            Point size = ConnectionView.this.parent.getSize();
            ++size.x;
            ConnectionView.this.parent.setSize(size);
            ConnectionView.this.parent.update();
            --size.x;
            ConnectionView.this.parent.setSize(size);
            ConnectionView.this.parent.setVisible(true);
            ConnectionView.this.dispComposite.setVisible(true);
        }
    }

    protected class DeleteButtonListener
    extends SelectionAdapter {
        private ISapTableViewer selView;
        private String tabKey;
        private int tabNumber;

        public DeleteButtonListener(ISapTableViewer view, int index, String key) {
            this.selView = view;
            this.tabKey = key;
            this.tabNumber = index;
        }

        public void widgetSelected(SelectionEvent e) {
            ConnectionView.this.fields.clearErrorMessage(this.tabNumber);
            IStructuredSelection tableSel = (IStructuredSelection)this.selView.getTableViewer().getSelection();
            Object[] selectedObjs = tableSel.toArray();
            int selRowNumber = 0;
            int i = 0;
            while (i < selectedObjs.length) {
                SapTableRow selectedRow = (SapTableRow)selectedObjs[i];
                selRowNumber = selectedRow.getRowNum();
                ++i;
            }
            ConnectionView.this.data.deleteLine((CustomerConnection)((Vector)ConnectionView.this.systems.get(this.tabKey)).elementAt(selRowNumber));
            ((Vector)ConnectionView.this.systems.get(this.tabKey)).remove(selRowNumber);
            BuildTModel dataPerSystem = new BuildTModel(this.tabKey, (Vector)ConnectionView.this.systems.get(this.tabKey));
            this.selView.setTableModel((TableModel)dataPerSystem);
        }
    }

    protected class SListener
    implements ISelectionChangedListener {
        ISapTableViewer viewer;
        String key;
        int i;

        public SListener(ISapTableViewer view, String k, int j) {
            this.viewer = view;
            this.key = k;
            this.i = j;
        }

        public void selectionChanged(SelectionChangedEvent e) {
            IStructuredSelection tableSel = (IStructuredSelection)this.viewer.getTableViewer().getSelection();
            Object[] selectedObjs = tableSel.toArray();
            ConnectionView.this.fields.getButton(this.i, 3).setEnabled(true);
            int selRowNumber = 0;
            int i = 0;
            while (i < selectedObjs.length) {
                SapTableRow selectedRow = (SapTableRow)selectedObjs[i];
                selRowNumber = selectedRow.getRowNum();
                ++i;
            }
            String status = ConnectionView.this.data.getStatus((CustomerConnection)((Vector)ConnectionView.this.systems.get(this.key)).elementAt(selRowNumber));
            if (!status.equals("closed") && !status.equals("tbd")) {
                ConnectionView.this.fields.getButton(this.i, 1).setEnabled(true);
            }
        }
    }

    protected class CancelButtonListener
    extends SelectionAdapter {
        int tabIndex;

        public CancelButtonListener(int index) {
            this.tabIndex = index;
        }

        public void widgetSelected(SelectionEvent e) {
            ConnectionView.this.fields.clearErrorMessage(this.tabIndex);
            if (ConnectionView.this.remoteLaunch != null) {
                try {
                    if (ConnectionView.this.remoteLaunch.getDebugTarget().canDisconnect()) {
                        ConnectionView.this.remoteLaunch.getDebugTarget().disconnect();
                    }
                }
                catch (DebugException dEx) {
                    Tracer.dtTracer.userOut("JavaRemoteDebug", 2, dEx.getMessage());
                }
            }
            if (ConnectionView.this.cusConn != null) {
                ConnectionView.this.cusConn.cancelConnection();
            }
            ConnectionView.this.fields.getButton(this.tabIndex, 2).setEnabled(false);
            ConnectionView.this.fields.getButton(this.tabIndex, 1).setEnabled(true);
        }
    }

    protected class ConnectButtonListener
    extends SelectionAdapter {
        private ISapTableViewer selView;
        private Button actButton;
        private int tabNumber;
        private int selRowNumber;
        private String tabKey;
        private Composite parent;
        private String host;
        private ILaunchConfiguration iL;
        private String routeString;
        private CustomerConnection cC;
        private String u;
        private String p;
        private ConnectToCustomer conn;
        private CreateConfigurations creaCon;
        private String projectName;

        public ConnectButtonListener(Button butt, ISapTableViewer view, int i, String key, Composite par) {
            this.selView = view;
            this.actButton = butt;
            this.tabNumber = i;
            this.tabKey = key;
            this.parent = par;
        }

        public void widgetSelected(SelectionEvent e) {
            ConnectionView.this.fields.clearErrorMessage(this.tabNumber);
            IStructuredSelection tableSel = (IStructuredSelection)this.selView.getTableViewer().getSelection();
            Object[] selectedObjs = tableSel.toArray();
            this.u = ConnectionView.this.fields.getTextField(this.tabNumber, 0).getText().trim();
            this.p = ConnectionView.this.fields.getTextField(this.tabNumber, 1).getText().trim();
            this.projectName = ConnectionView.this.project.getText().trim();
            if (selectedObjs.length == 0) {
                ConnectionView.this.fields.getIconLabels(this.tabNumber).setImage(IConstants.IMAGE_ERROR);
                ConnectionView.this.fields.getMessageLabel(this.tabNumber).setText("Please select a table row !");
            } else if (ConnectionView.this.project.getText().trim().compareTo(ConnectionView.this.compare) == 0) {
                ConnectionView.this.fields.getIconLabels(this.tabNumber).setImage(IConstants.IMAGE_ERROR);
                ConnectionView.this.fields.getMessageLabel(this.tabNumber).setText("Please enter a projectname!");
            } else if (this.u.length() == 0 || this.p.length() == 0) {
                ConnectionView.this.fields.getIconLabels(this.tabNumber).setImage(IConstants.IMAGE_ERROR);
                ConnectionView.this.fields.getMessageLabel(this.tabNumber).setText("Please enter user and password");
            } else {
                int i = 0;
                while (i < selectedObjs.length) {
                    SapTableRow selectedRow = (SapTableRow)selectedObjs[i];
                    this.selRowNumber = selectedRow.getRowNum();
                    ++i;
                }
                this.cC = (CustomerConnection)((Vector)ConnectionView.this.systems.get(this.tabKey)).elementAt(this.selRowNumber);
                if (!this.cC.getConnectionState().equals("closed")) {
                    IRunnableWithProgress op = new IRunnableWithProgress(this){
                        private final /* synthetic */ ConnectButtonListener this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run(IProgressMonitor monitor) throws InvocationTargetException {
                            try {
                                block5: {
                                    try {
                                        ConnectButtonListener.access$1202(this.this$1, JcoInfo.getRouteString(ConnectButtonListener.access$1300(this.this$1), ConnectButtonListener.access$1400(this.this$1), ConnectButtonListener.access$1500(this.this$1)));
                                        if (ConnectButtonListener.access$1200(this.this$1) != null && ConnectButtonListener.access$1200(this.this$1).length() > 1) {
                                            int endIndex = ConnectButtonListener.access$1200(this.this$1).indexOf(47, 3);
                                            ConnectButtonListener.access$1602(this.this$1, ConnectButtonListener.access$1200(this.this$1).substring(3, endIndex));
                                            int startIndex = endIndex + 3;
                                            endIndex = ConnectButtonListener.access$1200(this.this$1).indexOf(47, startIndex);
                                            String port = ConnectButtonListener.access$1200(this.this$1).substring(startIndex, endIndex);
                                            ConnectButtonListener.access$1702(this.this$1, new ConnectToCustomer());
                                            ConnectButtonListener.access$1700(this.this$1).passToRouter(ConnectButtonListener.access$1200(this.this$1));
                                            ConnectionView.access$1902(ConnectButtonListener.access$1800(this.this$1), ConnectButtonListener.access$1700(this.this$1));
                                            ConnectButtonListener.access$2002(this.this$1, new CreateConfigurations(port, ConnectButtonListener.access$2100(this.this$1), ConnectButtonListener.access$1600(this.this$1), ConnectionView.access$2200(ConnectButtonListener.access$1800(this.this$1))));
                                            ConnectButtonListener.access$2302(this.this$1, ConnectButtonListener.access$2000(this.this$1).createConfig());
                                        }
                                        ConnectionView.access$2402(ConnectButtonListener.access$1800(this.this$1), ConnectButtonListener.access$2300(this.this$1).launch("debug", null));
                                        if (!monitor.isCanceled()) break block5;
                                        ConnectionView.access$2400(ConnectButtonListener.access$1800(this.this$1)).getDebugTarget().disconnect();
                                        ConnectionView.access$1900(ConnectButtonListener.access$1800(this.this$1)).cancelConnection();
                                    }
                                    catch (Exception e) {
                                        Tracer.dtTracer.userOut("JavaRemoteDebug", 2, e.getMessage());
                                        throw new InvocationTargetException(e);
                                    }
                                }
                                Object var6_6 = null;
                            }
                            catch (Throwable throwable) {
                                Object var6_7 = null;
                                monitor.done();
                                throw throwable;
                            }
                            monitor.done();
                        }
                    };
                    try {
                        new ProgressMonitorDialog(this.parent.getShell()).run(true, true, op);
                        if (this.routeString == null || this.routeString.length() < 1) {
                            ConnectionView.this.l.setVisible(true);
                            ConnectionView.this.fields.getMessageLabel(this.tabNumber).setText("Routestring not available, maybe connection is closed!");
                        } else {
                            ConnectionView.this.fields.getButton(this.tabNumber, 2).setEnabled(true);
                        }
                        ConnectionView.this.fields.getButton(this.tabNumber, 1).setEnabled(false);
                    }
                    catch (InterruptedException exep) {
                        if (this.conn != null) {
                            this.conn.cancelConnection();
                        }
                        Tracer.dtTracer.userOut("JavaRemoteDebug", 2, exep.getMessage());
                    }
                    catch (InvocationTargetException exep) {
                        if (this.conn != null) {
                            this.conn.cancelConnection();
                        }
                        Throwable realException = exep.getTargetException();
                        MessageDialog.openError((Shell)this.parent.getShell(), (String)"Error", (String)realException.getMessage());
                    }
                } else {
                    ConnectionView.this.fields.getMessageLabel(this.tabNumber).setText("Connection is closed!");
                    ConnectionView.this.fields.getMessageLabel(this.tabNumber).setBackground(null);
                }
            }
        }

        static /* synthetic */ String access$1202(ConnectButtonListener x0, String x1) {
            x0.routeString = x1;
            return x0.routeString;
        }

        static /* synthetic */ CustomerConnection access$1300(ConnectButtonListener x0) {
            return x0.cC;
        }

        static /* synthetic */ String access$1400(ConnectButtonListener x0) {
            return x0.u;
        }

        static /* synthetic */ String access$1500(ConnectButtonListener x0) {
            return x0.p;
        }

        static /* synthetic */ String access$1200(ConnectButtonListener x0) {
            return x0.routeString;
        }

        static /* synthetic */ String access$1602(ConnectButtonListener x0, String x1) {
            x0.host = x1;
            return x0.host;
        }

        static /* synthetic */ ConnectToCustomer access$1702(ConnectButtonListener x0, ConnectToCustomer x1) {
            x0.conn = x1;
            return x0.conn;
        }

        static /* synthetic */ ConnectToCustomer access$1700(ConnectButtonListener x0) {
            return x0.conn;
        }

        static /* synthetic */ ConnectionView access$1800(ConnectButtonListener x0) {
            return x0.ConnectionView.this;
        }

        static /* synthetic */ CreateConfigurations access$2002(ConnectButtonListener x0, CreateConfigurations x1) {
            x0.creaCon = x1;
            return x0.creaCon;
        }

        static /* synthetic */ String access$2100(ConnectButtonListener x0) {
            return x0.projectName;
        }

        static /* synthetic */ String access$1600(ConnectButtonListener x0) {
            return x0.host;
        }

        static /* synthetic */ ILaunchConfiguration access$2302(ConnectButtonListener x0, ILaunchConfiguration x1) {
            x0.iL = x1;
            return x0.iL;
        }

        static /* synthetic */ CreateConfigurations access$2000(ConnectButtonListener x0) {
            return x0.creaCon;
        }

        static /* synthetic */ ILaunchConfiguration access$2300(ConnectButtonListener x0) {
            return x0.iL;
        }
    }

    protected class CheckButtonListener
    extends SelectionAdapter {
        private String system;
        private int tabNumber;
        private String user;
        private String password;
        private Vector connections = null;

        public CheckButtonListener(String key, int i) {
            this.system = key;
            this.tabNumber = i;
        }

        public void widgetSelected(SelectionEvent e) {
            ConnectionView.this.fields.clearErrorMessage(this.tabNumber);
            this.user = ConnectionView.this.fields.getTextField(this.tabNumber, 0).getText().trim();
            this.password = ConnectionView.this.fields.getTextField(this.tabNumber, 1).getText().trim();
            if (this.user.length() == 0 || this.password.length() == 0) {
                ConnectionView.this.fields.getIconLabels(this.tabNumber).setImage(IConstants.IMAGE_ERROR);
                ConnectionView.this.fields.getMessageLabel(this.tabNumber).setText("Please enter user and password");
            } else {
                ProgressMonitorDialog pmd = new ProgressMonitorDialog(ConnectionView.this.parent.getShell());
                IRunnableWithProgress op = new IRunnableWithProgress(this, pmd){
                    private final /* synthetic */ ProgressMonitorDialog val$pmd;
                    private final /* synthetic */ CheckButtonListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$pmd = val$pmd;
                    }

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        try {
                            try {
                                Shell monitorShell = this.val$pmd.getShell();
                                CheckButtonListener.access$402(this.this$1, JcoInfo.checkConnectionsOpen((Vector)ConnectionView.access$700(CheckButtonListener.access$600(this.this$1)).get(CheckButtonListener.access$500(this.this$1)), CheckButtonListener.access$800(this.this$1), CheckButtonListener.access$900(this.this$1), monitorShell));
                            }
                            catch (Exception e) {
                                Tracer.dtTracer.userOut("JavaRemoteDebug", 2, e.getMessage());
                                throw new InvocationTargetException(e);
                            }
                            Object var4_4 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_5 = null;
                            monitor.done();
                            throw throwable;
                        }
                        monitor.done();
                    }
                };
                try {
                    pmd.setCancelable(false);
                    pmd.run(true, true, op);
                }
                catch (InterruptedException exep) {
                    Tracer.dtTracer.userOut("JavaRemoteDebug", 2, exep.getMessage());
                    MessageDialog.openError((Shell)ConnectionView.this.parent.getShell(), (String)"Error", (String)exep.getMessage());
                }
                catch (InvocationTargetException exep) {
                    Throwable realException = exep.getTargetException();
                    MessageDialog.openError((Shell)ConnectionView.this.parent.getShell(), (String)"Error", (String)realException.getMessage());
                }
                if (this.connections != null) {
                    ConnectionView.this.systems.remove(this.system);
                    ConnectionView.this.systems.put(this.system, this.connections);
                    BuildTModel dataPerSystem = new BuildTModel(this.system, (Vector)ConnectionView.this.systems.get(this.system));
                    ConnectionView.this.fields.getTableView(this.tabNumber).setTableModel((TableModel)dataPerSystem);
                } else {
                    ConnectionView.this.fields.getIconLabels(this.tabNumber).setImage(IConstants.IMAGE_ERROR);
                    ConnectionView.this.fields.getMessageLabel(this.tabNumber).setText("Check user and password are correct and system " + this.system + " is available");
                }
            }
        }

        static /* synthetic */ Vector access$402(CheckButtonListener x0, Vector x1) {
            x0.connections = x1;
            return x0.connections;
        }

        static /* synthetic */ String access$500(CheckButtonListener x0) {
            return x0.system;
        }

        static /* synthetic */ ConnectionView access$600(CheckButtonListener x0) {
            return x0.ConnectionView.this;
        }

        static /* synthetic */ String access$800(CheckButtonListener x0) {
            return x0.user;
        }

        static /* synthetic */ String access$900(CheckButtonListener x0) {
            return x0.password;
        }
    }
}

