/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.rdebug.views;

import com.sap.ide.eclipse.rdebug.CustomerConnectionEntry;
import com.sap.ide.eclipse.rdebug.ICustomerConnectionManager;
import com.sap.ide.eclipse.rdebug.views.RemoteDebugViewMessages;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

class ConnectionDialog
extends TitleAreaDialog {
    private static int STANDARDSPACING = 5;
    private CustomerConnectionEntry selectedConnectionEntry = null;
    private ICustomerConnectionManager connectionManager = null;
    private Table connectionTable = null;
    private Text selectedEntryIdentifier = null;
    private MenuItem deleteMenu = null;
    private Button deleteButton = null;
    private MenuItem refreshMenu = null;
    private Button refreshButton = null;
    private MenuItem checkConnectionMenu = null;
    private Button checkConnectionButton = null;

    public ConnectionDialog(Shell shell, ICustomerConnectionManager connManager) {
        super(shell);
        this.connectionManager = connManager;
    }

    protected Control createContents(Composite parent) {
        Control mother = super.createContents(parent);
        WorkbenchHelp.setHelp((Control)mother, (String)"com.sap.ide.eclipse.rdebug.connectionTablePopup");
        return mother;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(RemoteDebugViewMessages.THIS.getString("ConnectionDialog.dialogTitle"));
        Font font = parent.getFont();
        Label titleBarSeparator = new Label(parent, 258);
        titleBarSeparator.setLayoutData((Object)new GridData(768));
        Composite mainArea = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 2;
        mainLayout.marginHeight = STANDARDSPACING;
        mainLayout.marginWidth = STANDARDSPACING;
        mainLayout.verticalSpacing = 0;
        mainLayout.horizontalSpacing = 0;
        mainArea.setLayout((Layout)mainLayout);
        mainArea.setLayoutData((Object)new GridData(1808));
        mainArea.setFont(font);
        Composite tableArea = new Composite(mainArea, 0);
        GridLayout tableLayout = new GridLayout();
        tableLayout.marginHeight = STANDARDSPACING;
        tableLayout.marginWidth = STANDARDSPACING;
        tableLayout.verticalSpacing = 0;
        tableLayout.horizontalSpacing = 0;
        tableArea.setLayout((Layout)tableLayout);
        tableArea.setLayoutData((Object)new GridData(1808));
        tableArea.setFont(font);
        Label identifierLabel = new Label(tableArea, 0);
        identifierLabel.setText(RemoteDebugViewMessages.THIS.getString("ConnectionDialog.Selected_Connection_Identifier"));
        identifierLabel.setLayoutData((Object)new GridData(4));
        this.selectedEntryIdentifier = new Text(tableArea, 2048);
        this.selectedEntryIdentifier.setLayoutData((Object)new GridData(768));
        this.selectedEntryIdentifier.setEditable(false);
        this.connectionTable = new Table(tableArea, 66308);
        this.connectionTable.setHeaderVisible(true);
        this.connectionTable.setLinesVisible(true);
        this.connectionTable.addSelectionListener((SelectionListener)new ConnectionTableListener());
        GridData tableGridData = new GridData(1808);
        this.connectionTable.setLayoutData((Object)tableGridData);
        TableColumn custNameColumn = new TableColumn(this.connectionTable, 16384);
        custNameColumn.setText(RemoteDebugViewMessages.THIS.getString("ConnectionDialog.Table.Customer_Name"));
        TableColumn connStateColumn = new TableColumn(this.connectionTable, 16384);
        connStateColumn.setText(RemoteDebugViewMessages.THIS.getString("ConnectionDialog.Table.Connection_State"));
        TableColumn dbNameColumn = new TableColumn(this.connectionTable, 16384);
        dbNameColumn.setText(RemoteDebugViewMessages.THIS.getString("ConnectionDialog.Table.System"));
        TableColumn hostnameColumn = new TableColumn(this.connectionTable, 16384);
        hostnameColumn.setText(RemoteDebugViewMessages.THIS.getString("ConnectionDialog.Table.Host"));
        this.connectionTable.addMouseListener((MouseListener)new TableMouseListener());
        Composite buttonArea = new Composite(mainArea, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginHeight = STANDARDSPACING + this.convertHeightInCharsToPixels(1);
        buttonLayout.marginWidth = STANDARDSPACING;
        buttonLayout.verticalSpacing = STANDARDSPACING;
        buttonLayout.horizontalSpacing = STANDARDSPACING;
        buttonArea.setLayout((Layout)buttonLayout);
        buttonArea.setLayoutData((Object)new GridData(1808));
        buttonArea.setFont(font);
        this.refreshEntries();
        this.addContextMenuAndButtons(buttonArea);
        return mainArea;
    }

    public CustomerConnectionEntry.CustomerConnectionIdentifier getConnectionIdentifier() {
        if (this.selectedConnectionEntry != null) {
            return this.selectedConnectionEntry.getIdentifier();
        }
        return null;
    }

    private void refreshEntries() {
        this.connectionTable.removeAll();
        List connections = this.connectionManager.getConnectionList();
        Iterator entries = connections.iterator();
        while (entries.hasNext()) {
            CustomerConnectionEntry custConn = (CustomerConnectionEntry)entries.next();
            TableItem entryLine = new TableItem(this.connectionTable, 0);
            entryLine.setText(0, custConn.getCustName() != null ? custConn.getCustName() : "");
            entryLine.setText(1, custConn.getConnectionState() != null ? custConn.getConnectionState() : "");
            entryLine.setText(2, custConn.getDataBaseId() != null ? custConn.getDataBaseId() : "");
            entryLine.setText(3, custConn.getHostName() != null ? custConn.getHostName() : "");
            entryLine.setData((Object)custConn);
        }
        TableColumn[] columns = this.connectionTable.getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].pack();
            ++i;
        }
    }

    private void addContextMenuAndButtons(Composite buttonArea) {
        Menu contextMenu = new Menu((Control)this.connectionTable);
        this.deleteMenu = new MenuItem(contextMenu, 8);
        this.deleteMenu.setText(RemoteDebugViewMessages.THIS.getString("ConnectionDialog.Context.Delete_Line"));
        DeleteLineListener deleteLineListener = new DeleteLineListener();
        this.deleteMenu.addSelectionListener((SelectionListener)deleteLineListener);
        this.deleteMenu.setEnabled(false);
        this.deleteButton = new Button(buttonArea, 0);
        this.deleteButton.setText(RemoteDebugViewMessages.THIS.getString("ConnectionDialog.Context.Delete_Line"));
        this.deleteButton.setLayoutData((Object)new GridData(768));
        this.deleteButton.addSelectionListener((SelectionListener)deleteLineListener);
        this.deleteButton.setEnabled(false);
        this.refreshMenu = new MenuItem(contextMenu, 8);
        this.refreshMenu.setText(RemoteDebugViewMessages.THIS.getString("ConnectionDialog.Context.Refresh_List"));
        RefreshListener refreshListener = new RefreshListener();
        this.refreshMenu.addSelectionListener((SelectionListener)refreshListener);
        this.refreshButton = new Button(buttonArea, 0);
        this.refreshButton.setText(RemoteDebugViewMessages.THIS.getString("ConnectionDialog.Context.Refresh_List"));
        this.refreshButton.setLayoutData((Object)new GridData(768));
        this.refreshButton.addSelectionListener((SelectionListener)refreshListener);
        this.checkConnectionMenu = new MenuItem(contextMenu, 8);
        this.checkConnectionMenu.setText(RemoteDebugViewMessages.THIS.getString("ConnectionDialog.Context.Check_Connections"));
        CheckConnectionListener checkConnectionListener = new CheckConnectionListener();
        this.checkConnectionMenu.addSelectionListener((SelectionListener)checkConnectionListener);
        this.checkConnectionButton = new Button(buttonArea, 0);
        this.checkConnectionButton.setText(RemoteDebugViewMessages.THIS.getString("ConnectionDialog.Context.Check_Connections"));
        this.checkConnectionButton.setLayoutData((Object)new GridData(768));
        this.checkConnectionButton.addSelectionListener((SelectionListener)checkConnectionListener);
        this.connectionTable.setMenu(contextMenu);
    }

    private void evaluateSelectedEntry() {
        if (this.connectionTable.getSelectionCount() > 0) {
            this.selectedConnectionEntry = (CustomerConnectionEntry)this.connectionTable.getSelection()[0].getData();
            if (this.selectedConnectionEntry != null) {
                this.selectedEntryIdentifier.setText(this.selectedConnectionEntry.getIdentifier().getDescription());
                this.deleteButton.setEnabled(true);
                this.deleteMenu.setEnabled(true);
            } else {
                this.selectedEntryIdentifier.setText("");
                this.deleteButton.setEnabled(false);
                this.deleteMenu.setEnabled(false);
            }
        } else {
            this.selectedEntryIdentifier.setText("");
            this.deleteButton.setEnabled(false);
            this.deleteMenu.setEnabled(false);
        }
    }

    private class TableMouseListener
    implements MouseListener {
        private TableMouseListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            ConnectionDialog.this.evaluateSelectedEntry();
            if (ConnectionDialog.this.selectedConnectionEntry != null) {
                ConnectionDialog.super.okPressed();
            }
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }
    }

    private class CheckConnectionListener
    implements SelectionListener {
        private CheckConnectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                public void run() {
                    ConnectionDialog.this.connectionManager.checkConnections(ConnectionDialog.this.getShell());
                }
            });
            ConnectionDialog.this.refreshEntries();
            ConnectionDialog.this.evaluateSelectedEntry();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class RefreshListener
    implements SelectionListener {
        private RefreshListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ConnectionDialog.this.connectionManager.load();
            ConnectionDialog.this.refreshEntries();
            ConnectionDialog.this.evaluateSelectedEntry();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class DeleteLineListener
    implements SelectionListener {
        private DeleteLineListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            CustomerConnectionEntry deleteEntry = ConnectionDialog.this.selectedConnectionEntry;
            if (deleteEntry != null) {
                ConnectionDialog.this.connectionManager.deleteEntry(ConnectionDialog.this.getShell(), deleteEntry.getIdentifier().getIdString());
            }
            ConnectionDialog.this.refreshEntries();
            ConnectionDialog.this.evaluateSelectedEntry();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class ConnectionTableListener
    implements SelectionListener {
        private ConnectionTableListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.item instanceof TableItem) {
                TableItem entryLine = (TableItem)e.item;
                CustomerConnectionEntry selectedConn = (CustomerConnectionEntry)entryLine.getData();
                ConnectionDialog.this.selectedConnectionEntry = selectedConn;
                ConnectionDialog.this.selectedEntryIdentifier.setText(selectedConn.getIdentifier().getDescription());
                if (selectedConn != null) {
                    ConnectionDialog.this.deleteButton.setEnabled(true);
                    ConnectionDialog.this.deleteMenu.setEnabled(true);
                } else {
                    ConnectionDialog.this.deleteButton.setEnabled(false);
                    ConnectionDialog.this.deleteMenu.setEnabled(false);
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

