/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.rdebug.SourceWizard.wizards;

import com.sap.ide.eclipse.rdebug.SourceWizard.wizards.BuildTreeModel;
import com.sap.ide.eclipse.rdebug.SourceWizard.wizards.IGlobalConstants;
import com.sap.ide.eclipse.rdebug.SourceWizard.wizards.ProjectPaths;
import com.sap.ide.eclipse.rdebug.SourceWizard.wizards.Projects;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import com.tssap.util.ui.viewer.tree.ISapTreeViewer;
import com.tssap.util.ui.viewer.tree.SapTreeLabelProvider;
import javax.swing.tree.TreeModel;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SourcePathDialog
extends Dialog
implements IGlobalConstants {
    BuildTreeModel treeModel;
    ISapTreeViewer t;
    String projectOrPath;

    public SourcePathDialog(Shell parentShell, BuildTreeModel model, String mode) {
        super(parentShell);
        this.treeModel = model;
        this.projectOrPath = mode;
    }

    public Control createDialogArea(Composite parent) {
        Composite compo = (Composite)super.createDialogArea(parent);
        compo.setLayoutData((Object)new GridData(1808));
        IGridLayoutPane treePane = PaneFactory.createGridLayoutPane((Composite)compo, (int)1);
        treePane.setLayoutData((Object)new GridData(1808));
        this.t = treePane.addSapTreeViewer((TreeModel)this.treeModel, treePane.createGridLayoutData(4, 4, true, true));
        this.t.setLabelProvider(new SapTreeLabelProvider(){

            public String getText(Object node) {
                if (node instanceof String && SourcePathDialog.this.projectOrPath.equals("PROJECT")) {
                    return "Projects in Workspace                       ";
                }
                if (node instanceof String && SourcePathDialog.this.projectOrPath.equals("PATH")) {
                    return "Source path                        ";
                }
                if (node instanceof Projects) {
                    return ((Projects)node).getProjetName();
                }
                return ((ProjectPaths)node).getRelDisplayPath();
            }
        });
        this.t.getTreeViewer().expandToLevel(2);
        this.t.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)new SelChangedListener());
        return compo;
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    protected void okPressed() {
        ISelection selection = this.t.getTreeViewer().getSelection();
        if (selection instanceof StructuredSelection) {
            StructuredSelection structSel = (StructuredSelection)selection;
            Object[] arr = structSel.toArray();
            this.treeModel.setSelection(arr[0]);
            this.close();
        }
    }

    public Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(132);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createButtonsForButtonBar(composite);
        this.getButton(0).setEnabled(false);
        return composite;
    }

    public void enableButton() {
        this.getButton(0).setEnabled(true);
    }

    private class SelChangedListener
    implements ISelectionChangedListener {
        private SelChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            SourcePathDialog.super.getButton(0).setEnabled(false);
            StructuredSelection strusel = (StructuredSelection)event.getSelection();
            Object s = strusel.getFirstElement();
            if (SourcePathDialog.this.treeModel.isChild(s) && SourcePathDialog.this.projectOrPath.equals("PATH")) {
                SourcePathDialog.this.enableButton();
            } else if (!SourcePathDialog.this.treeModel.isChild(s) && SourcePathDialog.this.projectOrPath.equals("PROJECT")) {
                SourcePathDialog.this.enableButton();
            }
        }
    }
}

