/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.rdebug.SourceWizard.wizards;

import com.sap.ide.eclipse.rdebug.SourceWizard.wizards.BuildTModel;
import com.sap.ide.eclipse.rdebug.SourceWizard.wizards.P4Out;
import com.sap.ide.eclipse.rdebug.SourceWizard.wizards.P4UtilException;
import com.sap.ide.eclipse.rdebug.trace.Tracer;
import com.sap.p4japi.core.P4Command;
import com.sap.p4japi.core.P4Env;
import com.sap.p4japi.core.P4Exception;
import com.sap.p4japi.core.P4OutputListener;
import com.sap.p4japi.core.P4StandardOutputListener;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.runtime.Platform;

public class P4UtilMain {
    private static P4Env p4env = null;

    public static void init() throws Exception {
        String FILE_PREFIX = "file:";
        String REDUCED_FILE_PREFIX = "file:";
        String PLUGIN_ID = "com.sap.p4japi";
        String lPath = null;
        try {
            URL url = Platform.resolve((URL)Platform.getPlugin((String)"com.sap.p4japi").getDescriptor().getInstallURL());
            lPath = url + "lib/p4japi.dll";
            if (lPath.startsWith("file:")) {
                lPath = lPath.substring(5);
            }
        }
        catch (Exception e) {
            Tracer.dtTracer.userOut("JavaRemoteDebugging", 1, e.getMessage());
        }
        try {
            P4UtilMain.start(lPath);
        }
        catch (Exception e) {
            Tracer.dtTracer.userOut("JavaRemoteDebugging", 1, e.getMessage());
            throw new P4UtilException(e.getMessage());
        }
    }

    public static void sync(BuildTModel mod) throws P4UtilException {
        String[] sources = new String[3];
        Vector vec = mod.getSourceVector();
        int i = 0;
        while (i < vec.size()) {
            sources = (String[])vec.elementAt(i);
            P4UtilMain.syncP4Project(sources[1].trim(), mod.getUser().trim(), "", sources[0].trim(), sources[2].trim(), mod.getSourcePath().trim(), System.out);
            ++i;
        }
    }

    public static void start(String path) throws P4UtilException {
        try {
            p4env = new P4Env(path);
        }
        catch (UnsatisfiedLinkError e) {
            throw new P4UtilException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void syncP4Project(String p4port, String p4user, String p4password, String projectname, String changeList, String path, PrintStream out) throws P4UtilException {
        if (p4env == null) {
            throw new P4UtilException("P4Util was not initialized. Initialize with P4Util.init() first");
        }
        p4env.setP4Port(p4port);
        p4env.setP4User(p4user);
        p4env.setP4Password(p4password);
        Date timestamp = new Date();
        String p4client = "P4UTIL_" + timestamp.getTime();
        ArrayList<String> params = new ArrayList<String>();
        params.add("-i");
        Properties props = new Properties();
        ((Hashtable)props).put("Client", p4client);
        ((Hashtable)props).put("Root", path);
        ((Hashtable)props).put("View", "\t" + projectname + "/... " + "//" + p4client + "/... \n");
        P4StandardOutputListener p4out = new P4StandardOutputListener(out);
        P4Command p4cmd = new P4Command("client", params, props, (P4OutputListener)p4out);
        try {
            p4env.executeCommand(p4cmd);
        }
        catch (P4Exception e) {
            throw new P4UtilException("create client error: " + e.getMessage());
        }
        p4env.setP4Client(p4client);
        params.clear();
        params.add("-f");
        params.add(projectname + "/...@" + changeList);
        ((Hashtable)props).clear();
        p4cmd.setCmd("sync");
        try {
            try {
                p4env.executeCommand(p4cmd);
            }
            catch (P4Exception e) {
                throw new P4UtilException("sync error: " + e.getMessage());
            }
            Object var15_15 = null;
            params.clear();
            params.add("-d");
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            params.clear();
            params.add("-d");
            params.add(p4client);
            ((Hashtable)props).clear();
            p4cmd.setCmd("client");
            try {
                p4env.executeCommand(p4cmd);
                throw throwable;
            }
            catch (P4Exception e) {
                throw new P4UtilException("delete client error: " + e.getMessage());
            }
        }
        params.add(p4client);
        ((Hashtable)props).clear();
        p4cmd.setCmd("client");
        try {}
        catch (P4Exception e) {
            throw new P4UtilException("delete client error: " + e.getMessage());
        }
        p4env.executeCommand(p4cmd);
    }

    public static Vector getP4Dir(String p4port, String p4user, String p4password, String path, PrintStream out) throws P4UtilException {
        p4user = "d019277";
        if (p4env == null) {
            throw new P4UtilException("P4Util was not initialized. Initialize with P4Util.init() first");
        }
        p4env.setP4Port(p4port);
        p4env.setP4User(p4user);
        if (p4password == null) {
            p4password = "";
        }
        p4env.setP4Password(p4password);
        ArrayList<String> params = new ArrayList<String>();
        params.add(path + "/*");
        Properties props = new Properties();
        P4Out p4out = new P4Out(out);
        P4Command p4cmd = new P4Command("dirs", params, props, (P4OutputListener)p4out);
        try {
            p4env.executeCommand(p4cmd);
            Vector lines = p4out.getLines();
            int i = 0;
            while (i < lines.size()) {
                String line = ((String)lines.elementAt(i)).substring(path.length() + 1);
                lines.setElementAt(line, i);
                ++i;
            }
            return lines;
        }
        catch (P4Exception e) {
            throw new P4UtilException("ERROR getting subdirs: " + e.getMessage());
        }
    }

    public static Vector getP4Depots(String p4port, String p4user, String p4password, PrintStream out) throws P4UtilException {
        if (p4env == null) {
            throw new P4UtilException("P4Util was not initialized. Initialize with P4Util.init() first");
        }
        p4env.setP4Port(p4port);
        p4env.setP4User(p4user);
        if (p4password == null) {
            p4password = "";
        }
        p4env.setP4Password(p4password);
        ArrayList params = new ArrayList();
        Properties props = new Properties();
        P4Out p4out = new P4Out(out);
        P4Command p4cmd = new P4Command("depots", params, props, (P4OutputListener)p4out);
        try {
            p4env.executeCommand(p4cmd);
            Vector lines = p4out.getLines();
            int i = 0;
            while (i < lines.size()) {
                String line = (String)lines.elementAt(i);
                int pos1 = line.indexOf(" ");
                int pos2 = line.indexOf(" ", pos1 + 1);
                lines.setElementAt(line.substring(pos1 + 1, pos2), i);
                ++i;
            }
            return lines;
        }
        catch (P4Exception e) {
            throw new P4UtilException("ERROR getting depots: " + e.getMessage());
        }
    }
}

