/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.rdebug.SourceWizard.wizards;

import com.sap.ide.eclipse.rdebug.SourceWizard.wizards.BuildSPModel;
import com.sap.ide.eclipse.rdebug.SourceWizard.wizards.BuildTModel;
import com.sap.ide.eclipse.rdebug.SourceWizard.wizards.BuildTreeModel;
import com.sap.ide.eclipse.rdebug.SourceWizard.wizards.IGlobalConstants;
import com.sap.ide.eclipse.rdebug.SourceWizard.wizards.ServerProjectDialog;
import com.sap.ide.eclipse.rdebug.SourceWizard.wizards.SourcePathDialog;
import com.sap.ide.eclipse.rdebug.trace.Tracer;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ITabbedPane;
import com.tssap.util.ui.pane.PaneFactory;
import com.tssap.util.ui.viewer.table.ISapTableViewer;
import com.tssap.util.ui.viewer.table.SapTableRow;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.table.TableModel;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class DsourceNewWizardPage
extends WizardPage
implements IGlobalConstants {
    private ISelection selection;
    private ISapTableViewer pViewer;
    private ISapTableViewer dViewer;
    private Text spContent;
    protected BuildTModel mod = null;
    private Text pf1;
    private Text pf2;
    private Text pf3;
    private Text df1;
    private Text df2;
    private Text puser;
    private Text pWord;
    private Composite parent;
    private ITabbedPane tab;
    private int actualTab;
    private String user;
    private String password;

    public DsourceNewWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle("Get Java Sources");
        this.setDescription("Fetch all necessary sources from perforce server(s)");
        this.selection = selection;
    }

    public void createControl(Composite p) {
        this.parent = p;
        IGridLayoutPane parentPane = PaneFactory.createGridLayoutPane((Composite)this.parent, (int)1);
        IGridLayoutPane sourcePane = parentPane.addGridLayoutPane(3, parentPane.createGridLayoutData(4, 4, 1, 1));
        sourcePane.addTextLabel("&SourcePath:");
        this.spContent = sourcePane.addTextField(" ", false, sourcePane.createGridLayoutData(4, 4, true, false, 1, 2));
        this.spContent.setEditable(false);
        this.spContent.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DsourceNewWizardPage.this.dialogChanged();
            }
        });
        Button button = sourcePane.addPushButton("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DsourceNewWizardPage.this.handleBrowse();
            }
        });
        IGridLayoutPane perforcePane = parentPane.addGridLayoutPane(1);
        perforcePane.createGridLayoutData(4, 4, 1, 2);
        this.createPerforceContent(perforcePane, this.parent);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)this.parent);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.spContent.setText(container.getFullPath().toString());
            }
        }
    }

    private void handleBrowse() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        BuildTreeModel mod = new BuildTreeModel(projects, "PATH");
        SourcePathDialog diag = new SourcePathDialog(this.parent.getShell(), mod, "PATH");
        diag.open();
        if (!false) {
            this.spContent.setText(mod.getSelection());
        }
    }

    private void handleBrowseSandD() {
        Vector v = this.createServerList();
        BuildSPModel mod = new BuildSPModel(v, this.user, this.password);
        ServerProjectDialog diag = new ServerProjectDialog(this.parent.getShell(), mod);
        diag.open();
    }

    private void dialogChanged() {
        if (this.spContent.getText().trim().length() == 0) {
            this.updateStatus("Source path must be specified");
            return;
        }
        this.mod.setSourcePath(this.spContent.getText());
        this.determineComplete();
    }

    private void userChanged() {
        String low = null;
        low = this.puser.getText().toLowerCase();
        if (this.mod != null) {
            this.mod.setUser(low.charAt(0) + this.puser.getText().substring(1).trim());
        }
        this.user = low.charAt(0) + this.puser.getText().substring(1).trim();
    }

    private void pWordChanged() {
        if (this.mod != null) {
            this.mod.setPassword(this.pWord.getText().trim());
        }
        this.password = this.pWord.getText().trim();
    }

    private void determineComplete() {
        if (this.mod.complete()) {
            this.updateStatus(null);
        } else {
            this.updateStatus("Please specify all fields");
        }
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.spContent.getText();
    }

    private void createPerforceContent(IGridLayoutPane perforcePane, Composite container) {
        IGridLayoutPane pBasicPane = perforcePane.addGridLayoutPane(1, perforcePane.createGridLayoutData(4, 4, true, false, 1, 3));
        IGridLayoutPane pUserPane = pBasicPane.addGridLayoutPane(2, pBasicPane.createGridLayoutData(4, 4, true, false, 1, 1));
        pUserPane.addTextLabel("Perforce User:");
        this.puser = pUserPane.addTextField("                         ", false, pUserPane.createGridLayoutData(4, 2, true, false, 1, 1));
        this.puser.setEditable(true);
        this.puser.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DsourceNewWizardPage.this.userChanged();
            }
        });
        pUserPane.addTextLabel("Perforce Password:");
        this.pWord = pUserPane.addTextField("                         ", false, pUserPane.createGridLayoutData(4, 2, true, false, 1, 1));
        this.pWord.setEditable(true);
        this.pWord.setEchoChar('*');
        this.pWord.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DsourceNewWizardPage.this.pWordChanged();
            }
        });
        IGridLayoutPane pFieldsPane = pBasicPane.addGridLayoutPane(3, perforcePane.createGridLayoutData(4, 4, 1, 2));
        this.pf1 = pFieldsPane.addTextField(" ", pFieldsPane.createGridLayoutData(4, 4, true, true));
        this.pf2 = pFieldsPane.addTextField(" ", pFieldsPane.createGridLayoutData(4, 4, true, true));
        this.pf3 = pFieldsPane.addTextField(" ", pFieldsPane.createGridLayoutData(4, 4, true, true));
        this.mod = new BuildTModel();
        this.pViewer = pBasicPane.addSapTableViewer((TableModel)this.mod, pBasicPane.createGridLayoutData(4, 4, true, true));
        Table t = this.pViewer.getTable();
        TableLayout tl = new TableLayout();
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        t.setLayout((Layout)tl);
        IGridLayoutPane buttonPane = pBasicPane.addGridLayoutPane(2);
        Button addButton = buttonPane.addPushButton("Add Line");
        addButton.addSelectionListener((SelectionListener)new AddButtonListener());
        Button deleteButton = buttonPane.addPushButton("Delete Lines");
        deleteButton.addSelectionListener((SelectionListener)new DeleteButtonListener());
    }

    private void setLayout(ISapTableViewer v) {
        Table t = v.getTable();
        TableLayout tl = new TableLayout();
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        t.setLayout((Layout)tl);
        tl.layout((Composite)t, true);
    }

    public Vector createServerList() {
        Vector<String> serverlist = new Vector<String>();
        String filename = "c:\\file.txt";
        File configfile = new File(filename);
        Properties props = new Properties();
        try {
            FileInputStream inputStream = new FileInputStream(configfile);
            props.load(inputStream);
            Enumeration enumeration = ((Hashtable)props).keys();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                serverlist.add(props.getProperty(name));
            }
        }
        catch (FileNotFoundException exc) {
            Tracer.dtTracer.userOut("JavaRemoteDebugging", 1, "ERROR configfile " + filename + " not found");
            return null;
        }
        catch (IOException exc) {
            Tracer.dtTracer.userOut("JavaRemoteDebug", 2, "ERROR, I/O Error reading configfile " + filename);
            return null;
        }
        return serverlist;
    }

    protected class DeleteButtonListener
    extends SelectionAdapter {
        protected DeleteButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            IStructuredSelection tableSel = (IStructuredSelection)DsourceNewWizardPage.this.pViewer.getTableViewer().getSelection();
            Object[] selectedObjs = tableSel.toArray();
            Vector<Integer> selRowNumber = new Vector<Integer>();
            int i = 0;
            while (i < selectedObjs.length) {
                SapTableRow selectedRow = (SapTableRow)selectedObjs[i];
                selRowNumber.add(new Integer(selectedRow.getRowNum()));
                ++i;
            }
            DsourceNewWizardPage.this.mod.deleteRow(selRowNumber);
            DsourceNewWizardPage.this.pViewer.setTableModel((TableModel)DsourceNewWizardPage.this.mod);
            DsourceNewWizardPage.this.setLayout(DsourceNewWizardPage.this.pViewer);
            DsourceNewWizardPage.this.determineComplete();
        }
    }

    protected class AddButtonListener
    extends SelectionAdapter {
        protected AddButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (DsourceNewWizardPage.this.pf2.getText().endsWith("/")) {
                int j = DsourceNewWizardPage.this.pf2.getText().length();
                String test = DsourceNewWizardPage.this.pf2.getText().substring(j - 1);
            } else {
                String test = DsourceNewWizardPage.this.pf2.getText();
            }
            DsourceNewWizardPage.this.mod.insertRow(DsourceNewWizardPage.this.pf2.getText(), DsourceNewWizardPage.this.pf1.getText(), DsourceNewWizardPage.this.pf3.getText());
            DsourceNewWizardPage.this.pViewer.setTableModel((TableModel)DsourceNewWizardPage.this.mod);
            DsourceNewWizardPage.this.setLayout(DsourceNewWizardPage.this.pViewer);
            DsourceNewWizardPage.this.updateStatus(null);
            DsourceNewWizardPage.this.pf1.setText("");
            DsourceNewWizardPage.this.pf2.setText("");
            DsourceNewWizardPage.this.pf3.setText("");
            DsourceNewWizardPage.this.determineComplete();
        }
    }
}

