/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.rdebug.SourceWizard.wizards;

import com.sap.ide.eclipse.rdebug.SourceWizard.wizards.IGlobalConstants;
import com.sap.ide.eclipse.rdebug.SourceWizard.wizards.ProjectPaths;
import com.sap.ide.eclipse.rdebug.SourceWizard.wizards.Projects;
import java.util.Vector;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;

public class BuildTreeModel
implements TreeModel,
IGlobalConstants {
    private Vector parents = new Vector();
    private Vector children = new Vector();
    private Vector absPath = new Vector();
    private IProject[] pro;
    private Object treeSelection;
    private Vector projects = new Vector();
    public String absolutePath;
    private String actualParent;
    private String mode;

    public BuildTreeModel(IProject[] p, String proOrPat) {
        this.pro = p;
        this.buildTreeContents(this.pro);
        this.mode = proOrPat;
    }

    public Object getRoot() {
        if (this.mode.equals("PROJECT")) {
            return "Projects in Workspace                       ";
        }
        return "Source path                        ";
    }

    public Object getChild(Object parent, int index) {
        if (parent == "Projects in Workspace                       " || parent == "Source path                        ") {
            return this.parents.elementAt(index);
        }
        return ((Projects)parent).getChild(index);
    }

    public int getChildCount(Object parent) {
        if (parent != "Projects in Workspace                       " && parent != "Source path                        ") {
            if (parent instanceof Projects) {
                return ((Projects)parent).getNumberOfChildren();
            }
            return 0;
        }
        return this.parents.size();
    }

    public boolean isLeaf(Object node) {
        return node instanceof ProjectPaths;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        return ((Projects)this.parents.get(this.parents.indexOf(parent))).getChild((ProjectPaths)child);
    }

    public void addTreeModelListener(TreeModelListener l) {
    }

    public void removeTreeModelListener(TreeModelListener l) {
    }

    private void buildTreeContents(IProject[] pro) {
        Vector<ProjectPaths> help = new Vector<ProjectPaths>();
        Projects p = null;
        int i = 0;
        while (i < pro.length) {
            try {
                p = new Projects();
                p.setProjectName(pro[i].getName().toString());
                IClasspathEntry[] cp = JavaCore.create((IProject)pro[i]).getRawClasspath();
                int j = 0;
                while (j < cp.length) {
                    if (cp[j].getEntryKind() == 3) {
                        ProjectPaths pP = new ProjectPaths();
                        pP.setRelPath(cp[j].getPath().toString());
                        if (pro[i].getDescription().getLocation() == null) {
                            this.absolutePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString() + cp[j].getPath().toString();
                        } else {
                            this.absolutePath = pro[i].getDescription().getLocation().toString();
                            this.absolutePath = this.absolutePath.concat("/" + cp[j].getPath().removeFirstSegments(1).toString());
                        }
                        pP.setAbsoutePath(this.absolutePath);
                        help.add(pP);
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            p.setNumberOfChildren(help.size());
            p.setChildren((Vector)help.clone());
            this.parents.add(p);
            help.clear();
            ++i;
        }
    }

    protected void setSelection(Object s) {
        this.treeSelection = s;
    }

    public String getSelection() {
        String pReturn;
        try {
            if (this.mode == "PATH") {
                ProjectPaths p = (ProjectPaths)this.treeSelection;
                pReturn = ((ProjectPaths)this.treeSelection).getAbsoutePath();
            } else {
                pReturn = ((Projects)this.treeSelection).getProjetName();
                this.absolutePath = ((Projects)this.treeSelection).getChild(0).getAbsoutePath();
            }
        }
        catch (Exception e) {
            pReturn = ((Projects)this.treeSelection).getProjetName();
        }
        return pReturn;
    }

    protected boolean isChild(Object o) {
        return o instanceof ProjectPaths;
    }
}

