/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.rdebug;

import com.sap.ide.eclipse.rdebug.CustomerConnection;
import com.sap.ide.eclipse.rdebug.IConstants;
import com.sap.ide.eclipse.rdebug.trace.Tracer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.widgets.Composite;

public class ReadAndStoreInput
implements IConstants {
    private Composite parent;
    private Hashtable systems = new Hashtable(100);
    private Object errorData;
    private File f;
    private int error = 0;
    private String path;
    private int counter = 0;
    private Vector connections = new Vector();
    private int numberOfSystems = 0;
    private int n = 0;
    private String connectionDataString;

    public ReadAndStoreInput() {
        this.path = System.getProperty("java.io.tmpdir") + "sapdebugdata.txt";
    }

    public String getStatus(CustomerConnection cus) {
        String status = cus.getConnectionState();
        return status;
    }

    public int readFile() {
        FileInputStream s;
        try {
            this.f = new File(this.path);
            s = new FileInputStream(this.f);
        }
        catch (Exception e) {
            Tracer.dtTracer.userOut("JavaRemoteDebug", 2, e.getMessage());
            return 3;
        }
        try {
            this.n = s.available();
            if (this.n < 0) {
                return 3;
            }
            if (this.n == 0) {
                return 2;
            }
            byte[] bytes = new byte[this.n];
            s.read(bytes);
            s.close();
            this.connectionDataString = new String(bytes);
            this.createCustomerInfo(this.connectionDataString, this.n);
            return 0;
        }
        catch (Exception e) {
            Tracer.dtTracer.userOut("JavaRemoteDebug", 2, e.getMessage());
            return 4;
        }
    }

    public void createCustomerInfo(String cusInfo, int n) {
        int glength = 0;
        int index = 0;
        CustomerConnection cus = null;
        String key = null;
        int insertIndex = 0;
        String substr = null;
        String endString = null;
        endString = cusInfo;
        while (glength < n) {
            index = endString.indexOf("\n");
            if (index < 0) {
                substr = endString.substring(0, endString.length());
                break;
            }
            substr = endString.substring(0, index - 1);
            if (substr.substring(8, 18).equals("%_CUSNAME%")) {
                cus = (CustomerConnection)((Vector)this.systems.get(key)).elementAt(insertIndex);
                cus.setCustomerName(substr.substring(18));
            } else {
                cus = new CustomerConnection(substr);
                if (this.systems.containsKey(cus.getSysId())) {
                    key = cus.getSysId();
                    this.connections = (Vector)this.systems.get(cus.getSysId());
                    this.connections.addElement(cus);
                    insertIndex = this.connections.lastIndexOf(this.connections.lastElement());
                } else {
                    Vector<CustomerConnection> newConnections = new Vector<CustomerConnection>();
                    newConnections.add(0, cus);
                    this.systems.put(cus.getSysId(), newConnections);
                    ++this.numberOfSystems;
                    insertIndex = 0;
                    key = cus.getSysId();
                }
            }
            ++this.counter;
            endString = endString.substring(index + 1);
            glength = glength + substr.length() + 1;
        }
    }

    public Hashtable getTableData() {
        if (this.systems == null) {
            this.systems = new Hashtable();
        }
        return this.systems;
    }

    public int getNumberOfSystems() {
        return this.numberOfSystems;
    }

    public void deleteLine(CustomerConnection cus) {
        String snum = cus.getNumberInFile();
        this.deleteFromFile(snum);
    }

    public int deleteFromFile(String number) {
        int myInt = 4;
        try {
            FileInputStream s = new FileInputStream(this.f);
            this.n = s.available();
            if (this.n <= 0) {
                return 3;
            }
            byte[] bytes = new byte[this.n];
            s.read(bytes);
            String fileContents = new String(bytes);
            this.deleteLines(fileContents, this.n, number);
        }
        catch (Exception e) {
            Tracer.dtTracer.userOut("JavaRemoteDebug", 2, e.getMessage());
        }
        return myInt;
    }

    public void deleteLines(String content, int n, String number) {
        int glength = 0;
        String startString = new String();
        String lineFeed = "\r\n";
        String endString = content;
        while (glength < n) {
            int index = endString.indexOf("\n");
            if (index < 0 && !endString.substring(0, 6).equals(number)) {
                startString = startString + endString;
                break;
            }
            if (!endString.substring(0, 6).equals(number)) {
                startString = startString + endString.substring(0, index - 1) + lineFeed;
            } else {
                ++this.counter;
            }
            endString = endString.substring(index + 1);
            glength = glength + index + 1;
        }
        byte[] newContent = startString.getBytes();
        try {
            FileOutputStream dump = new FileOutputStream(this.f);
            dump.write(newContent);
        }
        catch (Exception e) {
            Tracer.dtTracer.userOut("JavaRemoteDebug", 2, e.getMessage());
        }
    }
}

