/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.rdebug;

import com.sap.ide.eclipse.rdebug.CSSAttachConnector;
import com.sap.ide.eclipse.rdebug.ICustomerConnectionManager;
import com.sap.ide.eclipse.rdebug.JrdebugecPlugin;
import com.sap.ide.eclipse.rdebug.RemoteDebugMessages;
import com.sap.ide.eclipse.rdebug.trace.Tracer;
import com.sap.ni.NiHandle;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jdi.TimeoutException;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RDebugLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(RemoteDebugMessages.THIS.getString("RDebugLaunchConfigurationDelegate.Starting_CSS_Remote_Debug..."), 8);
        if (monitor.isCanceled()) {
            this.removeLaunch(launch);
            return;
        }
        monitor.subTask(RemoteDebugMessages.THIS.getString("RDebugLaunchConfigurationDelegate.Getting_VMConnector..."));
        String connectorId = this.getVMConnectorId(configuration);
        Object connector = null;
        connector = connectorId == null ? new CSSAttachConnector() : JavaRuntime.getVMConnector((String)connectorId);
        if (connector == null) {
            this.removeLaunch(launch);
            this.abort(LaunchingMessages.getString((String)"JavaRemoteApplicationLaunchConfigurationDelegate.Connector_not_specified_2"), null, 119);
        }
        monitor.worked(1);
        monitor.subTask(RemoteDebugMessages.THIS.getString("RDebugLaunchConfigurationDelegate.Getting_Route_String..."));
        final ICustomerConnectionManager connectionManager = JrdebugecPlugin.getDefault().getConnectionManager();
        final String customerConnIdString = configuration.getAttribute("com.sap.ide.rdebug.connectionIdentifier", "");
        final String[] routeTransport = new String[1];
        Runnable getRouteString = new Runnable(){

            public void run() {
                Display display = Display.getCurrent();
                if (display == null) {
                    display = Display.getDefault();
                }
                Shell shell = display.getActiveShell();
                routeTransport[0] = connectionManager.getRouteString(display.getActiveShell(), customerConnIdString);
            }
        };
        Display.getDefault().syncExec(getRouteString);
        String routeString = routeTransport[0];
        if (routeString == null) {
            monitor.done();
            this.removeLaunch(launch);
            return;
        }
        int serverStartIndex = routeString.indexOf("/H", 0) + 3;
        int serverEndIndex = routeString.indexOf("/S/", 0);
        String hostName = routeString.substring(serverStartIndex, serverEndIndex);
        int portStartIndex = serverEndIndex + 3;
        int portEndIndex = routeString.indexOf("/H/", portStartIndex);
        String port = routeString.substring(portStartIndex, portEndIndex);
        HashMap<String, String> connectAttributes = new HashMap<String, String>(2);
        connectAttributes.put("hostname", hostName);
        connectAttributes.put("port", port);
        if (monitor.isCanceled()) {
            this.removeLaunch(launch);
            return;
        }
        monitor.worked(1);
        monitor.subTask(RemoteDebugMessages.THIS.getString("RDebugLaunchConfigurationDelegate.Connecting_to_SAP_Router..."));
        NiHandle routerHandle = null;
        try {
            routerHandle = this.passRouteString(routeString);
        }
        catch (Exception ex) {
            this.removeLaunch(launch);
            this.abort(RemoteDebugMessages.THIS.getString("RDebugLaunchConfigurationDelegate.Connect_to_SAP_router_failed"), ex, 120);
        }
        monitor.worked(1);
        this.setDefaultSourceLocator(launch, configuration);
        monitor.worked(1);
        monitor.subTask(RemoteDebugMessages.THIS.getString("RDebugLaunchConfigurationDelegate.Connecting_to_remote_VM..."));
        try {
            connector.connect(connectAttributes, monitor, launch);
        }
        catch (Throwable t) {
            IDebugTarget debugTarget;
            Tracer.dtTracer.userOut("JavaRemoteDebug", 2, t.getMessage());
            if (!launch.isTerminated() && launch.canTerminate()) {
                try {
                    launch.terminate();
                }
                catch (DebugException dEx) {
                    Tracer.dtTracer.userOut("JavaRemoteDebug", 2, dEx.getMessage());
                }
            }
            if ((debugTarget = launch.getDebugTarget()) != null && !debugTarget.isDisconnected() && debugTarget.canDisconnect()) {
                debugTarget.disconnect();
            }
            this.removeLaunch(launch);
            if (t instanceof CoreException) {
                throw (CoreException)t;
            }
            String additionalComment = "";
            if (t instanceof TimeoutException) {
                additionalComment = ": JDI Timeout occured";
            }
            throw new CoreException((IStatus)new Status(4, JrdebugecPlugin.getDefault().getDescriptor().getUniqueIdentifier(), -1, "Connect to virtual machine failed due to internal reason" + additionalComment, t));
        }
        monitor.done();
    }

    private void removeLaunch(ILaunch launch) {
        if (launch != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
        }
    }

    private NiHandle passRouteString(String routeString) throws Exception {
        int tracelevel = 4;
        NiHandle handle = null;
        Tracer.dtTracer.userOut("JavaRemoteDebug", 4, routeString);
        try {
            handle = new NiHandle(routeString, tracelevel);
        }
        catch (Exception ex) {
            Tracer.dtTracer.userOut("JavaRemoteDebug", 2, ex.getMessage());
            throw new Exception(RemoteDebugMessages.THIS.getString("RDebugLaunchConfigurationDelegate.Connect_to_router_not_possible"));
        }
        if (handle == null) {
            throw new Exception(RemoteDebugMessages.THIS.getString("RDebugLaunchConfigurationDelegate.Connect_to_router_not_possible"));
        }
        return handle;
    }
}

