/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.rdebug;

import com.sap.ide.eclipse.rdebug.CustomerConnectionManager;
import com.sap.ide.eclipse.rdebug.ICustomerConnectionManager;
import java.io.UnsupportedEncodingException;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class JrdebugecPlugin
extends AbstractUIPlugin {
    private static JrdebugecPlugin plugin;
    private ResourceBundle resourceBundle;
    private byte[] password;
    private ICustomerConnectionManager connectionManager = null;
    private byte[] pwdObfuscator = null;
    Random random = new Random();

    public JrdebugecPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("com.sap.ide.eclipse.rdebug.JrdebugecPluginResources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
        this.connectionManager = CustomerConnectionManager.getInstance();
    }

    public static JrdebugecPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = JrdebugecPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("com.sap.ide.eclipse.rdebug.ask_disconnect_all", true);
        store.setDefault("com.sap.ide.eclipse.rdebug.css_r3name", "CSS");
        store.setDefault("com.sap.ide.eclipse.rdebug.css_group", "PUBLIC");
        store.setDefault("com.sap.ide.eclipse.rdebug.css_mshost", "servprod.wdf.sap.corp");
        store.setDefault("com.sap.ide.eclipse.rdebug.css_sysno", "24");
        store.setDefault("com.sap.ide.eclipse.rdebug.css_lang", "EN");
        store.setDefault("com.sap.ide.eclipse.rdebug.css_client", "001");
        store.setDefault("com.sap.ide.eclipse.rdebug.css_user", "");
        store.setDefault("com.sap.ide.eclipse.rdebug.css_password", "");
    }

    public void setPassword(String pPassword) {
        if (pPassword == null || pPassword.equals("")) {
            this.password = null;
            return;
        }
        this.password = new byte[pPassword.length()];
        this.pwdObfuscator = new byte[pPassword.length()];
        this.random.nextBytes(this.pwdObfuscator);
        try {
            this.password = pPassword.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.password = null;
            return;
        }
        int i = 0;
        while (i < this.password.length) {
            this.password[i] = new Integer(this.password[i] ^ this.pwdObfuscator[i]).byteValue();
            ++i;
        }
    }

    public String getPassword() {
        if (this.password == null || this.password.length == 0) {
            return "";
        }
        byte[] decoded = new byte[this.password.length];
        int i = 0;
        while (i < this.password.length) {
            decoded[i] = new Integer(this.password[i] ^ this.pwdObfuscator[i]).byteValue();
            ++i;
        }
        try {
            String pwd = new String(decoded, "UTF-8");
            return pwd;
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public ICustomerConnectionManager getConnectionManager() {
        return this.connectionManager;
    }
}

