/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.rdebug;

import com.sap.ide.eclipse.rdebug.CustomerConnection;
import com.sap.ide.eclipse.rdebug.IConstants;
import com.sap.ide.eclipse.rdebug.JrdebugecPlugin;
import com.sap.ide.eclipse.rdebug.trace.Tracer;
import com.sap.ide.eclipse.rdebug.views.UserPasswordDialog;
import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class JcoInfo
implements IConstants {
    public static Vector checkConnectionsOpen(Vector connections, String user, String password, Shell parentShell) {
        int counter = connections.lastIndexOf((CustomerConnection)connections.lastElement()) + 1;
        JCO.Client connection = JcoInfo.createProperties();
        IRepository repository = JcoInfo.createRepository(connection);
        if (repository == null) {
            connection = JcoInfo.createPropertiesNoSnc(user, password, parentShell);
            repository = JcoInfo.createRepository(connection);
        }
        if (repository == null) {
            JrdebugecPlugin.getDefault().setPassword(null);
            return null;
        }
        JCO.Function function = repository.getFunctionTemplate("CHECK_CONNECTIONS_OPEN").getFunction();
        JCO.Table codes = function.getTableParameterList().getTable("CUSTOMERCONNECTIONS");
        int i = 0;
        while (i < counter) {
            CustomerConnection cus = (CustomerConnection)connections.elementAt(i);
            codes.appendRow();
            codes.setValue(cus.getSysNr(), "SYSNR");
            codes.setValue(cus.getKdnr(), "KDNR");
            codes.setValue(cus.getKdinfonr(), "KDINFONR");
            codes.setValue(cus.getDbid(), "DBID");
            codes.setValue(570, "SERVTYPE");
            ++i;
        }
        connection.execute(function);
        JCO.Table infoTable = function.getTableParameterList().getTable("CUSTOMERCONNECTIONS");
        int count = 0;
        int j = 0;
        while (j < infoTable.getNumRows()) {
            JCO.FieldIterator it = infoTable.fields();
            while (it.hasMoreElements()) {
                JCO.Field tabField = it.nextField();
                if (count == 5) {
                    count = 0;
                    if ((Integer)tabField.getValue() != 0) {
                        ((CustomerConnection)connections.elementAt(j)).setStateClosed(j);
                        continue;
                    }
                    ((CustomerConnection)connections.elementAt(j)).setStateOpen(j);
                    continue;
                }
                ++count;
            }
            infoTable.nextRow();
            ++j;
        }
        return connections;
    }

    public static JCO.Client createProperties() {
        String helper = " ";
        Properties props = new Properties();
        helper = " ";
        IPreferenceStore store = JrdebugecPlugin.getDefault().getPreferenceStore();
        ((Hashtable)props).put("jco.client.snc_mode", "1");
        helper = "p:CN=" + store.getString("com.sap.ide.eclipse.rdebug.css_r3name") + ", O=SAP-AG, C=DE";
        ((Hashtable)props).put("jco.client.snc_partnername", helper);
        ((Hashtable)props).put("jco.client.r3name", store.getString("com.sap.ide.eclipse.rdebug.css_r3name"));
        ((Hashtable)props).put("jco.client.group", store.getString("com.sap.ide.eclipse.rdebug.css_group"));
        ((Hashtable)props).put("jco.client.mshost", store.getString("com.sap.ide.eclipse.rdebug.css_mshost"));
        ((Hashtable)props).put("jco.client.sysnr", store.getString("com.sap.ide.eclipse.rdebug.css_sysno"));
        ((Hashtable)props).put("jco.client.client", store.getString("com.sap.ide.eclipse.rdebug.css_client"));
        ((Hashtable)props).put("jco.client.lang", store.getString("com.sap.ide.eclipse.rdebug.css_lang"));
        ((Hashtable)props).put("jco.client.user", store.getString("com.sap.ide.eclipse.rdebug.css_user"));
        ((Hashtable)props).put("jco.client.passwd", "?");
        JCO.Client mConnection = JCO.createClient((Properties)props);
        return mConnection;
    }

    public static JCO.Client createPropertiesNoSnc(String user, String password, final Shell parentShell) {
        final Properties props = new Properties();
        IPreferenceStore store = JrdebugecPlugin.getDefault().getPreferenceStore();
        ((Hashtable)props).put("jco.client.r3name", store.getString("com.sap.ide.eclipse.rdebug.css_r3name"));
        ((Hashtable)props).put("jco.client.group", store.getString("com.sap.ide.eclipse.rdebug.css_group"));
        ((Hashtable)props).put("jco.client.mshost", store.getString("com.sap.ide.eclipse.rdebug.css_mshost"));
        ((Hashtable)props).put("jco.client.sysnr", store.getString("com.sap.ide.eclipse.rdebug.css_sysno"));
        ((Hashtable)props).put("jco.client.client", store.getString("com.sap.ide.eclipse.rdebug.css_client"));
        ((Hashtable)props).put("jco.client.lang", store.getString("com.sap.ide.eclipse.rdebug.css_lang"));
        final String lUser = store.getString("com.sap.ide.eclipse.rdebug.css_user");
        final String lPassword = JrdebugecPlugin.getDefault().getPassword();
        if (lUser.equals("") || lPassword.equals("")) {
            Runnable dialogWrapper = new Runnable(){

                public void run() {
                    UserPasswordDialog dialog = new UserPasswordDialog(parentShell, "CSS Logon", null, "Please enter user and password for CSS logon", lUser, lPassword);
                    dialog.open();
                    ((Hashtable)props).put("jco.client.user", dialog.getUser());
                    String password = dialog.getPassword();
                    ((Hashtable)props).put("jco.client.passwd", password);
                    JrdebugecPlugin.getDefault().setPassword(password);
                }
            };
            Display.getDefault().syncExec(dialogWrapper);
        } else {
            ((Hashtable)props).put("jco.client.user", lUser);
            ((Hashtable)props).put("jco.client.passwd", lPassword);
        }
        JCO.Client mConnection = JCO.createClient((Properties)props);
        return mConnection;
    }

    public static IRepository createRepository(JCO.Client connection) {
        IRepository repository = null;
        try {
            connection.connect();
        }
        catch (Exception e) {
            Tracer.dtTracer.userOut("JavaRemoteDebug", 2, e.getMessage());
            return repository;
        }
        try {
            repository = JCO.createRepository((String)"MyRepository", (JCO.Client)connection);
        }
        catch (Exception e) {
            Tracer.dtTracer.userOut("JavaRemoteDebug", 1, e.getMessage());
            repository = null;
        }
        return repository;
    }

    public static String getRouteString(CustomerConnection cus, String user, String password) {
        String ret = null;
        JCO.Client connection = JcoInfo.createProperties();
        connection.setSapGui(1);
        IRepository repository = JcoInfo.createRepository(connection);
        if (repository == null) {
            connection = JcoInfo.createPropertiesNoSnc(user, password, null);
            connection.setSapGui(1);
            repository = JcoInfo.createRepository(connection);
        }
        JCO.Function function = repository.getFunctionTemplate("EWO_GET_ROUTESTRING").getFunction();
        JCO.ParameterList inp = function.getImportParameterList();
        inp.setValue(cus.getDbid(), "DBID");
        inp.setValue(cus.getHostname(), "HOSTNAME");
        inp.setValue("  ", "INSTANCE");
        inp.setValue(cus.getKdinfonr(), "KDINFONR");
        inp.setValue(cus.getKdnr(), "KDNR");
        inp.setValue(570, "SERVICE");
        inp.setValue(cus.getSysNr(), "SYSNR");
        try {
            connection.setSapGui(1);
            connection.execute(function);
            ret = (String)function.getExportParameterList().getField("ROUTESTRING").getValue();
        }
        catch (Exception e) {
            JrdebugecPlugin.getDefault().setPassword(null);
            return null;
        }
        connection.disconnect();
        return ret;
    }
}

