/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.rdebug;

import com.sap.ide.eclipse.rdebug.JrdebugecPlugin;
import com.sap.ide.eclipse.rdebug.RemoteDebugMessages;
import com.sap.ide.eclipse.rdebug.trace.Tracer;
import com.sap.ide.eclipse.rdebug.views.NeverAgainQuestionDialog;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import java.util.List;
import org.eclipse.jdi.Bootstrap;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class DisconnectAllDelegate
implements IViewActionDelegate {
    private IViewPart viewPart = null;
    private static final String DISCONNECT_MESSAGE = RemoteDebugMessages.THIS.getString("DisconnectAllDelegate.Disconnect_All_Description", null);

    public void run(IAction action) {
        try {
            VirtualMachineManager vmManager;
            IPreferenceStore rdebugPreferenceStore = JrdebugecPlugin.getDefault().getPreferenceStore();
            boolean askAgain = rdebugPreferenceStore.getBoolean("com.sap.ide.eclipse.rdebug.ask_disconnect_all");
            if (askAgain) {
                NeverAgainQuestionDialog confirm = new NeverAgainQuestionDialog(this.viewPart.getViewSite().getShell(), RemoteDebugMessages.THIS.getString("DisconnectAllDelegate.Disconnect_All", null), null, DISCONNECT_MESSAGE);
                confirm.open();
                if (!confirm.askAgain()) {
                    rdebugPreferenceStore.setValue("com.sap.ide.eclipse.rdebug.ask_disconnect_all", confirm.askAgain());
                }
                if (confirm.getReturnCode() != 0) {
                    return;
                }
            }
            if ((vmManager = Bootstrap.virtualMachineManager()) != null) {
                List<VirtualMachine> connectedVMs = vmManager.connectedVirtualMachines();
                VirtualMachine[] virtualMachines = new VirtualMachine[connectedVMs.size()];
                connectedVMs.toArray(virtualMachines);
                int i = 0;
                i = 0;
                while (i < virtualMachines.length) {
                    virtualMachines[i].dispose();
                    ++i;
                }
                String messageText = RemoteDebugMessages.THIS.getString("DisconnectAllDelegate.Disconnected_{0}_Virtual_Machine(s)", new Object[]{new Integer(i)});
                MessageDialog.openInformation((Shell)this.viewPart.getViewSite().getShell(), (String)RemoteDebugMessages.THIS.getString("DisconnectAllDelegate.Disconnect_All_Popup_Title", null), (String)messageText);
            }
        }
        catch (Exception ex) {
            Tracer.dtTracer.userOut("JavaRemoteDebug", 2, ex.getMessage());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IViewPart view) {
        this.viewPart = view;
    }
}

