/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.rdebug;

import com.sap.ide.eclipse.rdebug.CustomerConnectionEntry;
import com.sap.ide.eclipse.rdebug.CustomerConnectionManager;
import com.sap.ide.eclipse.rdebug.RemoteDebugMessages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.jface.dialogs.IDialogSettings;

public class DebugDataFileTest
extends TestCase {
    private static final String V2_FILE = "1%_DBID=HA1%_HOST=pgwdf441%_KDINFONR=0120004031%_KDNR=0000031811%_DNAME=SAP AG%_SYSNR=000000000300010389%_URL=http://pgwdf441:50900/sap/monitoring/ComponentInfoServlet%_SAPSERV=sapserv3.wdf.sap.corp%_CBS=http://cbs8000:8000/tc.CBS.Appl/default.html%_DTR=http://dtr8000:8000/dtr%_\n2%_DBID=HA2%_HOST=pgwdf442%_KDINFONR=0120004032%_KDNR=0000031812%_DNAME=Fool AG%_SYSNR=000000000300010390%_URL=http://pgwdf441:50900/sap/monitoring/ComponentInfoServlet%_SAPSERV=localhost%_CBS=http://cbs8000:8000/tc.CBS.Appl/default.html%_DTR=http://dtr8000:8000/dtr%_\n3%_DBID=HA3%_HOST=pgwdf443%_KDINFONR=0120004033%_KDNR=0000031813%_DNAME=SAP SI AG%_SYSNR=000000000300010391%_URL=http://pgwdf441:50900/sap/monitoring/ComponentInfoServlet%_SAPSERV=sapserv3.wdf.sap%_CBS=http://cbs8000:8000/tc.CBS.Appl/default.html%_DTR=http://dtr8000:8000/dtr%_\n";
    private static final String V1_FILE = "000001%_CAR%_PGWDF441%_24%_0020157051%_0000031811%_570%_000000000310187647%_CSN%_pwdf1401%_001%_D%_D035816%_\n000001%_%_CUSNAME%SAP AG\n000002%_CAS%_PGWDF442%_25%_0020157052%_0000031812%_570%_000000000310187647%_CSN%_pwdf1401%_001%_D%_D035816%_\n000002%_%_CUSNAME%SAP SI AG\n000003%_CAT%_PGWDF443%_26%_0020157053%_0000031813%_570%_000000000310187647%_CSN%_pwdf1401%_001%_D%_D035816%_\n000003%_%_CUSNAME%SAP LGD AG\n";
    private static String usrTmpDir = System.getProperty("java.io.tmpdir");
    private static String tmpDir = usrTmpDir + "debugTmp/";
    private static String origV1 = usrTmpDir + "sapdebugdata.txt";
    private static String origV2 = usrTmpDir + "sapdebugdata_v2.txt";
    private static String tempV1 = tmpDir + "sapdebugdata.txt";
    private static String tempV2 = tmpDir + "sapdebugdata_v2.txt";
    private final String testMethod;
    private boolean overwriteV1File = false;
    private boolean overwriteV2File = false;
    static /* synthetic */ Class class$com$sap$ide$eclipse$rdebug$CustomerConnectionEntry;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$eclipse$jface$dialogs$IDialogSettings;
    static /* synthetic */ Class class$com$sap$ide$eclipse$rdebug$CustomerConnectionManager;

    public DebugDataFileTest(String testMethod) {
        super(testMethod);
        this.testMethod = testMethod;
    }

    public void setUp() {
        if (this.testMethod.equals("testConnectionManager")) {
            File v1OrigFile;
            File tmpDirFile = new File(tmpDir);
            if (!tmpDirFile.exists()) {
                tmpDirFile.mkdir();
            }
            this.overwriteV1File = (v1OrigFile = new File(origV1)).exists() ? v1OrigFile.renameTo(new File(tempV1)) : true;
            File v2OrigFile = new File(origV2);
            this.overwriteV2File = v2OrigFile.exists() ? v2OrigFile.renameTo(new File(tempV2)) : true;
        }
    }

    public void tearDown() {
        if (this.testMethod.equals("testConnectionManager")) {
            File tmpDirFile = new File(tmpDir);
            File v1TempFile = new File(tempV1);
            if (this.overwriteV1File) {
                File v1OrigFile = new File(origV1);
                if (v1OrigFile.exists()) {
                    v1OrigFile.delete();
                }
                if (v1TempFile.exists()) {
                    v1TempFile.renameTo(v1OrigFile);
                }
            }
            File v2TempFile = new File(tempV2);
            if (this.overwriteV2File) {
                File v2OrigFile = new File(origV2);
                if (v2OrigFile.exists()) {
                    v2OrigFile.delete();
                }
                if (v2TempFile.exists()) {
                    v2TempFile.renameTo(v2OrigFile);
                }
            }
            if (tmpDirFile.exists()) {
                tmpDirFile.delete();
            }
        }
    }

    public void testSplit() {
        Class cceClass = class$com$sap$ide$eclipse$rdebug$CustomerConnectionEntry == null ? (class$com$sap$ide$eclipse$rdebug$CustomerConnectionEntry = DebugDataFileTest.class$("com.sap.ide.eclipse.rdebug.CustomerConnectionEntry")) : class$com$sap$ide$eclipse$rdebug$CustomerConnectionEntry;
        Class[] args = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DebugDataFileTest.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = DebugDataFileTest.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE};
        try {
            Method split = cceClass.getDeclaredMethod("split", args);
            ((AccessibleObject)split).setAccessible(true);
            String v1Line = "000001%_CAR%_PGWDF441%_24%_0020157051%_0000031811%_570%_000000000310187647%_CSN%_pwdf1401%_001%_D%_D035816%_";
            Object[] params1 = new Object[]{v1Line, "%_", new Integer(14)};
            String[] result = (String[])split.invoke(null, params1);
            Assert.assertEquals((int)14, (int)result.length);
            Assert.assertEquals((String)"000001", (String)result[0]);
            Assert.assertEquals((String)"CAR", (String)result[1]);
            Assert.assertEquals((String)"D035816", (String)result[12]);
            Object[] params2 = new Object[]{v1Line, "%_", new Integer(-1)};
            result = (String[])split.invoke(null, params2);
            Assert.assertEquals((int)13, (int)result.length);
            Assert.assertEquals((String)"000001", (String)result[0]);
            Assert.assertEquals((String)"CAR", (String)result[1]);
            Assert.assertEquals((String)"D035816", (String)result[12]);
            String v2Line = "1%_DBID=HA1%_HOST=pgwdf441%_KDINFONR=0120004031%_KDNR=0000031811%_DNAME=SAP AG%_SYSNR=000000000300010389%_URL=http://pgwdf441:50900/sap/monitoring/ComponentInfoServlet%_SAPSERV=sapserv3.wdf.sap.corp%_CBS=http://cbs8000:8000/tc.CBS.Appl/default.html%_DTR=http://dtr8000:8000/dtr%_";
            Object[] params3 = new Object[]{v2Line, "%_", new Integer(-1)};
            result = (String[])split.invoke(null, params3);
            Assert.assertEquals((int)11, (int)result.length);
            Assert.assertEquals((String)"1", (String)result[0]);
            Assert.assertEquals((String)"DBID=HA1", (String)result[1]);
            Assert.assertEquals((String)"DTR=http://dtr8000:8000/dtr", (String)result[10]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    public void testConstructionFromV1Line() {
        String v1Line = "000001%_CAR%_PGWDF441%_24%_0020157051%_0000031811%_570%_000000000310187647%_CSN%_pwdf1401%_001%_D%_D035816%_";
        CustomerConnectionEntry entry = CustomerConnectionEntry.getEntryFromV1Line(v1Line);
        Assert.assertEquals((String)"000001", (String)entry.getNumberInFile());
        Assert.assertEquals((String)"CAR", (String)entry.getDataBaseId());
        Assert.assertEquals((String)"PGWDF441", (String)entry.getHostName());
        Assert.assertEquals((String)"0020157051", (String)entry.getCustInfoNo());
        Assert.assertEquals((String)"0000031811", (String)entry.getCustNo());
        Assert.assertEquals((String)"000000000310187647", (String)entry.getSysNo());
    }

    public void testConstructionFromV2Line() {
        String v2Line = "1%_DBID=HA1%_HOST=pgwdf441%_KDINFONR=0120004031%_KDNR=0000031811%_DNAME=SAP AG%_SYSNR=000000000300010389%_URL=http://pgwdf441:50900/sap/monitoring/ComponentInfoServlet%_SAPSERV=sapserv3.wdf.sap.corp%_CBS=http://cbs8000:8000/tc.CBS.Appl/default.html%_DTR=http://dtr8000:8000/dtr%_";
        CustomerConnectionEntry entry = null;
        try {
            entry = CustomerConnectionEntry.getEntryFromV2Line(v2Line);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
        Assert.assertEquals((String)"1", (String)entry.getNumberInFile());
        Assert.assertEquals((String)"HA1", (String)entry.getDataBaseId());
        Assert.assertEquals((String)"pgwdf441", (String)entry.getHostName());
        Assert.assertEquals((String)"0120004031", (String)entry.getCustInfoNo());
        Assert.assertEquals((String)"0000031811", (String)entry.getCustNo());
        Assert.assertEquals((String)"SAP AG", (String)entry.getCustName());
        Assert.assertEquals((String)"000000000300010389", (String)entry.getSysNo());
        StringBuffer testString = new StringBuffer("SAP AG");
        testString.append(RemoteDebugMessages.THIS.getString("CustomerConnectionEntry.|"));
        testString.append(RemoteDebugMessages.THIS.getString("CustomerConnectionEntry.unknown"));
        testString.append(RemoteDebugMessages.THIS.getString("CustomerConnectionEntry.|"));
        testString.append("HA1");
        testString.append(RemoteDebugMessages.THIS.getString("CustomerConnectionEntry.|"));
        testString.append("pgwdf441");
        Assert.assertEquals((String)testString.toString(), (String)entry.getIdentifier().getDescription());
        testString = new StringBuffer(entry.getNumberInFile());
        testString.append(entry.getDataBaseId());
        testString.append(entry.getHostName());
        testString.append(entry.getSysNo());
        testString.append(entry.getCustNo());
        Assert.assertEquals((String)testString.toString(), (String)entry.getIdentifier().getIdString());
    }

    /*
     * Loose catch block
     */
    public void testConnectionManager() {
        block14: {
            FileOutputStream v1Out = null;
            FileOutputStream v2Out = null;
            Constructor ccmConstructor = (class$com$sap$ide$eclipse$rdebug$CustomerConnectionManager == null ? (class$com$sap$ide$eclipse$rdebug$CustomerConnectionManager = DebugDataFileTest.class$("com.sap.ide.eclipse.rdebug.CustomerConnectionManager")) : class$com$sap$ide$eclipse$rdebug$CustomerConnectionManager).getDeclaredConstructor(Long.TYPE, class$org$eclipse$jface$dialogs$IDialogSettings == null ? (class$org$eclipse$jface$dialogs$IDialogSettings = DebugDataFileTest.class$("org.eclipse.jface.dialogs.IDialogSettings")) : class$org$eclipse$jface$dialogs$IDialogSettings);
            ((AccessibleObject)ccmConstructor).setAccessible(true);
            CustomerConnectionManager ccm = (CustomerConnectionManager)ccmConstructor.newInstance(new Long(0L), new DialogSettings());
            Assert.assertNotNull((Object)ccm);
            File newV1File = new File(origV1);
            Assert.assertFalse((boolean)newV1File.exists());
            v1Out = new FileOutputStream(newV1File);
            v1Out.write(V1_FILE.getBytes());
            v1Out.close();
            ccm.load();
            List connectionList = ccm.getConnectionList();
            Assert.assertEquals((int)3, (int)connectionList.size());
            this.checkV1Entries(connectionList);
            CustomerConnectionEntry deleteEntry = (CustomerConnectionEntry)connectionList.get(1);
            ccm.deleteEntry(null, deleteEntry.getIdentifier().getIdString());
            connectionList = ccm.getConnectionList();
            Assert.assertEquals((int)2, (int)connectionList.size());
            this.checkV1Entries(connectionList);
            this.resetModifiedFlag(ccm);
            ccm.load();
            connectionList = ccm.getConnectionList();
            Assert.assertEquals((int)2, (int)connectionList.size());
            this.checkV1Entries(connectionList);
            File newV2File = new File(origV2);
            Assert.assertFalse((boolean)newV2File.exists());
            v2Out = new FileOutputStream(newV2File);
            v2Out.write(V2_FILE.getBytes());
            v2Out.close();
            this.resetModifiedFlag(ccm);
            ccm.load();
            connectionList = ccm.getConnectionList();
            Assert.assertEquals((int)3, (int)connectionList.size());
            this.checkV2Entries(connectionList);
            deleteEntry = (CustomerConnectionEntry)connectionList.get(1);
            ccm.deleteEntry(null, deleteEntry.getIdentifier().getIdString());
            connectionList = ccm.getConnectionList();
            Assert.assertEquals((int)2, (int)connectionList.size());
            this.checkV2Entries(connectionList);
            this.resetModifiedFlag(ccm);
            ccm.load();
            connectionList = ccm.getConnectionList();
            Assert.assertEquals((int)2, (int)connectionList.size());
            this.checkV2Entries(connectionList);
            Object var10_10 = null;
            try {
                if (v1Out != null) {
                    v1Out.close();
                }
                if (v2Out != null) {
                    v2Out.close();
                }
                break block14;
            }
            catch (IOException ex2) {
                ex2.printStackTrace();
            }
            break block14;
            {
                catch (Exception ex) {
                    ex.printStackTrace();
                    Assert.fail((String)ex.getMessage());
                    Object var10_11 = null;
                    try {
                        if (v1Out != null) {
                            v1Out.close();
                        }
                        if (v2Out != null) {
                            v2Out.close();
                        }
                        break block14;
                    }
                    catch (IOException ex2) {
                        ex2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (v1Out != null) {
                        v1Out.close();
                    }
                    if (v2Out != null) {
                        v2Out.close();
                    }
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    private void checkV1Entries(List connectionList) {
        Iterator i = connectionList.iterator();
        while (i.hasNext()) {
            CustomerConnectionEntry entry = (CustomerConnectionEntry)i.next();
            if (entry.getNumberInFile().equals("000001")) {
                Assert.assertEquals((String)"CAR", (String)entry.getDataBaseId());
                Assert.assertEquals((String)"PGWDF441", (String)entry.getHostName());
                Assert.assertEquals((String)"0020157051", (String)entry.getCustInfoNo());
                Assert.assertEquals((String)"0000031811", (String)entry.getCustNo());
                Assert.assertEquals((String)"000000000310187647", (String)entry.getSysNo());
                Assert.assertEquals((String)"SAP AG", (String)entry.getCustName());
                continue;
            }
            if (entry.getNumberInFile().equals("000002")) {
                Assert.assertEquals((String)"CAS", (String)entry.getDataBaseId());
                Assert.assertEquals((String)"PGWDF442", (String)entry.getHostName());
                Assert.assertEquals((String)"0020157052", (String)entry.getCustInfoNo());
                Assert.assertEquals((String)"0000031812", (String)entry.getCustNo());
                Assert.assertEquals((String)"000000000310187647", (String)entry.getSysNo());
                Assert.assertEquals((String)"SAP SI AG", (String)entry.getCustName());
                continue;
            }
            if (entry.getNumberInFile().equals("000003")) {
                Assert.assertEquals((String)"CAT", (String)entry.getDataBaseId());
                Assert.assertEquals((String)"PGWDF443", (String)entry.getHostName());
                Assert.assertEquals((String)"0020157053", (String)entry.getCustInfoNo());
                Assert.assertEquals((String)"0000031813", (String)entry.getCustNo());
                Assert.assertEquals((String)"000000000310187647", (String)entry.getSysNo());
                Assert.assertEquals((String)"SAP LGD AG", (String)entry.getCustName());
                continue;
            }
            Assert.fail((String)("entry with invalid line number detected: " + entry.getNumberInFile()));
        }
    }

    private void checkV2Entries(List connectionList) {
        Iterator i = connectionList.iterator();
        while (i.hasNext()) {
            CustomerConnectionEntry entry = (CustomerConnectionEntry)i.next();
            if (entry.getNumberInFile().equals("1")) {
                Assert.assertEquals((String)"HA1", (String)entry.getDataBaseId());
                Assert.assertEquals((String)"pgwdf441", (String)entry.getHostName());
                Assert.assertEquals((String)"0120004031", (String)entry.getCustInfoNo());
                Assert.assertEquals((String)"0000031811", (String)entry.getCustNo());
                Assert.assertEquals((String)"000000000300010389", (String)entry.getSysNo());
                Assert.assertEquals((String)"SAP AG", (String)entry.getCustName());
                continue;
            }
            if (entry.getNumberInFile().equals("2")) {
                Assert.assertEquals((String)"HA2", (String)entry.getDataBaseId());
                Assert.assertEquals((String)"pgwdf442", (String)entry.getHostName());
                Assert.assertEquals((String)"0120004032", (String)entry.getCustInfoNo());
                Assert.assertEquals((String)"0000031812", (String)entry.getCustNo());
                Assert.assertEquals((String)"000000000300010390", (String)entry.getSysNo());
                Assert.assertEquals((String)"Fool AG", (String)entry.getCustName());
                continue;
            }
            if (entry.getNumberInFile().equals("3")) {
                Assert.assertEquals((String)"HA3", (String)entry.getDataBaseId());
                Assert.assertEquals((String)"pgwdf443", (String)entry.getHostName());
                Assert.assertEquals((String)"0120004033", (String)entry.getCustInfoNo());
                Assert.assertEquals((String)"0000031813", (String)entry.getCustNo());
                Assert.assertEquals((String)"000000000300010391", (String)entry.getSysNo());
                Assert.assertEquals((String)"SAP SI AG", (String)entry.getCustName());
                continue;
            }
            Assert.fail((String)("entry with invalid line number detected: " + entry.getNumberInFile()));
        }
    }

    private void resetModifiedFlag(CustomerConnectionManager ccm) {
        try {
            Field modifiedTimeStamp = ccm.getClass().getDeclaredField("debugDataFileLastModified");
            ((AccessibleObject)modifiedTimeStamp).setAccessible(true);
            modifiedTimeStamp.setLong(ccm, 0L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DialogSettings
    implements IDialogSettings {
        private DialogSettings() {
        }

        public IDialogSettings addNewSection(String name) {
            throw new UnsupportedOperationException();
        }

        public void addSection(IDialogSettings section) {
            throw new UnsupportedOperationException();
        }

        public String get(String key) {
            throw new UnsupportedOperationException();
        }

        public String[] getArray(String key) {
            throw new UnsupportedOperationException();
        }

        public boolean getBoolean(String key) {
            throw new UnsupportedOperationException();
        }

        public double getDouble(String key) throws NumberFormatException {
            throw new UnsupportedOperationException();
        }

        public float getFloat(String key) throws NumberFormatException {
            throw new UnsupportedOperationException();
        }

        public int getInt(String key) throws NumberFormatException {
            throw new UnsupportedOperationException();
        }

        public long getLong(String key) throws NumberFormatException {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            throw new UnsupportedOperationException();
        }

        public IDialogSettings getSection(String sectionName) {
            throw new UnsupportedOperationException();
        }

        public IDialogSettings[] getSections() {
            throw new UnsupportedOperationException();
        }

        public void load(Reader reader) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void load(String fileName) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void put(String key, String[] value) {
            throw new UnsupportedOperationException();
        }

        public void put(String key, double value) {
            throw new UnsupportedOperationException();
        }

        public void put(String key, float value) {
            throw new UnsupportedOperationException();
        }

        public void put(String key, int value) {
            throw new UnsupportedOperationException();
        }

        public void put(String key, long value) {
        }

        public void put(String key, String value) {
            throw new UnsupportedOperationException();
        }

        public void put(String key, boolean value) {
            throw new UnsupportedOperationException();
        }

        public void save(Writer writer) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void save(String fileName) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

